/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S2Filter;
import org.locationtech.geomesa.index.index.s2.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class S2Filter$
implements RowFilter.RowFilterFactory<S2Filter> {
    public static S2Filter$ MODULE$;
    private final String RangeSeparator;
    private final String TermSeparator;
    private final String XYKey;

    static {
        new S2Filter$();
    }

    private String RangeSeparator() {
        return this.RangeSeparator;
    }

    private String TermSeparator() {
        return this.TermSeparator;
    }

    public String XYKey() {
        return this.XYKey;
    }

    public S2Filter apply(package.S2IndexValues values) {
        Seq xy = (Seq)values.spatialBounds().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            double[] dArray = new double[]{xmin, ymin, xmax, ymax};
            return dArray;
        }, Seq$.MODULE$.canBuildFrom());
        return new S2Filter((double[][])xy.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    @Override
    public byte[] serializeToBytes(S2Filter filter) {
        int xyLength = 4 + filter.xy().length * 32;
        ByteBuffer buffer = ByteBuffer.allocate(xyLength);
        buffer.putInt(filter.xy().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            S2Filter$.$anonfun$serializeToBytes$1(buffer, bounds);
            return BoxedUnit.UNIT;
        });
        return buffer.array();
    }

    @Override
    public S2Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        double[][] xy = (double[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> buffer.getDouble(), ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return new S2Filter(xy);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(S2Filter filter) {
        String xy = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).map((Function1 & Serializable & scala.Serializable)bounds -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bounds)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.TermSeparator());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy)}));
    }

    @Override
    public S2Filter deserializeFromStrings(Map<String, String> serialized) {
        double[][] xy = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$1 -> (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)S2Filter$.$anonfun$deserializeFromStrings$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return new S2Filter(xy);
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$1(ByteBuffer buffer$1, double[] bounds) {
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bounds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
    }

    public static final /* synthetic */ double $anonfun$deserializeFromStrings$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toDouble();
    }

    private S2Filter$() {
        MODULE$ = this;
        this.RangeSeparator = ":";
        this.TermSeparator = ";";
        this.XYKey = "sxy";
    }
}

