/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S3Filter;
import org.locationtech.geomesa.index.index.s3.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.ShortRef;
import scala.runtime.java8.JFunction0;

public final class S3Filter$
implements RowFilter.RowFilterFactory<S3Filter> {
    public static S3Filter$ MODULE$;
    private final String RangeSeparator;
    private final String TermSeparator;
    private final String EpochSeparator;
    private final String XYKey;
    private final String TKey;
    private final String EpochKey;

    static {
        new S3Filter$();
    }

    private String RangeSeparator() {
        return this.RangeSeparator;
    }

    private String TermSeparator() {
        return this.TermSeparator;
    }

    private String EpochSeparator() {
        return this.EpochSeparator;
    }

    public String XYKey() {
        return this.XYKey;
    }

    public String TKey() {
        return this.TKey;
    }

    public String EpochKey() {
        return this.EpochKey;
    }

    public S3Filter apply(package.S3IndexValues values) {
        package.S3IndexValues s3IndexValues = values;
        if (s3IndexValues == null) {
            throw new MatchError((Object)s3IndexValues);
        }
        int maxTime = s3IndexValues.maxTime();
        Seq<Tuple4<Object, Object, Object, Object>> spatialBounds = s3IndexValues.spatialBounds();
        scala.collection.immutable.Map<Object, Seq<Tuple2<Object, Object>>> temporalBounds = s3IndexValues.temporalBounds();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxTime), spatialBounds, temporalBounds);
        Tuple3 tuple32 = tuple3;
        int maxTime2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        Seq spatialBounds2 = (Seq)tuple32._2();
        scala.collection.immutable.Map temporalBounds2 = (scala.collection.immutable.Map)tuple32._3();
        double[][] xy = (double[][])((TraversableOnce)spatialBounds2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            double[] dArray = new double[]{xmin, ymin, xmax, ymax};
            return dArray;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Seq wholePeriod = (Seq)new .colon.colon((Object)new Tuple2.mcJI.sp(0L, maxTime2), (List)Nil$.MODULE$);
        ShortRef minEpoch = ShortRef.create((short)Short.MAX_VALUE);
        ShortRef maxEpoch = ShortRef.create((short)Short.MIN_VALUE);
        Seq epochsAndTimes = (Seq)((TraversableLike)((SeqLike)temporalBounds2.toSeq().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S3Filter$.$anonfun$apply$2(wholePeriod, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToShort((short)S3Filter$.$anonfun$apply$3(x$4)), (Ordering)Ordering.Short$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq times;
            short epoch;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                epoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
                times = (Seq)tuple2._2();
                if (epoch < minEpoch$1.elem) {
                    minEpoch$1.elem = epoch;
                }
                if (epoch > maxEpoch$1.elem) {
                    maxEpoch$1.elem = epoch;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)epoch), ((TraversableOnce)times.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int t1 = tuple2._1$mcI$sp();
                int t2 = tuple2._2$mcI$sp();
                int[] nArray = new int[]{t1, t2};
                return nArray;
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        int[][][] t = minEpoch.elem == Short.MAX_VALUE && maxEpoch.elem == Short.MIN_VALUE ? (int[][][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))) : (int[][][])Array$.MODULE$.ofDim(maxEpoch.elem - minEpoch.elem + 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        epochsAndTimes.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            S3Filter$.$anonfun$apply$6(t, minEpoch, x0$4);
            return BoxedUnit.UNIT;
        });
        return new S3Filter(xy, t, minEpoch.elem, maxEpoch.elem);
    }

    @Override
    public byte[] serializeToBytes(S3Filter filter) {
        int xyLength = 4 + filter.xy().length * 32;
        int tLength = 4 + BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).map((Function1 & Serializable & scala.Serializable)bounds -> BoxesRunTime.boxToInteger((int)S3Filter$.$anonfun$serializeToBytes$1(bounds)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer buffer = ByteBuffer.allocate(xyLength + tLength + 4);
        buffer.putInt(filter.xy().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            S3Filter$.$anonfun$serializeToBytes$2(buffer, bounds);
            return BoxedUnit.UNIT;
        });
        buffer.putInt(filter.t().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            ByteBuffer byteBuffer;
            if (bounds == null) {
                byteBuffer = buffer.putInt(-1);
            } else {
                buffer.putInt(((int[][])bounds).length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds)).foreach((Function1 & Serializable & scala.Serializable)inner -> {
                    S3Filter$.$anonfun$serializeToBytes$5(buffer, inner);
                    return BoxedUnit.UNIT;
                });
                byteBuffer = BoxedUnit.UNIT;
            }
            return byteBuffer;
        });
        buffer.putShort(filter.minEpoch());
        buffer.putShort(filter.maxEpoch());
        return buffer.array();
    }

    @Override
    public S3Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        double[][] xy = (double[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> buffer.getDouble(), ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[][][] t = (int[][][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> {
            int length = buffer.getInt();
            return length == -1 ? null : (int[][])Array$.MODULE$.fill(length, (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> buffer.getInt(), ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        short minEpoch = buffer.getShort();
        short maxEpoch = buffer.getShort();
        return new S3Filter(xy, t, minEpoch, maxEpoch);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(S3Filter filter) {
        String xy = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).map((Function1 & Serializable & scala.Serializable)bounds -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bounds)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.TermSeparator());
        String t = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).map((Function1 & Serializable & scala.Serializable)bounds -> bounds == null ? "" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$5)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(MODULE$.TermSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.EpochSeparator());
        String epoch = new StringBuilder(0).append(filter.minEpoch()).append(this.RangeSeparator()).append(filter.maxEpoch()).toString();
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TKey()), (Object)t), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EpochKey()), (Object)epoch)}));
    }

    @Override
    public S3Filter deserializeFromStrings(Map<String, String> serialized) {
        double[][] xy = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)S3Filter$.$anonfun$deserializeFromStrings$2(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        int[][][] t = (int[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.TKey())).split(this.EpochSeparator()))).map((Function1 & Serializable & scala.Serializable)bounds -> bounds.isEmpty() ? null : (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds.split(MODULE$.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$8 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)S3Filter$.$anonfun$deserializeFromStrings$5(x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))));
        short[] sArray = (short[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.EpochKey())).split(this.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToShort((short)S3Filter$.$anonfun$deserializeFromStrings$6(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        Option option = Array$.MODULE$.unapplySeq((Object)sArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)sArray);
        }
        short minEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(0));
        short maxEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(1));
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)minEpoch), (Object)BoxesRunTime.boxToShort((short)maxEpoch));
        Tuple2 tuple22 = tuple2;
        short minEpoch2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        short maxEpoch2 = BoxesRunTime.unboxToShort((Object)tuple22._2());
        return new S3Filter(xy, t, minEpoch2, maxEpoch2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Seq wholePeriod$1, Tuple2 x$3) {
        Object object = x$3._2();
        Seq seq = wholePeriod$1;
        return object == null ? seq != null : !object.equals(seq);
    }

    public static final /* synthetic */ short $anonfun$apply$3(Tuple2 x$4) {
        return BoxesRunTime.unboxToShort((Object)x$4._1());
    }

    public static final /* synthetic */ void $anonfun$apply$6(int[][][] t$1, ShortRef minEpoch$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
        int[][] times = (int[][])tuple2._2();
        t$1[w - minEpoch$1.elem] = times;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$serializeToBytes$1(int[][] bounds) {
        return bounds == null ? 4 : 4 + bounds.length * 8;
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$2(ByteBuffer buffer$1, double[] bounds) {
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bounds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$5(ByteBuffer buffer$1, int[] inner) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(inner)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ double $anonfun$deserializeFromStrings$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toDouble();
    }

    public static final /* synthetic */ int $anonfun$deserializeFromStrings$5(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ short $anonfun$deserializeFromStrings$6(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toShort();
    }

    private S3Filter$() {
        MODULE$ = this;
        this.RangeSeparator = ":";
        this.TermSeparator = ";";
        this.EpochSeparator = ",";
        this.XYKey = "sxy";
        this.TKey = "st";
        this.EpochKey = "epoch";
    }
}

