/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.Z2Filter;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.z2.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Z2Filter$
implements RowFilter.RowFilterFactory<Z2Filter> {
    public static Z2Filter$ MODULE$;
    private final String RangeSeparator;
    private final String TermSeparator;

    static {
        new Z2Filter$();
    }

    private String RangeSeparator() {
        return this.RangeSeparator;
    }

    private String TermSeparator() {
        return this.TermSeparator;
    }

    public Z2Filter apply(package.Z2IndexValues values) {
        Z2SFC sfc = values.sfc();
        int[][] xy = (int[][])((TraversableOnce)values.spatialBounds().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            int[] nArray = new int[]{sfc.lon().normalize(xmin), sfc.lat().normalize(ymin), sfc.lon().normalize(xmax), sfc.lat().normalize(ymax)};
            return nArray;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    @Override
    public byte[] serializeToBytes(Z2Filter filter) {
        int xyLength = 4 + filter.xy().length * 16;
        ByteBuffer buffer = ByteBuffer.allocate(xyLength);
        buffer.putInt(filter.xy().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            Z2Filter$.$anonfun$serializeToBytes$1(buffer, bounds);
            return BoxedUnit.UNIT;
        });
        return buffer.array();
    }

    @Override
    public Z2Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        int[][] xy = (int[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> buffer.getInt(), ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(Z2Filter filter) {
        String xy = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).map((Function1 & Serializable & scala.Serializable)bounds -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bounds)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.TermSeparator());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Z3Filter$.MODULE$.XYKey()), (Object)xy)}));
    }

    @Override
    public Z2Filter deserializeFromStrings(Map<String, String> serialized) {
        int[][] xy = (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)Z3Filter$.MODULE$.XYKey())).split(this.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$2 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Z2Filter$.$anonfun$deserializeFromStrings$2(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        return new Z2Filter(xy);
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$1(ByteBuffer buffer$1, int[] bounds) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bounds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ int $anonfun$deserializeFromStrings$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    private Z2Filter$() {
        MODULE$ = this;
        this.RangeSeparator = ":";
        this.TermSeparator = ";";
    }
}

