/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geoserver;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import org.geotools.data.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.planning.QueryPlanner$CostEvaluation$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class ViewParams$
implements LazyLogging {
    public static ViewParams$ MODULE$;
    private final scala.collection.immutable.Map<String, Hints.Key> QueryHintMap;
    private final scala.collection.immutable.Map<String, Hints.Key> AllHintsMap;
    private final scala.collection.immutable.Map<Hints.Key, String> AllHintsInverse;
    private final Regex envelope;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ViewParams$();
    }

    private Logger logger$lzycompute() {
        ViewParams$ viewParams$ = this;
        synchronized (viewParams$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private scala.collection.immutable.Map<String, Hints.Key> QueryHintMap() {
        return this.QueryHintMap;
    }

    private scala.collection.immutable.Map<String, Hints.Key> AllHintsMap() {
        return this.AllHintsMap;
    }

    private scala.collection.immutable.Map<Hints.Key, String> AllHintsInverse() {
        return this.AllHintsInverse;
    }

    private Regex envelope() {
        return this.envelope;
    }

    public String serialize(Hints hints) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)this.AllHintsMap().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Hints.Key hint = (Hints.Key)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(hints.get((Object)hint)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Some some;
                Object object = x0$2;
                if (object instanceof String) {
                    String string = (String)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)string));
                } else if (object instanceof Boolean) {
                    Boolean bl = (Boolean)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)bl.toString()));
                } else if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)n.toString()));
                } else if (object instanceof Float) {
                    Float f = (Float)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)f.toString()));
                } else if (object instanceof ReferencedEnvelope) {
                    ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)MODULE$.toString(referencedEnvelope)));
                } else if (object instanceof Enumeration.Value && ((Enumeration.Value)object).scala$Enumeration$Value$$$outer() == QueryPlanner$CostEvaluation$.MODULE$) {
                    Enumeration.Value value = (Enumeration.Value)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)value.toString()));
                } else if (object instanceof SimpleFeatureType) {
                    SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                    some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)SimpleFeatureTypes$.MODULE$.serialize(simpleFeatureType)));
                } else {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("Unhandled hint type for '{}'", new Object[]{name});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    some = None$.MODULE$;
                }
                return some;
            }));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        return StringSerialization$.MODULE$.encodeMap((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    public Hints deserialize(String serialized) {
        void var2_2;
        Hints hints = new Hints();
        this.setHints(hints, (scala.collection.immutable.Map<String, String>)StringSerialization$.MODULE$.decodeMap(serialized), this.AllHintsMap());
        return var2_2;
    }

    public void setHints(Query query) {
        java.util.Map viewParams = (java.util.Map)query.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)viewParams).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$2).asScala()).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        this.setHints(query.getHints(), (scala.collection.immutable.Map<String, String>)params, this.QueryHintMap());
    }

    public String getReadableHints(Query query) {
        Builder readable = Seq$.MODULE$.newBuilder();
        readable.sizeHint(query.getHints().size());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)query.getHints()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object k = tuple2._1();
            Object v = tuple2._2();
            if (!(k instanceof Hints.Key)) throw new MatchError((Object)tuple2);
            Hints.Key key = (Hints.Key)k;
            String key2 = MODULE$.hintToString(key);
            Object object = v;
            if (object == null) {
                string = "null";
            } else if (object instanceof SimpleFeatureType) {
                SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                string = SimpleFeatureTypes$.MODULE$.encodeType(simpleFeatureType);
            } else {
                string = object.toString();
            }
            String value = string;
            return readable.$plus$eq((Object)new StringBuilder(1).append(key2).append("=").append(value).toString());
        });
        return ((TraversableOnce)((SeqLike)readable.result()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    public String hintToString(Hints.Key hint) {
        return (String)this.AllHintsInverse().getOrElse((Object)hint, (Function0 & Serializable & scala.Serializable)() -> "unknown_hint");
    }

    private void setHints(Hints hints, scala.collection.immutable.Map<String, String> params, scala.collection.immutable.Map<String, Hints.Key> lookup) {
        params.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ViewParams$.$anonfun$setHints$3(lookup, hints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void setHint(Hints hints, String name, Hints.Key hint, Object value) {
        block5: {
            BoxedUnit boxedUnit;
            Object old;
            block4: {
                BoxedUnit boxedUnit2;
                old = hints.get((Object)hint);
                if (old != null) break block4;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Using query hint from geoserver view params: {}={}", new Object[]{name, value});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                hints.put((Object)hint, value);
                break block5;
            }
            if (BoxesRunTime.equals((Object)old, (Object)value)) break block5;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(100).append("Ignoring query hint from geoserver in favor of hint directly set in query. ").append("Using ").append(name).append("=").append(old).append(" and disregarding ").append(value).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Option<Enumeration.Value> toCost(String name) {
        void var3_3;
        BoxedUnit boxedUnit;
        String check = name.toLowerCase(Locale.US);
        Option value = QueryPlanner$CostEvaluation$.MODULE$.values().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ViewParams$.$anonfun$toCost$1(check, x$9)));
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(64).append("Ignoring invalid cost type from view params: ").append(name).append(". Valid values ").append("are ").append(QueryPlanner$CostEvaluation$.MODULE$.values().mkString(", ")).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private String toString(ReferencedEnvelope env) {
        return new StringBuilder(5).append("[").append(env.getMinX()).append(",").append(env.getMinY()).append(",").append(env.getMaxX()).append(",").append(env.getMaxY()).append("]").toString();
    }

    /*
     * WARNING - void declaration
     */
    private Option<ReferencedEnvelope> toEnvelope(String name, String geom) {
        void var3_3;
        BoxedUnit boxedUnit;
        Option value = ViewParams$.fromBbox$1(geom).orElse((Function0 & Serializable & scala.Serializable)() -> ViewParams$.fromWkt$1(geom)).toOption();
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(110).append("Ignoring invalid envelope from view params: ").append(name).append("=").append(geom).append(". Envelope should be ").append("WKT or in the form [-180.0,-90.0,180.0,90.0]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private Option<Object> toInt(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(string)).toInt()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring invalid int type from view params: {}={}", (Object[])new String[]{name, string});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private Option<Object> toFloat(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring invalid float type from view params: {}={}", (Object[])new String[]{name, string});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private Option<Object> toBoolean(String name, String bool) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(bool)).toBoolean()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring invalid int type from view params: {}={}", (Object[])new String[]{name, bool});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private Option<SimpleFeatureType> toFeatureType(String name, String sft) {
        Some some;
        try {
            some = new Some((Object)SimpleFeatureTypes$.MODULE$.deserialize(sft));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring invalid simple feature type from view params: {}={}", (Object[])new String[]{name, sft});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private scala.collection.immutable.Map<String, Hints.Key> buildHintsMap(Object obj) {
        Method[] methods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getDeclaredMethods())).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)ViewParams$.$anonfun$buildHintsMap$1(m)));
        Builder map = Predef$.MODULE$.Map().newBuilder();
        map.sizeHint(methods.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).foreach((Function1 & Serializable & scala.Serializable)m -> map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)m.getName().toUpperCase(Locale.US)), (Object)((Hints.Key)m.invoke(obj, new Object[0])))));
        return (scala.collection.immutable.Map)map.result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setHints$3(scala.collection.immutable.Map lookup$1, Hints hints$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String original = (String)tuple2._1();
        String value = (String)tuple2._2();
        String string = original;
        String string2 = "STRATEGY";
        String key = !(string != null ? !string.equals(string2) : string2 != null) ? "QUERY_INDEX" : original;
        Option option = lookup$1.get((Object)key);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Ignoring view param {}={}", (Object[])new String[]{key, value});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            Some some = (Some)option;
            Hints.Key hint = (Hints.Key)some.value();
            try {
                Class clazz;
                Class clazz2 = clazz = hint.getValueClass();
                Class<String> clazz3 = String.class;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    MODULE$.setHint(hints$2, key, hint, value);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    Class clazz4 = clazz;
                    Class<Boolean> clazz5 = Boolean.class;
                    if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                        MODULE$.toBoolean(key, value).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                            ViewParams$.MODULE$.setHint(hints$2, key, hint, BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)x$3)));
                            return BoxedUnit.UNIT;
                        });
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        Class clazz6 = clazz;
                        Class<Integer> clazz7 = Integer.class;
                        if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                            MODULE$.toInt(key, value).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.setHint(hints$2, key, hint, BoxesRunTime.boxToInteger((int)x$4)));
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            Class clazz8 = clazz;
                            Class<Float> clazz9 = Float.class;
                            if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                                MODULE$.toFloat(key, value).foreach((Function1)(JFunction1.mcVF.sp & Serializable & scala.Serializable)x$5 -> MODULE$.setHint(hints$2, key, hint, BoxesRunTime.boxToFloat((float)x$5)));
                                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                Class clazz10 = clazz;
                                Class<ReferencedEnvelope> clazz11 = ReferencedEnvelope.class;
                                if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                    MODULE$.toEnvelope(key, value).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                                        ViewParams$.MODULE$.setHint(hints$2, key, hint, x$6);
                                        return BoxedUnit.UNIT;
                                    });
                                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                } else {
                                    Class clazz12 = clazz;
                                    Class<Enumeration.Value> clazz13 = Enumeration.Value.class;
                                    if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                        MODULE$.toCost(value).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                                            ViewParams$.MODULE$.setHint(hints$2, key, hint, x$7);
                                            return BoxedUnit.UNIT;
                                        });
                                        BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                    } else {
                                        Class clazz14 = clazz;
                                        Class<SimpleFeatureType> clazz15 = SimpleFeatureType.class;
                                        if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                            MODULE$.toFeatureType(key, value).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                                                ViewParams$.MODULE$.setHint(hints$2, key, hint, x$8);
                                                return BoxedUnit.UNIT;
                                            });
                                            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                                        } else {
                                            BoxedUnit boxedUnit10;
                                            if (MODULE$.logger().underlying().isWarnEnabled()) {
                                                MODULE$.logger().underlying().warn("Unhandled hint type for '{}'", new Object[]{key});
                                                boxedUnit10 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit10 = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit11 = boxedUnit10;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit12;
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) throw throwable;
                Throwable e = (Throwable)option2.get();
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn(new StringBuilder(31).append("Error invoking query hint for ").append(key).append("=").append(value).toString(), e);
                    boxedUnit12 = BoxedUnit.UNIT;
                } else {
                    boxedUnit12 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit13 = boxedUnit12;
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit14 = boxedUnit;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$toCost$1(String check$1, Enumeration.Value x$9) {
        String string = x$9.toString().toLowerCase(Locale.US);
        String string2 = check$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Try fromBbox$1(String geom$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string = geom$1;
            Option option = MODULE$.envelope().unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(8) != 0) {
                throw new MatchError((Object)string);
            }
            String xmin = (String)((LinearSeqOptimized)option.get()).apply(0);
            String ymin = (String)((LinearSeqOptimized)option.get()).apply(2);
            String xmax = (String)((LinearSeqOptimized)option.get()).apply(4);
            String ymax = (String)((LinearSeqOptimized)option.get()).apply(6);
            Tuple4 tuple4 = new Tuple4((Object)xmin, (Object)ymin, (Object)xmax, (Object)ymax);
            Tuple4 tuple42 = tuple4;
            String xmin2 = (String)tuple42._1();
            String ymin2 = (String)tuple42._2();
            String xmax2 = (String)tuple42._3();
            String ymax2 = (String)tuple42._4();
            return new ReferencedEnvelope(new StringOps(Predef$.MODULE$.augmentString(xmin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(xmax2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymax2)).toDouble(), package$.MODULE$.CRS_EPSG_4326());
        });
    }

    private static final Try fromWkt$1(String geom$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ReferencedEnvelope(WKTUtils$.MODULE$.read(geom$1).getEnvelopeInternal(), package$.MODULE$.CRS_EPSG_4326()));
    }

    public static final /* synthetic */ boolean $anonfun$buildHintsMap$1(Method m) {
        return m.getParameterCount() == 0 && Hints.Key.class.isAssignableFrom(m.getReturnType());
    }

    private ViewParams$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.QueryHintMap = this.buildHintsMap(QueryHints$.MODULE$);
        this.AllHintsMap = this.QueryHintMap().$plus$plus(this.buildHintsMap(QueryHints$Internal$.MODULE$));
        this.AllHintsInverse = (scala.collection.immutable.Map)this.AllHintsMap().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom());
        this.envelope = new StringOps(Predef$.MODULE$.augmentString("\\[\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?)\\s*]")).r();
    }
}

