/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureReader;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.audit.QueryEvent;
import org.locationtech.geomesa.index.audit.QueryEvent$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.audit.AuditedEvent;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.geomesa.utils.stats.Timings;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0016-\u0001]B\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u001d\t\bA1A\u0005\nIDa! \u0001!\u0002\u0013\u0019\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0002!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u000e\u0001\t#\t9\u0004C\u0004\u0002:\u0001!\t\"!\f\b\u000f\u0005mB\u0006#\u0001\u0002>\u001911\u0006\fE\u0001\u0003\u007fAa![\t\u0005\u0002\u0005\u001d\u0003bBA%#\u0011\u0005\u00111\n\u0004\u0007\u0003\u000f\u000b\u0002!!#\t\u0011%#\"\u0011!Q\u0001\n)C\u0001b\u0015\u000b\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t5R\u0011\t\u0011)A\u00057\"Aq\f\u0006B\u0001B\u0003%\u0001\r\u0003\u0006\u0002\u0018R\u0011\t\u0011)A\u0005\u0003CB!\"!'\u0015\u0005\u0003\u0005\u000b\u0011BA6\u0011)\tY\n\u0006B\u0001B\u0003%\u0011\u0011\u000f\u0005\u000b\u0003;#\"\u0011!Q\u0001\n\u0005}\u0005bB5\u0015\t\u0003\t\u0012Q\u0015\u0005\n\u0003w#\"\u0019!C\u0005\u0003{C\u0001\"!2\u0015A\u0003%\u0011q\u0018\u0005\b\u00033!B\u0011IA\u000e\u0011\u001d\t\u0019\u0003\u0006C!\u0003KAq!!\u000e\u0015\t#\n9\u0004C\u0004\u0002:Q!\t&!\f\t\u001b\u0005\u001dG\u0003%A\u0002\u0002\u0003%I!a\u0007\u000b\u00115\tI\r\u0006I\u0001\u0004\u0003\u0005I\u0011BA\u0013\u0017!i\u00111\u001a\u000b\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002899\u0011\"!4\u0012\u0003\u0003E\t!a4\u0007\u0013\u0005\u001d\u0015#!A\t\u0002\u0005E\u0007BB5)\t\u0003\t\u0019\u000e\u0003\u0006\u0002V\"\n\n\u0011\"\u0001\u0012\u0003/\u0014AcR3p\u001b\u0016\u001c\u0018MR3biV\u0014XMU3bI\u0016\u0014(BA\u0017/\u0003!9Wm\u001c;p_2\u001c(BA\u00181\u0003\u0015Ig\u000eZ3y\u0015\t\t$'A\u0004hK>lWm]1\u000b\u0005M\"\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001A\u0004\t\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\r=\u0013'.Z2u!\t\tu)D\u0001C\u0015\t\u0019E)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u000b\u001a\u000bA\u0001Z1uC*\u0011Q\u0006N\u0005\u0003\u0011\n\u00131cU5na2,g)Z1ukJ,'+Z1eKJ\f1a\u001d4u!\tY\u0015+D\u0001M\u0015\t\u0019UJ\u0003\u0002O\u001f\u00069a-Z1ukJ,'B\u0001)5\u0003\u001dy\u0007/\u001a8hSNL!A\u0015'\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0002raB\u0011Q\u000bW\u0007\u0002-*\u0011qKL\u0001\ta2\fgN\\5oO&\u0011\u0011L\u0016\u0002\f#V,'/\u001f*v]:,'/A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002];6\tA)\u0003\u0002_\t\n)\u0011+^3ss\u00069A/[7f_V$\bcA1eM6\t!MC\u0001d\u0003\u0015\u00198-\u00197b\u0013\t)'M\u0001\u0004PaRLwN\u001c\t\u0003C\u001eL!\u0001\u001b2\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b-lgn\u001c9\u0011\u00051\u0004Q\"\u0001\u0017\t\u000b%+\u0001\u0019\u0001&\t\u000bM+\u0001\u0019\u0001+\t\u000bi+\u0001\u0019A.\t\u000b}+\u0001\u0019\u00011\u0002\r\rdwn]3e+\u0005\u0019\bC\u0001;|\u001b\u0005)(B\u0001<x\u0003\u0019\tGo\\7jG*\u0011\u00010_\u0001\u000bG>t7-\u001e:sK:$(B\u0001>=\u0003\u0011)H/\u001b7\n\u0005q,(!D!u_6L7MQ8pY\u0016\fg.A\u0004dY>\u001cX\r\u001a\u0011\u0002\t%$XM]\u000b\u0003\u0003\u0003\u0001b!a\u0001\u0002\u000e\u0005EQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0015\r|G\u000e\\3di&|gNC\u0002\u0002\fA\nQ!\u001e;jYNLA!a\u0004\u0002\u0006\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u0007-\u000b\u0019\"C\u0002\u0002\u00161\u0013QbU5na2,g)Z1ukJ,\u0017!B5uKJ\u0004\u0013a\u00025bg:+\u0007\u0010\u001e\u000b\u0003\u0003;\u00012!YA\u0010\u0013\r\t\tC\u0019\u0002\b\u0005>|G.Z1o\u0003\u0011qW\r\u001f;\u0015\u0005\u0005E\u0011AD4fi\u001a+\u0017\r^;sKRK\b/\u001a\u000b\u0002\u0015\u0006)1\r\\8tKR\u0011\u0011q\u0006\t\u0004C\u0006E\u0012bAA\u001aE\n!QK\\5u\u0003!\u0011XO\\)vKJLHCAA\u0001\u0003%\u0019Gn\\:f\u001f:\u001cW-\u0001\u000bHK>lUm]1GK\u0006$XO]3SK\u0006$WM\u001d\t\u0003YF\u00192!EA!!\r\t\u00171I\u0005\u0004\u0003\u000b\u0012'AB!osJ+g\r\u0006\u0002\u0002>\u0005)\u0011\r\u001d9msRY1.!\u0014\u0002P\u0005E\u00131KA+\u0011\u0015I5\u00031\u0001K\u0011\u0015Q6\u00031\u0001\\\u0011\u0015\u00196\u00031\u0001U\u0011\u0015y6\u00031\u0001a\u0011\u001d\t9f\u0005a\u0001\u00033\nQ!Y;eSR\u0004B!\u00193\u0002\\AI\u0011-!\u0018\u0002b\u0005-\u0014\u0011O\u0005\u0004\u0003?\u0012'A\u0002+va2,7\u0007\u0005\u0003\u0002d\u0005\u001dTBAA3\u0015\u0011\t9&!\u0003\n\t\u0005%\u0014Q\r\u0002\f\u0003V$\u0017\u000e^,sSR,'\u000f\u0005\u0003\u0002d\u00055\u0014\u0002BA8\u0003K\u0012Q\"Q;eSR\u0004&o\u001c<jI\u0016\u0014\b\u0003BA:\u0003\u0003sA!!\u001e\u0002~A\u0019\u0011q\u000f2\u000e\u0005\u0005e$bAA>m\u00051AH]8pizJ1!a c\u0003\u0019\u0001&/\u001a3fM&!\u00111QAC\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u00102\u0003;\u001d+w.T3tC\u001a+\u0017\r^;sKJ+\u0017\rZ3s/&$\b.Q;eSR\u001cB\u0001F6\u0002\fB!\u0011QRAJ\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006%\u0011!B:uCR\u001c\u0018\u0002BAK\u0003\u001f\u0013q\"T3uQ>$\u0007K]8gS2LgnZ\u0001\fCV$\u0017\u000e^,sSR,'/A\u0007bk\u0012LG\u000f\u0015:pm&$WM]\u0001\ngR|'/\u001a+za\u0016\fq\u0001^5nS:<7\u000f\u0005\u0003\u0002\u000e\u0006\u0005\u0016\u0002BAR\u0003\u001f\u0013q\u0001V5nS:<7\u000f\u0006\n\u0002(\u0006-\u0016QVAX\u0003c\u000b\u0019,!.\u00028\u0006e\u0006cAAU)5\t\u0011\u0003C\u0003J;\u0001\u0007!\nC\u0003T;\u0001\u0007A\u000bC\u0003[;\u0001\u00071\fC\u0003`;\u0001\u0007\u0001\rC\u0004\u0002\u0018v\u0001\r!!\u0019\t\u000f\u0005eU\u00041\u0001\u0002l!9\u00111T\u000fA\u0002\u0005E\u0004\"CAO;A\u0005\t\u0019AAP\u0003\u0015\u0019w.\u001e8u+\t\ty\fE\u0002u\u0003\u0003L1!a1v\u0005)\tEo\\7jG2{gnZ\u0001\u0007G>,h\u000e\u001e\u0011\u0002\u001bM,\b/\u001a:%Q\u0006\u001ch*\u001a=u\u0003)\u0019X\u000f]3sI9,\u0007\u0010^\u0001\u000fgV\u0004XM\u001d\u0013sk:\fV/\u001a:z\u0003u9Um\\'fg\u00064U-\u0019;ve\u0016\u0014V-\u00193fe^KG\u000f[!vI&$\bcAAUQM\u0019\u0001&!\u0011\u0015\u0005\u0005=\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0002Z*\"\u0011qTAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtE\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class GeoMesaFeatureReader
implements SimpleFeatureReader {
    private final SimpleFeatureType sft;
    private final QueryRunner qp;
    private final Query query;
    private final AtomicBoolean closed;
    private final CloseableIterator<SimpleFeature> iter;

    public static GeoMesaFeatureReader apply(SimpleFeatureType simpleFeatureType, Query query, QueryRunner queryRunner, Option<Object> option, Option<Tuple3<AuditWriter, AuditProvider, String>> option2) {
        return GeoMesaFeatureReader$.MODULE$.apply(simpleFeatureType, query, queryRunner, option, option2);
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private CloseableIterator<SimpleFeature> iter() {
        return this.iter;
    }

    public boolean hasNext() {
        return this.iter().hasNext();
    }

    public SimpleFeature next() {
        return (SimpleFeature)this.iter().next();
    }

    public SimpleFeatureType getFeatureType() {
        return QueryHints$.MODULE$.RichHints(this.query.getHints()).getReturnSft();
    }

    public void close() {
        block0: {
            if (!this.closed().compareAndSet(false, true)) break block0;
            this.closeOnce();
        }
    }

    public CloseableIterator<SimpleFeature> runQuery() {
        return this.qp.runQuery(this.sft, this.query, this.qp.runQuery$default$3());
    }

    public void closeOnce() {
        this.iter().close();
    }

    public GeoMesaFeatureReader(SimpleFeatureType sft, QueryRunner qp, Query query, Option<Object> timeout) {
        this.sft = sft;
        this.qp = qp;
        this.query = query;
        this.closed = new AtomicBoolean(false);
        this.iter = this.runQuery();
    }

    public static class GeoMesaFeatureReaderWithAudit
    extends GeoMesaFeatureReader
    implements MethodProfiling {
        private final SimpleFeatureType sft;
        private final Query query;
        private final AuditWriter auditWriter;
        private final AuditProvider auditProvider;
        private final String storeType;
        private final Timings timings;
        private final AtomicLong count;
        private Logger logger;
        private volatile boolean bitmap$0;

        public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
            return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
        }

        public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
            return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
        }

        public <R> R profile(String message, Function0<R> code) {
            return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
        }

        private Logger logger$lzycompute() {
            GeoMesaFeatureReaderWithAudit geoMesaFeatureReaderWithAudit = this;
            synchronized (geoMesaFeatureReaderWithAudit) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        private /* synthetic */ boolean super$hasNext() {
            return super.hasNext();
        }

        private /* synthetic */ SimpleFeature super$next() {
            return super.next();
        }

        private /* synthetic */ CloseableIterator super$runQuery() {
            return super.runQuery();
        }

        private AtomicLong count() {
            return this.count;
        }

        @Override
        public boolean hasNext() {
            return BoxesRunTime.unboxToBoolean(this.profile((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> $this.timings.occurrence("hasNext", time), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.super$hasNext()));
        }

        @Override
        public SimpleFeature next() {
            return (SimpleFeature)this.profile((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> $this.timings.occurrence("next", time), (Function0 & Serializable & scala.Serializable)() -> this.super$next());
        }

        @Override
        public CloseableIterator<SimpleFeature> runQuery() {
            return (CloseableIterator)this.profile((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> $this.timings.occurrence("planning", time), (Function0 & Serializable & scala.Serializable)() -> {
                CloseableIterator closeableIterator;
                CloseableIterator base = this.super$runQuery();
                SimpleFeatureType simpleFeatureType = QueryHints$.MODULE$.RichHints($this.query.getHints()).getReturnSft();
                SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
                if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
                    int bytesPerHit = QueryHints$.MODULE$.RichHints($this.query.getHints()).getBinLabelField().isDefined() ? 24 : 16;
                    closeableIterator = base.map((Function1 & Serializable & scala.Serializable)sf -> {
                        this.count().addAndGet(((byte[])sf.getAttribute(0)).length / bytesPerHit);
                        return sf;
                    });
                } else {
                    closeableIterator = base.map((Function1 & Serializable & scala.Serializable)sf -> {
                        this.count().incrementAndGet();
                        return sf;
                    });
                }
                return closeableIterator;
            });
        }

        @Override
        public void closeOnce() {
            try {
                super.closeOnce();
            }
            finally {
                QueryEvent stat = new QueryEvent(this.storeType, this.sft.getTypeName(), System.currentTimeMillis(), this.auditProvider.getCurrentUserId(), package$.MODULE$.filterToString(this.query.getFilter()), ViewParams$.MODULE$.getReadableHints(this.query), this.timings.time("planning"), this.timings.time("next") + this.timings.time("hasNext"), this.count().get(), QueryEvent$.MODULE$.apply$default$10());
                this.auditWriter.writeEvent((AuditedEvent)stat, ClassTag$.MODULE$.apply(QueryEvent.class));
            }
        }

        public GeoMesaFeatureReaderWithAudit(SimpleFeatureType sft, QueryRunner qp, Query query, Option<Object> timeout, AuditWriter auditWriter, AuditProvider auditProvider, String storeType, Timings timings) {
            this.sft = sft;
            this.query = query;
            this.auditWriter = auditWriter;
            this.auditProvider = auditProvider;
            this.storeType = storeType;
            this.timings = timings;
            super(sft, qp, query, timeout);
            LazyLogging.$init$((LazyLogging)this);
            MethodProfiling.$init$((MethodProfiling)this);
            this.count = new AtomicLong(0L);
        }
    }
}

