/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.identity.FeatureId;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001\u0002\u000b\u0016\u0001\u0001B\u0011B\f\u0001\u0003\u0002\u0003\u0006Ia\f'\t\u00135\u0003!\u0011!Q\u0001\n9;\u0006\"\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-`\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001dA\u0007\u00011A\u0005\n%Dq!\u001c\u0001A\u0002\u0013%a\u000e\u0003\u0004x\u0001\u0001\u0006KA\u001b\u0005\u0006q\u0002!\t%\u001f\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t9\u0004\u0001C!\u0003sAq!a\u000e\u0001\t\u0003\nY\u0007C\u0004\u00028\u0001!\t%a\u001e\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\f\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\t9\u0004\u0001C\u0001\u0003KCq!a\u000e\u0001\t\u0003\t\u0019\fC\u0004\u0002>\u0002!I!a0\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sKN#xN]3\u000b\u0005Y9\u0012\u0001C4f_R|w\u000e\\:\u000b\u0005aI\u0012!B5oI\u0016D(B\u0001\u000e\u001c\u0003\u001d9Wm\\7fg\u0006T!\u0001H\u000f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011&!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\u000bHK>lUm]1GK\u0006$XO]3T_V\u00148-\u001a\t\u0003M1j\u0011a\n\u0006\u0003Q%\naa]5na2,'B\u0001\u0016,\u0003\u0011!\u0017\r^1\u000b\u0005Yi\u0012BA\u0017(\u0005I\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN#xN]3\u0002\u0005\u0011\u001c(c\u0001\u00193m\u0019!\u0011\u0007\u0001\u00010\u00051a$/\u001a4j]\u0016lWM\u001c;?!\t\u0019D'D\u0001*\u0013\t)\u0014FA\u0005ECR\f7\u000b^8sKB\u0011q'\u0013\b\u0003q\u0019s!!\u000f#\u000f\u0005i\u001aeBA\u001eC\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@?\u00051AH]8pizJ\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012BA#\u0018\u0003\u0015\u0019H/\u0019;t\u0013\t9\u0005*A\u0004qC\u000e\\\u0017mZ3\u000b\u0005\u0015;\u0012B\u0001&L\u0005=A\u0015m]$f_6+7/Y*uCR\u001c(BA$I\u0013\tq3%A\u0002tMR\u0004\"aT+\u000e\u0003AS!\u0001K)\u000b\u0005I\u001b\u0016a\u00024fCR,(/\u001a\u0006\u0003)v\tqa\u001c9f]\u001eL7/\u0003\u0002W!\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\n\u00055\u001b\u0013A\u0002:v]:,'\u000f\u0005\u0002[;6\t1L\u0003\u0002]/\u0005A\u0001\u000f\\1o]&tw-\u0003\u0002_7\nY\u0011+^3ssJ+hN\\3s\u0013\tA6%\u0001\u0004=S:LGO\u0010\u000b\u0005E\u000e4w\r\u0005\u0002#\u0001!)a\u0006\u0002a\u0001IJ\u0019QM\r\u001c\u0007\tE\u0002\u0001\u0001\u001a\u0005\u0006\u001b\u0012\u0001\rA\u0014\u0005\u00061\u0012\u0001\r!W\u0001\fiJ\fgn]1di&|g.F\u0001k!\t\u00194.\u0003\u0002mS\tYAK]1og\u0006\u001cG/[8o\u0003=!(/\u00198tC\u000e$\u0018n\u001c8`I\u0015\fHCA8v!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005\u0011)f.\u001b;\t\u000fY4\u0011\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\u0002\u0019Q\u0014\u0018M\\:bGRLwN\u001c\u0011\u0002\u0017\u0005$GMR3biV\u0014Xm\u001d\u000b\u0004u\u0006U\u0001#B>\u0002\u0002\u0005\u0015Q\"\u0001?\u000b\u0005ut\u0018\u0001B;uS2T\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004q\u0014A\u0001T5tiB!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001C5eK:$\u0018\u000e^=\u000b\u0007\u0005=1+\u0001\u0004gS2$XM]\u0005\u0005\u0003'\tIAA\u0005GK\u0006$XO]3JI\"9\u0011q\u0003\u0005A\u0002\u0005e\u0011AC2pY2,7\r^5p]B9\u00111DA\u0010\u001d\u0006\rRBAA\u000f\u0015\t\u00116&\u0003\u0003\u0002\"\u0005u!!\u0005$fCR,(/Z\"pY2,7\r^5p]B\u0019q*!\n\n\u0007\u0005\u001d\u0002KA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\fg\u0016$h)Z1ukJ,7\u000fF\u0002p\u0003[Aq!a\f\n\u0001\u0004\t\t$\u0001\u0004sK\u0006$WM\u001d\t\u0007g\u0005Mb*a\t\n\u0007\u0005U\u0012FA\u0007GK\u0006$XO]3SK\u0006$WM]\u0001\u000f[>$\u0017NZ=GK\u0006$XO]3t)\u001dy\u00171HA+\u0003CBq!!\u0010\u000b\u0001\u0004\ty$\u0001\u0006biR\u0014\u0018NY;uKN\u0004R\u0001]A!\u0003\u000bJ1!a\u0011r\u0005\u0015\t%O]1z!\u0011\t9%a\u0014\u000f\t\u0005%\u00131\n\t\u0003{EL1!!\u0014r\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011QJ9\t\u000f\u0005]#\u00021\u0001\u0002Z\u00051a/\u00197vKN\u0004R\u0001]A!\u00037\u00022\u0001]A/\u0013\r\ty&\u001d\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005=!\u00021\u0001\u0002dA!\u0011QMA4\u001b\t\ti!\u0003\u0003\u0002j\u00055!A\u0002$jYR,'\u000fF\u0004p\u0003[\n\t(!\u001e\t\u000f\u0005=4\u00021\u0001\u0002F\u0005I\u0011\r\u001e;sS\n,H/\u001a\u0005\b\u0003gZ\u0001\u0019AA.\u0003\u00151\u0018\r\\;f\u0011\u001d\tya\u0003a\u0001\u0003G\"ra\\A=\u0003\u000f\u000bI\tC\u0004\u0002p1\u0001\r!a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!R\u0003\u0011!\u0018\u0010]3\n\t\u0005\u0015\u0015q\u0010\u0002\u0005\u001d\u0006lW\rC\u0004\u0002t1\u0001\r!a\u0017\t\u000f\u0005=A\u00021\u0001\u0002dQ9q.!$\u0002\u0012\u0006M\u0005bBA\u001f\u001b\u0001\u0007\u0011q\u0012\t\u0006a\u0006\u0005\u00131\u0010\u0005\b\u0003/j\u0001\u0019AA-\u0011\u001d\ty!\u0004a\u0001\u0003G\naB]3n_Z,g)Z1ukJ,7\u000fF\u0002p\u00033Cq!a\u0004\u000f\u0001\u0004\t\u0019'\u0001\btKR$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0007=\fy\nC\u0003i\u001f\u0001\u0007!.\u0001\bhKR$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0003)$ra\\AT\u0003_\u000b\t\fC\u0004\u0002pE\u0001\r!!+\u0011\t\u0005u\u00141V\u0005\u0005\u0003[\u000byHA\nBiR\u0014\u0018NY;uK\u0012+7o\u0019:jaR|'\u000fC\u0004\u0002tE\u0001\r!a\u0017\t\u000f\u0005=\u0011\u00031\u0001\u0002dQ9q.!.\u0002:\u0006m\u0006bBA\u001f%\u0001\u0007\u0011q\u0017\t\u0006a\u0006\u0005\u0013\u0011\u0016\u0005\b\u0003/\u0012\u0002\u0019AA-\u0011\u001d\tyA\u0005a\u0001\u0003G\naa\u001e:ji\u0016\u0014H\u0003BAa\u0003\u000f\u0004baMAb\u001d\u0006\r\u0012bAAcS\tia)Z1ukJ,wK]5uKJDq!a\u0004\u0014\u0001\u0004\tI\rE\u0003q\u0003\u0017\f\u0019'C\u0002\u0002NF\u0014aa\u00149uS>t\u0007")
public class GeoMesaFeatureStore
extends GeoMesaFeatureSource
implements SimpleFeatureStore {
    private Transaction transaction = Transaction.AUTO_COMMIT;

    private Transaction transaction() {
        return this.transaction;
    }

    private void transaction_$eq(Transaction x$1) {
        this.transaction = x$1;
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeatureId> fids = new ArrayList<FeatureId>(collection.size());
        ArrayBuffer errors = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        package.WithClose$.MODULE$.apply((Object)collection.features(), (Function0 & Serializable & scala.Serializable)() -> this.writer((Option<Filter>)None$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            GeoMesaFeatureStore.$anonfun$addFeatures$2(fids, errors, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
        if (!errors.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("Some features were not written:");
            errors.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                e.addSuppressed(x$1);
                return BoxedUnit.UNIT;
            });
            throw e;
        }
        return fids;
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.removeFeatures((Filter)Filter.INCLUDE);
        try {
            package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)None$.MODULE$), (Function1 & Serializable & scala.Serializable)writer -> {
                GeoMesaFeatureStore.$anonfun$setFeatures$1(reader, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        finally {
            reader.close();
        }
    }

    public void modifyFeatures(String[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).map((Function1 & Serializable & scala.Serializable)x$1 -> new NameImpl(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Name.class))), values, filter);
    }

    public void modifyFeatures(String attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{new NameImpl(attribute)}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{attribute}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name[] attributes2, Object[] values, Filter filter) {
        SimpleFeatureType sft = this.getSchema();
        Predef$.MODULE$.require(filter != null, (Function0 & Serializable & scala.Serializable)() -> "Filter must not be null");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Predef$.MODULE$.require(sft.getDescriptor(a) != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(a).append(" is not an attribute of ").append(sft$1.getName()).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.require(attributes2.length == values.length, (Function0 & Serializable & scala.Serializable)() -> "Modified names and values don't match");
        package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable & scala.Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$modifyFeatures$6(attributes2, values, writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFeatures(Filter filter) {
        DataStore dataStore = super.ds();
        if (dataStore instanceof GeoMesaDataStore) {
            GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
                if (TablePartition$.MODULE$.partitioned(super.sft())) {
                    ((ParIterableLike)geoMesaDataStore.manager().indices(super.sft(), geoMesaDataStore.manager().indices$default$2()).par()).foreach((Function1 & Serializable & scala.Serializable)index -> {
                        GeoMesaFeatureStore.$anonfun$removeFeatures$1(geoMesaDataStore, index);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    ((ParIterableLike)geoMesaDataStore.manager().indices(super.sft(), geoMesaDataStore.manager().indices$default$2()).par()).foreach((Function1 & Serializable & scala.Serializable)index -> {
                        GeoMesaFeatureStore.$anonfun$removeFeatures$2(geoMesaDataStore, index);
                        return BoxedUnit.UNIT;
                    });
                }
                geoMesaDataStore.stats().writer().clear(super.sft());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = (BoxedUnit)package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable & scala.Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$removeFeatures$4(writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void setTransaction(Transaction transaction) {
        Predef$.MODULE$.require(transaction != null, (Function0 & Serializable & scala.Serializable)() -> "Transaction can't be null - did you mean Transaction.AUTO_COMMIT?");
        this.transaction_$eq(transaction);
    }

    public Transaction getTransaction() {
        return this.transaction();
    }

    public void modifyFeatures(AttributeDescriptor attribute, Object value, Filter filter) {
        this.modifyFeatures(attribute.getName(), value, filter);
    }

    public void modifyFeatures(AttributeDescriptor[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Name.class))), values, filter);
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> writer(Option<Filter> filter) {
        SimpleFeatureWriter simpleFeatureWriter;
        DataStore dataStore = super.ds();
        if (dataStore instanceof MetadataBackedDataStore) {
            MetadataBackedDataStore metadataBackedDataStore = (MetadataBackedDataStore)dataStore;
            simpleFeatureWriter = metadataBackedDataStore.getFeatureWriter(super.sft(), this.transaction(), filter);
        } else {
            simpleFeatureWriter = filter.isEmpty() ? super.ds().getFeatureWriterAppend(super.sft().getTypeName(), this.transaction()) : super.ds().getFeatureWriter(super.sft().getTypeName(), (Filter)filter.get(), this.transaction());
        }
        return simpleFeatureWriter;
    }

    public static final /* synthetic */ void $anonfun$addFeatures$2(ArrayList fids$1, ArrayBuffer errors$1, FeatureIterator x0$1, FeatureWriter x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            FeatureIterator features = (FeatureIterator)tuple2._1();
            FeatureWriter writer = (FeatureWriter)tuple2._2();
            while (features.hasNext()) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)fids$1.add(FeatureUtils$.MODULE$.write(writer, (SimpleFeature)features.next(), FeatureUtils$.MODULE$.write$default$3()).getIdentifier()));
                }
                catch (IllegalArgumentException e) {
                    errors$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{e}));
                    bl = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$setFeatures$1(FeatureReader reader$1, FeatureWriter writer) {
        while (reader$1.hasNext()) {
            FeatureUtils$.MODULE$.write(writer, (SimpleFeature)reader$1.next(), FeatureUtils$.MODULE$.write$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$modifyFeatures$6(Name[] attributes$1, Object[] values$1, FeatureWriter writer) {
        while (writer.hasNext()) {
            SimpleFeature sf = (SimpleFeature)writer.next();
            for (int i = 0; i < attributes$1.length; ++i) {
                try {
                    sf.setAttribute(attributes$1[i], values$1[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new DataSourceException(new StringBuilder(32).append("Error updating feature ").append("'").append(sf.getID()).append("' with ").append(attributes$1[i]).append("=").append(values$1[i]).toString(), (Throwable)e);
                }
            }
            writer.write();
        }
    }

    public static final /* synthetic */ void $anonfun$removeFeatures$1(GeoMesaDataStore x2$1, GeoMesaFeatureIndex index) {
        x2$1.adapter().deleteTables(index.deleteTableNames((Option<String>)None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$removeFeatures$3(byte[] x$2) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$removeFeatures$2(GeoMesaDataStore x2$1, GeoMesaFeatureIndex index) {
        Option prefix = new Some((Object)index.keySpace().sharing()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureStore.$anonfun$removeFeatures$3(x$2)));
        x2$1.adapter().clearTables(index.getTableNames((Option<String>)None$.MODULE$), (Option<byte[]>)prefix);
    }

    public static final /* synthetic */ void $anonfun$removeFeatures$4(FeatureWriter writer) {
        while (writer.hasNext()) {
            writer.next();
            writer.remove();
        }
    }

    public GeoMesaFeatureStore(DataStore ds, SimpleFeatureType sft, QueryRunner runner) {
        super(ds, sft, runner);
    }
}

