/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.utils.DistributedLocking;
import org.locationtech.geomesa.index.utils.Releasable;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.geomesa.utils.index.ReservedWordCheck$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tUe!\u0002\u0013&\u0003\u0003\u0001\u0004\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u000bi\u0004A\u0011A>\t\u0013}\u0004!\u0019!C\tS\u0005\u0005\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0001\t\u000f\u0005m\u0001A\"\u0005\u0002\u001e!9\u0011\u0011\f\u0001\u0007\u0012\u0005m\u0003bBA3\u0001\u0019E\u0011q\r\u0005\b\u0003W\u0002a\u0011CA7\u0011\u001d\t\u0019\b\u0001D\t\u0003kBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAT\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t)\f\u0001C!\u0003{Cq!a1\u0001\t\u0003\n)\rC\u0004\u0002D\u0002!\t%!3\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0007bBA~\u0001\u0011\u0005\u0013Q \u0005\b\u0003w\u0004A\u0011\tB\b\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KA\u0001\"!8\u0001\r\u0003I#1\u0006\u0005\t\u0003w\u0004a\u0011A\u0015\u00034!9!\u0011\t\u0001\u0005B\t\r\u0003b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u0005+\u0002A\u0011\tB,\u0011\u001d\u0011I\u0006\u0001C\t\u00057B\u0001Ba\u0019\u0001\t#I#QM\u0004\b\u0005[*\u0003\u0012\u0001B8\r\u0019!S\u0005#\u0001\u0003r!1!\u0010\tC\u0001\u0005sB\u0011Ba\u001f!\u0005\u0004%IA! \t\u0011\tM\u0005\u0005)A\u0005\u0005\u007f\u0012q#T3uC\u0012\fG/\u0019\"bG.,G\rR1uCN#xN]3\u000b\u0005\u0019:\u0013\u0001C4f_R|w\u000e\\:\u000b\u0005!J\u0013!B5oI\u0016D(B\u0001\u0016,\u0003\u001d9Wm\\7fg\u0006T!\u0001L\u0017\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u0019:\u0001\u00024\u0007C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005irT\"A\u001e\u000b\u0005qj\u0014\u0001\u00023bi\u0006T!AJ\u0017\n\u0005}Z$!\u0003#bi\u0006\u001cFo\u001c:f!\r\t5K\u0016\b\u0003\u0005Bs!a\u0011(\u000f\u0005\u0011keBA#M\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002J_\u00051AH]8pizJ\u0011AL\u0005\u0003Y5J!AK\u0016\n\u0005!J\u0013BA((\u0003!iW\r^1eCR\f\u0017BA)S\u0003\u001d\u0001\u0018mY6bO\u0016T!aT\u0014\n\u0005Q+&A\u0005%bg\u001e+w.T3tC6+G/\u00193bi\u0006T!!\u0015*\u0011\u0005]kfB\u0001-\\!\t9\u0015LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016,\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/Z!\t\tG-D\u0001c\u0015\t\u0019w%A\u0003vi&d7/\u0003\u0002fE\n\u0011B)[:ue&\u0014W\u000f^3e\u0019>\u001c7.\u001b8h!\t9g.D\u0001i\u0015\tI'.\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002lY\u0006AA/\u001f9fg\u00064WMC\u0001n\u0003\r\u0019w.\\\u0005\u0003_\"\u00141\u0002T1{s2{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"A]<\u000f\u0005M,hBA\"u\u0013\t1s%\u0003\u0002wK\u00059r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/_\u0005\u0003qf\u0014qBT1nKN\u0004\u0018mY3D_:4\u0017n\u001a\u0006\u0003m\u0016\na\u0001P5oSRtDC\u0001?\u007f!\ti\b!D\u0001&\u0011\u0015\u0001(\u00011\u0001r\u00031Ig\u000e^3sG\u0016\u0004Ho\u001c:t+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005Ma\u0002BA\u0004\u0003\u001bq1aQA\u0005\u0013\r\tYaJ\u0001\ta2\fgN\\5oO&!\u0011qBA\t\u0003A\tV/\u001a:z\u0013:$XM]2faR|'OC\u0002\u0002\f\u001dJA!!\u0006\u0002\u0018\t9\u0012+^3ss&sG/\u001a:dKB$xN\u001d$bGR|'/\u001f\u0006\u0005\u0003\u001f\t\t\"A\u0007j]R,'oY3qi>\u00148\u000fI\u0001\u0010aJ,7k\u00195f[\u0006\u001c%/Z1uKR!\u0011qDA\u0014!\u0011\t\t#a\t\u000e\u0003eK1!!\nZ\u0005\u0011)f.\u001b;\t\u000f\u0005%R\u00011\u0001\u0002,\u0005\u00191O\u001a;\u0011\t\u00055\u00121H\u0007\u0003\u0003_QA!!\r\u00024\u000511/[7qY\u0016TA!!\u000e\u00028\u00059a-Z1ukJ,'bAA\u001d[\u00059q\u000e]3oO&\u001c\u0018\u0002BA\u001f\u0003_\u0011\u0011cU5na2,g)Z1ukJ,G+\u001f9fQ\u0015)\u0011\u0011IA,!\u0019\t\t#a\u0011\u0002H%\u0019\u0011QI-\u0003\rQD'o\\<t!\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0004\u000f\u00065\u0013\"\u0001.\n\u0005EK\u0016\u0002BA*\u0003+\u0012\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\t\t\u0016l\t\u0002\u0002H\u0005y\u0001O]3TG\",W.Y+qI\u0006$X\r\u0006\u0004\u0002 \u0005u\u0013q\f\u0005\b\u0003S1\u0001\u0019AA\u0016\u0011\u001d\t\tG\u0002a\u0001\u0003W\t\u0001\u0002\u001d:fm&|Wo\u001d\u0015\u0006\r\u0005\u0005\u0013qK\u0001\u0010_:\u001c6\r[3nC\u000e\u0013X-\u0019;fIR!\u0011qDA5\u0011\u001d\tIc\u0002a\u0001\u0003W\tqb\u001c8TG\",W.Y+qI\u0006$X\r\u001a\u000b\u0007\u0003?\ty'!\u001d\t\u000f\u0005%\u0002\u00021\u0001\u0002,!9\u0011\u0011\r\u0005A\u0002\u0005-\u0012aD8o'\u000eDW-\\1EK2,G/\u001a3\u0015\t\u0005}\u0011q\u000f\u0005\b\u0003SI\u0001\u0019AA\u0016\u000319W\r\u001e+za\u0016t\u0015-\\3t)\t\ti\bE\u0003\u0002\"\u0005}d+C\u0002\u0002\u0002f\u0013Q!\u0011:sCf\f\u0001bZ3u\u001d\u0006lWm\u001d\u000b\u0003\u0003\u000f\u0003b!!#\u0002\u0010\u0006MUBAAF\u0015\r\ti)N\u0001\u0005kRLG.\u0003\u0003\u0002\u0012\u0006-%\u0001\u0002'jgR\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000b\u0019$\u0001\u0003usB,\u0017\u0002BAO\u0003/\u0013AAT1nK\u0006a1M]3bi\u0016\u001c6\r[3nCR!\u0011qDAR\u0011\u001d\t)\u000b\u0004a\u0001\u0003W\taa]2iK6\f\u0017!C4fiN\u001b\u0007.Z7b)\u0011\tY#a+\t\u000f\u00055V\u00021\u0001\u0002\u0014\u0006!a.Y7f)\u0011\tY#!-\t\r\u0005Mf\u00021\u0001W\u0003!!\u0018\u0010]3OC6,\u0017\u0001D;qI\u0006$XmU2iK6\fGCBA\u0010\u0003s\u000bY\f\u0003\u0004\u00024>\u0001\rA\u0016\u0005\b\u0003Sy\u0001\u0019AA\u0016)\u0019\ty\"a0\u0002B\"9\u00111\u0017\tA\u0002\u0005M\u0005bBAS!\u0001\u0007\u00111F\u0001\re\u0016lwN^3TG\",W.\u0019\u000b\u0005\u0003?\t9\r\u0003\u0004\u00024F\u0001\rA\u0016\u000b\u0005\u0003?\tY\rC\u0004\u00024J\u0001\r!a%\u0002!\u001d,GOR3biV\u0014XmU8ve\u000e,G\u0003BAi\u00037\u0004B!a5\u0002X6\u0011\u0011Q\u001b\u0006\u0004\u0003cY\u0014\u0002BAm\u0003+\u00141cU5na2,g)Z1ukJ,7k\\;sG\u0016Dq!a-\u0014\u0001\u0004\t\u0019*\u0001\thKR4U-\u0019;ve\u0016\u0014V-\u00193feR1\u0011\u0011]At\u0003c\u00042!`Ar\u0013\r\t)/\n\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f%\u0016\fG-\u001a:\t\u000f\u0005%H\u00031\u0001\u0002l\u0006)\u0011/^3ssB\u0019!(!<\n\u0007\u0005=8HA\u0003Rk\u0016\u0014\u0018\u0010C\u0004\u0002tR\u0001\r!!>\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\t\u0004u\u0005]\u0018bAA}w\tYAK]1og\u0006\u001cG/[8o\u0003A9W\r\u001e$fCR,(/Z,sSR,'\u000f\u0006\u0004\u0002\u0000\n-!Q\u0002\t\u0005\u0005\u0003\u0011)AD\u0002D\u0005\u0007I!!U\u0014\n\t\t\u001d!\u0011\u0002\u0002\u0017\r2,8\u000f[1cY\u00164U-\u0019;ve\u0016<&/\u001b;fe*\u0011\u0011k\n\u0005\u0007\u0003g+\u0002\u0019\u0001,\t\u000f\u0005MX\u00031\u0001\u0002vRA\u0011q B\t\u0005'\u0011\t\u0003\u0003\u0004\u00024Z\u0001\rA\u0016\u0005\b\u0005+1\u0002\u0019\u0001B\f\u0003\u00191\u0017\u000e\u001c;feB!!\u0011\u0004B\u000f\u001b\t\u0011YB\u0003\u0003\u0003\u0016\u0005]\u0012\u0002\u0002B\u0010\u00057\u0011aAR5mi\u0016\u0014\bbBAz-\u0001\u0007\u0011Q_\u0001\u0017O\u0016$h)Z1ukJ,wK]5uKJ\f\u0005\u000f]3oIR1\u0011q B\u0014\u0005SAa!a-\u0018\u0001\u00041\u0006bBAz/\u0001\u0007\u0011Q\u001f\u000b\t\u0003C\u0014iCa\f\u00032!9\u0011\u0011\u0006\rA\u0002\u0005-\u0002bBAz1\u0001\u0007\u0011Q\u001f\u0005\b\u0003SD\u0002\u0019AAv)!\tyP!\u000e\u00038\te\u0002bBA\u00153\u0001\u0007\u00111\u0006\u0005\b\u0003gL\u0002\u0019AA{\u0011\u001d\u0011)\"\u0007a\u0001\u0005w\u0001b!!\t\u0003>\t]\u0011b\u0001B 3\n1q\n\u001d;j_:\fqaZ3u\u0013:4w\u000e\u0006\u0002\u0003FA\u0019!Ha\u0012\n\u0007\t%3HA\u0006TKJ4\u0018nY3J]\u001a|\u0017!E4fi2{7m[5oO6\u000bg.Y4feR\u0011!q\n\t\u0004u\tE\u0013b\u0001B*w\tqAj\\2lS:<W*\u00198bO\u0016\u0014\u0018a\u00023jgB|7/\u001a\u000b\u0003\u0003?\tAC^1mS\u0012\fG/Z*dQ\u0016l\u0017-\u00169eCR,GCBA\u0010\u0005;\u0012\t\u0007C\u0004\u0003`u\u0001\r!a\u000b\u0002\u0011\u0015D\u0018n\u001d;j]\u001eDq!!*\u001e\u0001\u0004\tY#\u0001\nbGF,\u0018N]3DCR\fGn\\4M_\u000e\\GC\u0001B4!\r\t'\u0011N\u0005\u0004\u0005W\u0012'A\u0003*fY\u0016\f7/\u00192mK\u00069R*\u001a;bI\u0006$\u0018MQ1dW\u0016$G)\u0019;b'R|'/\u001a\t\u0003{\u0002\u001a2\u0001\tB:!\u0011\t\tC!\u001e\n\u0007\t]\u0014L\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005_\n\u0001$\u00168n_\u0012Lg-[1cY\u0016,6/\u001a:ECR\f7*Z=t+\t\u0011y\b\u0005\u0004\u0003\u0002\n-%qR\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005\u0013K\u0016AC2pY2,7\r^5p]&!!Q\u0012BB\u0005\r\u0019V\r\u001e\t\u0004e\tE\u0015B\u000104\u0003e)f.\\8eS\u001aL\u0017M\u00197f+N,'\u000fR1uC.+\u0017p\u001d\u0011")
public abstract class MetadataBackedDataStore
implements DataStore,
package.HasGeoMesaMetadata<String>,
DistributedLocking,
LazyLogging {
    private final GeoMesaDataStoreFactory.NamespaceConfig config;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public <T> T withLock(String key, Function0<T> fn) {
        return (T)DistributedLocking.withLock$(this, key, fn);
    }

    @Override
    public <T> T withLock(String key, long timeOut, Function0<T> fn, Function0<T> fallback) {
        return (T)DistributedLocking.withLock$(this, key, timeOut, fn, fallback);
    }

    private Logger logger$lzycompute() {
        MetadataBackedDataStore metadataBackedDataStore = this;
        synchronized (metadataBackedDataStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    public abstract void preSchemaCreate(SimpleFeatureType var1) throws IllegalArgumentException;

    public abstract void preSchemaUpdate(SimpleFeatureType var1, SimpleFeatureType var2) throws IllegalArgumentException;

    public abstract void onSchemaCreated(SimpleFeatureType var1);

    public abstract void onSchemaUpdated(SimpleFeatureType var1, SimpleFeatureType var2);

    public abstract void onSchemaDeleted(SimpleFeatureType var1);

    public String[] getTypeNames() {
        return this.metadata().getFeatureTypes();
    }

    /*
     * WARNING - void declaration
     */
    public List<Name> getNames() {
        void var2_1;
        ArrayList names = new ArrayList();
        Option<String> option = this.config.namespace();
        if (None$.MODULE$.equals(option)) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(name))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String ns = (String)some.value();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(ns, name))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return var2_1;
    }

    public void createSchema(SimpleFeatureType schema) {
        block10: {
            if (this.getSchema(schema.getTypeName()) == null) {
                Releasable lock = this.acquireCatalogLock();
                try {
                    if (this.getSchema(schema.getTypeName()) != null) break block10;
                    SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
                    GeoMesaSchemaValidator$.MODULE$.validate(sft);
                    this.preSchemaCreate(sft);
                    try {
                        Map metadataMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.AttributesKey()), (Object)SimpleFeatureTypes$.MODULE$.encodeType(sft, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.StatsGenerationKey()), (Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.GeoToolsDateFormat().format(Instant.now().atOffset(ZoneOffset.UTC)))}));
                        this.metadata().insert(sft.getTypeName(), metadataMap);
                        String attributes2 = (String)this.metadata().readRequired(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey());
                        SimpleFeatureType reloadedSft = SimpleFeatureTypes$.MODULE$.createType(sft.getTypeName(), attributes2);
                        HashMap userData = new HashMap();
                        userData.putAll(reloadedSft.getUserData());
                        reloadedSft.getUserData().putAll(sft.getUserData());
                        reloadedSft.getUserData().putAll(userData);
                        this.onSchemaCreated(reloadedSft);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e;
                            block11: {
                                e = (Throwable)option.get();
                                try {
                                    this.metadata().delete(sft.getTypeName());
                                }
                                catch (Throwable throwable3) {
                                    Throwable throwable4 = throwable3;
                                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                                    if (!option2.isEmpty()) {
                                        Throwable e2 = (Throwable)option2.get();
                                        e.addSuppressed(e2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block11;
                                    }
                                    throw throwable3;
                                }
                            }
                            throw e;
                        }
                        throw throwable;
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
    }

    public SimpleFeatureType getSchema(Name name) {
        return this.getSchema(name.getLocalPart());
    }

    public SimpleFeatureType getSchema(String typeName) {
        SimpleFeatureType simpleFeatureType;
        boolean x$3;
        String x$2;
        String x$1;
        GeoMesaMetadata qual$1 = this.metadata();
        Option option = qual$1.read(x$1 = typeName, x$2 = GeoMesaMetadata$.MODULE$.AttributesKey(), x$3 = qual$1.read$default$3());
        if (None$.MODULE$.equals(option)) {
            simpleFeatureType = null;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String spec = (String)some.value();
            simpleFeatureType = SimpleFeatureTypes$.MODULE$.createImmutableType((String)this.config.namespace().orNull(Predef$.MODULE$.$conforms()), typeName, spec);
        } else {
            throw new MatchError(option);
        }
        return simpleFeatureType;
    }

    public void updateSchema(String typeName, SimpleFeatureType sft) {
        this.updateSchema((Name)new NameImpl(typeName), sft);
    }

    public void updateSchema(Name typeName, SimpleFeatureType schema) {
        String string = typeName.getLocalPart();
        String string2 = schema.getTypeName();
        if ((string == null ? string2 != null : !string.equals(string2)) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).contains((Object)schema.getTypeName())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Updated type name already exists: '").append(typeName).append("' changed to '").append(schema.getTypeName()).append("'").toString());
        }
        Releasable lock = this.acquireCatalogLock();
        try {
            SimpleFeatureType previousSft = this.getSchema(typeName);
            if (previousSft == null) {
                throw new IllegalArgumentException(new StringBuilder(24).append("Schema '").append(typeName).append("' does not exist").toString());
            }
            GeoMesaSchemaValidator$.MODULE$.validate(schema);
            this.validateSchemaUpdate(previousSft, schema);
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
            this.preSchemaUpdate(sft, previousSft);
            if (Predef$.MODULE$.Boolean2boolean((Boolean)FastConverter$.MODULE$.convertOrElse(sft.getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.UpdateBackupMetadata()), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.boolean2Boolean(true), ClassTag$.MODULE$.apply(Boolean.class)))) {
                this.metadata().backup(typeName.getLocalPart());
            }
            String string3 = typeName.getLocalPart();
            String string4 = schema.getTypeName();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.metadata().scan(typeName.getLocalPart(), "", false).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    MetadataBackedDataStore.$anonfun$updateSchema$2(this, sft, typeName, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            this.metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey(), SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
            this.onSchemaUpdated(sft, previousSft);
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(String typeName) {
        Releasable lock = this.acquireCatalogLock();
        try {
            Option$.MODULE$.apply((Object)this.getSchema(typeName)).foreach((Function1 & Serializable & scala.Serializable)sft -> {
                MetadataBackedDataStore.$anonfun$removeSchema$1(this, typeName, sft);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public GeoMesaFeatureReader getFeatureReader(Query query, Transaction transaction) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0 & Serializable & scala.Serializable)() -> "Type name is required in the query");
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(query.getTypeName()).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureReader(sft, transaction, query);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)Option$.MODULE$.apply((Object)filter));
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)None$.MODULE$);
    }

    public abstract GeoMesaFeatureReader getFeatureReader(SimpleFeatureType var1, Transaction var2, Query var3);

    public abstract SimpleFeatureWriter getFeatureWriter(SimpleFeatureType var1, Transaction var2, Option<Filter> var3);

    /*
     * WARNING - void declaration
     */
    public ServiceInfo getInfo() {
        void var1_1;
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringBuilder(14).append("Features from ").append(this.getClass().getSimpleName()).toString());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return var1_1;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.metadata(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void validateSchemaUpdate(SimpleFeatureType existing, SimpleFeatureType schema) {
        block3: {
            if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema)) != RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing))) {
                throw new UnsupportedOperationException("Changing the default geometry attribute is not supported");
            }
            Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema));
            Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing));
            if (option == null ? option2 != null : !option.equals(option2)) {
                throw new UnsupportedOperationException("Changing the default date attribute is not supported");
            }
            MetadataBackedDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$MetadataBackedDataStore$$UnmodifiableUserDataKeys().foreach((Function1 & Serializable & scala.Serializable)key -> {
                MetadataBackedDataStore.$anonfun$validateSchemaUpdate$1(schema, existing, key);
                return BoxedUnit.UNIT;
            });
            if (existing.getAttributeCount() > schema.getAttributeCount()) {
                throw new UnsupportedOperationException("Removing attributes from the schema is not supported");
            }
            ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(existing.getAttributeDescriptors()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MetadataBackedDataStore.$anonfun$validateSchemaUpdate$2(schema, x0$1);
                return BoxedUnit.UNIT;
            });
            boolean reserved = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetadataBackedDataStore.$anonfun$validateSchemaUpdate$4(existing, name)));
            if (!reserved) break block3;
            ReservedWordCheck$.MODULE$.validateAttributeNames(schema);
        }
    }

    public Releasable acquireCatalogLock() {
        String dsTypeName = this.getClass().getSimpleName().replaceAll("[^A-Za-z]", "");
        String path = new StringBuilder(30).append("/org.locationtech.geomesa/ds/").append(dsTypeName).append("/").append(this.config.catalog()).toString();
        Duration timeout = (Duration)package$.MODULE$.DistributedLockTimeout().toDuration().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Couldn't convert '").append(package$.MODULE$.DistributedLockTimeout().get()).append("' to a duration").toString());
        });
        return (Releasable)this.acquireDistributedLock(path, timeout.toMillis()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(48).append("Could not acquire distributed lock at '").append(path).append("' within ").append(timeout).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$updateSchema$2(MetadataBackedDataStore $this, SimpleFeatureType sft$1, Name typeName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        $this.metadata().insert(sft$1.getTypeName(), k, v);
        $this.metadata().remove(typeName$1.getLocalPart(), k);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$removeSchema$1(MetadataBackedDataStore $this, String typeName$2, SimpleFeatureType sft) {
        $this.onSchemaDeleted(sft);
        $this.metadata().delete(typeName$2);
    }

    public static final /* synthetic */ void $anonfun$validateSchemaUpdate$1(SimpleFeatureType schema$1, SimpleFeatureType existing$1, String key) {
        Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema$1), (Object)key);
        Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing$1), (Object)key);
        if (option == null ? option2 != null : !option.equals(option2)) {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Updating '").append(key).append("' is not supported").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateSchemaUpdate$2(SimpleFeatureType schema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AttributeDescriptor prev = (AttributeDescriptor)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Class binding = schema$1.getDescriptor(i).getType().getBinding();
            if (!binding.isAssignableFrom(prev.getType().getBinding())) {
                throw new UnsupportedOperationException(new StringBuilder(50).append("Incompatible schema column type change: ").append(schema$1.getDescriptor(i).getLocalName()).append(" ").append("from ").append(prev.getType().getBinding().getName()).append(" to ").append(binding.getName()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateSchemaUpdate$4(SimpleFeatureType existing$1, String name) {
        return existing$1.getDescriptor(name) == null && FeatureUtils$.MODULE$.ReservedWords().contains((Object)name.toUpperCase(Locale.US));
    }

    public MetadataBackedDataStore(GeoMesaDataStoreFactory.NamespaceConfig config) {
        this.config = config;
        DistributedLocking.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.apply(this);
    }
}

