/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$Configuration$;
import org.locationtech.geomesa.index.iterators.ArrowScan$Configuration$Types$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.AttributeOrdering$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class ArrowScan$
implements LazyLogging {
    public static ArrowScan$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty DictionaryTopK;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ArrowScan$();
    }

    private Logger logger$lzycompute() {
        ArrowScan$ arrowScan$ = this;
        synchronized (arrowScan$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public GeoMesaSystemProperties.SystemProperty DictionaryTopK() {
        return this.DictionaryTopK;
    }

    public ArrowScan.ArrowScanConfig configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, GeoMesaStats stats, Option<Filter> filter, Option<Filter> ecql, Hints hints) {
        ArrowScan.ArrowScanConfig arrowScanConfig;
        Map cachedDictionaries;
        Map map;
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryHints$.MODULE$.RichHints(hints).getTransformSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
        boolean includeFids = QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid();
        boolean proxyFids = QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid();
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = this.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids, proxyFids);
        String ipc = (String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(ipc);
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, ecql, QueryHints$.MODULE$.RichHints(hints).getTransform(), QueryHints$.MODULE$.RichHints(hints).getSampling(), batchSize);
        Map baseConfig = base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.IncludeFidsKey()), AggregatingScan$.MODULE$.StringToConfig(Boolean.toString(includeFids))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.ProxyFidsKey()), AggregatingScan$.MODULE$.StringToConfig(Boolean.toString(proxyFids))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.IpcVersionKey()), AggregatingScan$.MODULE$.StringToConfig(ipc)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortReverseKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1 & Serializable & scala.Serializable)x$6 -> Boolean.toString(x$6._2$mcZ$sp()))))})));
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        Map<String, Object[]> providedDictionaries = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(sft);
        if (!QueryHints$.MODULE$.RichHints(hints).isArrowCachedDictionaries()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Seq toLookup = (Seq)dictionaryFields.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)providedDictionaries.contains((Object)key)));
            map = cachedDictionaries = ((TraversableOnce)((TraversableLike)toLookup.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.option2Iterable(stats.getTopK(sft, (String)x$7, stats.getTopK$default$3(), stats.getTopK$default$4())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.property()), k), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowDoublePass() || dictionaryFields.nonEmpty() && dictionaryFields.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrowScan$.$anonfun$configure$8(providedDictionaries, cachedDictionaries, f)))) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Running deprecated Arrow double pass scan - switch to delta scans instead");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Map<String, ArrowDictionary> dictionaries = this.createDictionaries(stats, sft, filter, dictionaryFields, providedDictionaries, (Map<String, TopK<Object>>)cachedDictionaries);
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.BatchType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)this.org$locationtech$geomesa$index$iterators$ArrowScan$$encodeDictionaries(dictionaries))})));
            ArrowScan.BatchReducer reducer = new ArrowScan.BatchReducer(arrowSft, dictionaries, encoding, ipcOpts, batchSize, sort, false);
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, reducer);
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowMultiFile()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Running deprecated Arrow multi file scan - switch to delta scans instead");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.FileType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)dictionaryFields.mkString(","))})));
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, new ArrowScan.FileReducer(arrowSft, dictionaryFields, encoding, ipcOpts, sort));
        } else {
            Map config = baseConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.TypeKey()), (Object)ArrowScan$Configuration$Types$.MODULE$.DeltaType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), (Object)dictionaryFields.mkString(","))})));
            boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
            ArrowScan.DeltaReducer reducer = new ArrowScan.DeltaReducer(arrowSft, dictionaryFields, encoding, ipcOpts, batchSize, sort, false, process);
            arrowScanConfig = new ArrowScan.ArrowScanConfig((Map<String, String>)config, reducer);
        }
        return arrowScanConfig;
    }

    public int getBatchSize(Hints hints) {
        return BoxesRunTime.unboxToInt((Object)QueryHints$.MODULE$.RichHints(hints).getArrowBatchSize().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
    }

    public Map<String, ArrowDictionary> createDictionaries(GeoMesaStats stats, SimpleFeatureType sft, Option<Filter> filter, Seq<String> attributes2, Map<String, Object[]> provided, Map<String, TopK<Object>> cached) {
        Map map;
        if (attributes2.isEmpty()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            LongRef id = LongRef.create((long)-1L);
            Map providedDictionaries = (Map)provided.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Object[] v;
                String k;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    k = (String)tuple22._1();
                    v = (Object[])tuple22._2();
                    ++id$1.elem;
                    AttributeDescriptor descriptor = sft.getDescriptor(k);
                    Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
                    Tuple2 tuple24 = tuple23 = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? new Tuple2((Object)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)), (Object)AttributeOrdering$.MODULE$.apply((Seq)bindings.tail())) : new Tuple2((Object)descriptor.getType().getBinding(), (Object)AttributeOrdering$.MODULE$.apply(bindings));
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Class binding = (Class)tuple23._1();
                    Ordering order = (Ordering)tuple23._2();
                    tuple2 = new Tuple2((Object)binding, (Object)order);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple25 = tuple2;
                Class binding = (Class)tuple25._1();
                Ordering order = (Ordering)tuple25._2();
                Arrays.sort(v, order);
                Tuple2 tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(sft.getTypeName(), id$1.elem, v, ClassTag$.MODULE$.apply(binding)));
                return tuple26;
            }, Map$.MODULE$.canBuildFrom());
            Seq toLookup = (Seq)attributes2.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)provided.contains((Object)key)));
            if (toLookup.isEmpty()) {
                map = providedDictionaries;
            } else {
                Map map2;
                if (toLookup.forall((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)cached.contains((Object)key)))) {
                    map2 = (Map)cached.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple3 tuple3;
                        String name;
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple3 tuple32;
                            Tuple3 tuple33;
                            name = (String)tuple2._1();
                            TopK k = (TopK)tuple2._2();
                            ++id$1.elem;
                            AttributeDescriptor descriptor = sft.getDescriptor(name);
                            Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
                            if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
                                Iterator lists = k.topK(new StringOps(Predef$.MODULE$.augmentString(MODULE$.DictionaryTopK().get())).toInt());
                                Object[] values = (Object[])lists.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)x$9._1()).asScala()).toArray(ClassTag$.MODULE$.AnyRef());
                                tuple33 = new Tuple3((Object)values, (Object)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)), (Object)AttributeOrdering$.MODULE$.apply((Seq)bindings.tail()));
                            } else {
                                Object[] values = (Object[])k.topK(new StringOps(Predef$.MODULE$.augmentString(MODULE$.DictionaryTopK().get())).toInt()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10._1()).toArray(ClassTag$.MODULE$.AnyRef());
                                tuple33 = tuple32 = new Tuple3((Object)values, (Object)descriptor.getType().getBinding(), (Object)AttributeOrdering$.MODULE$.apply(bindings));
                            }
                            if (tuple32 == null) {
                                throw new MatchError((Object)tuple32);
                            }
                            Object[] values = (Object[])tuple32._1();
                            Class binding = (Class)tuple32._2();
                            Ordering order = (Ordering)tuple32._3();
                            tuple3 = new Tuple3((Object)values, (Object)binding, (Object)order);
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        Tuple3 tuple34 = tuple3;
                        Object[] values = (Object[])tuple34._1();
                        Class binding = (Class)tuple34._2();
                        Ordering order = (Ordering)tuple34._3();
                        Arrays.sort(values, order);
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(sft.getTypeName(), id$1.elem, values, ClassTag$.MODULE$.apply(binding)));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom());
                } else {
                    Seq queries = (Seq)toLookup.map((Function1 & Serializable & scala.Serializable)attribute -> Stat$.MODULE$.Enumeration(attribute), Seq$.MODULE$.canBuildFrom());
                    Filter filt = (Filter)filter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE);
                    Seq enumerations = stats.getSeqStat(sft, (Seq<String>)queries, filt, true);
                    Iterator nameIter = toLookup.iterator();
                    map2 = ((TraversableOnce)enumerations.map((Function1 & Serializable & scala.Serializable)e -> {
                        Tuple3 tuple3;
                        Tuple3 tuple32;
                        ++id$1.elem;
                        String name = (String)nameIter.next();
                        AttributeDescriptor descriptor = sft.getDescriptor(name);
                        Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
                        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
                            Object[] values = (Object[])((TraversableOnce)e.values().flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)((Object)x$12)).asScala(), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef());
                            tuple32 = new Tuple3((Object)values, (Object)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)), (Object)AttributeOrdering$.MODULE$.apply((Seq)bindings.tail()));
                        } else {
                            Object[] values = (Object[])e.values().toArray(ClassTag$.MODULE$.AnyRef());
                            tuple32 = tuple3 = new Tuple3((Object)values, (Object)descriptor.getType().getBinding(), (Object)AttributeOrdering$.MODULE$.apply(bindings));
                        }
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Object[] values = (Object[])tuple3._1();
                        Class binding = (Class)tuple3._2();
                        Ordering order = (Ordering)tuple3._3();
                        Tuple3 tuple33 = new Tuple3((Object)values, (Object)binding, (Object)order);
                        Tuple3 tuple34 = tuple33;
                        Object[] values2 = (Object[])tuple34._1();
                        Class binding2 = (Class)tuple34._2();
                        Ordering order2 = (Ordering)tuple34._3();
                        Arrays.sort(values2, order2);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(sft.getTypeName(), id$1.elem, values2, ClassTag$.MODULE$.apply(binding2)));
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
                Map queried = map2;
                map = queried.$plus$plus((GenTraversableOnce)providedDictionaries);
            }
        }
        return map;
    }

    public SimpleFeature resultFeature() {
        return new ScalaSimpleFeature(package$.MODULE$.ArrowEncodedSft(), "", new Object[]{null, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
    }

    public String org$locationtech$geomesa$index$iterators$ArrowScan$$encodeDictionaries(Map<String, ArrowDictionary> dictionaries) {
        return StringSerialization$.MODULE$.encodeSeqMap((Map)dictionaries.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ArrowDictionary v = (ArrowDictionary)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.iterator().toSeq());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()));
    }

    public Map<String, ArrowDictionary> org$locationtech$geomesa$index$iterators$ArrowScan$$decodeDictionaries(SimpleFeatureType sft, String encoded) {
        LongRef id = LongRef.create((long)-1L);
        return (Map)StringSerialization$.MODULE$.decodeSeqMap(sft, encoded).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object[] v;
            String k;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                k = (String)tuple2._1();
                v = (Object[])tuple2._2();
                ++id$2.elem;
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(sft.getTypeName(), id$2.elem, v, ClassTag$.MODULE$.apply(sft.getDescriptor(k).getType().getBinding())));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$configure$8(Map providedDictionaries$1, Map cachedDictionaries$1, String f) {
        return providedDictionaries$1.contains((Object)f) || cachedDictionaries$1.contains((Object)f);
    }

    private ArrowScan$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.DictionaryTopK = new GeoMesaSystemProperties.SystemProperty("geomesa.arrow.dictionary.top", "1000");
    }
}

