/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureSerialization$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.index.iterators.DensityScan$EqualWeight$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.interop.SimpleFeatureTypes;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class DensityScan$
implements LazyLogging {
    public static DensityScan$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty BatchSize;
    private final SimpleFeatureType DensitySft;
    private final Hints.ClassKey DensityValueKey;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DensityScan$();
    }

    private Logger logger$lzycompute() {
        DensityScan$ densityScan$ = this;
        synchronized (densityScan$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public GeoMesaSystemProperties.SystemProperty BatchSize() {
        return this.BatchSize;
    }

    public SimpleFeatureType DensitySft() {
        return this.DensitySft;
    }

    public Hints.ClassKey DensityValueKey() {
        return this.DensityValueKey;
    }

    public Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<Filter> filter, Hints hints) {
        String geom = this.getDensityGeometry(sft, hints);
        Envelope envelope = (Envelope)QueryHints$.MODULE$.RichHints(hints).getDensityEnvelope().get();
        Tuple2 tuple2 = (Tuple2)QueryHints$.MODULE$.RichHints(hints).getDensityBounds().get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int width = tuple2._1$mcI$sp();
        int height = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        Tuple2.mcII.sp sp3 = sp2;
        int width2 = sp3._1$mcI$sp();
        int height2 = sp3._2$mcI$sp();
        int batchSize = BoxesRunTime.unboxToInt((Object)this.BatchSize().toInt().get());
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, filter, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, QueryHints$.MODULE$.RichHints(hints).getSampling(), batchSize);
        return base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.GeometryOpt()), AggregatingScan$.MODULE$.StringToConfig(geom)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt()), AggregatingScan$.MODULE$.StringToConfig(new java.lang.StringBuilder(3).append(envelope.getMinX()).append(",").append(envelope.getMaxX()).append(",").append(envelope.getMinY()).append(",").append(envelope.getMaxY()).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.GridOpt()), AggregatingScan$.MODULE$.StringToConfig(new java.lang.StringBuilder(1).append(width2).append(",").append(height2).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.WeightOpt()), AggregatingScan$.MODULE$.OptionToConfig(QueryHints$.MODULE$.RichHints(hints).getDensityWeight()))})));
    }

    public byte[] encodeResult(RenderingGrid result) {
        Output output = KryoFeatureSerialization$.MODULE$.getOutput(null);
        result.iterator().toList().groupBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)DensityScan$.$anonfun$encodeResult$1(x$5))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DensityScan$.$anonfun$encodeResult$2(output, x0$1);
            return BoxedUnit.UNIT;
        });
        return output.toBytes();
    }

    public Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int gridWidth, int gridHeight) {
        GridSnap gridSnap = new GridSnap(envelope, gridWidth, gridHeight);
        return (Function1 & Serializable & scala.Serializable)sf -> MODULE$.decodeResult(gridSnap, (SimpleFeature)sf);
    }

    public Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature sf) {
        byte[] result = (byte[])sf.getUserData().get(this.DensityValueKey());
        Input input = KryoFeatureDeserialization$.MODULE$.getInput(result, 0, result.length);
        return new Iterator<Tuple3<Object, Object, Object>>(input, gridSnap){
            private double x;
            private int colCount;
            private final Input input$1;
            private final GridSnap gridSnap$1;

            public Iterator<Tuple3<Object, Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple3<Object, Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple3<Object, Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple3<Object, Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple3<Object, Object, Object>> filter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple3<Object, Object, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> withFilter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> filterNot(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple3<Object, Object, Object>> takeWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> partition(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> span(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> dropWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple3<Object, Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple3<Object, Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple3<Object, Object, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple3<Object, Object, Object>> find(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple3<Object, Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple3<Object, Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple3<Object, Object, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple3<Object, Object, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple3<Object, Object, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple3<Object, Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple3<Object, Object, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple3<Object, Object, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple3<Object, Object, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple3<Object, Object, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple3<Object, Object, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple3<Object, Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple3<Object, Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private double x() {
                return this.x;
            }

            private void x_$eq(double x$1) {
                this.x = x$1;
            }

            private int colCount() {
                return this.colCount;
            }

            private void colCount_$eq(int x$1) {
                this.colCount = x$1;
            }

            public boolean hasNext() {
                return this.input$1.position() < this.input$1.limit();
            }

            public Tuple3<Object, Object, Object> next() {
                if (this.colCount() == 0) {
                    this.x_$eq(this.gridSnap$1.x(this.input$1.readInt(true)));
                    this.colCount_$eq(this.input$1.readInt(true));
                }
                double y = this.gridSnap$1.y(this.input$1.readInt(true));
                double weight = this.input$1.readDouble();
                this.colCount_$eq(this.colCount() - 1);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.x()), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)weight));
            }
            {
                this.input$1 = input$1;
                this.gridSnap$1 = gridSnap$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.x = 0.0;
                this.colCount = 0;
            }
        };
    }

    public Seq<String> propertyNames(Hints hints, SimpleFeatureType sft) {
        String geom = (String)QueryHints$.MODULE$.RichHints(hints).getDensityGeometry().getOrElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Option weight = QueryHints$.MODULE$.RichHints(hints).getDensityWeight().map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toExpression((String)x$1));
        return (Seq)((SeqLike)((TraversableLike)new .colon.colon((Object)geom, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(weight).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> FilterHelper$.MODULE$.propertyNames(x$6, sft), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public DensityScan.GeometryRenderer getRenderer(SimpleFeatureType sft, String geom, Option<String> weight) {
        DensityScan.GeometryRenderer geometryRenderer;
        Class clazz;
        DensityScan.Weigher weigher;
        Option<String> option = weight;
        if (None$.MODULE$.equals(option)) {
            weigher = DensityScan$EqualWeight$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String w = (String)some.value();
            int i = sft.indexOf(w);
            weigher = i == -1 ? new DensityScan.WeightByExpression(ECQL.toExpression((String)w)) : (Number.class.isAssignableFrom(sft.getDescriptor(i).getType().getBinding()) ? new DensityScan.WeightByNumber(i) : new DensityScan.WeightByNonNumber(i));
        } else {
            throw new MatchError(option);
        }
        DensityScan$EqualWeight$ weigher2 = weigher;
        int i = sft.indexOf(geom);
        Class clazz2 = clazz = sft.getDescriptor(i).getType().getBinding();
        Class<Point> clazz3 = Point.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            geometryRenderer = new DensityScan.PointRenderer(i, weigher2);
        } else {
            Class clazz4 = clazz;
            Class<MultiPoint> clazz5 = MultiPoint.class;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                geometryRenderer = new DensityScan.MultiPointRenderer(i, weigher2);
            } else {
                Class clazz6 = clazz;
                Class<LineString> clazz7 = LineString.class;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    geometryRenderer = new DensityScan.LineStringRenderer(i, weigher2);
                } else {
                    Class clazz8 = clazz;
                    Class<MultiLineString> clazz9 = MultiLineString.class;
                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                        geometryRenderer = new DensityScan.MultiLineStringRenderer(i, weigher2);
                    } else {
                        Class clazz10 = clazz;
                        Class<Polygon> clazz11 = Polygon.class;
                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                            geometryRenderer = new DensityScan.PolygonRenderer(i, weigher2);
                        } else {
                            Class clazz12 = clazz;
                            Class<MultiPolygon> clazz13 = MultiPolygon.class;
                            geometryRenderer = !(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null) ? new DensityScan.MultiPolygonRenderer(i, weigher2) : new DensityScan.MultiRenderer(i, weigher2);
                        }
                    }
                }
            }
        }
        return geometryRenderer;
    }

    /*
     * WARNING - void declaration
     */
    public String getDensityGeometry(SimpleFeatureType sft, Hints hints) {
        void var3_3;
        String geom = (String)QueryHints$.MODULE$.RichHints(hints).getDensityGeometry().getOrElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Predef$.MODULE$.require(sft.indexOf(geom) != -1 && Geometry.class.isAssignableFrom(sft.getDescriptor(geom).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(24).append("Invalid geometry field: ").append(geom).toString());
        return var3_3;
    }

    public static final /* synthetic */ int $anonfun$encodeResult$1(Tuple2 x$5) {
        return ((Tuple2)x$5._1())._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$encodeResult$3(Output output$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 xy = (Tuple2)tuple2._1();
        double weight = tuple2._2$mcD$sp();
        output$1.writeInt(xy._2$mcI$sp(), true);
        output$1.writeDouble(weight);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$encodeResult$2(Output output$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int row = tuple2._1$mcI$sp();
        List cols = (List)tuple2._2();
        output$1.writeInt(row, true);
        output$1.writeInt(cols.size(), true);
        cols.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DensityScan$.$anonfun$encodeResult$3(output$1, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DensityScan$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.BatchSize = new GeoMesaSystemProperties.SystemProperty("geomesa.density.batch.size", "100000");
        this.DensitySft = SimpleFeatureTypes.createType((String)"density", (String)"*geom:Point:srid=4326");
        this.DensityValueKey = new Hints.ClassKey(byte[].class);
    }
}

