/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011ufaB:u!\u0003\r\ta \u0005\b\t7\u0003A\u0011\u0001C$\u0011-!Y\u0004\u0001a\u0001\u0002\u0004%\t\u0002\"(\t\u0017\u0011\u0005\u0006\u00011AA\u0002\u0013EA1\u0015\u0005\b\tO\u0003A\u0011\u000bCU\u0011\u001d!Y\f\u0001C)\u0007c9q!a\ru\u0011\u0003\t)D\u0002\u0004ti\"\u0005\u0011q\u0007\u0005\b\u0003\u001b:A\u0011AA(\u000b\u0019\t\tf\u0002\u0001\u0002T!I\u00111R\u0004C\u0002\u0013\u0005\u0011Q\u0012\u0005\t\u0003[;\u0001\u0015!\u0003\u0002\u0010\"I\u0011qV\u0004C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003s;\u0001\u0015!\u0003\u00024\"I\u00111X\u0004C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003K<\u0001\u0015!\u0003\u0002@\u001e9\u0011q]\u0004\t\u0002\u0005%haBAw\u000f!\u0005\u0011q\u001e\u0005\b\u0003\u001b\nB\u0011AAy\u0011%\t\u00190\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\bE\u0001\u000b\u0011BA|\u0011%\u0011I!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\fE\u0001\u000b\u0011BA|\u0011%\u0011i!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0010E\u0001\u000b\u0011BA|\u0011%\u0011\t\"\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0014E\u0001\u000b\u0011BA|\u0011\u001d\u0011)b\u0002C\u0001\u0005/AqA! \b\t\u0003\u0011y\bC\u0004\u0003\u001c\u001e!\tA!(\t\u000f\tmu\u0001\"\u0001\u0003D\"9!Q[\u0004\u0005\u0002\t]\u0007b\u0002Br\u000f\u0011\u0005!Q\u001d\u0005\b\tC9A\u0011\u0001C\u0012\r\u0019!Ic\u0002\u0001\u0005,!QA1\b\u0012\u0003\u0002\u0003\u0006IAa:\t\u0015\te(E!A!\u0002\u0013\u0011\t\nC\u0004\u0002N\t\"\t\u0001\"\u0010\t\u000f\u0011\u0015#\u0005\"\u0011\u0005H!9A\u0011\n\u0012\u0005B\u0011-\u0003b\u0002C(E\u0011\u0005C\u0011\u000b\u0005\b\t'\u0012C\u0011\tC$\r\u001d!)fBA\u0001\t/Bq!!\u0014+\t\u0003!\u0019\bC\u0004\u0005F)\"\t\u0005b\u001e\t\u000f\u0011m$\u0006\"\u0011\u0005~!9Aq\u0010\u0016\u0005B\u0005E\u0006b\u0002CAU\u0011\u0005C1\u0011\u0005\b\t\u000fSc\u0011\u0003CE\u0011\u001d\u0019IE\u000bC\u0001\t\u001bCq\u0001b%+\t\u0003\")\nC\u0004\u0004V)\"\tea\u0016\u0007\u0013\r%q\u0001%A\u0012\"\r-\u0001bBB\u0007i\u0019\u00051qB\u0004\b\t3;\u0001\u0012QB\u0014\r\u001d\u0019)b\u0002EA\u0007/Aq!!\u00148\t\u0003\u0019)\u0003C\u0004\u0004\u000e]\"\te!\u000b\t\u0013\r5r'!A\u0005B\u0005U\b\"CB\u0018o\u0005\u0005I\u0011AB\u0019\u0011%\u0019\u0019dNA\u0001\n\u0003\u0019)\u0004C\u0005\u0004<]\n\t\u0011\"\u0011\u0004>!I1\u0011J\u001c\u0002\u0002\u0013\u000511\n\u0005\n\u0007+:\u0014\u0011!C!\u0007/B\u0011b!\u00178\u0003\u0003%\tea\u0017\t\u0013\rus'!A\u0005\n\r}cABBI\u000f\u0001\u0019\u0019\n\u0003\u0006\u0004\u0004\t\u0013\t\u0011)A\u0005\u0005sCq!!\u0014C\t\u0003\u0019)\nC\u0004\u0004\u000e\t#\tea'\u0007\r\r\ru\u0001ABC\u0011)\u0019\u0019A\u0012B\u0001B\u0003%!\u0011\u0018\u0005\b\u0003\u001b2E\u0011ABD\u0011\u001d\u0019iA\u0012C!\u0007\u001b3aaa\u001a\b\u0001\r%\u0004BCB6\u0015\n\u0005\t\u0015!\u0003\u0004n!9\u0011Q\n&\u0005\u0002\re\u0004bBB\u0007\u0015\u0012\u00053q\u0010\u0004\n\u0005S<\u0001\u0013aI\u0011\u0005WDqA!<O\r\u0003\u0011yO\u0002\u0004\u0004v\u001e\u00011q\u001f\u0005\u000b\u0007\u0007\u0001&\u0011!Q\u0001\n\te\u0006BCB\u0003!\n\u0005\t\u0015!\u0003\u0004\b!9\u0011Q\n)\u0005\u0002\re\bb\u0002Bw!\u0012\u0005C\u0011\u0001\u0004\u0007\u0007\u007f;\u0001a!1\t\u0015\r\rQK!A!\u0002\u0013\u0011I\f\u0003\u0006\u0004\u0006U\u0013\t\u0011)A\u0005\u0007\u000fAq!!\u0014V\t\u0003\u0019\u0019\rC\u0004\u0003nV#\tea3\u0007\r\t}x\u0001AB\u0001\u0011)\u0019\u0019A\u0017B\u0001B\u0003%!\u0011\u0018\u0005\u000b\u0007\u000bQ&\u0011!Q\u0001\n\r\u001d\u0001bBA'5\u0012\u00051q\u0014\u0005\b\u0005[TF\u0011IBT\r\u0019\u0019ik\u0002\u0001\u00040\"Q11A0\u0003\u0002\u0003\u0006IA!/\t\u0015\r\u0015qL!A!\u0002\u0013\u00199\u0001C\u0004\u0002N}#\ta!-\t\u000f\t5x\f\"\u0011\u0004:\u001a1AqA\u0004\u0001\t\u0013A!ba\u0001e\u0005\u0003\u0005\u000b\u0011\u0002B]\u0011)\u0019)\u0001\u001aB\u0001B\u0003%1q\u0001\u0005\b\u0003\u001b\"G\u0011\u0001C\u0006\u0011\u001d\u0011i\u000f\u001aC!\t'1aa!5\b\u0001\rM\u0007BCB\u0002S\n\u0005\t\u0015!\u0003\u0003:\"Q1QA5\u0003\u0002\u0003\u0006Iaa\u0002\t\u000f\u00055\u0013\u000e\"\u0001\u0004V\"9!Q^5\u0005B\rugABBr\u000f\u0001\u0019)\u000f\u0003\u0006\u0004\u00049\u0014\t\u0011)A\u0005\u0005sC!b!\u0002o\u0005\u0003\u0005\u000b\u0011BB\u0004\u0011\u001d\tiE\u001cC\u0001\u0007ODqA!<o\t\u0003\u001ayOA\u0006EK:\u001c\u0018\u000e^=TG\u0006t'BA;w\u0003%IG/\u001a:bi>\u00148O\u0003\u0002xq\u0006)\u0011N\u001c3fq*\u0011\u0011P_\u0001\bO\u0016|W.Z:b\u0015\tYH0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001~\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011\u0011AA\u0007!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!BAA\u0004\u0003\u0015\u00198-\u00197b\u0013\u0011\tY!!\u0002\u0003\r\u0005s\u0017PU3g!\u0019\ty!!\u0005\u0002\u00165\tA/C\u0002\u0002\u0014Q\u0014q\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\t\u0004\u0003/\u0011cbAA\r\r9!\u00111DA\u0019\u001d\u0011\ti\"a\f\u000f\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tYC\u0004\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9C`\u0001\u0007yI|w\u000e\u001e \n\u0003uL!a\u001f?\n\u0005eT\u0018BA<y\u0013\t)h/A\u0006EK:\u001c\u0018\u000e^=TG\u0006t\u0007cAA\b\u000fM)q!!\u0001\u0002:A!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001D:dC2\fGn\\4hS:<'\u0002BA\"\u0003\u000b\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u000f\n1aY8n\u0013\u0011\tY%!\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005U\"\u0001D$sS\u0012LE/\u001a:bi>\u0014\b\u0003CA\u0002\u0003+\nI&!\u001c\n\t\u0005]\u0013Q\u0001\u0002\n\rVt7\r^5p]F\u0002B!a\u0017\u0002j5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003G\n)'A\u0004gK\u0006$XO]3\u000b\u0007\u0005\u001dD0A\u0004pa\u0016tw-[:\n\t\u0005-\u0014Q\f\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0011\r\u0005=\u0014\u0011PA@\u001d\u0011\t\t(!\u001e\u000f\t\u0005\r\u00121O\u0005\u0003\u0003\u000fIA!a\u001e\u0002\u0006\u00059\u0001/Y2lC\u001e,\u0017\u0002BA>\u0003{\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0005\u0003o\n)\u0001\u0005\u0006\u0002\u0004\u0005\u0005\u0015QQAC\u0003\u000bKA!a!\u0002\u0006\t1A+\u001e9mKN\u0002B!a\u0001\u0002\b&!\u0011\u0011RA\u0003\u0005\u0019!u.\u001e2mK\u0006I!)\u0019;dQNK'0Z\u000b\u0003\u0003\u001f\u0003B!!%\u0002(:!\u00111SAQ\u001d\u0011\t)*a'\u000f\t\u0005u\u0011qS\u0005\u0004\u00033C\u0018!B;uS2\u001c\u0018\u0002BAO\u0003?\u000bAaY8oM*\u0019\u0011\u0011\u0014=\n\t\u0005\r\u0016QU\u0001\u0018\u000f\u0016|W*Z:b'f\u001cH/Z7Qe>\u0004XM\u001d;jKNTA!!(\u0002 &!\u0011\u0011VAV\u00059\u0019\u0016p\u001d;f[B\u0013x\u000e]3sifTA!a)\u0002&\u0006Q!)\u0019;dQNK'0\u001a\u0011\u0002\u0015\u0011+gn]5usN3G/\u0006\u0002\u00024B!\u00111LA[\u0013\u0011\t9,!\u0018\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0006EK:\u001c\u0018\u000e^=TMR\u0004\u0013a\u0004#f]NLG/\u001f,bYV,7*Z=\u0016\u0005\u0005}\u0006\u0003BAa\u0003?tA!a1\u0002Z:!\u0011QYAj\u001d\u0011\t9-!4\u000f\t\u0005\u0005\u0012\u0011Z\u0005\u0004\u0003\u0017d\u0018\u0001C4f_R|w\u000e\\:\n\t\u0005=\u0017\u0011[\u0001\u0005kRLGNC\u0002\u0002LrLA!!6\u0002X\u00069a-Y2u_JL(\u0002BAh\u0003#LA!a7\u0002^\u0006)\u0001*\u001b8ug*!\u0011Q[Al\u0013\u0011\t\t/a9\u0003\u0011\rc\u0017m]:LKfTA!a7\u0002^\u0006\u0001B)\u001a8tSRLh+\u00197vK.+\u0017\u0010I\u0001\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0007\u0005-\u0018#D\u0001\b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]N\u0019\u0011#!\u0001\u0015\u0005\u0005%\u0018aC$f_6,GO]=PaR,\"!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006!A.\u00198h\u0015\t\u0011\t!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0003w\u0014aa\u0015;sS:<\u0017\u0001D$f_6,GO]=PaR\u0004\u0013aC#om\u0016dw\u000e]3PaR\fA\"\u00128wK2|\u0007/Z(qi\u0002\nqa\u0012:jI>\u0003H/\u0001\u0005He&$w\n\u001d;!\u0003%9V-[4ii>\u0003H/\u0001\u0006XK&<\u0007\u000e^(qi\u0002\n\u0011bY8oM&<WO]3\u0015\u0015\te!Q\u0006B\u0019\u0005;\u0012\t\b\u0005\u0005\u0003\u001c\t\r\"\u0011\u0006B\u0015\u001d\u0011\u0011iBa\b\u0011\t\u0005\r\u0012QA\u0005\u0005\u0005C\t)!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005K\u00119CA\u0002NCBTAA!\t\u0002\u0006A!!1\u0004B\u0016\u0013\u0011\u0011)Aa\n\t\u000f\t=2\u00041\u0001\u00024\u0006\u00191O\u001a;\t\r]\\\u0002\u0019\u0001B\u001aa\u0019\u0011)D!\u0012\u0003ZAA!q\u0007B\u001f\u0005\u0003\u00129&\u0004\u0002\u0003:)\u0019!1\b<\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003@\te\"aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\b\u0003\u0002B\"\u0005\u000bb\u0001\u0001\u0002\u0007\u0003H\tE\u0012\u0011!A\u0001\u0006\u0003\u0011IEA\u0002`IE\nBAa\u0013\u0003RA!\u00111\u0001B'\u0013\u0011\u0011y%!\u0002\u0003\u000f9{G\u000f[5oOB!\u00111\u0001B*\u0013\u0011\u0011)&!\u0002\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0003D\teC\u0001\u0004B.\u0005c\t\t\u0011!A\u0003\u0002\t%#aA0%e!9!qL\u000eA\u0002\t\u0005\u0014A\u00024jYR,'\u000f\u0005\u0004\u0002\u0004\t\r$qM\u0005\u0005\u0005K\n)A\u0001\u0004PaRLwN\u001c\t\u0005\u0005S\u0012i'\u0004\u0002\u0003l)!!qLA3\u0013\u0011\u0011yGa\u001b\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0011\u0019h\u0007a\u0001\u0005k\nQ\u0001[5oiN\u0004BAa\u001e\u0003z5\u0011\u0011Q\\\u0005\u0005\u0005w\niNA\u0003IS:$8/\u0001\u0007f]\u000e|G-\u001a*fgVdG\u000f\u0006\u0003\u0003\u0002\n5\u0005CBA\u0002\u0005\u0007\u00139)\u0003\u0003\u0003\u0006\u0006\u0015!!B!se\u0006L\b\u0003BA\u0002\u0005\u0013KAAa#\u0002\u0006\t!!)\u001f;f\u0011\u001d\u0011y\t\ba\u0001\u0005#\u000baA]3tk2$\b\u0003\u0002BJ\u0005/k!A!&\u000b\t\u0005-\u0017qT\u0005\u0005\u00053\u0013)JA\u0007SK:$WM]5oO\u001e\u0013\u0018\u000eZ\u0001\rI\u0016\u001cw\u000eZ3SKN,H\u000e\u001e\u000b\t\u0005?\u0013\tK!.\u0003@B\u0019\u00111^\u0005\t\u000f\t\rV\u00041\u0001\u0003&\u0006AQM\u001c<fY>\u0004X\r\u0005\u0003\u0003(\nEVB\u0001BU\u0015\u0011\u0011YK!,\u0002\t\u001d,w.\u001c\u0006\u0004\u0005_S\u0018a\u00016ug&!!1\u0017BU\u0005!)eN^3m_B,\u0007b\u0002B\\;\u0001\u0007!\u0011X\u0001\nOJLGmV5ei\"\u0004B!a\u0001\u0003<&!!QXA\u0003\u0005\rIe\u000e\u001e\u0005\b\u0005\u0003l\u0002\u0019\u0001B]\u0003)9'/\u001b3IK&<\u0007\u000e\u001e\u000b\u0005\u0005\u000b\u0014Y\r\u0006\u0003\u0002n\t\u001d\u0007b\u0002Be=\u0001\u0007\u0011\u0011L\u0001\u0003g\u001aDqA!4\u001f\u0001\u0004\u0011y-\u0001\u0005he&$7K\\1q!\u0011\u0011\u0019J!5\n\t\tM'Q\u0013\u0002\t\u000fJLGm\u00158ba\u0006i\u0001O]8qKJ$\u0018PT1nKN$bA!7\u0003`\n\u0005\bCBA8\u00057\u0014I#\u0003\u0003\u0003^\u0006u$aA*fc\"9!1O\u0010A\u0002\tU\u0004b\u0002B\u0018?\u0001\u0007\u00111W\u0001\fO\u0016$(+\u001a8eKJ,'\u000f\u0006\u0005\u0003h\u0012eA1\u0004C\u000f!\r\tYO\u0014\u0002\u0011\u000f\u0016|W.\u001a;ssJ+g\u000eZ3sKJ\u001c2ATA\u0001\u0003\u0019\u0011XM\u001c3feR1!\u0011\u001fB|\u0005w\u0004B!a\u0001\u0003t&!!Q_A\u0003\u0005\u0011)f.\u001b;\t\u000f\tex\n1\u0001\u0003\u0012\u0006!qM]5e\u0011\u001d\u0011Im\u0014a\u0001\u00033J\u0003B\u0014.`+&t\u0007\u000b\u001a\u0002\u0013\u0019&tWm\u0015;sS:<'+\u001a8eKJ,'oE\u0003[\u0003\u0003\u00119/A\u0001j\u0003\u001d9X-[4iKJ\u00042!a;5\u0005\u001d9V-[4iKJ\u001c2\u0001NA\u0001\u0003\u00199X-[4iiR!\u0011QQB\t\u0011\u001d\u0011I-\u000ea\u0001\u00033JS\u0001N\u001cK\r\n\u00131\"R9vC2<V-[4iiNIq'!\u0001\u0004\b\re1q\u0004\t\u0005\u0003\u0007\u0019Y\"\u0003\u0003\u0004\u001e\u0005\u0015!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0007\u0019\t#\u0003\u0003\u0004$\u0005\u0015!\u0001D*fe&\fG.\u001b>bE2,GCAB\u0014!\r\tYo\u000e\u000b\u0005\u0003\u000b\u001bY\u0003C\u0004\u0003Jf\u0002\r!!\u0017\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE3q\u0007\u0005\n\u0007sa\u0014\u0011!a\u0001\u0005s\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB !\u0019\u0019\tea\u0012\u0003R5\u001111\t\u0006\u0005\u0007\u000b\n)!\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0004D\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0004N\rM\u0003\u0003BA\u0002\u0007\u001fJAa!\u0015\u0002\u0006\t9!i\\8mK\u0006t\u0007\"CB\u001d}\u0005\u0005\t\u0019\u0001B)\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B]\u0003!!xn\u0015;sS:<GCAA|\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r\u0005\u0004\u0003BA}\u0007GJAa!\u001a\u0002|\n1qJ\u00196fGR\u0014!cV3jO\"$()_#yaJ,7o]5p]N)!*!\u0001\u0004\b\u0005\tQ\r\u0005\u0003\u0004p\rUTBAB9\u0015\u0011\u0019\u0019Ha\u001b\u0002\u0015\u0015D\bO]3tg&|g.\u0003\u0003\u0004x\rE$AC#yaJ,7o]5p]R!11PB?!\r\tYO\u0013\u0005\b\u0007Wb\u0005\u0019AB7)\u0011\t)i!!\t\u000f\t%W\n1\u0001\u0002Z\t\tr+Z5hQR\u0014\u0015PT8o\u001dVl'-\u001a:\u0014\u000b\u0019\u000b\taa\u0002\u0015\t\r%51\u0012\t\u0004\u0003W4\u0005bBB\u0002\u0011\u0002\u0007!\u0011\u0018\u000b\u0005\u0003\u000b\u001by\tC\u0004\u0003J&\u0003\r!!\u0017\u0003\u001d]+\u0017n\u001a5u\u0005ftU/\u001c2feN)!)!\u0001\u0004\bQ!1qSBM!\r\tYO\u0011\u0005\b\u0007\u0007!\u0005\u0019\u0001B])\u0011\t)i!(\t\u000f\t%W\t1\u0001\u0002ZQ11\u0011UBR\u0007K\u00032!a;[\u0011\u001d\u0019\u0019!\u0018a\u0001\u0005sCqa!\u0002^\u0001\u0004\u00199\u0001\u0006\u0004\u0003r\u000e%61\u0016\u0005\b\u0005st\u0006\u0019\u0001BI\u0011\u001d\u0011IM\u0018a\u0001\u00033\u0012q#T;mi&d\u0015N\\3TiJLgn\u001a*f]\u0012,'/\u001a:\u0014\u000b}\u000b\tAa:\u0015\r\rM6QWB\\!\r\tYo\u0018\u0005\b\u0007\u0007\u0011\u0007\u0019\u0001B]\u0011\u001d\u0019)A\u0019a\u0001\u0007\u000f!bA!=\u0004<\u000eu\u0006b\u0002B}G\u0002\u0007!\u0011\u0013\u0005\b\u0005\u0013\u001c\u0007\u0019AA-\u0005IiU\u000f\u001c;j!>Lg\u000e\u001e*f]\u0012,'/\u001a:\u0014\u000bU\u000b\tAa:\u0015\r\r\u00157qYBe!\r\tY/\u0016\u0005\b\u0007\u0007A\u0006\u0019\u0001B]\u0011\u001d\u0019)\u0001\u0017a\u0001\u0007\u000f!bA!=\u0004N\u000e=\u0007b\u0002B}3\u0002\u0007!\u0011\u0013\u0005\b\u0005\u0013L\u0006\u0019AA-\u0005QiU\u000f\u001c;j!>d\u0017pZ8o%\u0016tG-\u001a:feN)\u0011.!\u0001\u0003hR11q[Bm\u00077\u00042!a;j\u0011\u001d\u0019\u0019\u0001\u001ca\u0001\u0005sCqa!\u0002m\u0001\u0004\u00199\u0001\u0006\u0004\u0003r\u000e}7\u0011\u001d\u0005\b\u0005sl\u0007\u0019\u0001BI\u0011\u001d\u0011I-\u001ca\u0001\u00033\u0012Q\"T;mi&\u0014VM\u001c3fe\u0016\u00148#\u00028\u0002\u0002\t\u001dHCBBu\u0007W\u001ci\u000fE\u0002\u0002l:Dqaa\u0001r\u0001\u0004\u0011I\fC\u0004\u0004\u0006E\u0004\raa\u0002\u0015\r\tE8\u0011_Bz\u0011\u001d\u0011IP\u001da\u0001\u0005#CqA!3s\u0001\u0004\tIFA\u0007Q_&tGOU3oI\u0016\u0014XM]\n\u0006!\u0006\u0005!q\u001d\u000b\u0007\u0007w\u001cipa@\u0011\u0007\u0005-\b\u000bC\u0004\u0004\u0004M\u0003\rA!/\t\u000f\r\u00151\u000b1\u0001\u0004\bQ1!\u0011\u001fC\u0002\t\u000bAqA!?U\u0001\u0004\u0011\t\nC\u0004\u0003JR\u0003\r!!\u0017\u0003\u001fA{G._4p]J+g\u000eZ3sKJ\u001cR\u0001ZA\u0001\u0005O$b\u0001\"\u0004\u0005\u0010\u0011E\u0001cAAvI\"911A4A\u0002\te\u0006bBB\u0003O\u0002\u00071q\u0001\u000b\u0007\u0005c$)\u0002b\u0006\t\u000f\te\b\u000e1\u0001\u0003\u0012\"9!\u0011\u001a5A\u0002\u0005e\u0003b\u0002B\u0018A\u0001\u0007\u00111\u0017\u0005\b\u0005W\u0003\u0003\u0019\u0001B\u0015\u0011\u001d\u0019i\u0001\ta\u0001\t?\u0001b!a\u0001\u0003d\t%\u0012AE4fi\u0012+gn]5us\u001e+w.\\3uef$bA!\u000b\u0005&\u0011\u001d\u0002b\u0002B\u0018C\u0001\u0007\u00111\u0017\u0005\b\u0005g\n\u0003\u0019\u0001B;\u0005E!UM\\:jif\u001c6-\u00198SKN,H\u000e^\n\u0006E\u0005\u0005AQ\u0006\t\u0005\t_!)D\u0004\u0003\u0002\u0010\u0011E\u0012b\u0001C\u001ai\u0006y\u0011iZ4sK\u001e\fG/\u001b8h'\u000e\fg.\u0003\u0003\u00058\u0011e\"A\u0002*fgVdGOC\u0002\u00054Q\f\u0001B]3oI\u0016\u0014XM\u001d\u000b\u0007\t\u007f!\t\u0005b\u0011\u0011\u0007\u0005-(\u0005C\u0004\u0005<\u0015\u0002\rAa:\t\u000f\teX\u00051\u0001\u0003\u0012\u0006!\u0011N\\5u)\t\u0011\t0A\u0005bO\u001e\u0014XmZ1uKR!!\u0011\u0018C'\u0011\u001d\u0011Im\na\u0001\u00033\na!\u001a8d_\u0012,GC\u0001BA\u0003\u001d\u0019G.Z1okB\u0014\u0001\u0004R3og&$\u0018PU3tk2$8\u000fV8GK\u0006$XO]3t+\u0011!I\u0006b\u001c\u0014\u000b)\n\t\u0001b\u0017\u0011\r\u0011uCq\rC7\u001d\u0011!y\u0006b\u0019\u000f\t\u0005mA\u0011M\u0005\u0004\u0005w1\u0018\u0002\u0002C3\u0005s\t\u0011\"U;fef\u0004F.\u00198\n\t\u0011%D1\u000e\u0002\u0012%\u0016\u001cX\u000f\u001c;t)>4U-\u0019;ve\u0016\u001c(\u0002\u0002C3\u0005s\u0001BAa\u0011\u0005p\u00119A\u0011\u000f\u0016C\u0002\t%#!\u0001+\u0015\u0005\u0011U\u0004#BAvU\u00115D\u0003\u0002By\tsBq\u0001b\u001f-\u0001\u0004\u0011I\"A\u0003ti\u0006$X-\u0006\u0002\u0003\u001a\u000511o\u00195f[\u0006\fQ!\u00199qYf$B!!\u0017\u0005\u0006\"9!qR\u0018A\u0002\u00115\u0014!\u00022zi\u0016\u001cH\u0003\u0002BA\t\u0017CqAa$1\u0001\u0004!i\u0007\u0006\u0003\u0004N\u0011=\u0005b\u0002CIc\u0001\u0007!\u0011K\u0001\u0006_RDWM]\u0001\u0007KF,\u0018\r\\:\u0015\t\r5Cq\u0013\u0005\b\t#\u0013\u0004\u0019\u0001B)\u0003-)\u0015/^1m/\u0016Lw\r\u001b;\u0002\r\u0011Jg.\u001b;%+\t!y\nE\u0002\u0002\u00189\u000bAB]3oI\u0016\u0014XM]0%KF$BA!=\u0005&\"I1\u0011H\u0002\u0002\u0002\u0003\u0007AqT\u0001\rGJ,\u0017\r^3SKN,H\u000e\u001e\u000b\u000b\u0003+!Y\u000b\",\u00054\u0012]\u0006b\u0002B\u0018\t\u0001\u0007\u00111\u0017\u0005\b\t_#\u0001\u0019\u0001CY\u0003%!(/\u00198tM>\u0014X\u000e\u0005\u0004\u0002\u0004\t\r\u00141\u0017\u0005\b\tk#\u0001\u0019\u0001B]\u0003%\u0011\u0017\r^2i'&TX\rC\u0004\u0005:\u0012\u0001\rA!\u0007\u0002\u000f=\u0004H/[8og\u0006\u0001B-\u001a4bk2$()\u0019;dQNK'0\u001a")
public interface DensityScan
extends AggregatingScan<DensityScanResult> {
    public static String getDensityGeometry(SimpleFeatureType simpleFeatureType, Hints hints) {
        return DensityScan$.MODULE$.getDensityGeometry(simpleFeatureType, hints);
    }

    public static GeometryRenderer getRenderer(SimpleFeatureType simpleFeatureType, String string, Option<String> option) {
        return DensityScan$.MODULE$.getRenderer(simpleFeatureType, string, option);
    }

    public static Seq<String> propertyNames(Hints hints, SimpleFeatureType simpleFeatureType) {
        return DensityScan$.MODULE$.propertyNames(hints, simpleFeatureType);
    }

    public static Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature simpleFeature) {
        return DensityScan$.MODULE$.decodeResult(gridSnap, simpleFeature);
    }

    public static Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int n, int n2) {
        return DensityScan$.MODULE$.decodeResult(envelope, n, n2);
    }

    public static byte[] encodeResult(RenderingGrid renderingGrid) {
        return DensityScan$.MODULE$.encodeResult(renderingGrid);
    }

    public static Map<String, String> configure(SimpleFeatureType simpleFeatureType, GeoMesaFeatureIndex<?, ?> geoMesaFeatureIndex, Option<Filter> option, Hints hints) {
        return DensityScan$.MODULE$.configure(simpleFeatureType, geoMesaFeatureIndex, option, hints);
    }

    public static Hints.ClassKey DensityValueKey() {
        return DensityScan$.MODULE$.DensityValueKey();
    }

    public static SimpleFeatureType DensitySft() {
        return DensityScan$.MODULE$.DensitySft();
    }

    public static GeoMesaSystemProperties.SystemProperty BatchSize() {
        return DensityScan$.MODULE$.BatchSize();
    }

    public GeometryRenderer renderer();

    public void renderer_$eq(GeometryRenderer var1);

    public static /* synthetic */ DensityScanResult createResult$(DensityScan $this, SimpleFeatureType sft, Option transform, int batchSize, Map options) {
        return $this.createResult(sft, (Option<SimpleFeatureType>)transform, batchSize, (Map<String, String>)options);
    }

    @Override
    default public DensityScanResult createResult(SimpleFeatureType sft, Option<SimpleFeatureType> transform, int batchSize, Map<String, String> options) {
        String geom = (String)options.getOrElse((Object)DensityScan$Configuration$.MODULE$.GeometryOpt(), (Function0 & Serializable & scala.Serializable)() -> sft.getGeometryDescriptor().getLocalName());
        GeometryRenderer renderer = DensityScan$.MODULE$.getRenderer(sft, geom, (Option<String>)options.get((Object)DensityScan$Configuration$.MODULE$.WeightOpt()));
        double[] bounds = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt())).split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)DensityScan.$anonfun$createResult$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Envelope envelope = new Envelope(bounds[0], bounds[1], bounds[2], bounds[3]);
        int[] nArray = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.GridOpt())).split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DensityScan.$anonfun$createResult$3(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Option option = Array$.MODULE$.unapplySeq((Object)nArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)nArray);
        }
        int width = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
        int height = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        Tuple2.mcII.sp sp3 = sp2;
        int width2 = sp3._1$mcI$sp();
        int height2 = sp3._2$mcI$sp();
        return new DensityScanResult(renderer, new RenderingGrid(envelope, width2, height2));
    }

    public static /* synthetic */ int defaultBatchSize$(DensityScan $this) {
        return $this.defaultBatchSize();
    }

    @Override
    default public int defaultBatchSize() {
        return BoxesRunTime.unboxToInt((Object)DensityScan$.MODULE$.BatchSize().toInt().get());
    }

    public static /* synthetic */ double $anonfun$createResult$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    public static /* synthetic */ int $anonfun$createResult$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static void $init$(DensityScan $this) {
    }

    public static abstract class DensityResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return DensityScan$.MODULE$.DensitySft();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SimpleFeature apply(T result) {
            void var2_2;
            ScalaSimpleFeature sf = new ScalaSimpleFeature(DensityScan$.MODULE$.DensitySft(), "", new Object[]{GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            sf.getUserData().put(DensityScan$.MODULE$.DensityValueKey(), this.bytes(result));
            return var2_2;
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof DensityResultsToFeatures;
        }

        public boolean equals(Object other) {
            DensityResultsToFeatures densityResultsToFeatures;
            Object object = other;
            boolean bl = object instanceof DensityResultsToFeatures && (densityResultsToFeatures = (DensityResultsToFeatures)object).canEqual(this);
            return bl;
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }

    public static class DensityScanResult
    implements AggregatingScan.Result {
        private final GeometryRenderer renderer;
        private final RenderingGrid grid;

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            this.renderer.render(this.grid, sf);
            return 1;
        }

        @Override
        public byte[] encode() {
            byte[] byArray;
            try {
                byArray = DensityScan$.MODULE$.encodeResult(this.grid);
            }
            finally {
                this.grid.clear();
            }
            return byArray;
        }

        @Override
        public void cleanup() {
        }

        public DensityScanResult(GeometryRenderer renderer, RenderingGrid grid) {
            this.renderer = renderer;
            this.grid = grid;
        }
    }

    public static interface GeometryRenderer {
        public void render(RenderingGrid var1, SimpleFeature var2);
    }

    public static class LineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((LineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public LineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiLineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiLineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiLineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPoint)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPolygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Geometry)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Point)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Polygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static interface Weigher {
        public double weight(SimpleFeature var1);
    }

    public static class WeightByExpression
    implements Weigher {
        private final Expression e;

        @Override
        public double weight(SimpleFeature sf) {
            Double d = (Double)this.e.evaluate((Object)sf, Double.class);
            return d == null ? 0.0 : Predef$.MODULE$.Double2double(d);
        }

        public WeightByExpression(Expression e) {
            this.e = e;
        }
    }

    public static class WeightByNonNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Double converted;
            Object d = sf.getAttribute(this.i);
            return d == null ? 0.0 : ((converted = (Double)FastConverter$.MODULE$.convert(d, Double.class)) == null ? 1.0 : converted);
        }

        public WeightByNonNumber(int i) {
            this.i = i;
        }
    }

    public static class WeightByNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Number d = (Number)sf.getAttribute(this.i);
            return d == null ? 0.0 : d.doubleValue();
        }

        public WeightByNumber(int i) {
            this.i = i;
        }
    }
}

