/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.DeltaWriter;
import org.locationtech.geomesa.arrow.io.DictionaryBuildingWriter;
import org.locationtech.geomesa.arrow.io.DictionaryBuildingWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.io.records.RecordBatchUnloader;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$;
import org.locationtech.geomesa.index.iterators.DensityScan;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.FeatureSampler$;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.security.VisibilityEvaluator$;
import org.locationtech.geomesa.utils.bin.BinaryEncodeCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

public final class LocalQueryRunner$
implements LazyLogging {
    public static LocalQueryRunner$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LocalQueryRunner$();
    }

    private Logger logger$lzycompute() {
        LocalQueryRunner$ localQueryRunner$ = this;
        synchronized (localQueryRunner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Function1<SimpleFeature, Object> visible(Option<AuthorizationsProvider> provider) {
        Function1 & Serializable & scala.Serializable intersect;
        Option<AuthorizationsProvider> option = provider;
        if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.MODULE$.noAuthVisibilityCheck(f));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            AuthorizationsProvider p = (AuthorizationsProvider)some.value();
            intersect = (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.MODULE$.authVisibilityCheck(x$3, (Seq<byte[]>)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthorizations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getBytes(StandardCharsets.UTF_8), Buffer$.MODULE$.canBuildFrom())).toSeq()));
        } else {
            throw new MatchError(option);
        }
        return intersect;
    }

    public CloseableIterator<SimpleFeature> transform(SimpleFeatureType sft, CloseableIterator<SimpleFeature> features, Option<Tuple2<String, SimpleFeatureType>> transform, Hints hints, Option<LocalQueryRunner.ArrowDictionaryHook> arrow) {
        CloseableIterator<SimpleFeature> closeableIterator;
        Some some;
        Tuple2 tuple2;
        CloseableIterator<SimpleFeature> closeableIterator2;
        Option<Tuple2<Object, Option<String>>> option = QueryHints$.MODULE$.RichHints(hints).getSampling();
        if (None$.MODULE$.equals(option)) {
            closeableIterator2 = features;
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            float percent = BoxesRunTime.unboxToFloat((Object)tuple2._1());
            Option field = (Option)tuple2._2();
            closeableIterator2 = this.sample(sft, percent, (Option<String>)field, features);
        } else {
            throw new MatchError(option);
        }
        CloseableIterator<SimpleFeature> sampled = closeableIterator2;
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            Option trackId = Option$.MODULE$.apply((Object)QueryHints$.MODULE$.RichHints(hints).getBinTrackIdField()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.$anonfun$transform$1(x$11))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            Option geom = QueryHints$.MODULE$.RichHints(hints).getBinGeomField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            Option dtg = QueryHints$.MODULE$.RichHints(hints).getBinDtgField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            boolean sorting = QueryHints$.MODULE$.RichHints(hints).isBinSorting();
            closeableIterator = this.binTransform(sampled, sft, (Option<Object>)trackId, (Option<Object>)geom, (Option<Object>)dtg, (Option<Object>)QueryHints$.MODULE$.RichHints(hints).getBinLabelField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))), sorting);
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            closeableIterator = this.arrowTransform(sampled, sft, transform, hints, arrow);
        } else if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            Some some2;
            Tuple2 tuple22;
            Envelope envelope;
            Option<Envelope> option2 = QueryHints$.MODULE$.RichHints(hints).getDensityEnvelope();
            if (!(option2 instanceof Some)) {
                throw new MatchError(option2);
            }
            Some some3 = (Some)option2;
            Envelope envelope2 = envelope = (Envelope)some3.value();
            Envelope envelope3 = envelope2;
            Option<Tuple2<Object, Object>> option3 = QueryHints$.MODULE$.RichHints(hints).getDensityBounds();
            if (!(option3 instanceof Some) || (tuple22 = (Tuple2)(some2 = (Some)option3).value()) == null) {
                throw new MatchError(option3);
            }
            int width = tuple22._1$mcI$sp();
            int height = tuple22._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
            Tuple2.mcII.sp sp3 = sp2;
            int width2 = sp3._1$mcI$sp();
            int height2 = sp3._2$mcI$sp();
            String geom = DensityScan$.MODULE$.getDensityGeometry(sft, hints);
            closeableIterator = this.densityTransform(sampled, sft, geom, envelope3, width2, height2, QueryHints$.MODULE$.RichHints(hints).getDensityWeight());
        } else if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            closeableIterator = this.statsTransform(sampled, sft, transform, QueryHints$.MODULE$.RichHints(hints).getStatsQuery(), QueryHints$.MODULE$.RichHints(hints).isStatsEncode() || QueryHints$.MODULE$.RichHints(hints).isSkipReduce());
        } else {
            Some some4;
            Tuple2 tuple23;
            CloseableIterator<SimpleFeature> closeableIterator3;
            Option<Tuple2<String, SimpleFeatureType>> option4 = transform;
            if (None$.MODULE$.equals(option4)) {
                closeableIterator3 = this.noTransform(sampled, QueryHints$.MODULE$.RichHints(hints).getSortFields());
            } else if (option4 instanceof Some && (tuple23 = (Tuple2)(some4 = (Some)option4).value()) != null) {
                String defs = (String)tuple23._1();
                SimpleFeatureType tsft = (SimpleFeatureType)tuple23._2();
                closeableIterator3 = this.projectionTransform(sampled, sft, tsft, defs, QueryHints$.MODULE$.RichHints(hints).getSortFields());
            } else {
                throw new MatchError(option4);
            }
            closeableIterator = closeableIterator3;
        }
        return closeableIterator;
    }

    public Option<LocalQueryRunner.ArrowDictionaryHook> transform$default$5() {
        return None$.MODULE$;
    }

    private CloseableIterator<SimpleFeature> binTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, Option<Object> trackId, Option<Object> geom, Option<Object> dtg, Option<Object> label, boolean sorting) {
        SortingSimpleFeatureIterator sortingSimpleFeatureIterator;
        BinaryOutputEncoder encoder = BinaryOutputEncoder$.MODULE$.apply(sft, new BinaryOutputEncoder.EncodingOptions(geom, dtg, trackId, label, BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5()));
        if (!sorting) {
            sortingSimpleFeatureIterator = features;
        } else {
            int i = BoxesRunTime.unboxToInt((Object)dtg.orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Can't sort BIN features by date");
            }));
            sortingSimpleFeatureIterator = new SortingSimpleFeatureIterator(features, (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sft.getDescriptor(i).getLocalName()), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)));
        }
        SortingSimpleFeatureIterator sorted = sortingSimpleFeatureIterator;
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        BinaryEncodeCallback.ByteStreamCallback callback = new BinaryEncodeCallback.ByteStreamCallback((OutputStream)os);
        return new CloseableIterator<SimpleFeature>((CloseableIterator)sorted, os, encoder, callback){
            private final CloseableIterator sorted$1;
            private final ByteArrayOutputStream os$1;
            private final BinaryOutputEncoder encoder$1;
            private final BinaryEncodeCallback.ByteStreamCallback callback$1;

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                return Iterator.map$((Iterator)this, (Function1)f);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                return Iterator.filter$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                return Iterator.filterNot$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                return Iterator.takeWhile$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                return Iterator.collect$((Iterator)this, (PartialFunction)pf);
            }

            public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                return CloseableIterator.map$((CloseableIterator)this, f);
            }

            public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filter$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filterNot$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> take(int n) {
                return CloseableIterator.take$((CloseableIterator)this, (int)n);
            }

            public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.takeWhile$((CloseableIterator)this, p);
            }

            public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                return CloseableIterator.collect$((CloseableIterator)this, pf);
            }

            public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return CloseableIterator.$plus$plus$((CloseableIterator)this, that);
            }

            public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                return CloseableIterator.flatMap$((CloseableIterator)this, f);
            }

            public Iterator<SimpleFeature> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<SimpleFeature> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<SimpleFeature> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<SimpleFeature, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<SimpleFeature, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<SimpleFeature, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<SimpleFeature> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<SimpleFeature> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<SimpleFeature> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<SimpleFeature> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<SimpleFeature> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<SimpleFeature, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<SimpleFeature> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<SimpleFeature> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<SimpleFeature> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<SimpleFeature> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<SimpleFeature> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.sorted$1.hasNext();
            }

            public SimpleFeature next() {
                this.os$1.reset();
                this.sorted$1.take(64).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                    anon.1.$anonfun$next$1(this, x$13);
                    return BoxedUnit.UNIT;
                });
                return new ScalaSimpleFeature(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), "", new Object[]{this.os$1.toByteArray(), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            }

            public void close() {
                this.sorted$1.close();
            }

            public static final /* synthetic */ void $anonfun$next$1(anon.1 $this, SimpleFeature x$13) {
                $this.encoder$1.encode(x$13, (BinaryOutputCallback)$this.callback$1);
            }
            {
                this.sorted$1 = sorted$1;
                this.os$1 = os$1;
                this.encoder$1 = encoder$1;
                this.callback$1 = callback$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$((CloseableIterator)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1$adapted(org.locationtech.geomesa.index.planning.LocalQueryRunner$$anon$1 org.opengis.feature.simple.SimpleFeature )}, serializedLambda);
            }
        };
    }

    private CloseableIterator<SimpleFeature> arrowTransform(CloseableIterator<SimpleFeature> original, SimpleFeatureType sft, Option<Tuple2<String, SimpleFeatureType>> transform, Hints hints, Option<LocalQueryRunner.ArrowDictionaryHook> hook) {
        Object object;
        Map cachedDictionaries;
        Map map;
        Some some;
        Tuple2 tuple2;
        Tuple2 tuple22;
        LazyRef x$16$lzy = new LazyRef();
        LazyRef stats$lzy = new LazyRef();
        LazyRef filter$lzy = new LazyRef();
        Option sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort().map((Function1 & Serializable & scala.Serializable)x$14 -> (Seq)Seq$.MODULE$.fill(1, (Function0 & Serializable & scala.Serializable)() -> x$14));
        int batchSize = ArrowScan$.MODULE$.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options((String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get()));
        Option<Tuple2<String, SimpleFeatureType>> option = transform;
        if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2(this.noTransform(original, (Option<Seq<Tuple2<String, Object>>>)sort), (Object)sft);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String definitions = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            tuple22 = new Tuple2(this.projectionTransform(original, sft, tsft, definitions, (Option<Seq<Tuple2<String, Object>>>)sort), (Object)tsft);
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        CloseableIterator features = (CloseableIterator)tuple23._1();
        SimpleFeatureType arrowSft = (SimpleFeatureType)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)features, (Object)arrowSft);
        Tuple2 tuple25 = tuple24;
        CloseableIterator features2 = (CloseableIterator)tuple25._1();
        SimpleFeatureType arrowSft2 = (SimpleFeatureType)tuple25._2();
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        Map<String, Object[]> providedDictionaries = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(sft);
        if (!QueryHints$.MODULE$.RichHints(hints).isArrowCachedDictionaries()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Seq toLookup = (Seq)dictionaryFields.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)providedDictionaries.contains((Object)key)));
            map = cachedDictionaries = ((TraversableOnce)((TraversableLike)toLookup.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> Option$.MODULE$.option2Iterable(LocalQueryRunner$.stats$1(stats$lzy, x$16$lzy, hook).getTopK(sft, (String)x$17, LocalQueryRunner$.stats$1(stats$lzy, x$16$lzy, hook).getTopK$default$3(), LocalQueryRunner$.stats$1(stats$lzy, x$16$lzy, hook).getTopK$default$4())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.property()), k), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowDoublePass() || dictionaryFields.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.$anonfun$arrowTransform$8(providedDictionaries, cachedDictionaries, f)))) {
            Map<String, ArrowDictionary> map2;
            if (dictionaryFields.isEmpty()) {
                map2 = Predef$.MODULE$.Map().empty();
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Running deprecated Arrow double pass scan - switch to delta scans instead");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                map2 = ArrowScan$.MODULE$.createDictionaries(LocalQueryRunner$.stats$1(stats$lzy, x$16$lzy, hook), sft, (Option<Filter>)LocalQueryRunner$.filter$1(filter$lzy, x$16$lzy, hook), dictionaryFields, providedDictionaries, (Map<String, TopK<Object>>)cachedDictionaries);
            }
            Map<String, ArrowDictionary> dictionaries = map2;
            SimpleFeatureVector vector = SimpleFeatureVector$.MODULE$.create(arrowSft2, (Map)dictionaries, encoding, SimpleFeatureVector$.MODULE$.create$default$4());
            RecordBatchUnloader batchWriter = new RecordBatchUnloader(vector, ipcOpts);
            SimpleFeature sf = ArrowScan$.MODULE$.resultFeature();
            CloseableIterator<SimpleFeature> arrows = new CloseableIterator<SimpleFeature>(features2, vector, batchSize, sf, batchWriter){
                private final CloseableIterator features$1;
                private final SimpleFeatureVector vector$1;
                private final int batchSize$1;
                private final SimpleFeature sf$1;
                private final RecordBatchUnloader batchWriter$1;

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                    return Iterator.map$((Iterator)this, (Function1)f);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                    return Iterator.filter$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                    return Iterator.filterNot$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                    return Iterator.takeWhile$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                    return Iterator.collect$((Iterator)this, (PartialFunction)pf);
                }

                public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                    return CloseableIterator.map$((CloseableIterator)this, f);
                }

                public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filter$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filterNot$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> take(int n) {
                    return CloseableIterator.take$((CloseableIterator)this, (int)n);
                }

                public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.takeWhile$((CloseableIterator)this, p);
                }

                public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                    return CloseableIterator.collect$((CloseableIterator)this, pf);
                }

                public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return CloseableIterator.$plus$plus$((CloseableIterator)this, that);
                }

                public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                    return CloseableIterator.flatMap$((CloseableIterator)this, f);
                }

                public Iterator<SimpleFeature> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<SimpleFeature> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<SimpleFeature> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<SimpleFeature, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<SimpleFeature, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<SimpleFeature, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<SimpleFeature> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<SimpleFeature> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<SimpleFeature> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<SimpleFeature> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<SimpleFeature> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<SimpleFeature, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<SimpleFeature> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<SimpleFeature> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<SimpleFeature> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<SimpleFeature> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<SimpleFeature> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.features$1.hasNext();
                }

                public SimpleFeature next() {
                    int index;
                    this.vector$1.clear();
                    for (index = 0; index < this.batchSize$1 && this.features$1.hasNext(); ++index) {
                        this.vector$1.writer().set(index, (SimpleFeature)this.features$1.next());
                    }
                    this.sf$1.setAttribute(0, (Object)this.batchWriter$1.unload(index));
                    return this.sf$1;
                }

                public void close() {
                    package.CloseWithLogging$.MODULE$.apply((Object)new .colon.colon((Object)this.features$1, (List)new .colon.colon((Object)this.vector$1, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
                }
                {
                    this.features$1 = features$1;
                    this.vector$1 = vector$1;
                    this.batchSize$1 = batchSize$1;
                    this.sf$1 = sf$1;
                    this.batchWriter$1 = batchWriter$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                    CloseableIterator.$init$((CloseableIterator)this);
                }
            };
            object = QueryHints$.MODULE$.RichHints(hints).isSkipReduce() ? arrows : new ArrowScan.BatchReducer(arrowSft2, dictionaries, encoding, ipcOpts, batchSize, (Option<Tuple2<String, Object>>)sort.map((Function1 & Serializable & scala.Serializable)x$18 -> (Tuple2)x$18.head()), true).apply(arrows);
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowMultiFile()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Running deprecated Arrow multi file scan - switch to delta scans instead");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            DictionaryBuildingWriter writer = new DictionaryBuildingWriter(arrowSft2, dictionaryFields, encoding, ipcOpts, DictionaryBuildingWriter$.MODULE$.$lessinit$greater$default$5());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            SimpleFeature sf = ArrowScan$.MODULE$.resultFeature();
            CloseableIterator<SimpleFeature> arrows = new CloseableIterator<SimpleFeature>(features2, writer, os, batchSize, sf){
                private final CloseableIterator features$1;
                private final DictionaryBuildingWriter writer$1;
                private final ByteArrayOutputStream os$2;
                private final int batchSize$1;
                private final SimpleFeature sf$2;

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                    return Iterator.map$((Iterator)this, (Function1)f);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                    return Iterator.filter$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                    return Iterator.filterNot$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                    return Iterator.takeWhile$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                    return Iterator.collect$((Iterator)this, (PartialFunction)pf);
                }

                public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                    return CloseableIterator.map$((CloseableIterator)this, f);
                }

                public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filter$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filterNot$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> take(int n) {
                    return CloseableIterator.take$((CloseableIterator)this, (int)n);
                }

                public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.takeWhile$((CloseableIterator)this, p);
                }

                public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                    return CloseableIterator.collect$((CloseableIterator)this, pf);
                }

                public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return CloseableIterator.$plus$plus$((CloseableIterator)this, that);
                }

                public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                    return CloseableIterator.flatMap$((CloseableIterator)this, f);
                }

                public Iterator<SimpleFeature> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<SimpleFeature> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<SimpleFeature> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<SimpleFeature, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<SimpleFeature, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<SimpleFeature, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<SimpleFeature> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<SimpleFeature> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<SimpleFeature> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<SimpleFeature> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<SimpleFeature> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<SimpleFeature, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<SimpleFeature> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<SimpleFeature> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<SimpleFeature> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<SimpleFeature> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<SimpleFeature> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.features$1.hasNext();
                }

                public SimpleFeature next() {
                    this.writer$1.clear();
                    this.os$2.reset();
                    for (int index = 0; index < this.batchSize$1 && this.features$1.hasNext(); ++index) {
                        this.writer$1.add((SimpleFeature)this.features$1.next());
                    }
                    this.writer$1.encode((OutputStream)this.os$2);
                    this.sf$2.setAttribute(0, (Object)this.os$2.toByteArray());
                    return this.sf$2;
                }

                public void close() {
                    package.CloseWithLogging$.MODULE$.apply((Object)new .colon.colon((Object)this.features$1, (List)new .colon.colon((Object)this.writer$1, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
                }
                {
                    this.features$1 = features$1;
                    this.writer$1 = writer$1;
                    this.os$2 = os$2;
                    this.batchSize$1 = batchSize$1;
                    this.sf$2 = sf$2;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                    CloseableIterator.$init$((CloseableIterator)this);
                }
            };
            object = QueryHints$.MODULE$.RichHints(hints).isSkipReduce() ? arrows : new ArrowScan.FileReducer(arrowSft2, dictionaryFields, encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort.map((Function1 & Serializable & scala.Serializable)x$19 -> (Tuple2)x$19.head())).apply(arrows);
        } else {
            DeltaWriter writer = new DeltaWriter(arrowSft2, dictionaryFields, encoding, ipcOpts, (Option)None$.MODULE$, batchSize);
            SimpleFeature[] array = (SimpleFeature[])Array$.MODULE$.ofDim(batchSize, ClassTag$.MODULE$.apply(SimpleFeature.class));
            SimpleFeature sf = ArrowScan$.MODULE$.resultFeature();
            CloseableIterator<SimpleFeature> arrows = new CloseableIterator<SimpleFeature>(features2, batchSize, array, sf, writer){
                private final CloseableIterator features$1;
                private final int batchSize$1;
                private final SimpleFeature[] array$1;
                private final SimpleFeature sf$3;
                private final DeltaWriter writer$2;

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                    return Iterator.map$((Iterator)this, (Function1)f);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                    return Iterator.filter$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                    return Iterator.filterNot$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                    return Iterator.takeWhile$((Iterator)this, (Function1)p);
                }

                public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                    return Iterator.collect$((Iterator)this, (PartialFunction)pf);
                }

                public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                    return CloseableIterator.map$((CloseableIterator)this, f);
                }

                public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filter$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.filterNot$((CloseableIterator)this, p);
                }

                public CloseableIterator<SimpleFeature> take(int n) {
                    return CloseableIterator.take$((CloseableIterator)this, (int)n);
                }

                public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                    return CloseableIterator.takeWhile$((CloseableIterator)this, p);
                }

                public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                    return CloseableIterator.collect$((CloseableIterator)this, pf);
                }

                public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return CloseableIterator.$plus$plus$((CloseableIterator)this, that);
                }

                public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                    return CloseableIterator.flatMap$((CloseableIterator)this, f);
                }

                public Iterator<SimpleFeature> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<SimpleFeature> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<SimpleFeature> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<SimpleFeature, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<SimpleFeature, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<SimpleFeature, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<SimpleFeature> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<SimpleFeature> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<SimpleFeature> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<SimpleFeature> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<SimpleFeature> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<SimpleFeature, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<SimpleFeature> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<SimpleFeature> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<SimpleFeature> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<SimpleFeature> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<SimpleFeature> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.features$1.hasNext();
                }

                public SimpleFeature next() {
                    int index;
                    for (index = 0; index < this.batchSize$1 && this.features$1.hasNext(); ++index) {
                        this.array$1[index] = (SimpleFeature)this.features$1.next();
                    }
                    this.sf$3.setAttribute(0, (Object)this.writer$2.encode(this.array$1, index));
                    return this.sf$3;
                }

                public void close() {
                    package.CloseWithLogging$.MODULE$.apply((Object)new .colon.colon((Object)this.features$1, (List)new .colon.colon((Object)this.writer$2, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
                }
                {
                    this.features$1 = features$1;
                    this.batchSize$1 = batchSize$1;
                    this.array$1 = array$1;
                    this.sf$3 = sf$3;
                    this.writer$2 = writer$2;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                    CloseableIterator.$init$((CloseableIterator)this);
                }
            };
            if (QueryHints$.MODULE$.RichHints(hints).isSkipReduce()) {
                object = arrows;
            } else {
                boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
                object = new ArrowScan.DeltaReducer(arrowSft2, dictionaryFields, encoding, ipcOpts, batchSize, (Option<Tuple2<String, Object>>)sort.map((Function1 & Serializable & scala.Serializable)x$20 -> (Tuple2)x$20.head()), true, process).apply(arrows);
            }
        }
        return object;
    }

    private CloseableIterator<SimpleFeature> densityTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, String geom, Envelope envelope, int width, int height, Option<String> weight) {
        DensityScan.GeometryRenderer renderer = DensityScan$.MODULE$.getRenderer(sft, geom, weight);
        RenderingGrid grid = new RenderingGrid(envelope, width, height);
        try {
            features.foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
                renderer.render(grid, x$21);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            features.close();
        }
        ScalaSimpleFeature sf = new ScalaSimpleFeature(DensityScan$.MODULE$.DensitySft(), "", new Object[]{GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        sf.getUserData().put(DensityScan$.MODULE$.DensityValueKey(), DensityScan$.MODULE$.encodeResult(grid));
        return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{sf})), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2());
    }

    private CloseableIterator<SimpleFeature> statsTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, Option<Tuple2<String, SimpleFeatureType>> transform, String query, boolean encode) {
        Some some;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Option<Tuple2<String, SimpleFeatureType>> option = transform;
        if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2((Object)sft, features);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            tuple22 = new Tuple2((Object)tsft, this.projectionTransform(features, sft, tsft, tdefs, (Option<Seq<Tuple2<String, Object>>>)None$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        SimpleFeatureType statSft = (SimpleFeatureType)tuple23._1();
        CloseableIterator toObserve = (CloseableIterator)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)statSft, (Object)toObserve);
        Tuple2 tuple25 = tuple24;
        SimpleFeatureType statSft2 = (SimpleFeatureType)tuple25._1();
        Stat stat = Stat$.MODULE$.apply(statSft2, query);
        try (CloseableIterator toObserve2 = (CloseableIterator)tuple25._2();){
            toObserve2.foreach((Function1 & Serializable & scala.Serializable)sf -> {
                stat.observe(sf);
                return BoxedUnit.UNIT;
            });
        }
        String encoded = encode ? (String)StatsScan$.MODULE$.encodeStat(statSft2).apply((Object)stat) : stat.toJson();
        return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{new ScalaSimpleFeature(StatsScan$.MODULE$.StatsSft(), "stat", new Object[]{encoded, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4())})), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2());
    }

    private CloseableIterator<SimpleFeature> projectionTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, SimpleFeatureType transform, String definitions, Option<Seq<Tuple2<String, Object>>> sort) {
        CloseableIterator closeableIterator;
        TransformSimpleFeature transformSf = TransformSimpleFeature$.MODULE$.apply(sft, transform, definitions);
        CloseableIterator result = features.map((Function1 & Serializable & scala.Serializable)x$23 -> LocalQueryRunner$.setValues$1(x$23, new ScalaSimpleFeature(transform, "", ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$3(), ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4()), transformSf, transform));
        Option<Seq<Tuple2<String, Object>>> option = sort;
        if (None$.MODULE$.equals(option)) {
            closeableIterator = result;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Seq s = (Seq)some.value();
            closeableIterator = new SortingSimpleFeatureIterator((CloseableIterator<SimpleFeature>)result, (Seq<Tuple2<String, Object>>)s);
        } else {
            throw new MatchError(option);
        }
        return closeableIterator;
    }

    private CloseableIterator<SimpleFeature> noTransform(CloseableIterator<SimpleFeature> features, Option<Seq<Tuple2<String, Object>>> sort) {
        SortingSimpleFeatureIterator sortingSimpleFeatureIterator;
        Option<Seq<Tuple2<String, Object>>> option = sort;
        if (None$.MODULE$.equals(option)) {
            sortingSimpleFeatureIterator = features;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Seq s = (Seq)some.value();
            sortingSimpleFeatureIterator = new SortingSimpleFeatureIterator(features, (Seq<Tuple2<String, Object>>)s);
        } else {
            throw new MatchError(option);
        }
        return sortingSimpleFeatureIterator;
    }

    private CloseableIterator<SimpleFeature> sample(SimpleFeatureType sft, float percent, Option<String> by, CloseableIterator<SimpleFeature> features) {
        CloseableIterator closeableIterator;
        if (!(percent > 0.0f) || !(percent < 1.0f)) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(46).append("Sampling must be a percentage between (0, 1): ").append(percent).toString());
        }
        int nth = (int)(1.0f / percent);
        Option field = by.map((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToInteger((int)LocalQueryRunner$.$anonfun$sample$1(sft, name)));
        if (nth <= 1) {
            closeableIterator = features;
        } else {
            Function1<SimpleFeature, Object> sample = FeatureSampler$.MODULE$.sample(nth, (Option<Object>)field);
            closeableIterator = features.filter((Function1 & Serializable & scala.Serializable)v1 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.$anonfun$sample$2(sample, v1)));
        }
        return closeableIterator;
    }

    private boolean noAuthVisibilityCheck(SimpleFeature f) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)f);
        return vis == null || vis.isEmpty();
    }

    private boolean authVisibilityCheck(SimpleFeature f, Seq<byte[]> auths) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)f);
        return vis == null || VisibilityEvaluator$.MODULE$.parse(vis, VisibilityEvaluator$.MODULE$.parse$default$2()).evaluate(auths);
    }

    public static final /* synthetic */ boolean $anonfun$transform$1(String x$11) {
        String string = x$11;
        String string2 = "id";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final /* synthetic */ Tuple2 x$16$lzycompute$1(LazyRef x$16$lzy$1, Option hook$1) {
        Tuple2 tuple2;
        LazyRef lazyRef = x$16$lzy$1;
        synchronized (lazyRef) {
            Tuple2 tuple22;
            if (x$16$lzy$1.initialized()) {
                tuple22 = (Tuple2)x$16$lzy$1.value();
            } else {
                LocalQueryRunner.ArrowDictionaryHook arrowDictionaryHook = (LocalQueryRunner.ArrowDictionaryHook)hook$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException("Arrow query called without required hooks for dictionary lookups");
                });
                if (arrowDictionaryHook == null) {
                    throw new MatchError((Object)arrowDictionaryHook);
                }
                GeoMesaStats stats = arrowDictionaryHook.stats();
                Option<Filter> filter = arrowDictionaryHook.filter();
                Tuple2 tuple23 = new Tuple2((Object)stats, filter);
                tuple22 = (Tuple2)x$16$lzy$1.initialize((Object)tuple23);
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private static final /* synthetic */ Tuple2 x$16$1(LazyRef x$16$lzy$1, Option hook$1) {
        return x$16$lzy$1.initialized() ? (Tuple2)x$16$lzy$1.value() : LocalQueryRunner$.x$16$lzycompute$1(x$16$lzy$1, hook$1);
    }

    private static final /* synthetic */ GeoMesaStats stats$lzycompute$1(LazyRef stats$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        GeoMesaStats geoMesaStats;
        LazyRef lazyRef = stats$lzy$1;
        synchronized (lazyRef) {
            geoMesaStats = stats$lzy$1.initialized() ? (GeoMesaStats)stats$lzy$1.value() : (GeoMesaStats)stats$lzy$1.initialize(LocalQueryRunner$.x$16$1(x$16$lzy$1, hook$1)._1());
        }
        return geoMesaStats;
    }

    private static final GeoMesaStats stats$1(LazyRef stats$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        return stats$lzy$1.initialized() ? (GeoMesaStats)stats$lzy$1.value() : LocalQueryRunner$.stats$lzycompute$1(stats$lzy$1, x$16$lzy$1, hook$1);
    }

    private static final /* synthetic */ Option filter$lzycompute$1(LazyRef filter$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        Option option;
        LazyRef lazyRef = filter$lzy$1;
        synchronized (lazyRef) {
            option = filter$lzy$1.initialized() ? (Option)filter$lzy$1.value() : (Option)filter$lzy$1.initialize(LocalQueryRunner$.x$16$1(x$16$lzy$1, hook$1)._2());
        }
        return option;
    }

    private static final Option filter$1(LazyRef filter$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        return filter$lzy$1.initialized() ? (Option)filter$lzy$1.value() : LocalQueryRunner$.filter$lzycompute$1(filter$lzy$1, x$16$lzy$1, hook$1);
    }

    public static final /* synthetic */ boolean $anonfun$arrowTransform$8(Map providedDictionaries$1, Map cachedDictionaries$1, String f) {
        return providedDictionaries$1.contains((Object)f) || cachedDictionaries$1.contains((Object)f);
    }

    private static final ScalaSimpleFeature setValues$1(SimpleFeature from, ScalaSimpleFeature to, TransformSimpleFeature transformSf$1, SimpleFeatureType transform$1) {
        transformSf$1.setFeature(from);
        for (int i = 0; i < transform$1.getAttributeCount(); ++i) {
            to.setAttributeNoConvert(i, transformSf$1.getAttribute(i));
        }
        to.setId(from.getID());
        return to;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$sample$1(SimpleFeatureType sft$5, String name) {
        void var2_2;
        int i = sft$5.indexOf(name);
        if (i == -1) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(38).append("Invalid sampling field '").append(name).append("' for schema ").append(sft$5.getTypeName()).append(" ").append(SimpleFeatureTypes$.MODULE$.encodeType(sft$5)).toString());
        }
        return (int)var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$sample$2(Function1 sample$1, SimpleFeature v1) {
        return BoxesRunTime.unboxToBoolean((Object)sample$1.apply((Object)v1));
    }

    private LocalQueryRunner$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

