/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GraduatedQueryGuard$
implements LazyLogging {
    public static GraduatedQueryGuard$ MODULE$;
    private final String ConfigPath;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GraduatedQueryGuard$();
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard$ graduatedQueryGuard$ = this;
        synchronized (graduatedQueryGuard$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public boolean disabled(String typeName) {
        return new GeoMesaSystemProperties.SystemProperty(new StringBuilder(32).append("geomesa.guard.graduated.").append(typeName).append(".disable").toString(), GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<GraduatedQueryGuard.SizeAndDuration> evaluateLimits(Seq<GraduatedQueryGuard.SizeAndDuration> limits) {
        void var2_2;
        Seq candidate = (Seq)limits.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeLimit()), (Ordering)Ordering.Int$.MODULE$);
        if (candidate.size() > 1) {
            candidate.sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GraduatedQueryGuard$.$anonfun$evaluateLimits$2(x0$1);
                return BoxedUnit.UNIT;
            });
        } else if (candidate.isEmpty()) {
            throw new IllegalArgumentException("Graduated query guard configuration is empty.");
        }
        if (((GraduatedQueryGuard.SizeAndDuration)candidate.last()).sizeLimit() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Graduated query guard configuration must include ").append("unbounded restriction.").toString());
        }
        return var2_2;
    }

    public Seq<GraduatedQueryGuard.SizeAndDuration> buildLimits(List<? extends Config> guardConfig) {
        Buffer confs = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(guardConfig).asScala()).map((Function1 & Serializable & scala.Serializable)durationConfig -> {
            int size = durationConfig.hasPath("size") ? durationConfig.getInt("size") : Integer.MAX_VALUE;
            Duration duration = Duration$.MODULE$.apply(durationConfig.getString("duration"));
            return new GraduatedQueryGuard.SizeAndDuration(size, duration);
        }, Buffer$.MODULE$.canBuildFrom());
        return this.evaluateLimits((Seq<GraduatedQueryGuard.SizeAndDuration>)confs.toSeq());
    }

    public static final /* synthetic */ void $anonfun$evaluateLimits$2(Seq x0$1) {
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            GraduatedQueryGuard.SizeAndDuration first = (GraduatedQueryGuard.SizeAndDuration)((SeqLike)some.get()).apply(0);
            GraduatedQueryGuard.SizeAndDuration second = (GraduatedQueryGuard.SizeAndDuration)((SeqLike)some.get()).apply(1);
            if (first.sizeLimit() == second.sizeLimit()) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Graduated query guard configuration ").append("has repeated size: ").append(first.sizeLimit()).toString());
            }
            if (first.durationLimit().compareTo((Object)second.durationLimit()) <= 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Graduated query guard configuration ").append("has durations out of order: ").append(first.durationLimit()).append(" is less than ").append(second.durationLimit()).toString());
            }
        } else {
            throw new MatchError((Object)seq);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private GraduatedQueryGuard$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.ConfigPath = "geomesa.guard.graduated";
    }
}

