/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard$;
import org.locationtech.geomesa.index.planning.guard.package$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001\u0002\u0017.\u0001iBQ!\u0015\u0001\u0005\u0002IC\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002,\t\u0017\t\u001d\u0002\u00011AA\u0002\u0013%!\u0011\u0006\u0005\u000b\u0005g\u0001\u0001\u0019!A!B\u00139\u0006\"CAk\u0001\u0001\u0007I\u0011\u0002B\u001b\u0011%\u00119\u0004\u0001a\u0001\n\u0013\u0011I\u0004\u0003\u0005\u0003>\u0001\u0001\u000b\u0015BAF\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqAa\u001c\u0001\t\u0003\u0012\t\b\u0003\u0004/\u0001\u0011\u0005#Q\u0010\u0005\b\u0005?\u0003A\u0011\tBQ\u000f\u0015\u0019X\u0006#\u0001u\r\u0015aS\u0006#\u0001v\u0011\u0015\tV\u0002\"\u0001{\u0011\u001dYXB1A\u0005\u0002qDq!!\u0001\u000eA\u0003%QP\u0002\u0004\u0002\u00045\u0001\u0015Q\u0001\u0005\u000b\u0003'\t\"Q3A\u0005\u0002\u0005U\u0001BCA\u000f#\tE\t\u0015!\u0003\u0002\u0018!Q\u0011qD\t\u0003\u0016\u0004%\t!!\t\t\u0015\u0005M\u0012C!E!\u0002\u0013\t\u0019\u0003\u0003\u0004R#\u0011\u0005\u0011Q\u0007\u0005\n\u0003\u007f\t\u0012\u0011!C\u0001\u0003\u0003B\u0011\"a\u0012\u0012#\u0003%\t!!\u0013\t\u0013\u0005}\u0013#%A\u0005\u0002\u0005\u0005\u0004\u0002CA3#\u0005\u0005I\u0011\t?\t\u0013\u0005\u001d\u0014#!A\u0005\u0002\u0005U\u0001\"CA5#\u0005\u0005I\u0011AA6\u0011%\t9(EA\u0001\n\u0003\nI\bC\u0005\u0002\bF\t\t\u0011\"\u0001\u0002\n\"I\u00111S\t\u0002\u0002\u0013\u0005\u0013Q\u0013\u0005\n\u0003/\u000b\u0012\u0011!C!\u00033C\u0011\"a'\u0012\u0003\u0003%\t%!(\b\u0013\u0005\u0005V\"!A\t\u0002\u0005\rf!CA\u0002\u001b\u0005\u0005\t\u0012AAS\u0011\u0019\t6\u0005\"\u0001\u00024\"I\u0011qS\u0012\u0002\u0002\u0013\u0015\u0013\u0011\u0014\u0005\n\u0003k\u001b\u0013\u0011!CA\u0003oC\u0011\"!0$\u0003\u0003%\t)a0\t\u0013\u0005E7%!A\u0005\n\u0005M\u0007bBAk\u001b\u0011\u0005\u0011q\u001b\u0005\b\u0003WlA\u0011BAw\u0011\u001d\t)0\u0004C\u0001\u0003o\u00141c\u0012:bIV\fG/\u001a3Rk\u0016\u0014\u0018pR;be\u0012T!AL\u0018\u0002\u000b\u001d,\u0018M\u001d3\u000b\u0005A\n\u0014\u0001\u00039mC:t\u0017N\\4\u000b\u0005I\u001a\u0014!B5oI\u0016D(B\u0001\u001b6\u0003\u001d9Wm\\7fg\u0006T!AN\u001c\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003a\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001eD\u000fB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$AB(cU\u0016\u001cG\u000f\u0005\u0002E\u000b6\tq&\u0003\u0002G_\t\u0001\u0012+^3ss&sG/\u001a:dKB$xN\u001d\t\u0003\u0011>k\u0011!\u0013\u0006\u0003\u0015.\u000bAb]2bY\u0006dwnZ4j]\u001eT!\u0001T'\u0002\u0011QL\b/Z:bM\u0016T\u0011AT\u0001\u0004G>l\u0017B\u0001)J\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0006C\u0001+\u0001\u001b\u0005i\u0013aC4vCJ$G*[7jiN,\u0012a\u0016\t\u00041\n,gBA-`\u001d\tQV,D\u0001\\\u0015\ta\u0016(\u0001\u0004=e>|GOP\u0005\u0002=\u0006)1oY1mC&\u0011\u0001-Y\u0001\ba\u0006\u001c7.Y4f\u0015\u0005q\u0016BA2e\u0005\r\u0019V-\u001d\u0006\u0003A\u0006\u0004\"AZ\t\u000f\u0005\u001ddaB\u00015s\u001d\tI\u0017O\u0004\u0002ka:\u00111n\u001c\b\u0003Y:t!AW7\n\u0003aJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\t\u0001\u0014'\u0003\u0002/_\u0005\u0019rI]1ek\u0006$X\rZ)vKJLx)^1sIB\u0011A+D\n\u0004\u001bY<\u0005CA<y\u001b\u0005\t\u0017BA=b\u0005\u0019\te.\u001f*fMR\tA/\u0001\u0006D_:4\u0017n\u001a)bi\",\u0012! \t\u0003yyL!a`\u001f\u0003\rM#(/\u001b8h\u0003-\u0019uN\u001c4jOB\u000bG\u000f\u001b\u0011\u0003\u001fMK'0Z!oI\u0012+(/\u0019;j_:\u001cb!\u0005<\u0002\b\u00055\u0001cA<\u0002\n%\u0019\u00111B1\u0003\u000fA\u0013x\u000eZ;diB\u0019q/a\u0004\n\u0007\u0005E\u0011M\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0005tSj,G*[7jiV\u0011\u0011q\u0003\t\u0004o\u0006e\u0011bAA\u000eC\n\u0019\u0011J\u001c;\u0002\u0015ML'0\u001a'j[&$\b%A\u0007ekJ\fG/[8o\u0019&l\u0017\u000e^\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0005ekJ\fG/[8o\u0015\r\ti#Y\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0019\u0003O\u0011\u0001\u0002R;sCRLwN\\\u0001\u000fIV\u0014\u0018\r^5p]2KW.\u001b;!)\u0019\t9$a\u000f\u0002>A\u0019\u0011\u0011H\t\u000e\u00035Aq!a\u0005\u0017\u0001\u0004\t9\u0002C\u0004\u0002 Y\u0001\r!a\t\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003o\t\u0019%!\u0012\t\u0013\u0005Mq\u0003%AA\u0002\u0005]\u0001\"CA\u0010/A\u0005\t\u0019AA\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0013+\t\u0005]\u0011QJ\u0016\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011L1\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0005M#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA2U\u0011\t\u0019#!\u0014\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001c\u0002tA\u0019q/a\u001c\n\u0007\u0005E\u0014MA\u0002B]fD\u0011\"!\u001e\u001d\u0003\u0003\u0005\r!a\u0006\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\b\u0005\u0004\u0002~\u0005\r\u0015QN\u0007\u0003\u0003\u007fR1!!!b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\u000byH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAF\u0003#\u00032a^AG\u0013\r\ty)\u0019\u0002\b\u0005>|G.Z1o\u0011%\t)HHA\u0001\u0002\u0004\ti'\u0001\u0005iCND7i\u001c3f)\t\t9\"\u0001\u0005u_N#(/\u001b8h)\u0005i\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\f\u0006}\u0005\"CA;C\u0005\u0005\t\u0019AA7\u0003=\u0019\u0016N_3B]\u0012$UO]1uS>t\u0007cAA\u001dGM)1%a*\u0002\u000eAQ\u0011\u0011VAX\u0003/\t\u0019#a\u000e\u000e\u0005\u0005-&bAAWC\u00069!/\u001e8uS6,\u0017\u0002BAY\u0003W\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\u0019+A\u0003baBd\u0017\u0010\u0006\u0004\u00028\u0005e\u00161\u0018\u0005\b\u0003'1\u0003\u0019AA\f\u0011\u001d\tyB\na\u0001\u0003G\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002B\u00065\u0007#B<\u0002D\u0006\u001d\u0017bAAcC\n1q\n\u001d;j_:\u0004ra^Ae\u0003/\t\u0019#C\u0002\u0002L\u0006\u0014a\u0001V;qY\u0016\u0014\u0004\"CAhO\u0005\u0005\t\u0019AA\u001c\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\rF\u0001<\u0003!!\u0017n]1cY\u0016$G\u0003BAF\u00033Dq!a7*\u0001\u0004\ti.\u0001\u0005usB,g*Y7f!\u0011\ty.a:\u000f\t\u0005\u0005\u00181\u001d\t\u00035\u0006L1!!:b\u0003\u0019\u0001&/\u001a3fM&\u0019q0!;\u000b\u0007\u0005\u0015\u0018-\u0001\bfm\u0006dW/\u0019;f\u0019&l\u0017\u000e^:\u0015\t\u0005=\u0018\u0011\u001f\t\u00051\n\f9\u0004C\u0004\u0002t*\u0002\r!a<\u0002\r1LW.\u001b;t\u0003-\u0011W/\u001b7e\u0019&l\u0017\u000e^:\u0015\t\u0005=\u0018\u0011 \u0005\b\u0003w\\\u0003\u0019AA\u007f\u0003-9W/\u0019:e\u0007>tg-[41\t\u0005}(q\u0002\t\u0007\u0005\u0003\u00119Aa\u0003\u000e\u0005\t\r!b\u0001B\u0003\u007f\u0005!Q\u000f^5m\u0013\u0011\u0011IAa\u0001\u0003\t1K7\u000f\u001e\t\u0005\u0005\u001b\u0011y\u0001\u0004\u0001\u0005\u0019\tE\u0011\u0011`A\u0001\u0002\u0003\u0015\tAa\u0005\u0003\u0007}#3'\u0005\u0003\u0003\u0016\tm\u0001cA<\u0003\u0018%\u0019!\u0011D1\u0003\u000f9{G\u000f[5oOB!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"-\u000baaY8oM&<\u0017\u0002\u0002B\u0013\u0005?\u0011aaQ8oM&<\u0017aD4vCJ$G*[7jiN|F%Z9\u0015\t\t-\"\u0011\u0007\t\u0004o\n5\u0012b\u0001B\u0018C\n!QK\\5u\u0011!\t)hAA\u0001\u0002\u00049\u0016\u0001D4vCJ$G*[7jiN\u0004SCAAF\u00031!\u0017n]1cY\u0016$w\fJ3r)\u0011\u0011YCa\u000f\t\u0013\u0005Ud!!AA\u0002\u0005-\u0015!\u00033jg\u0006\u0014G.\u001a3!\u0003\u0011Ig.\u001b;\u0015\r\t-\"1\tB,\u0011\u001d\u0011)\u0005\u0003a\u0001\u0005\u000f\n!\u0001Z:\u0011\t\t%#1K\u0007\u0003\u0005\u0017RAA!\u0014\u0003P\u0005!A-\u0019;b\u0015\r\u0011\tfN\u0001\tO\u0016|Go\\8mg&!!Q\u000bB&\u0005%!\u0015\r^1Ti>\u0014X\rC\u0004\u0003Z!\u0001\rAa\u0017\u0002\u0007M4G\u000f\u0005\u0003\u0003^\t-TB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\rMLW\u000e\u001d7f\u0015\u0011\u0011)Ga\u001a\u0002\u000f\u0019,\u0017\r^;sK*\u0019!\u0011N\u001c\u0002\u000f=\u0004XM\\4jg&!!Q\u000eB0\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\be\u0016<(/\u001b;f)\u0011\u0011YCa\u001d\t\u000f\tU\u0014\u00021\u0001\u0003x\u0005)\u0011/^3ssB!!\u0011\nB=\u0013\u0011\u0011YHa\u0013\u0003\u000bE+XM]=\u0015\t\t}$q\u0011\t\u0006o\u0006\r'\u0011\u0011\t\u00041\n\r\u0015b\u0001BCI\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\t%%\u00021\u0001\u0003\f\u0006A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0003\u000e\nee\u0002\u0002BH\u0005+s1!\u001bBI\u0013\r\u0011\u0019*M\u0001\u0004CBL\u0017b\u00011\u0003\u0018*\u0019!1S\u0019\n\t\tm%Q\u0014\u0002\u000e#V,'/_*ue\u0006$XmZ=\u000b\u0007\u0001\u00149*A\u0003dY>\u001cX\r\u0006\u0002\u0003,\u0001")
public class GraduatedQueryGuard
implements QueryInterceptor,
LazyLogging {
    private Seq<SizeAndDuration> guardLimits;
    private boolean disabled;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Seq<SizeAndDuration> buildLimits(List<? extends Config> list) {
        return GraduatedQueryGuard$.MODULE$.buildLimits(list);
    }

    public static String ConfigPath() {
        return GraduatedQueryGuard$.MODULE$.ConfigPath();
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard graduatedQueryGuard = this;
        synchronized (graduatedQueryGuard) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private Seq<SizeAndDuration> guardLimits() {
        return this.guardLimits;
    }

    private void guardLimits_$eq(Seq<SizeAndDuration> x$1) {
        this.guardLimits = x$1;
    }

    private boolean disabled() {
        return this.disabled;
    }

    private void disabled_$eq(boolean x$1) {
        this.disabled = x$1;
    }

    @Override
    public void init(DataStore ds, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        this.disabled_$eq(GraduatedQueryGuard$.MODULE$.disabled(sft.getTypeName()));
        if (this.disabled()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("This guard is disabled for schema '{}' via system property", new Object[]{sft.getTypeName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.guardLimits_$eq(GraduatedQueryGuard$.MODULE$.buildLimits(ConfigFactory.load().getConfigList(new StringBuilder(1).append(GraduatedQueryGuard$.MODULE$.ConfigPath()).append(".").append(sft.getTypeName()).toString())));
        Predef$.MODULE$.require(this.guardLimits().nonEmpty());
    }

    @Override
    public void rewrite(Query query) {
    }

    @Override
    public Option<IllegalArgumentException> guard(package.QueryStrategy strategy) {
        None$ none$;
        if (this.disabled() || !(strategy.index() instanceof package.SpatioTemporalIndex)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            Tuple2 tuple2;
            Some some2;
            Option values = strategy.values().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof package.SpatialIndexValues && A1 instanceof package.TemporalIndexValues) {
                        A1 A12 = A1;
                        object = new Tuple2(((package.SpatialIndexValues)A12).spatialBounds(), ((package.TemporalIndexValues)A12).intervals());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof package.SpatialIndexValues && object instanceof package.TemporalIndexValues;
                    return bl;
                }
            });
            Option option = values;
            if (None$.MODULE$.equals(option)) {
                some2 = new Some((Object)new StringBuilder(98).append("Query does not have a temporal filter. Maximum allowed filter duration for ").append("whole world queries is ").append(((SizeAndDuration)this.guardLimits().last()).durationLimit()).toString());
            } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Seq s = (Seq)tuple2._1();
                FilterValues i = (FilterValues)tuple2._2();
                double spatialExtent = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)s.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GraduatedQueryGuard.$anonfun$guard$1(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                SizeAndDuration limit = (SizeAndDuration)this.guardLimits().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GraduatedQueryGuard.$anonfun$guard$2(spatialExtent, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Invalid extents/limits: {} / {}", (Object[])new String[]{s.mkString(", "), this.guardLimits().mkString(", ")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (SizeAndDuration)this.guardLimits().last();
                });
                some2 = package$.MODULE$.validate((FilterValues<Bounds<ZonedDateTime>>)i, limit.durationLimit()) ? None$.MODULE$ : new Some((Object)new StringBuilder(61).append("Query exceeds maximum allowed filter duration of ").append(limit.durationLimit()).append(" at ").append(limit.sizeLimit()).append(" degrees").toString());
            } else {
                throw new MatchError((Object)option);
            }
            none$ = some2;
        }
        None$ msg = none$;
        return msg.map((Function1 & Serializable & scala.Serializable)m -> new IllegalArgumentException(new StringBuilder(2).append((String)m).append(": ").append(package$.MODULE$.filterString(strategy)).toString()));
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ double $anonfun$guard$1(Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double lx = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double ly = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double ux = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double uy = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        double d = (ux - lx) * (uy - ly);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$guard$2(double spatialExtent$1, SizeAndDuration x$1) {
        return (double)x$1.sizeLimit() >= spatialExtent$1;
    }

    public GraduatedQueryGuard() {
        QueryInterceptor.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.disabled = false;
    }

    public static class SizeAndDuration
    implements Product,
    scala.Serializable {
        private final int sizeLimit;
        private final Duration durationLimit;

        public int sizeLimit() {
            return this.sizeLimit;
        }

        public Duration durationLimit() {
            return this.durationLimit;
        }

        public SizeAndDuration copy(int sizeLimit, Duration durationLimit) {
            return new SizeAndDuration(sizeLimit, durationLimit);
        }

        public int copy$default$1() {
            return this.sizeLimit();
        }

        public Duration copy$default$2() {
            return this.durationLimit();
        }

        public String productPrefix() {
            return "SizeAndDuration";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.sizeLimit());
                    break;
                }
                case 1: {
                    object = this.durationLimit();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SizeAndDuration;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.sizeLimit());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.durationLimit()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SizeAndDuration)) return false;
            boolean bl = true;
            if (!bl) return false;
            SizeAndDuration sizeAndDuration = (SizeAndDuration)x$1;
            if (this.sizeLimit() != sizeAndDuration.sizeLimit()) return false;
            Duration duration = this.durationLimit();
            Duration duration2 = sizeAndDuration.durationLimit();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (!sizeAndDuration.canEqual(this)) return false;
            return true;
        }

        public SizeAndDuration(int sizeLimit, Duration durationLimit) {
            this.sizeLimit = sizeLimit;
            this.durationLimit = durationLimit;
            Product.$init$((Product)this);
        }
    }
}

