/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.guard.TemporalQueryGuard$;
import org.locationtech.geomesa.index.planning.guard.package$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001\u0002\n\u0014\u0001\u0001BQa\u000e\u0001\u0005\u0002aB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"C(\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011\u001d\u0001\u0006\u00011A\u0005\nECq!\u0016\u0001A\u0002\u0013%a\u000b\u0003\u0004Y\u0001\u0001\u0006KA\u0015\u0005\u00063\u0002!\tE\u0017\u0005\u0006c\u0002!\tE\u001d\u0005\u0006)\u0001!\t\u0005\u001f\u0005\b\u0003s\u0001A\u0011IA\u001e\u000f\u001d\tid\u0005E\u0001\u0003\u007f1aAE\n\t\u0002\u0005\u0005\u0003BB\u001c\u000e\t\u0003\tI\u0005C\u0005\u0002L5\u0011\r\u0011\"\u0001\u0002N!A\u0011QK\u0007!\u0002\u0013\ty\u0005\u0003\u0004Q\u001b\u0011\u0005\u0011q\u000b\u0002\u0013)\u0016l\u0007o\u001c:bYF+XM]=Hk\u0006\u0014HM\u0003\u0002\u0015+\u0005)q-^1sI*\u0011acF\u0001\ta2\fgN\\5oO*\u0011\u0001$G\u0001\u0006S:$W\r\u001f\u0006\u00035m\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001d;\u0005aAn\\2bi&|g\u000e^3dQ*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001C%j\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)ZS\"A\u000b\n\u00051*\"\u0001E)vKJL\u0018J\u001c;fe\u000e,\u0007\u000f^8s!\tqS'D\u00010\u0015\t\u0001\u0014'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00023g\u0005AA/\u001f9fg\u00064WMC\u00015\u0003\r\u0019w.\\\u0005\u0003m=\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011aE\u0001\u0004[\u0006DX#A\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\t\u001b\u0015AC2p]\u000e,(O]3oi*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u007f\tAA)\u001e:bi&|g.A\u0004nCb|F%Z9\u0015\u0005%k\u0005C\u0001&L\u001b\u0005\u0019\u0015B\u0001'D\u0005\u0011)f.\u001b;\t\u000f9\u001b\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\u0002\t5\f\u0007\u0010I\u0001\tI&\u001c\u0018M\u00197fIV\t!\u000b\u0005\u0002K'&\u0011Ak\u0011\u0002\b\u0005>|G.Z1o\u00031!\u0017n]1cY\u0016$w\fJ3r)\tIu\u000bC\u0004O\r\u0005\u0005\t\u0019\u0001*\u0002\u0013\u0011L7/\u00192mK\u0012\u0004\u0013\u0001B5oSR$2!S.f\u0011\u0015a\u0006\u00021\u0001^\u0003\t!7\u000f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A-\u0019;b\u0015\t\u0011W$\u0001\u0005hK>$xn\u001c7t\u0013\t!wLA\u0005ECR\f7\u000b^8sK\")a\r\u0003a\u0001O\u0006\u00191O\u001a;\u0011\u0005!|W\"A5\u000b\u0005)\\\u0017AB:j[BdWM\u0003\u0002m[\u00069a-Z1ukJ,'B\u00018\u001e\u0003\u001dy\u0007/\u001a8hSNL!\u0001]5\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0004sK^\u0014\u0018\u000e^3\u0015\u0005%\u001b\b\"\u0002;\n\u0001\u0004)\u0018!B9vKJL\bC\u00010w\u0013\t9xLA\u0003Rk\u0016\u0014\u0018\u0010F\u0002z\u0003#\u00012A\u0013>}\u0013\tY8I\u0001\u0004PaRLwN\u001c\t\u0004{\u0006-ab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002?\u00051AH]8pizJ\u0011\u0001R\u0005\u0004\u0003\u0013\u0019\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T1!!\u0003D\u0011\u001d\t\u0019B\u0003a\u0001\u0003+\t\u0001b\u001d;sCR,w-\u001f\t\u0005\u0003/\t\u0019D\u0004\u0003\u0002\u001a\u0005=b\u0002BA\u000e\u0003WqA!!\b\u0002*9!\u0011qDA\u0014\u001d\u0011\t\t#!\n\u000f\u0007}\f\u0019#C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0004\u0003[9\u0012aA1qS&!\u0011\u0011BA\u0019\u0015\r\ticF\u0005\u0005\u0003k\t9DA\u0007Rk\u0016\u0014\u0018p\u0015;sCR,w-\u001f\u0006\u0005\u0003\u0013\t\t$A\u0003dY>\u001cX\rF\u0001J\u0003I!V-\u001c9pe\u0006d\u0017+^3ss\u001e+\u0018M\u001d3\u0011\u0005ij1cA\u0007\u0002DA\u0019!*!\u0012\n\u0007\u0005\u001d3I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u007f\taaQ8oM&<WCAA(!\r\u0011\u0013\u0011K\u0005\u0004\u0003'\u001a#AB*ue&tw-A\u0004D_:4\u0017n\u001a\u0011\u0015\u0007I\u000bI\u0006C\u0004\u0002\\E\u0001\r!!\u0018\u0002\u0011QL\b/\u001a(b[\u0016\u0004B!a\u0018\u0002h9!\u0011\u0011MA2!\ty8)C\u0002\u0002f\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003SR1!!\u001aD\u0001")
public class TemporalQueryGuard
implements QueryInterceptor,
LazyLogging {
    private Duration max;
    private boolean disabled;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String Config() {
        return TemporalQueryGuard$.MODULE$.Config();
    }

    private Logger logger$lzycompute() {
        TemporalQueryGuard temporalQueryGuard = this;
        synchronized (temporalQueryGuard) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private Duration max() {
        return this.max;
    }

    private void max_$eq(Duration x$1) {
        this.max = x$1;
    }

    private boolean disabled() {
        return this.disabled;
    }

    private void disabled_$eq(boolean x$1) {
        this.disabled = x$1;
    }

    @Override
    public void init(DataStore ds, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        this.disabled_$eq(TemporalQueryGuard$.MODULE$.disabled(sft.getTypeName()));
        if (this.disabled()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("This guard is disabled for schema '{}' via system property", new Object[]{sft.getTypeName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.max_$eq((Duration)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply((String)sft.getUserData().get(TemporalQueryGuard$.MODULE$.Config()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(66).append("Temporal query guard expects valid duration under user data key '").append(TemporalQueryGuard$.MODULE$.Config()).append("'").toString());
        }));
    }

    @Override
    public void rewrite(Query query) {
    }

    @Override
    public Option<IllegalArgumentException> guard(package.QueryStrategy strategy) {
        None$ none$;
        if (this.disabled() || !(strategy.index() instanceof package.TemporalIndex)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            FilterValues i;
            Option option = strategy.values().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    FilterValues<Bounds<ZonedDateTime>> filterValues;
                    A1 A1 = x1;
                    if (A1 instanceof package.TemporalIndexValues) {
                        A1 A12 = A1;
                        filterValues = ((package.TemporalIndexValues)A12).intervals();
                    } else {
                        filterValues = function1.apply(x1);
                    }
                    return (B1)filterValues;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof package.TemporalIndexValues;
                    return bl;
                }
            });
            Object object = None$.MODULE$.equals(option) ? new Some((Object)"Query does not have a temporal filter") : (option instanceof Some && !package$.MODULE$.validate((FilterValues<Bounds<ZonedDateTime>>)(i = (FilterValues)(some = (Some)option).value()), this.max()) ? new Some((Object)new StringBuilder(49).append("Query exceeds maximum allowed filter duration of ").append(this.max()).toString()) : None$.MODULE$);
            none$ = object;
        }
        None$ msg = none$;
        return msg.map((Function1 & Serializable & scala.Serializable)m -> new IllegalArgumentException(new StringBuilder(2).append((String)m).append(": ").append(package$.MODULE$.filterString(strategy)).toString()));
    }

    @Override
    public void close() {
    }

    public TemporalQueryGuard() {
        QueryInterceptor.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.disabled = false;
    }
}

