/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.view;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$StatsReducer$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.view.package$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.locationtech.geomesa.utils.iterators.SortedMergeIterator;
import org.locationtech.geomesa.utils.stats.TopK;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.sort.SortBy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.collection.parallel.ParSeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%g\u0001B\u0016-\u0001]B\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"Q!1\u0004\u0001\u0003\u0002\u0003\u0006I!!2\t\u0015\tu\u0001A!A!\u0002\u0013\t)\r\u0003\u0004z\u0001\u0011\u0005!q\u0004\u0005\n\u0005W\u0001!\u0019!C)\u0005[A\u0001B!\u0011\u0001A\u0003%!q\u0006\u0005\b\u0005\u0007\u0002A\u0011\tB#\u0011!\u0011Y\u0007\u0001C)a\t5\u0004b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011\u001d\u0011i\n\u0001C\u0005\u0005?CqAa*\u0001\t\u0013\u0011I\u000b\u0003\u0005\u00032\u0002!\t\u0006\rBZ\u0011\u001d\u0011I\f\u0001C\u0005\u0005w;Q!\u001e\u0017\t\u0002Y4Qa\u000b\u0017\t\u0002aDQ!_\t\u0005\u0002i4qa_\t\u0011\u0002G\u0005A\u0010C\u0003~'\u0019\u0005aP\u0002\u0004\u0002>E\u0001\u0015q\b\u0005\n\u001dV\u0011)\u001a!C\u0001\u0003#B!\"!\u0017\u0016\u0005#\u0005\u000b\u0011BA*\u0011\u0019IX\u0003\"\u0001\u0002\\!1Q0\u0006C!\u0003CB\u0011\"a\u001a\u0016\u0003\u0003%\t!!\u001b\t\u0013\u00055T#%A\u0005\u0002\u0005=\u0004\"CAC+\u0005\u0005I\u0011IAD\u0011%\tI*FA\u0001\n\u0003\tY\nC\u0005\u0002$V\t\t\u0011\"\u0001\u0002&\"I\u0011\u0011W\u000b\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003\u0003,\u0012\u0011!C\u0001\u0003\u0007D\u0011\"!4\u0016\u0003\u0003%\t%a4\t\u0013\u0005EW#!A\u0005B\u0005M\u0007\"CAk+\u0005\u0005I\u0011IAl\u000f%\tY.EA\u0001\u0012\u0003\tiNB\u0005\u0002>E\t\t\u0011#\u0001\u0002`\"1\u00110\nC\u0001\u0003[D\u0011\"!5&\u0003\u0003%)%a5\t\u0013\u0005=X%!A\u0005\u0002\u0006E\b\"CA{K\u0005\u0005I\u0011QA|\u0011%\u0011\u0019!JA\u0001\n\u0013\u0011)AA\tNKJ<W\rZ)vKJL(+\u001e8oKJT!!\f\u0018\u0002\tYLWm\u001e\u0006\u0003_A\nQ!\u001b8eKbT!!\r\u001a\u0002\u000f\u001d,w.\\3tC*\u00111\u0007N\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000f E!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fMB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IL\u0001\ta2\fgN\\5oO&\u00111\t\u0011\u0002\f#V,'/\u001f*v]:,'\u000f\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006a1oY1mC2|wmZ5oO*\u0011\u0011JS\u0001\tif\u0004Xm]1gK*\t1*A\u0002d_6L!!\u0014$\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0003IN\u0004\"\u0001\u00152\u000f\u0005E{fB\u0001*^\u001d\t\u0019FL\u0004\u0002U7:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031Z\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005M\"\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002_]\u0005)1\u000f^1ug&\u0011\u0001-Y\u0001\ba\u0006\u001c7.Y4f\u0015\tqf&\u0003\u0002dI\ny\u0001*Y:HK>lUm]1Ti\u0006$8O\u0003\u0002aC\u000611\u000f^8sKN\u00042aZ6o\u001d\tA'N\u0004\u0002WS&\t1(\u0003\u0002au%\u0011A.\u001c\u0002\u0004'\u0016\f(B\u00011;!\u0015It.\u001dB\u0007\u0013\t\u0001(H\u0001\u0004UkBdWM\r\t\u0003eNq!a\u001d\t\u000f\u0005I#\u0018BA\u0017/\u0003EiUM]4fIF+XM]=Sk:tWM\u001d\t\u0003oFi\u0011\u0001L\n\u0003#a\na\u0001P5oSRtD#\u0001<\u0003\u0013E+XM]=bE2,7CA\n9\u0003A9W\r\u001e$fCR,(/\u001a*fC\u0012,'\u000fF\u0003\u0000\u0003S\t\u0019\u0004\u0005\u0005\u0002\u0002\u0005-\u0011qBA\u0012\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00023bi\u0006T1!!\u00035\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BA\u0007\u0003\u0007\u0011QBR3biV\u0014XMU3bI\u0016\u0014\b\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005e\u00111D\u0001\bM\u0016\fG/\u001e:f\u0015\r\ti\u0002N\u0001\b_B,gnZ5t\u0013\u0011\t\t#a\u0005\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0005\u0003\u0002\u0012\u0005\u0015\u0012\u0002BA\u0014\u0003'\u0011QbU5na2,g)Z1ukJ,\u0007bBA\u0016)\u0001\u0007\u0011QF\u0001\u0002cB!\u0011\u0011AA\u0018\u0013\u0011\t\t$a\u0001\u0003\u000bE+XM]=\t\u000f\u0005UB\u00031\u0001\u00028\u0005\tA\u000f\u0005\u0003\u0002\u0002\u0005e\u0012\u0002BA\u001e\u0003\u0007\u00111\u0002\u0016:b]N\f7\r^5p]\n\u0011B)\u0019;b'R|'/Z)vKJL\u0018M\u00197f'!)\u0002(!\u0011\u0002F\u0005-\u0003cAA\"'5\t\u0011\u0003E\u0002:\u0003\u000fJ1!!\u0013;\u0005\u001d\u0001&o\u001c3vGR\u00042!OA'\u0013\r\tyE\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0003\u0003'\u0002B!!\u0001\u0002V%!\u0011qKA\u0002\u0005%!\u0015\r^1Ti>\u0014X-A\u0002eg\u0002\"B!!\u0018\u0002`A\u0019\u00111I\u000b\t\r9C\u0002\u0019AA*)\u0015y\u00181MA3\u0011\u001d\tY#\u0007a\u0001\u0003[Aq!!\u000e\u001a\u0001\u0004\t9$\u0001\u0003d_BLH\u0003BA/\u0003WB\u0001B\u0014\u000e\u0011\u0002\u0003\u0007\u00111K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tH\u000b\u0003\u0002T\u0005M4FAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}$(\u0001\u0006b]:|G/\u0019;j_:LA!a!\u0002z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\t1\fgn\u001a\u0006\u0003\u0003'\u000bAA[1wC&!\u0011qSAG\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0014\t\u0004s\u0005}\u0015bAAQu\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qUAW!\rI\u0014\u0011V\u0005\u0004\u0003WS$aA!os\"I\u0011q\u0016\u0010\u0002\u0002\u0003\u0007\u0011QT\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0006CBA\\\u0003{\u000b9+\u0004\u0002\u0002:*\u0019\u00111\u0018\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0006e&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!2\u0002LB\u0019\u0011(a2\n\u0007\u0005%'HA\u0004C_>dW-\u00198\t\u0013\u0005=\u0006%!AA\u0002\u0005\u001d\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002F\u0006e\u0007\"CAXG\u0005\u0005\t\u0019AAT\u0003I!\u0015\r^1Ti>\u0014X-U;fef\f'\r\\3\u0011\u0007\u0005\rSeE\u0003&\u0003C\fY\u0005\u0005\u0005\u0002d\u0006%\u00181KA/\u001b\t\t)OC\u0002\u0002hj\nqA];oi&lW-\u0003\u0003\u0002l\u0006\u0015(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011Q\\\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003;\n\u0019\u0010\u0003\u0004OQ\u0001\u0007\u00111K\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI0a@\u0011\u000be\nY0a\u0015\n\u0007\u0005u(H\u0001\u0004PaRLwN\u001c\u0005\n\u0005\u0003I\u0013\u0011!a\u0001\u0003;\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0001\u0003BAF\u0005\u0013IAAa\u0003\u0002\u000e\n1qJ\u00196fGR\u0004R!OA~\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0005\u0005+\tY\"\u0001\u0004gS2$XM]\u0005\u0005\u00053\u0011\u0019B\u0001\u0004GS2$XM]\u0001\fI\u0016$W\u000f\u001d7jG\u0006$X-\u0001\u0005qCJ\fG\u000e\\3m))\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006\t\u0003o\u0002AQAT\u0003A\u0002=CQ!Z\u0003A\u0002\u0019DqAa\u0007\u0006\u0001\u0004\t)\rC\u0004\u0003\u001e\u0015\u0001\r!!2\u0002\u0019%tG/\u001a:dKB$xN]:\u0016\u0005\t=\u0002\u0003\u0002B\u0019\u0005wqAAa\r\u000389\u0019!K!\u000e\n\u0005\u0005s\u0013b\u0001B\u001d\u0001\u0006\u0001\u0012+^3ss&sG/\u001a:dKB$xN]\u0005\u0005\u0005{\u0011yDA\fRk\u0016\u0014\u00180\u00138uKJ\u001cW\r\u001d;pe\u001a\u000b7\r^8ss*\u0019!\u0011\b!\u0002\u001b%tG/\u001a:dKB$xN]:!\u0003!\u0011XO\\)vKJLH\u0003\u0003B$\u0005+\u0012IF!\u0018\u0011\r\t%#\u0011KA\u0012\u001b\t\u0011YE\u0003\u0003\u0002<\n5#b\u0001B(a\u0005)Q\u000f^5mg&!!1\u000bB&\u0005E\u0019En\\:fC\ndW-\u0013;fe\u0006$xN\u001d\u0005\b\u0005/B\u0001\u0019AA\b\u0003\r\u0019h\r\u001e\u0005\b\u00057B\u0001\u0019AA\u0017\u0003!y'/[4j]\u0006d\u0007\"\u0003B0\u0011A\u0005\t\u0019\u0001B1\u0003\u001d)\u0007\u0010\u001d7bS:\u0004BAa\u0019\u0003h5\u0011!Q\r\u0006\u0004\u0005\u001fr\u0013\u0002\u0002B5\u0005K\u0012\u0011\"\u0012=qY\u0006Lg.\u001a:\u0002\u001d\r|gNZ5hkJ,\u0017+^3ssR1\u0011Q\u0006B8\u0005cBqAa\u0016\n\u0001\u0004\ty\u0001C\u0004\u0003\\%\u0001\r!!\f\u0002\u0015\u0005\u0014(o\\<Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0003H\t]$\u0011\u0010\u0005\b\u0005/R\u0001\u0019AA\b\u0011\u001d\u0011YH\u0003a\u0001\u0003[\tQ!];fef\fA\u0002Z3og&$\u00180U;fef$\u0002Ba\u0012\u0003\u0002\n\r%\u0011\u0012\u0005\b\u0005/Z\u0001\u0019AA\b\u0011\u001d\u0011)i\u0003a\u0001\u0005\u000f\u000bqA]3bI\u0016\u00148\u000fE\u0002hW~DqAa#\f\u0001\u0004\u0011i)A\u0003iS:$8\u000f\u0005\u0003\u0003\u0010\neUB\u0001BI\u0015\u0011\u0011\u0019J!&\u0002\u000f\u0019\f7\r^8ss*!!qSA\u0004\u0003\u0011)H/\u001b7\n\t\tm%\u0011\u0013\u0002\u0006\u0011&tGo]\u0001\u000bgR\fGo])vKJLH\u0003\u0003B$\u0005C\u0013\u0019K!*\t\u000f\t]C\u00021\u0001\u0002\u0010!9!Q\u0011\u0007A\u0002\t\u001d\u0005b\u0002BF\u0019\u0001\u0007!QR\u0001\tE&t\u0017+^3ssRA!q\tBV\u0005[\u0013y\u000bC\u0004\u0003X5\u0001\r!a\u0004\t\u000f\t\u0015U\u00021\u0001\u0003\b\"9!1R\u0007A\u0002\t5\u0015\u0001D4fiJ+G/\u001e:o'\u001a$HCBA\b\u0005k\u00139\fC\u0004\u0003X9\u0001\r!a\u0004\t\u000f\t-e\u00021\u0001\u0003\u000e\u0006qAm\u001c)be\u0006dG.\u001a7TG\u0006tGC\u0002B$\u0005{\u0013y\fC\u0004\u0003\u0006>\u0001\rAa\"\t\u000f\t\u0005w\u00021\u0001\u0003D\u000611/\u001b8hY\u0016\u0004b!\u000fBc\u007f\n\u001d\u0013b\u0001Bdu\tIa)\u001e8di&|g.\r")
public class MergedQueryRunner
implements QueryRunner,
LazyLogging {
    private final package.HasGeoMesaStats ds;
    private final Seq<Tuple2<Queryable, Option<Filter>>> stores;
    private final boolean deduplicate;
    private final boolean parallel;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public Explainer runQuery$default$3() {
        return QueryRunner.runQuery$default$3$(this);
    }

    private Logger logger$lzycompute() {
        MergedQueryRunner mergedQueryRunner = this;
        synchronized (mergedQueryRunner) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    @Override
    public CloseableIterator<SimpleFeature> runQuery(SimpleFeatureType sft, Query original, Explainer explain) {
        CloseableIterator closeableIterator;
        Query query = this.configureQuery(sft, original);
        Hints hints = query.getHints();
        None$ maxFeatures = query.isMaxFeaturesUnlimited() ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)query.getMaxFeatures()));
        Object object = QueryHints$.MODULE$.RichHints(hints).isStatsQuery() || QueryHints$.MODULE$.RichHints(hints).isArrowQuery() ? hints.put((Object)QueryHints$Internal$.MODULE$.SKIP_REDUCE(), (Object)Boolean.TRUE) : BoxedUnit.UNIT;
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            closeableIterator = this.arrowQuery(sft, query);
        } else {
            Seq readers = (Seq)this.stores.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Queryable store = (Queryable)tuple2._1();
                Option filter = (Option)tuple2._2();
                Query q = new Query(query);
                q.setHints(new Hints((RenderingHints)hints));
                FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = store.getFeatureReader(package$.MODULE$.mergeFilter(sft, q, (Option<Filter>)filter), Transaction.AUTO_COMMIT);
                return featureReader;
            }, Seq$.MODULE$.canBuildFrom());
            if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
                closeableIterator = this.densityQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, hints);
            } else if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
                closeableIterator = this.statsQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, hints);
            } else if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
                BoxedUnit boxedUnit;
                if (query.getSortBy() != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.getSortBy())).isEmpty()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Ignoring sort for BIN query");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                closeableIterator = this.binQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, hints);
            } else {
                CloseableIterator closeableIterator2;
                CloseableIterator closeableIterator3;
                Seq seq;
                if (this.deduplicate) {
                    HashSet cache = HashSet$.MODULE$.empty();
                    seq = (Seq)readers.map((Function1 & Serializable & scala.Serializable)r -> new DeduplicatingSimpleFeatureIterator((CloseableIterator)SelfClosingIterator$.MODULE$.apply(r), (Set)cache, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$3()), Seq$.MODULE$.canBuildFrom());
                } else {
                    seq = (Seq)readers.map((Function1 & Serializable & scala.Serializable)x$1 -> SelfClosingIterator$.MODULE$.apply(x$1), Seq$.MODULE$.canBuildFrom());
                }
                Seq iters = seq;
                Option option = Option$.MODULE$.apply((Object)query.getSortBy()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MergedQueryRunner.$anonfun$runQuery$4(x$2)));
                if (None$.MODULE$.equals(option)) {
                    closeableIterator3 = SelfClosingIterator$.MODULE$.apply(iters.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> i);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    SortBy[] sort = (SortBy[])some.value();
                    SimpleFeatureType sortSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable & scala.Serializable)x$3 -> (SimpleFeatureType)x$3._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
                    closeableIterator3 = new SortedMergeIterator(iters, SimpleFeatureOrdering$.MODULE$.apply(sortSft, sort));
                } else {
                    throw new MatchError((Object)option);
                }
                CloseableIterator results = closeableIterator3;
                None$ none$ = maxFeatures;
                if (None$.MODULE$.equals(none$)) {
                    closeableIterator2 = results;
                } else if (none$ instanceof Some) {
                    Some some = (Some)none$;
                    int m = BoxesRunTime.unboxToInt((Object)some.value());
                    closeableIterator2 = results.take(m);
                } else {
                    throw new MatchError((Object)none$);
                }
                closeableIterator = closeableIterator2;
            }
        }
        return closeableIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Query configureQuery(SimpleFeatureType sft, Query original) {
        void var3_3;
        Query query = new Query(original);
        QueryPlanner$.MODULE$.getPerThreadQueryHints().foreach((Function1 & Serializable & scala.Serializable)hints -> {
            MergedQueryRunner.$anonfun$configureQuery$1(query, hints);
            return BoxedUnit.UNIT;
        });
        ViewParams$.MODULE$.setHints(query);
        return var3_3;
    }

    private CloseableIterator<SimpleFeature> arrowQuery(SimpleFeatureType sft, Query query) {
        QueryPlan.FeatureReducer featureReducer;
        Map cachedDictionaries;
        Map map;
        Hints hints = query.getHints();
        QueryPlanner$.MODULE$.setQuerySort(sft, query);
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable & scala.Serializable)x$4 -> (SimpleFeatureType)x$4._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = ArrowScan$.MODULE$.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options((String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get()));
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        Map<String, Object[]> providedDictionaries = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(sft);
        if (!QueryHints$.MODULE$.RichHints(hints).isArrowCachedDictionaries()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            hints.put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_CACHED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            Seq toLookup = (Seq)dictionaryFields.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)providedDictionaries.contains((Object)key)));
            map = cachedDictionaries = ((TraversableOnce)((TraversableLike)toLookup.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
                GeoMesaStats qual$1 = $this.ds.stats();
                SimpleFeatureType x$1 = sft;
                String x$2 = x$5;
                Filter x$3 = qual$1.getTopK$default$3();
                boolean x$4 = qual$1.getTopK$default$4();
                return Option$.MODULE$.option2Iterable(qual$1.getTopK(x$1, x$2, x$3, x$4));
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.property()), k), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowDoublePass() || dictionaryFields.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MergedQueryRunner.$anonfun$arrowQuery$7(providedDictionaries, cachedDictionaries, f)))) {
            BoxedUnit boxedUnit;
            if (dictionaryFields.nonEmpty()) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Running deprecated Arrow double pass scan - switch to delta scans instead");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option filter = Option$.MODULE$.apply((Object)query.getFilter()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MergedQueryRunner.$anonfun$arrowQuery$8(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> FastFilterFactory$.MODULE$.optimize(sft, x$7));
            Map<String, ArrowDictionary> dictionaries = ArrowScan$.MODULE$.createDictionaries(this.ds.stats(), sft, (Option<Filter>)filter, dictionaryFields, providedDictionaries, (Map<String, TopK<Object>>)cachedDictionaries);
            QueryHints$.MODULE$.RichHints(hints).setArrowDictionaryEncodedValues((Map<String, Seq<Object>>)((Map)dictionaries.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                ArrowDictionary v = (ArrowDictionary)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)k, (Object)v.iterator().toSeq());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())));
            featureReducer = new ArrowScan.BatchReducer(arrowSft, dictionaries, encoding, ipcOpts, batchSize, sort, false);
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowMultiFile()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Running deprecated Arrow multi file scan - switch to delta scans instead");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            featureReducer = new ArrowScan.FileReducer(arrowSft, dictionaryFields, encoding, ipcOpts, sort);
        } else {
            boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
            featureReducer = new ArrowScan.DeltaReducer(arrowSft, dictionaryFields, encoding, ipcOpts, batchSize, sort, false, process);
        }
        QueryPlan.FeatureReducer reduce = featureReducer;
        Seq readers = (Seq)this.stores.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Queryable store = (Queryable)tuple2._1();
            Option filter = (Option)tuple2._2();
            Query q = new Query(query);
            q.setHints(new Hints((RenderingHints)hints));
            FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = store.getFeatureReader(package$.MODULE$.mergeFilter(sft, q, (Option<Filter>)filter), Transaction.AUTO_COMMIT);
            return featureReader;
        }, Seq$.MODULE$.canBuildFrom());
        return reduce.apply(this.doParallelScan((Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$1(reader, sft, hints)));
    }

    private CloseableIterator<SimpleFeature> densityQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$2(reader, sft, hints));
    }

    private CloseableIterator<SimpleFeature> statsQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        CloseableIterator<SimpleFeature> results = this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$3(reader, sft, hints));
        return StatsScan$StatsReducer$.MODULE$.apply(sft, hints).apply(results);
    }

    private CloseableIterator<SimpleFeature> binQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$4(reader, sft, hints));
    }

    @Override
    public SimpleFeatureType getReturnSft(SimpleFeatureType sft, Hints hints) {
        return QueryHints$.MODULE$.RichHints(hints).isBinQuery() ? BinaryOutputEncoder$.MODULE$.BinEncodedSft() : (QueryHints$.MODULE$.RichHints(hints).isArrowQuery() ? org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft() : (QueryHints$.MODULE$.RichHints(hints).isDensityQuery() ? DensityScan$.MODULE$.DensitySft() : (QueryHints$.MODULE$.RichHints(hints).isStatsQuery() ? StatsScan$.MODULE$.StatsSft() : QueryRunner.getReturnSft$(this, sft, hints))));
    }

    private CloseableIterator<SimpleFeature> doParallelScan(Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>> single) {
        return this.parallel ? SelfClosingIterator$.MODULE$.apply((Iterator)((ParSeqLike)((ParIterableLike)readers.par()).map(single, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> i) : SelfClosingIterator$.MODULE$.apply(readers.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap(single);
    }

    public static final /* synthetic */ boolean $anonfun$runQuery$4(SortBy[] x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$configureQuery$1(Query query$2, Map hints) {
        hints.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            Object object = query$2.getHints().put(k, v);
            return object;
        });
        QueryPlanner$.MODULE$.clearPerThreadQueryHints();
    }

    public static final /* synthetic */ boolean $anonfun$arrowQuery$7(Map providedDictionaries$1, Map cachedDictionaries$1, String f) {
        return providedDictionaries$1.contains((Object)f) || cachedDictionaries$1.contains((Object)f);
    }

    public static final /* synthetic */ boolean $anonfun$arrowQuery$8(Filter x$6) {
        Filter filter = x$6;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    private static final CloseableIterator getSingle$1(FeatureReader reader, SimpleFeatureType sft$2, Hints hints$2) {
        CloseableIterator<SimpleFeature> closeableIterator;
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            closeableIterator = CloseableIterator$.MODULE$.apply(reader);
        } else {
            SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$2.getUserData());
            closeableIterator = LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$2, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
        }
        return closeableIterator;
    }

    private static final CloseableIterator getSingle$2(FeatureReader reader, SimpleFeatureType sft$3, Hints hints$3) {
        CloseableIterator<SimpleFeature> closeableIterator;
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = DensityScan$.MODULE$.DensitySft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            closeableIterator = CloseableIterator$.MODULE$.apply(reader);
        } else {
            SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$3.getUserData());
            closeableIterator = LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$3, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
        }
        return closeableIterator;
    }

    private static final CloseableIterator getSingle$3(FeatureReader reader, SimpleFeatureType sft$4, Hints hints$4) {
        CloseableIterator<SimpleFeature> closeableIterator;
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = StatsScan$.MODULE$.StatsSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            closeableIterator = CloseableIterator$.MODULE$.apply(reader);
        } else {
            SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$4.getUserData());
            closeableIterator = LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$4, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
        }
        return closeableIterator;
    }

    private static final CloseableIterator getSingle$4(FeatureReader reader, SimpleFeatureType sft$5, Hints hints$5) {
        CloseableIterator<SimpleFeature> closeableIterator;
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            closeableIterator = CloseableIterator$.MODULE$.apply(reader);
        } else {
            SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$5.getUserData());
            closeableIterator = LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$5, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
        }
        return closeableIterator;
    }

    public MergedQueryRunner(package.HasGeoMesaStats ds, Seq<Tuple2<Queryable, Option<Filter>>> stores, boolean deduplicate, boolean parallel) {
        this.ds = ds;
        this.stores = stores;
        this.deduplicate = deduplicate;
        this.parallel = parallel;
        QueryRunner.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.empty();
    }

    public static class DataStoreQueryable
    implements Queryable,
    Product,
    scala.Serializable {
        private final DataStore ds;

        public DataStore ds() {
            return this.ds;
        }

        @Override
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query q, Transaction t) {
            return this.ds().getFeatureReader(q, t);
        }

        public DataStoreQueryable copy(DataStore ds) {
            return new DataStoreQueryable(ds);
        }

        public DataStore copy$default$1() {
            return this.ds();
        }

        public String productPrefix() {
            return "DataStoreQueryable";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.ds();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DataStoreQueryable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DataStoreQueryable)) return false;
            boolean bl = true;
            if (!bl) return false;
            DataStoreQueryable dataStoreQueryable = (DataStoreQueryable)x$1;
            DataStore dataStore = this.ds();
            DataStore dataStore2 = dataStoreQueryable.ds();
            if (dataStore == null) {
                if (dataStore2 != null) {
                    return false;
                }
            } else if (!dataStore.equals(dataStore2)) return false;
            if (!dataStoreQueryable.canEqual(this)) return false;
            return true;
        }

        public DataStoreQueryable(DataStore ds) {
            this.ds = ds;
            Product.$init$((Product)this);
        }
    }

    public static interface Queryable {
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query var1, Transaction var2);
    }
}

