/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$IdFromRow$;
import org.locationtech.geomesa.index.api.IndexAdapter$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.conf.splitter.TableSplitter$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.utils.ExplainNull$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0011%d!B.]\u0003\u00039\u0007BCA\u000f\u0001\t\u0015\r\u0011\"\u0001\u0002 !Q\u0011q\u0007\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u001d\u0003A!b\u0001\n\u0003\tI\u0005\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"!\u0019\u0001\u0005\u000b\u0007I\u0011AA2\u0011)\t)\b\u0001B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003o\u0002!Q1A\u0005\u0002\u0005e\u0004BCAA\u0001\t\u0005\t\u0015!\u0003\u0002|!Q\u00111\u0011\u0001\u0003\u0006\u0004%\t!!\"\t\u0015\u0005]\u0005A!A!\u0002\u0013\t9\t\u0003\u0006\u0002\u001a\u0002\u0011)\u0019!C\u0001\u00037C!\"!/\u0001\u0005\u0003\u0005\u000b\u0011BAO\u0011\u001d\tY\f\u0001C\u0001\u0003{C\u0011\"a9\u0001\u0005\u0004%\t\"a\u0019\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003KB!\"a:\u0001\u0011\u000b\u0007I\u0011CAu\u0011%\u0011y\u0002\u0001b\u0001\n\u0003\t\u0019\u0007\u0003\u0005\u0004V\u0001\u0001\u000b\u0011BA3\u0011%\u00199\u0006\u0001b\u0001\n\u0003\u0019I\u0006\u0003\u0005\u0004b\u0001\u0001\u000b\u0011BB.\u0011\u001d\u0011)\f\u0001D\u0001\u0007GBqA!4\u0001\r\u0003\u00199\u0007C\u0004\u0002d\u0002!\taa\u001f\t\u0013\r\r\u0005!%A\u0005\u0002\r\u0015\u0005bBBN\u0001\u0011\u00051Q\u0014\u0005\n\u0007O\u0003\u0011\u0013!C\u0001\u0007\u000bC\u0011b!+\u0001#\u0003%\taa+\t\u000f\r=\u0006\u0001\"\u0001\u00042\"I1Q\u0017\u0001\u0012\u0002\u0013\u00051Q\u0011\u0005\b\u0007o\u0003A\u0011AB]\u0011%\u0019y\fAI\u0001\n\u0003\u0019)\tC\u0004\u0004B\u0002!\t!!\"\t\u000f\r\r\u0007\u0001\"\u0001\u0004F\"I1\u0011\u001a\u0001\u0012\u0002\u0013\u00051Q\u0011\u0005\b\u0007\u0017\u0004A\u0011ABg\u0011\u001d\u0019y\u000e\u0001C\u0001\u0007CDqa!;\u0001\t\u0003\u0019Y\u000fC\u0004\u0004v\u0002!\taa>\t\u000f\r}\bA\"\u0001\u0005\u0002!9A\u0011\u0004\u0001\u0005\u0002\u0011m\u0001\"\u0003C$\u0001E\u0005I\u0011\u0001C%\u0011\u001d!i\u0005\u0001C\t\t\u001fB\u0011\u0002\"\u0016\u0001#\u0003%\tb!\"\t\u0013\u0011]\u0003!%A\u0005\u0012\r-\u0006b\u0002C-\u0001\u0011\u0005C1\f\u0005\b\t;\u0002A\u0011\tC0\u0011\u001d!)\u0007\u0001C!\tO:q!a=]\u0011\u0003\t)P\u0002\u0004\\9\"\u0005\u0011q\u001f\u0005\b\u0003w\u000bD\u0011AA}\u000f\u001d\tY0\rE\u0001\u0003{4qA!\u00012\u0011\u0003\u0011\u0019\u0001C\u0004\u0002<R\"\tA!\u0002\t\u0013\t\u001dAG1A\u0005\u0002\t%\u0001\u0002\u0003B\ti\u0001\u0006IAa\u0003\t\u0013\tMAG1A\u0005\u0002\t%\u0001\u0002\u0003B\u000bi\u0001\u0006IAa\u0003\t\u0013\t]AG1A\u0005\u0002\t%\u0001\u0002\u0003B\ri\u0001\u0006IAa\u0003\t\u0013\tmAG1A\u0005\u0002\t%\u0001\u0002\u0003B\u000fi\u0001\u0006IAa\u0003\t\u000f\t}\u0011\u0007\"\u0001\u0003\"!9!qD\u0019\u0005\u0002\t%\u0002b\u0002B\u0010c\u0011\u0005!1\b\u0005\b\u0005\u001f\nD\u0011\u0001B)\u0011\u001d\u0011I&\rC\u0001\u00057BqA!\u001d2\t\u0003\u0011\u0019HB\u0005\u0003\u0004F\u0002\n1%\t\u0003\u0006\"9!q\u0011#\u0007\u0002\t%\u0005b\u0002BM\t\u001a\u0005!1T\u0004\b\u0007S\t\u0004\u0012\u0001BV\r\u001d\u0011\u0019)\rE\u0001\u0005OCq!a/I\t\u0003\u0011I\u000bC\u0004\u0003\b\"#\tA!,\u0007\r\t\u0015\bJ\u0001Bt\u0011)\u0011\th\u0013B\u0001B\u0003%!Q\u000f\u0005\u000b\u0005S\\%\u0011!Q\u0001\n\u0005m\u0004bBA^\u0017\u0012\u0005!1\u001e\u0005\b\u0005\u000f[E\u0011\tB{\u0011\u001d\u0011Ij\u0013C!\u0005\u007f4aA!*I\u0005\r\u001d\u0001B\u0003B9#\n\u0005\t\u0015!\u0003\u0003v!Q!\u0011^)\u0003\u0002\u0003\u0006Ia!\u0003\t\u000f\u0005m\u0016\u000b\"\u0001\u0004\u0010!9!qQ)\u0005B\r]\u0001b\u0002BM#\u0012\u00053\u0011\u0005\u0005\b\u0007W\tD\u0011BB\u0017\u0011\u001d\u0019\t$\rC\u0005\u0007gAqaa\u00112\t\u0013\u0019)\u0005C\u0004\u0004JE\"Iaa\u0013\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u000b\u0005us\u0016aA1qS*\u0011q\fY\u0001\u0006S:$W\r\u001f\u0006\u0003C\n\fqaZ3p[\u0016\u001c\u0018M\u0003\u0002dI\u0006aAn\\2bi&|g\u000e^3dQ*\tQ-A\u0002pe\u001e\u001c\u0001!F\u0003i\u0003\u000b\fYmE\u0003\u0001S>\fI\u0001\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7N\u0001\u0004B]f\u0014VM\u001a\t\u0004a\u0006\raBA9\u007f\u001d\t\u0011XP\u0004\u0002ty:\u0011Ao\u001f\b\u0003kjt!A^=\u000e\u0003]T!\u0001\u001f4\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0017BA2e\u0013\t\t'-\u0003\u0002`A&\u0011qLX\u0005\u0004\u007f\u0006\u0005\u0011a\u00029bG.\fw-\u001a\u0006\u0003?zKA!!\u0002\u0002\b\tQa*Y7fI&sG-\u001a=\u000b\u0007}\f\t\u0001\u0005\u0003\u0002\f\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005M\u0011QC\u0001\tif\u0004Xm]1gK*\u0011\u0011qC\u0001\u0004G>l\u0017\u0002BA\u000e\u0003\u001b\u00111\u0002T1{s2{wmZ5oO\u0006\u0011Am]\u000b\u0003\u0003C\u0001D!a\t\u00024A1\u0011QEA\u0016\u0003_i!!a\n\u000b\u0007\u0005%b,\u0001\u0005hK>$xn\u001c7t\u0013\u0011\ti#a\n\u0003!\u001d+w.T3tC\u0012\u000bG/Y*u_J,\u0007\u0003BA\u0019\u0003ga\u0001\u0001B\u0006\u00026\t\t\t\u0011!A\u0003\u0002\u0005e\"aA0%c\u0005\u0019Am\u001d\u0011\u0012\t\u0005m\u0012\u0011\t\t\u0004U\u0006u\u0012bAA W\n9aj\u001c;iS:<\u0007c\u00016\u0002D%\u0019\u0011QI6\u0003\u0007\u0005s\u00170A\u0002tMR,\"!a\u0013\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u000511/[7qY\u0016TA!!\u0016\u0002X\u00059a-Z1ukJ,'bA/\u0002Z)\u0019\u0011\u0011\u00063\n\t\u0005u\u0013q\n\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\nAA\\1nKV\u0011\u0011Q\r\t\u0005\u0003O\nyG\u0004\u0003\u0002j\u0005-\u0004C\u0001<l\u0013\r\tig[\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000554.A\u0003oC6,\u0007%A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0005\u0005m\u0004c\u00016\u0002~%\u0019\u0011qP6\u0003\u0007%sG/\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0003)\tG\u000f\u001e:jEV$Xm]\u000b\u0003\u0003\u000f\u0003b!!#\u0002\u0012\u0006\u0015d\u0002BAF\u0003\u001fs1A^AG\u0013\u0005a\u0017BA@l\u0013\u0011\t\u0019*!&\u0003\u0007M+\u0017O\u0003\u0002\u0000W\u0006Y\u0011\r\u001e;sS\n,H/Z:!\u0003\u0011iw\u000eZ3\u0016\u0005\u0005u\u0005\u0003BAP\u0003gsA!!)\u0002.:!\u00111UAU\u001d\r\u0019\u0018QU\u0005\u0004\u0003O\u0003\u0017!B;uS2\u001c\u0018bA0\u0002,*\u0019\u0011q\u00151\n\t\u0005=\u0016\u0011W\u0001\n\u0013:$W\r_'pI\u0016T1aXAV\u0013\u0011\t),a.\u0003\u0013%sG-\u001a=N_\u0012,'\u0002BAX\u0003c\u000bQ!\\8eK\u0002\na\u0001P5oSRtDCDA`\u0003\u001f\fI.a7\u0002^\u0006}\u0017\u0011\u001d\t\b\u0003\u0003\u0004\u00111YAe\u001b\u0005a\u0006\u0003BA\u0019\u0003\u000b$q!a2\u0001\u0005\u0004\tIDA\u0001U!\u0011\t\t$a3\u0005\u000f\u00055\u0007A1\u0001\u0002:\t\tQ\u000bC\u0004\u0002\u001e5\u0001\r!!51\t\u0005M\u0017q\u001b\t\u0007\u0003K\tY#!6\u0011\t\u0005E\u0012q\u001b\u0003\r\u0003k\ty-!A\u0001\u0002\u000b\u0005\u0011\u0011\b\u0005\b\u0003\u000fj\u0001\u0019AA&\u0011\u001d\t\t'\u0004a\u0001\u0003KBq!a\u001e\u000e\u0001\u0004\tY\bC\u0004\u0002\u00046\u0001\r!a\"\t\u000f\u0005eU\u00021\u0001\u0002\u001e\u0006aA/\u00192mK:\u000bW.Z&fs\u0006iA/\u00192mK:\u000bW.Z&fs\u0002\n\u0011\"\u001b3Ge>l'k\\<\u0016\u0005\u0005-\bcAAw\t:\u0019\u0011q\u001e\u0019\u000f\u0007I\f\t0\u0003\u0002^=\u0006\u0019r)Z8NKN\fg)Z1ukJ,\u0017J\u001c3fqB\u0019\u0011\u0011Y\u0019\u0014\u0005EJGCAA{\u0003\u001d\u00196\r[3nKN\u00042!a@5\u001b\u0005\t$aB*dQ\u0016lWm]\n\u0003i%$\"!!@\u0002\u001bi\u001bD+\u00192mKN\u001b\u0007.Z7f+\t\u0011Y\u0001\u0005\u0004\u0002\n\n5\u0011QM\u0005\u0005\u0005\u001f\t)J\u0001\u0003MSN$\u0018A\u0004.4)\u0006\u0014G.Z*dQ\u0016lW\rI\u0001\u000e5J\"\u0016M\u00197f'\u000eDW-\\3\u0002\u001di\u0013D+\u00192mKN\u001b\u0007.Z7fA\u0005q\u0001LW\u001aUC\ndWmU2iK6,\u0017a\u0004-[gQ\u000b'\r\\3TG\",W.\u001a\u0011\u0002\u001daS&\u0007V1cY\u0016\u001c6\r[3nK\u0006y\u0001L\u0017\u001aUC\ndWmU2iK6,\u0007%\u0001\u0006jI\u0016tG/\u001b4jKJ$\u0002\"!\u001a\u0003$\t\u0015\"q\u0005\u0005\b\u0003Cr\u0004\u0019AA3\u0011\u001d\t9H\u0010a\u0001\u0003wBq!a!?\u0001\u0004\t9\t\u0006\u0003\u0002f\t-\u0002b\u0002B\u0017\u007f\u0001\u0007!qF\u0001\u0003S\u0012\u0004BA!\r\u000385\u0011!1\u0007\u0006\u0005\u0005k\tY+\u0001\u0003d_:4\u0017\u0002\u0002B\u001d\u0005g\u0011q!\u00138eKbLE\r\u0006\u0003\u0002f\tu\u0002BB0A\u0001\u0004\u0011y\u0004\r\u0004\u0003B\t\u0015#1\n\t\b\u0003\u0003\u0004!1\tB%!\u0011\t\tD!\u0012\u0005\u0019\t\u001d#QHA\u0001\u0002\u0003\u0015\t!!\u000f\u0003\u0007}#C\u0007\u0005\u0003\u00022\t-C\u0001\u0004B'\u0005{\t\t\u0011!A\u0003\u0002\u0005e\"aA0%k\u0005\u0001\"-Y:f)\u0006\u0014G.\u001a(b[\u0016\\U-\u001f\u000b\t\u0003K\u0012\u0019F!\u0016\u0003X!9\u0011\u0011M!A\u0002\u0005\u0015\u0004bBAB\u0003\u0002\u0007\u0011q\u0011\u0005\b\u0003o\n\u0005\u0019AA>\u0003%IG\rV8CsR,7\u000f\u0006\u0003\u0003^\t=\u0004c\u00026\u0003`\u0005\u0015$1M\u0005\u0004\u0005CZ'!\u0003$v]\u000e$\u0018n\u001c82!\u0015Q'Q\rB5\u0013\r\u00119g\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\n-\u0014b\u0001B7W\n!!)\u001f;f\u0011\u001d\t9E\u0011a\u0001\u0003\u0017\n1\"\u001b3Ge>l')\u001f;fgR!!Q\u000fBA!5Q'q\u000fB2\u0003w\nYHa\u001f\u0002f%\u0019!\u0011P6\u0003\u0013\u0019+hn\u0019;j_:$\u0004\u0003BA'\u0005{JAAa \u0002P\ti1+[7qY\u00164U-\u0019;ve\u0016Dq!a\u0012D\u0001\u0004\tYEA\u0005JI\u001a\u0013x.\u001c*poN\u0011A)[\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003K\u0012YIa$\u0003\u0014\n]\u0005b\u0002BG\u000b\u0002\u0007!1M\u0001\u0004e><\bb\u0002BI\u000b\u0002\u0007\u00111P\u0001\u0007_\u001a47/\u001a;\t\u000f\tUU\t1\u0001\u0002|\u00051A.\u001a8hi\"Dq!!\u0016F\u0001\u0004\u0011Y(A\u0003ti\u0006\u0014H\u000f\u0006\u0005\u0002|\tu%q\u0014BQ\u0011\u001d\u0011iI\u0012a\u0001\u0005GBqA!%G\u0001\u0004\tY\bC\u0004\u0003\u0016\u001a\u0003\r!a\u001f*\u0007\u0011\u000b6J\u0001\tEs:\fW.[2JI\u001a\u0013x.\u001c*poN\u0011\u0001*\u001b\u000b\u0003\u0005W\u00032!a@I)!\u0011yK!-\u00034\n-\u0007cAA\u0000\t\"9\u0011q\t&A\u0002\u0005-\u0003b\u0002B[\u0015\u0002\u0007!qW\u0001\tW\u0016L8\u000b]1dKB2!\u0011\u0018Ba\u0005\u000f\u0004\u0002\"!1\u0003<\n}&QY\u0005\u0004\u0005{c&!D%oI\u0016D8*Z=Ta\u0006\u001cW\r\u0005\u0003\u00022\t\u0005G\u0001\u0004Bb\u0005g\u000b\t\u0011!A\u0003\u0002\u0005e\"aA0%mA!\u0011\u0011\u0007Bd\t1\u0011IMa-\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryFe\u000e\u0005\b\u0005\u001bT\u0005\u0019\u0001Bh\u00039!\u0018.\u001a:fI.+\u0017p\u00159bG\u0016\u0004RA\u001bBi\u0005+L1Aa5l\u0005\u0019y\u0005\u000f^5p]B2!q\u001bBn\u0005C\u0004\u0002\"!1\u0003<\ne'q\u001c\t\u0005\u0003c\u0011Y\u000e\u0002\u0007\u0003^\n-\u0017\u0011!A\u0001\u0006\u0003\tIDA\u0002`Ia\u0002B!!\r\u0003b\u0012a!1\u001dBf\u0003\u0003\u0005\tQ!\u0001\u0002:\t\u0019q\fJ\u001d\u0003\u001d\u0019K\u00070\u001a3JI\u001a\u0013x.\u001c*poN!1*\u001bBX\u0003\u0019\u0001(/\u001a4jqR1!Q\u001eBy\u0005g\u00042Aa<L\u001b\u0005A\u0005b\u0002B9\u001d\u0002\u0007!Q\u000f\u0005\b\u0005St\u0005\u0019AA>))\t)Ga>\u0003z\nm(Q \u0005\b\u0005\u001b{\u0005\u0019\u0001B2\u0011\u001d\u0011\tj\u0014a\u0001\u0003wBqA!&P\u0001\u0004\tY\bC\u0004\u0002V=\u0003\rAa\u001f\u0015\u0011\u0005m4\u0011AB\u0002\u0007\u000bAqA!$Q\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\u0012B\u0003\r!a\u001f\t\u000f\tU\u0005\u000b1\u0001\u0002|M!\u0011+\u001bBX!-Q71\u0002B2\u0003w\nY(a\u001f\n\u0007\r51NA\u0005Gk:\u001cG/[8ogQ11\u0011CB\n\u0007+\u00012Aa<R\u0011\u001d\u0011\t\b\u0016a\u0001\u0005kBqA!;U\u0001\u0004\u0019I\u0001\u0006\u0006\u0002f\re11DB\u000f\u0007?AqA!$V\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\u0012V\u0003\r!a\u001f\t\u000f\tUU\u000b1\u0001\u0002|!9\u0011QK+A\u0002\tmD\u0003CA>\u0007G\u0019)ca\n\t\u000f\t5e\u000b1\u0001\u0003d!9!\u0011\u0013,A\u0002\u0005m\u0004b\u0002BK-\u0002\u0007\u00111P\u0001\n\u0013\u00124%o\\7S_^\f1\"^;jIR{')\u001f;fgR!!1MB\u0018\u0011\u001d\u0011ic\u0016a\u0001\u0003K\nQ\"^;jI\u001a\u0013x.\u001c\"zi\u0016\u001cHCCA3\u0007k\u0019Ida\u000f\u0004@!91q\u0007-A\u0002\t\r\u0014!\u00022zi\u0016\u001c\bb\u0002BI1\u0002\u0007\u00111\u0010\u0005\b\u0007{A\u0006\u0019AA>\u0003\u001dIwM\\8sK\u0012Dqa!\u0011Y\u0001\u0004\u0011Y(\u0001\u0002tM\u0006i1\u000f\u001e:j]\u001e$vNQ=uKN$BAa\u0019\u0004H!9!QF-A\u0002\u0005\u0015\u0014aD:ue&twM\u0012:p[\nKH/Z:\u0015\u0015\u0005\u00154QJB(\u0007#\u001a\u0019\u0006C\u0004\u00048i\u0003\rAa\u0019\t\u000f\tE%\f1\u0001\u0002|!9!Q\u0013.A\u0002\u0005m\u0004bBB\u001f5\u0002\u0007!1P\u0001\fS\u0012,g\u000e^5gS\u0016\u0014\b%\u0001\ttKJL\u0017\r\\5{K\u0012<\u0016\u000e\u001e5JIV\u001111\f\t\u0004U\u000eu\u0013bAB0W\n9!i\\8mK\u0006t\u0017!E:fe&\fG.\u001b>fI^KG\u000f[%eAU\u00111Q\r\t\t\u0003\u0003\u0014Y,a1\u0002JV\u00111\u0011\u000e\t\u0006U\nE71\u000e\u0019\u0007\u0007[\u001a\tha\u001e\u0011\u0011\u0005\u0005'1XB8\u0007k\u0002B!!\r\u0004r\u0011Y11\u000f\f\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryFE\r\t\u0005\u0003c\u00199\bB\u0006\u0004zY\t\t\u0011!A\u0003\u0002\u0005e\"aA0%gQ!\u0011QMB?\u0011%\u0019yh\u0006I\u0001\u0002\u0004\u0019\t)A\u0005qCJ$\u0018\u000e^5p]B)!N!5\u0002f\u00051B/\u00192mK:\u000bW.Z&fs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\b*\"1\u0011QBEW\t\u0019Y\t\u0005\u0003\u0004\u000e\u000e]UBABH\u0015\u0011\u0019\tja%\u0002\u0013Ut7\r[3dW\u0016$'bABKW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\re5q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE2p]\u001aLw-\u001e:f)\u0006\u0014G.\u001a(b[\u0016$b!!\u001a\u0004 \u000e\u0005\u0006\"CB@3A\u0005\t\u0019ABA\u0011%\u0019\u0019+\u0007I\u0001\u0002\u0004\u0019)+A\u0003mS6LG\u000fE\u0003k\u0005#\fY(\u0001\u000fd_:4\u0017nZ;sKR\u000b'\r\\3OC6,G\u0005Z3gCVdG\u000fJ\u0019\u00029\r|gNZ5hkJ,G+\u00192mK:\u000bW.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0016\u0016\u0005\u0007K\u001bI)\u0001\teK2,G/\u001a+bE2,g*Y7fgR!\u0011qQBZ\u0011%\u0019y\b\bI\u0001\u0002\u0004\u0019\t)\u0001\u000eeK2,G/\u001a+bE2,g*Y7fg\u0012\"WMZ1vYR$\u0013'A\u0005hKR\u001c\u0006\u000f\\5ugR!11XB_!\u0019\tI)!%\u0003d!I1q\u0010\u0010\u0011\u0002\u0003\u00071\u0011Q\u0001\u0014O\u0016$8\u000b\u001d7jiN$C-\u001a4bk2$H%M\u0001\u000eO\u0016$\b+\u0019:uSRLwN\\:\u0002\u001b\u001d,G\u000fV1cY\u0016t\u0015-\\3t)\u0011\t9ia2\t\u0013\r}\u0014\u0005%AA\u0002\r\u0005\u0015aF4fiR\u000b'\r\\3OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003E9W\r\u001e+bE2,7OR8s#V,'/\u001f\u000b\u0005\u0003\u000f\u001by\rC\u0004\u0004R\u000e\u0002\raa5\u0002\r\u0019LG\u000e^3s!\u0015Q'\u0011[Bk!\u0011\u00199na7\u000e\u0005\re'\u0002BBi\u0003/JAa!8\u0004Z\n1a)\u001b7uKJ\fqb\u0019:fCR,7i\u001c8wKJ$XM\u001d\u000b\u0003\u0007G\u0004b!!1\u0004f\u0006%\u0017bABt9\nqqK]5uK\u000e{gN^3si\u0016\u0014\u0018\u0001D4fi&#gI]8n%><HCCA3\u0007[\u001cyo!=\u0004t\"9!QR\u0013A\u0002\t\r\u0004b\u0002BIK\u0001\u0007\u00111\u0010\u0005\b\u0005++\u0003\u0019AA>\u0011\u001d\t)&\na\u0001\u0005w\n1bZ3u\u0013\u0012|eMZ:fiRA\u00111PB}\u0007w\u001ci\u0010C\u0004\u0003\u000e\u001a\u0002\rAa\u0019\t\u000f\tEe\u00051\u0001\u0002|!9!Q\u0013\u0014A\u0002\u0005m\u0014!E4fi\u001aKG\u000e^3s'R\u0014\u0018\r^3hsR1A1\u0001C\t\t'\u0001RA\u001bBi\t\u000b\u0001B\u0001b\u0002\u0005\f9!\u0011\u0011\u0019C\u0005\u0013\tyH,\u0003\u0003\u0005\u000e\u0011=!A\u0004$jYR,'o\u0015;sCR,w-\u001f\u0006\u0003\u007frCqa!5(\u0001\u0004\u0019)\u000eC\u0004\u0005\u0016\u001d\u0002\r\u0001b\u0006\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007#\u00026\u0003R\u0006-\u0013\u0001E4fiF+XM]=TiJ\fG/Z4z)!!i\u0002b\t\u0005&\u0011e\u0002\u0003\u0002C\u0004\t?IA\u0001\"\t\u0005\u0010\ti\u0011+^3ssN#(/\u0019;fOfDqa!5)\u0001\u0004!)\u0001C\u0004\u0005(!\u0002\r\u0001\"\u000b\u0002\u000b!Lg\u000e^:\u0011\t\u0011-BQG\u0007\u0003\t[QA\u0001b\f\u00052\u00059a-Y2u_JL(\u0002\u0002C\u001a\u00033\nA!\u001e;jY&!Aq\u0007C\u0017\u0005\u0015A\u0015N\u001c;t\u0011%!Y\u0004\u000bI\u0001\u0002\u0004!i$A\u0004fqBd\u0017-\u001b8\u0011\t\u0011}B1I\u0007\u0003\t\u0003R1!a*_\u0013\u0011!)\u0005\"\u0011\u0003\u0013\u0015C\b\u000f\\1j]\u0016\u0014\u0018AG4fiF+XM]=TiJ\fG/Z4zI\u0011,g-Y;mi\u0012\u001aTC\u0001C&U\u0011!id!#\u0002#\u001d,g.\u001a:bi\u0016$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0004\u0002f\u0011EC1\u000b\u0005\n\u0007\u007fR\u0003\u0013!a\u0001\u0007\u0003C\u0011ba)+!\u0003\u0005\ra!*\u00027\u001d,g.\u001a:bi\u0016$\u0016M\u00197f\u001d\u0006lW\r\n3fM\u0006,H\u000e\u001e\u00132\u0003m9WM\\3sCR,G+\u00192mK:\u000bW.\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005AAo\\*ue&tw\r\u0006\u0002\u0002f\u00051Q-];bYN$Baa\u0017\u0005b!9A1\r\u0018A\u0002\u0005\u0005\u0013!B8uQ\u0016\u0014\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005m\u0004")
public abstract class GeoMesaFeatureIndex<T, U>
implements package.NamedIndex,
LazyLogging {
    private IdFromRow idFromRow;
    private final GeoMesaDataStore<?> ds;
    private final SimpleFeatureType sft;
    private final String name;
    private final int version;
    private final Seq<String> attributes;
    private final IndexMode.IndexMode mode;
    private final String tableNameKey;
    private final String identifier;
    private final boolean serializedWithId;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes(SimpleFeatureType simpleFeatureType) {
        return GeoMesaFeatureIndex$.MODULE$.idFromBytes(simpleFeatureType);
    }

    public static Function1<String, byte[]> idToBytes(SimpleFeatureType simpleFeatureType) {
        return GeoMesaFeatureIndex$.MODULE$.idToBytes(simpleFeatureType);
    }

    public static String baseTableNameKey(String string, Seq<String> seq, int n) {
        return GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(string, seq, n);
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public GeoMesaDataStore<?> ds() {
        return this.ds;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Seq<String> attributes() {
        return this.attributes;
    }

    public IndexMode.IndexMode mode() {
        return this.mode;
    }

    public String tableNameKey() {
        return this.tableNameKey;
    }

    private IdFromRow idFromRow$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if (!this.bitmap$0) {
                this.idFromRow = GeoMesaFeatureIndex$IdFromRow$.MODULE$.apply(this.sft(), this.keySpace(), this.tieredKeySpace());
                this.bitmap$0 = true;
            }
        }
        return this.idFromRow;
    }

    public IdFromRow idFromRow() {
        if (!this.bitmap$0) {
            return this.idFromRow$lzycompute();
        }
        return this.idFromRow;
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean serializedWithId() {
        return this.serializedWithId;
    }

    public abstract IndexKeySpace<T, U> keySpace();

    public abstract Option<IndexKeySpace<?, ?>> tieredKeySpace();

    public String tableNameKey(Option<String> partition) {
        return (String)partition.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(this.tableNameKey()).append(".").append((String)p).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tableNameKey());
    }

    public Option<String> tableNameKey$default$1() {
        return None$.MODULE$;
    }

    public String configureTableName(Option<String> partition, Option<Object> limit) {
        String key = this.tableNameKey(partition);
        GeoMesaMetadata qual$1 = this.ds().metadata();
        String x$1 = this.sft().getTypeName();
        String x$2 = key;
        boolean x$3 = qual$1.read$default$3();
        return (String)qual$1.read(x$1, x$2, x$3).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String name = this.generateTableName(partition, limit);
            this.ds().metadata().insert(this.sft().getTypeName(), key, name);
            return name;
        });
    }

    public Option<String> configureTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> configureTableName$default$2() {
        return None$.MODULE$;
    }

    public Seq<String> deleteTableNames(Option<String> partition) {
        Seq<String> tables = this.getTableNames(partition);
        Option<String> option = partition;
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            this.ds().metadata().remove(this.sft().getTypeName(), new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString());
        } else if (None$.MODULE$.equals(option)) {
            this.ds().metadata().scan(this.sft().getTypeName(), this.tableNameKey(), false).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GeoMesaFeatureIndex.$anonfun$deleteTableNames$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            throw new MatchError(option);
        }
        return tables;
    }

    public Option<String> deleteTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<byte[]> getSplits(Option<String> partition) {
        Seq shards = GeoMesaFeatureIndex.nonEmpty$1(this.keySpace().sharding().shards());
        Seq splits = GeoMesaFeatureIndex.nonEmpty$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])TableSplitter$.MODULE$.getSplits(this.sft(), this.identifier(), partition)));
        Seq result = (Seq)shards.flatMap((Function1 & Serializable & scala.Serializable)shard -> (Seq)splits.map((Function1 & Serializable & scala.Serializable)split -> ByteArrays$.MODULE$.concat(shard, split), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)result.drop(1);
    }

    public Option<String> getSplits$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getPartitions() {
        if (!TablePartition$.MODULE$.partitioned(this.sft())) {
            return (Seq)Nil$.MODULE$;
        }
        int offset = this.tableNameKey().length() + 1;
        GeoMesaMetadata qual$1 = this.ds().metadata();
        String x$1 = this.sft().getTypeName();
        String x$2 = this.tableNameKey();
        boolean x$3 = qual$1.scan$default$3();
        return (Seq)qual$1.scan(x$1, x$2, x$3).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return k.substring(offset);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getTableNames(Option<String> partition) {
        Option<String> option = partition;
        if (None$.MODULE$.equals(option)) {
            GeoMesaMetadata qual$1 = this.ds().metadata();
            String x$12 = this.sft().getTypeName();
            String x$2 = this.tableNameKey();
            boolean x$3 = qual$1.scan$default$3();
            return (Seq)qual$1.scan(x$12, x$2, x$3).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Seq$.MODULE$.canBuildFrom());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            GeoMesaMetadata qual$2 = this.ds().metadata();
            String x$4 = this.sft().getTypeName();
            String x$5 = new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString();
            boolean x$6 = qual$2.read$default$3();
            return Option$.MODULE$.option2Iterable(qual$2.read(x$4, x$5, x$6)).toSeq();
        }
        throw new MatchError(option);
    }

    public Option<String> getTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getTablesForQuery(Option<Filter> filter) {
        Option partitioned = filter.flatMap((Function1 & Serializable & scala.Serializable)f -> TablePartition$.MODULE$.apply(this.ds(), this.sft()).flatMap((Function1 & Serializable & scala.Serializable)tp -> tp.partitions((Filter)f).map((Function1 & Serializable & scala.Serializable)partitions -> (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)p -> this.getTableNames((Option<String>)new Some(p)), Seq$.MODULE$.canBuildFrom()))));
        return (Seq)partitioned.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getTableNames((Option<String>)None$.MODULE$));
    }

    public WriteConverter<U> createConverter() {
        Option<IndexKeySpace<?, ?>> option = this.tieredKeySpace();
        if (None$.MODULE$.equals(option)) {
            return new WriteConverter.WriteConverterImpl<U>(this.keySpace());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexKeySpace tier = (IndexKeySpace)some.value();
            return new WriteConverter.TieredWriteConverter<U>(this.keySpace(), tier);
        }
        throw new MatchError(option);
    }

    public String getIdFromRow(byte[] row, int offset, int length, SimpleFeature feature) {
        return this.idFromRow().apply(row, offset, length, feature);
    }

    public int getIdOffset(byte[] row, int offset, int length) {
        return this.idFromRow().start(row, offset, length);
    }

    public abstract Option<package.FilterStrategy> getFilterStrategy(Filter var1, Option<SimpleFeatureType> var2);

    public package.QueryStrategy getQueryStrategy(package.FilterStrategy filter, Hints hints, Explainer explain) {
        byte[] sharing = this.keySpace().sharing();
        Option indexValues = filter.primary().map((Function1 & Serializable & scala.Serializable)x$2 -> this.keySpace().getIndexValues((Filter)x$2, explain));
        boolean useFullFilter = this.keySpace().useFullFilter(indexValues, (Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig>)new Some((Object)this.ds().config()), hints);
        Option<Filter> ecql = useFullFilter ? filter.filter() : filter.secondary();
        Option option = indexValues;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (filter.filter().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$2(x$3)))) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            }
            if (QueryHints$.MODULE$.RichHints(hints).getMaxFeatures().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.BlockMaxThreshold().toInt().get()))) {
                LazyRef filterString$lzy = new LazyRef();
                boolean block = BoxesRunTime.unboxToBoolean((Object)QueryProperties$.MODULE$.blockFullTableScansForFeatureType(this.sft().getTypeName()).orElse((Function0 & Serializable & scala.Serializable)() -> QueryProperties$.MODULE$.BlockFullTableScans().toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                if (block) {
                    throw new RuntimeException(new StringBuilder(57).append("Full-table scans are disabled. Query being stopped for ").append(this.sft().getTypeName()).append(": ").append(GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)).toString());
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Running full table scan for schema '{}' with filter: {}", new Object[]{this.sft().getTypeName(), GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Seq keyRanges = (Seq)new .colon.colon(new package.UnboundedRange<Object>(null), (List)Nil$.MODULE$);
            Seq byteRanges = (Seq)new .colon.colon((Object)new package.BoundedByteRange(sharing, ByteArrays$.MODULE$.rowFollowingPrefix(sharing)), (List)Nil$.MODULE$);
            return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object values = some.value();
            LazyRef tiers$lzy = new LazyRef();
            IndexKeySpace<Object, U> qual$1 = this.keySpace();
            Object x$1 = values;
            int x$22 = qual$1.getRanges$default$2();
            Seq keyRanges = qual$1.getRanges(x$1, x$22).toSeq();
            Seq bytes = this.keySpace().getRangeBytes(keyRanges.iterator(), this.tieredKeySpace().isDefined()).toSeq();
            IndexKeySpace tier = (IndexKeySpace)this.tieredKeySpace().orNull(Predef$.MODULE$.$conforms());
            Filter secondary = (Filter)filter.secondary().orNull(Predef$.MODULE$.$conforms());
            if (tier == null) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)bytes, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            }
            if (secondary == null || GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$8(x$6)))) {
                Seq byteRanges = this.keySpace().getRangeBytes(keyRanges.iterator(), true).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    package.ByteRange byteRange = x0$1;
                    if (byteRange instanceof package.BoundedByteRange) {
                        package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                        byte[] lo = boundedByteRange.lower();
                        byte[] hi = boundedByteRange.upper();
                        return new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.SingleRowByteRange) {
                        package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                        byte[] row = singleRowByteRange.row();
                        return new package.BoundedByteRange(row, ByteArrays$.MODULE$.concat(row, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.UpperBoundedByteRange) {
                        package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                        byte[] lo = upperBoundedByteRange.lower();
                        byte[] hi = upperBoundedByteRange.upper();
                        return new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.LowerBoundedByteRange) {
                        package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                        byte[] lo = lowerBoundedByteRange.lower();
                        byte[] hi = lowerBoundedByteRange.upper();
                        return new package.BoundedByteRange(lo, hi);
                    }
                    if (byteRange instanceof package.UnboundedByteRange) {
                        package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                        byte[] lo = unboundedByteRange.lower();
                        byte[] hi = unboundedByteRange.upper();
                        return new package.BoundedByteRange(lo, hi);
                    }
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
                }).toSeq();
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            }
            if (GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).isEmpty()) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Seq<package.ByteRange>)((Seq)Nil$.MODULE$), ecql, hints, indexValues);
            }
            LazyRef minTier$lzy = new LazyRef();
            LazyRef maxTier$lzy = new LazyRef();
            Seq byteRanges = (Seq)bytes.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                package.ByteRange byteRange = x0$2;
                if (byteRange instanceof package.SingleRowByteRange) {
                    package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                    byte[] row = singleRowByteRange.row();
                    return GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        package.ByteRange byteRange = x0$3;
                        if (byteRange instanceof package.BoundedByteRange) {
                            package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                            byte[] lo = boundedByteRange.lower();
                            byte[] hi = boundedByteRange.upper();
                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(row, lo), ByteArrays$.MODULE$.concat(row, hi));
                        }
                        if (byteRange instanceof package.SingleRowByteRange) {
                            package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                            byte[] trow = singleRowByteRange.row();
                            return new package.SingleRowByteRange(ByteArrays$.MODULE$.concat(row, trow));
                        }
                        throw new MatchError((Object)byteRange);
                    }, Seq$.MODULE$.canBuildFrom());
                }
                if (byteRange instanceof package.BoundedByteRange) {
                    package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                    byte[] lo = boundedByteRange.lower();
                    byte[] hi = boundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                }
                if (byteRange instanceof package.LowerBoundedByteRange) {
                    package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                    byte[] lo = lowerBoundedByteRange.lower();
                    byte[] hi = lowerBoundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), hi));
                }
                if (byteRange instanceof package.UpperBoundedByteRange) {
                    package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                    byte[] lo = upperBoundedByteRange.lower();
                    byte[] hi = upperBoundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                }
                if (byteRange instanceof package.UnboundedByteRange) {
                    package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                    byte[] lo = unboundedByteRange.lower();
                    byte[] hi = unboundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
            }, Seq$.MODULE$.canBuildFrom());
            return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain), ecql, hints, indexValues);
        }
        throw new MatchError((Object)option);
    }

    public Explainer getQueryStrategy$default$3() {
        return ExplainNull$.MODULE$;
    }

    public String generateTableName(Option<String> partition, Option<Object> limit) {
        String string = this.ds().config().catalog();
        String prefix = ((TraversableOnce)((SeqLike)((TraversableLike)new .colon.colon((Object)this.sft().getTypeName(), (List)new .colon.colon((Object)this.name(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).mkString("_");
        String suffix = new StringBuilder(1).append("v").append(this.version()).append(partition.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append("_").append((String)p).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        String full = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable & scala.Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input), Seq$.MODULE$.canBuildFrom()), prefix, suffix);
        Option<Object> option = limit;
        if (option instanceof Some) {
            Some some = (Some)option;
            int lim = BoxesRunTime.unboxToInt((Object)some.value());
            if (new StringOps(Predef$.MODULE$.augmentString(full)).lengthCompare(lim) > 0) {
                BoxedUnit boxedUnit;
                String nums = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable & scala.Serializable)a -> String.valueOf(BoxesRunTime.boxToInteger((int)this.sft().indexOf(a))), Seq$.MODULE$.canBuildFrom()), prefix, suffix);
                if (new StringOps(Predef$.MODULE$.augmentString(nums)).lengthCompare(lim) <= 0) {
                    return nums;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Table name length exceeds configured limit ({}), falling back to UUID: {}", new Object[]{BoxesRunTime.boxToInteger((int)lim), full});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return IndexAdapter$.MODULE$.truncateTableName(full, lim);
            }
        }
        return full;
    }

    public Option<String> generateTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> generateTableName$default$2() {
        return None$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(0).append(this.getClass().getSimpleName()).append(this.attributes().mkString("(", ",", ")")).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof GeoMesaFeatureIndex)) return false;
        GeoMesaFeatureIndex geoMesaFeatureIndex = (GeoMesaFeatureIndex)object;
        String string = this.identifier();
        String string2 = geoMesaFeatureIndex.identifier();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        IndexMode.IndexMode indexMode = this.mode();
        IndexMode.IndexMode indexMode2 = geoMesaFeatureIndex.mode();
        if (indexMode == null) {
            if (indexMode2 != null) {
                return false;
            }
        } else if (!indexMode.equals(indexMode2)) return false;
        GeoMesaDataStore<?> geoMesaDataStore = this.ds();
        GeoMesaDataStore<?> geoMesaDataStore2 = geoMesaFeatureIndex.ds();
        if (geoMesaDataStore == null) {
            if (geoMesaDataStore2 != null) {
                return false;
            }
        } else if (!geoMesaDataStore.equals(geoMesaDataStore2)) return false;
        SimpleFeatureType simpleFeatureType = this.sft();
        SimpleFeatureType simpleFeatureType2 = geoMesaFeatureIndex.sft();
        if (simpleFeatureType == null) {
            if (simpleFeatureType2 == null) return true;
            return false;
        } else {
            if (!simpleFeatureType.equals(simpleFeatureType2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)new .colon.colon((Object)this.identifier(), (List)new .colon.colon(this.ds(), (List)new .colon.colon((Object)this.sft(), (List)new .colon.colon((Object)this.mode(), (List)Nil$.MODULE$))))).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    return (B1)BoxesRunTime.boxToInteger((int)A1.hashCode());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object != null;
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ void $anonfun$deleteTableNames$1(GeoMesaFeatureIndex $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            $this.ds().metadata().remove($this.sft().getTypeName(), k);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Seq nonEmpty$1(Seq bytes) {
        if (bytes.nonEmpty()) {
            return bytes;
        }
        return (Seq)new .colon.colon((Object)((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$2(Filter x$3) {
        return x$3 instanceof ExcludeFilter;
    }

    private static final /* synthetic */ String filterString$lzycompute$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        String string;
        LazyRef lazyRef = filterString$lzy$1;
        synchronized (lazyRef) {
            string = filterString$lzy$1.initialized() ? (String)filterString$lzy$1.value() : (String)filterString$lzy$1.initialize((Object)org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter$1.filter().getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE)));
        }
        return string;
    }

    private static final String filterString$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        if (filterString$lzy$1.initialized()) {
            return (String)filterString$lzy$1.value();
        }
        return GeoMesaFeatureIndex.filterString$lzycompute$1(filterString$lzy$1, filter$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$7(package.ByteRange x$5) {
        return x$5 instanceof package.SingleRowByteRange;
    }

    private static final /* synthetic */ Seq tiers$lzycompute$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        Seq seq;
        LazyRef lazyRef = tiers$lzy$1;
        synchronized (lazyRef) {
            Seq seq2;
            if (tiers$lzy$1.initialized()) {
                seq2 = (Seq)tiers$lzy$1.value();
            } else {
                int multiplier = scala.math.package$.MODULE$.max(1, bytes$1.count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$7(x$5))));
                seq2 = (Seq)tiers$lzy$1.initialize((Object)tier$1.getRangeBytes(tier$1.getRanges(tier$1.getIndexValues(secondary$1, explain$1), multiplier), tier$1.getRangeBytes$default$2()).toSeq());
            }
            seq = seq2;
        }
        return seq;
    }

    private static final Seq tiers$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (tiers$lzy$1.initialized()) {
            return (Seq)tiers$lzy$1.value();
        }
        return GeoMesaFeatureIndex.tiers$lzycompute$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$8(package.ByteRange x$6) {
        return x$6 instanceof package.UnboundedByteRange;
    }

    private static final /* synthetic */ byte[] minTier$lzycompute$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = minTier$lzy$1;
        synchronized (lazyRef) {
            byArray = minTier$lzy$1.initialized() ? (byte[])minTier$lzy$1.value() : (byte[])minTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.min((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] minTier$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (minTier$lzy$1.initialized()) {
            return (byte[])minTier$lzy$1.value();
        }
        return GeoMesaFeatureIndex.minTier$lzycompute$1(minTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final /* synthetic */ byte[] maxTier$lzycompute$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = maxTier$lzy$1;
        synchronized (lazyRef) {
            byArray = maxTier$lzy$1.initialized() ? (byte[])maxTier$lzy$1.value() : (byte[])maxTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.max((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] maxTier$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (maxTier$lzy$1.initialized()) {
            return (byte[])maxTier$lzy$1.value();
        }
        return GeoMesaFeatureIndex.maxTier$lzycompute$1(maxTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final String build$1(Seq attrs, String prefix$1, String suffix$1) {
        String string = prefix$1;
        return ((TraversableOnce)((SeqLike)attrs.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)suffix$1, Seq$.MODULE$.canBuildFrom())).mkString("_");
    }

    public GeoMesaFeatureIndex(GeoMesaDataStore<?> ds, SimpleFeatureType sft, String name, int version, Seq<String> attributes2, IndexMode.IndexMode mode) {
        this.ds = ds;
        this.sft = sft;
        this.name = name;
        this.version = version;
        this.attributes = attributes2;
        this.mode = mode;
        LazyLogging.$init$((LazyLogging)this);
        this.tableNameKey = GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(name, attributes2, version);
        this.identifier = GeoMesaFeatureIndex$.MODULE$.identifier(name, version, attributes2);
        this.serializedWithId = false;
    }

    public static interface IdFromRow {
        public String apply(byte[] var1, int var2, int var3, SimpleFeature var4);

        public int start(byte[] var1, int var2, int var3);
    }
}

