/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import org.locationtech.geomesa.index.api.WritableFeature;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%caB\u0013'!\u0003\r\n!\r\u0005\u0006q\u00011\t!\u000f\u0005\u0006\r\u00021\ta\u0012\u0005\u0006)\u00021\t!V\u0004\u00063\u001aB\tA\u0017\u0004\u0006K\u0019B\ta\u0017\u0005\u00069\u0016!\t!\u0018\u0005\b=\u0016\u0011\r\u0011\"\u0003`\u0011\u0019IX\u0001)A\u0005A\")\u0001(\u0002C\u0001u\u001e)Q0\u0002E\u0001}\u001a1q0\u0002E\u0001\u0003\u0003Aa\u0001X\u0006\u0005\u0002\u0005\r\u0001B\u0002\u001d\f\t\u0003\n)\u0001C\u0004G\u0017\t\u0007I\u0011I$\t\rM\\\u0001\u0015!\u0003I\u0011\u001d!6B1A\u0005BUCa\u0001_\u0006!\u0002\u00131vaBA\u0005\u000b!\u0005\u00111\u0002\u0004\b\u0003\u001b)\u0001\u0012AA\b\u0011\u0019a6\u0003\"\u0001\u0002\u0012!1\u0001h\u0005C\u0001\u0003'9q!!\f\u0006\u0011\u0003\tyCB\u0004\u00022\u0015A\t!a\r\t\rq;B\u0011AA\u001b\u0011\u0019At\u0003\"\u0001\u00028\u001d9\u00111H\u0003\t\u0002\u0005ubaBA \u000b!\u0005\u0011\u0011\t\u0005\u00079n!\t!a\u0011\t\raZB\u0011AA#\r\u0011aW\u0001A7\t\u0011\u0019s\"Q1A\u0005B=D\u0001b\u001d\u0010\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u00069z!\t\u0001\u001e\u0005\u0006qy!\tE\u001e\u0005\b)z\u0011\r\u0011\"\u0011V\u0011\u0019Ah\u0004)A\u0005-\ni1\u000b[1sIN#(/\u0019;fOfT!a\n\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002*U\u0005)\u0011N\u001c3fq*\u00111\u0006L\u0001\bO\u0016|W.Z:b\u0015\tic&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VMZ\u0001\u0006CB\u0004H.\u001f\u000b\u0003u\u0001\u00032aM\u001e>\u0013\taDGA\u0003BeJ\f\u0017\u0010\u0005\u00024}%\u0011q\b\u000e\u0002\u0005\u0005f$X\rC\u0003B\u0003\u0001\u0007!)A\u0004gK\u0006$XO]3\u0011\u0005\r#U\"\u0001\u0014\n\u0005\u00153#aD,sSR\f'\r\\3GK\u0006$XO]3\u0002\rMD\u0017M\u001d3t+\u0005A\u0005cA%Ru9\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bB\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005A#\u0014a\u00029bG.\fw-Z\u0005\u0003%N\u00131aU3r\u0015\t\u0001F'\u0001\u0004mK:<G\u000f[\u000b\u0002-B\u00111gV\u0005\u00031R\u00121!\u00138u\u00035\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hsB\u00111)B\n\u0003\u000bI\na\u0001P5oSRtD#\u0001.\u0002\u0013%t7\u000f^1oG\u0016\u001cX#\u00011\u0011\t\u0005DgK[\u0007\u0002E*\u00111\rZ\u0001\u000bG>t7-\u001e:sK:$(BA3g\u0003\u0011)H/\u001b7\u000b\u0003\u001d\fAA[1wC&\u0011\u0011N\u0019\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA6\u001f\u001b\u0005)!!E*iCJ$7\u000b\u001e:bi\u0016<\u00170S7qYN\u0019aD\r8\u0011\u0005\r\u0003Q#\u00019\u0011\u0007%\u000b((\u0003\u0002s'\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u000fMD\u0017M\u001d3tAQ\u0011!.\u001e\u0005\u0006\r\u0006\u0002\r\u0001\u001d\u000b\u0003u]DQ!\u0011\u0012A\u0002\t\u000bq\u0001\\3oORD\u0007%\u0001\u0006j]N$\u0018M\\2fg\u0002\"\"A\\>\t\u000bqL\u0001\u0019\u0001,\u0002\u000b\r|WO\u001c;\u0002\u001f9{7\u000b[1sIN#(/\u0019;fOf\u0004\"a[\u0006\u0003\u001f9{7\u000b[1sIN#(/\u0019;fOf\u001c2a\u0003\u001ao)\u0005qHc\u0001\u001e\u0002\b!)\u0011)\u0004a\u0001\u0005\u0006y!LM*iCJ$7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002l'\ty!LM*iCJ$7\u000b\u001e:bi\u0016<\u0017p\u0005\u0002\u0014eQ\u0011\u00111\u0002\u000b\u0004]\u0006U\u0001bBA\f+\u0001\u0007\u0011\u0011D\u0001\u0004g\u001a$\b\u0003BA\u000e\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007\u0005\u000b\u0019CC\u0002(\u0003KQ1!a\n/\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BA\u0016\u0003;\u0011\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0003=Q6g\u00155be\u0012\u001cFO]1uK\u001eL\bCA6\u0018\u0005=Q6g\u00155be\u0012\u001cFO]1uK\u001eL8CA\f3)\t\ty\u0003F\u0002o\u0003sAq!a\u0006\u001a\u0001\u0004\tI\"\u0001\fBiR\u0014\u0018NY;uKNC\u0017M\u001d3TiJ\fG/Z4z!\tY7D\u0001\fBiR\u0014\u0018NY;uKNC\u0017M\u001d3TiJ\fG/Z4z'\tY\"\u0007\u0006\u0002\u0002>Q\u0019a.a\u0012\t\u000f\u0005]Q\u00041\u0001\u0002\u001a\u0001")
public interface ShardStrategy {
    public byte[] apply(WritableFeature var1);

    public Seq<byte[]> shards();

    public int length();

    public static class ShardStrategyImpl
    implements ShardStrategy {
        private final IndexedSeq<byte[]> shards;
        private final int length;

        public IndexedSeq<byte[]> shards() {
            return this.shards;
        }

        @Override
        public byte[] apply(WritableFeature feature) {
            byte[] byArray;
            try {
                byArray = (byte[])this.shards().apply(feature.idHash() % this.shards().length());
            }
            catch (IndexOutOfBoundsException e) {
                byArray = (byte[])this.shards().head();
            }
            return byArray;
        }

        @Override
        public int length() {
            return this.length;
        }

        public ShardStrategyImpl(IndexedSeq<byte[]> shards) {
            this.shards = shards;
            this.length = ((byte[])shards.head()).length;
        }
    }
}

