/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.conf.partition;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartitionFactory;
import org.locationtech.geomesa.index.conf.partition.TimePartition$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0017/\u0001mB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\f\u0001B\u0001B\u0003%A\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\"B8\u0001\t\u0003\u0001\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003z\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0005\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA\u000b\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+Aaa\f\u0001\u0005B\t\u0005\u0002bBAf\u0001\u0011\u0005#1\u0006\u0005\b\u0005\u0007\u0002A\u0011\tB#\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017:q!!\n/\u0011\u0003\t9C\u0002\u0004.]!\u0005\u0011\u0011\u0006\u0005\u0007_N!\t!a\u000b\t\u0013\u000552C1A\u0005\u0002\u0005=\u0002\u0002CA '\u0001\u0006I!!\r\t\u0013\u0005\u00053C1A\u0005\n\u0005=\u0002\u0002CA\"'\u0001\u0006I!!\r\t\u0013\u0005E1C1A\u0005\n\u0005\u0015\u0003\u0002CA4'\u0001\u0006I!a\u0012\u0007\r\u0005%4\u0003AA6\u0011\u0019y7\u0004\"\u0001\u0002t!9\u0011\u0011P\u000e\u0005B\u0005m\u0004bBA?7\u0011\u0005\u0013q\u0010\u0004\u0007\u0003g\u001bB!!.\t\u0011\u0019{\"\u0011!Q\u0001\n\u001dC\u0001bV\u0010\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0007_~!\t!a.\t\u0013\u0005}vD1A\u0005\n\u0005\u0005\u0007\u0002CAe?\u0001\u0006I!a1\t\u0017\u0005-w\u00041AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003c|\u0002\u0019!a\u0001\n\u0013\t\u0019\u0010C\u0006\u0002\u0000~\u0001\r\u0011!Q!\n\u0005=\u0007\"\u0003B\u0001?\u0001\u0007I\u0011BAa\u0011%\u0011\u0019a\ba\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\n}\u0001\u000b\u0015BAb\u0011\u001d\u0011Ya\bC\u0001\u0005\u001bAqAa\u0004 \t\u0003\u0011\tBA\u0007US6,\u0007+\u0019:uSRLwN\u001c\u0006\u0003_A\n\u0011\u0002]1si&$\u0018n\u001c8\u000b\u0005E\u0012\u0014\u0001B2p]\u001aT!a\r\u001b\u0002\u000b%tG-\u001a=\u000b\u0005U2\u0014aB4f_6,7/\u0019\u0006\u0003oa\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011!O\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\t6\ta&\u0003\u0002F]\tqA+\u00192mKB\u000b'\u000f^5uS>t\u0017\u0001C7fi\u0006$\u0017\r^1\u0011\u0007!SE*D\u0001J\u0015\t1%'\u0003\u0002L\u0013\nyq)Z8NKN\fW*\u001a;bI\u0006$\u0018\r\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fzj\u0011\u0001\u0015\u0006\u0003#j\na\u0001\u0010:p_Rt\u0014BA*?\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ms\u0014\u0001\u0003;za\u0016t\u0015-\\3\u0002\u0007\u0011$x-\u0001\u0005ei\u001eLe\u000eZ3y!\ti4,\u0003\u0002]}\t\u0019\u0011J\u001c;\u0002\rA,'/[8e!\tyFN\u0004\u0002aS:\u0011\u0011m\u001a\b\u0003E\u001at!aY3\u000f\u0005=#\u0017\"A\u001d\n\u0005]B\u0014BA\u001b7\u0013\tAG'A\u0003dkJ4X-\u0003\u0002kW\u0006QA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005!$\u0014BA7o\u0005)!\u0016.\\3QKJLw\u000e\u001a\u0006\u0003U.\fa\u0001P5oSRtDCB9sgR,h\u000f\u0005\u0002D\u0001!)aI\u0002a\u0001\u000f\")qK\u0002a\u0001\u0019\")\u0001L\u0002a\u0001\u0019\")\u0011L\u0002a\u00015\")QL\u0002a\u0001=\u0006)Ao\u001c\"j]V\t\u0011\u0010\u0005\u0002{}:\u00111\u0010`\u0007\u0002W&\u0011Qp[\u0001\u000b\u0005&tg.\u001a3US6,\u0017bA@\u0002\u0002\tIA)\u0019;f)>\u0014\u0015N\u001c\u0006\u0003{.\fa\u0001^8CS:\u0004\u0013A\u0002;p\t\u0006$X-\u0006\u0002\u0002\nA\u0019!0a\u0003\n\t\u00055\u0011\u0011\u0001\u0002\u0011\u0005&tg.\u001a3US6,Gk\u001c#bi\u0016\fq\u0001^8ECR,\u0007%A\u0003dC\u000eDW-\u0006\u0002\u0002\u0016A\u0019\u0011qC\u0010\u000f\u0007\u0005e!C\u0004\u0003\u0002\u001c\u0005\rb\u0002BA\u000f\u0003Cq1!YA\u0010\u0013\t\u0019D'\u0003\u00022e%\u0011q\u0006M\u0001\u000e)&lW\rU1si&$\u0018n\u001c8\u0011\u0005\r\u001b2CA\n=)\t\t9#\u0001\u0003OC6,WCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u00111H\u0001\u0005U\u00064\u0018-C\u0002V\u0003k\tQAT1nK\u0002\n!\u0003U1si&$\u0018n\u001c8LKf\u0004&/\u001a4jq\u0006\u0019\u0002+\u0019:uSRLwN\\&fsB\u0013XMZ5yAU\u0011\u0011q\t\t\b\u0003\u0013\ni&!\u0019C\u001b\t\tYE\u0003\u0003\u0002\u0012\u00055#\u0002BA(\u0003#\n\u0001bY1gM\u0016Lg.\u001a\u0006\u0005\u0003'\n)&\u0001\u0005cK:l\u0017M\\3t\u0015\u0011\t9&!\u0017\u0002\r\u001dLG\u000f[;c\u0015\t\tY&A\u0002d_6LA!a\u0018\u0002L\taAj\\1eS:<7)Y2iKBAQ(a\u0019H\u00192Sf,C\u0002\u0002fy\u0012a\u0001V;qY\u0016,\u0014AB2bG\",\u0007E\u0001\u000bUS6,\u0007+\u0019:uSRLwN\u001c$bGR|'/_\n\u00057q\ni\u0007E\u0002D\u0003_J1!!\u001d/\u0005U!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:4\u0015m\u0019;pef$\"!!\u001e\u0011\u0007\u0005]4$D\u0001\u0014\u0003\u0011q\u0017-\\3\u0016\u00031\u000baa\u0019:fCR,G#\u0002\"\u0002\u0002\u0006]\u0005bBAB=\u0001\u0007\u0011QQ\u0001\u0003IN\u0004R!a\"\u0002\u00122sA!!#\u0002\u000e:!\u0011QDAF\u0013\t1%'C\u0002\u0002\u0010&\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0006U%A\u0005%bg\u001e+w.T3tC6+G/\u00193bi\u0006T1!a$J\u0011\u001d\tIJ\ba\u0001\u00037\u000b1a\u001d4u!\u0011\ti*a,\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000baa]5na2,'\u0002BAS\u0003O\u000bqAZ3biV\u0014XM\u0003\u0003\u0002*\u0006-\u0016aA1qS*\u0019\u0011Q\u0016\u001d\u0002\u0011\u001d,w\u000e^8pYNLA!!-\u0002 \n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0003)\r+8\u000f^8n!\u0006\u0014H/\u001b;j_:\u001c\u0015m\u00195f'\tyB\b\u0006\u0004\u0002:\u0006m\u0016Q\u0018\t\u0004\u0003oz\u0002\"\u0002$#\u0001\u00049\u0005\"B,#\u0001\u0004a\u0015AB3ya&\u0014\u00180\u0006\u0002\u0002DB\u0019Q(!2\n\u0007\u0005\u001dgH\u0001\u0003M_:<\u0017aB3ya&\u0014\u0018\u0010I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cXCAAh!\u0019\t\t.!7\u0002`:!\u00111[Al\u001d\ry\u0015Q[\u0005\u0002\u007f%\u0019\u0011q\u0012 \n\t\u0005m\u0017Q\u001c\u0002\u0004'\u0016\f(bAAH}AAQ(!9M\u0003K\f)/C\u0002\u0002dz\u0012a\u0001V;qY\u0016\u001c\u0004\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u0018\u0011H\u0001\u0005i&lW-\u0003\u0003\u0002p\u0006%(!\u0004.p]\u0016$G)\u0019;f)&lW-\u0001\bqCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u0005U\u00181 \t\u0004{\u0005]\u0018bAA}}\t!QK\\5u\u0011%\tiPJA\u0001\u0002\u0004\ty-A\u0002yIE\n1\u0002]1si&$\u0018n\u001c8tA\u00051!/\u001a7pC\u0012\f!B]3m_\u0006$w\fJ3r)\u0011\t)Pa\u0002\t\u0013\u0005u\u0018&!AA\u0002\u0005\r\u0017a\u0002:fY>\fG\rI\u0001\u0011GV\u001cHo\\7QCJ$\u0018\u000e^5p]N$\"!a4\u0002\u0015%tg/\u00197jI\u0006$X\r\u0006\u0002\u0002v\u0006A!/Z4jgR,'\u000f\u0006\u0005\u0002v\n]!\u0011\u0004B\u000f\u0011\u0015yS\u00021\u0001M\u0011\u001d\u0011Y\"\u0004a\u0001\u0003K\fQa\u001d;beRDqAa\b\u000e\u0001\u0004\t)/A\u0002f]\u0012$2\u0001\u0014B\u0012\u0011\u001d\t)K\u0004a\u0001\u0005K\u0001B!!(\u0003(%!!\u0011FAP\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKR!!Q\u0006B\u001b!\u0015i$q\u0006B\u001a\u0013\r\u0011\tD\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0005E\u0017\u0011\u001c'\t\u000f\t]r\u00021\u0001\u0003:\u00051a-\u001b7uKJ\u0004BAa\u000f\u0003@5\u0011!Q\b\u0006\u0005\u0005o\t9+\u0003\u0003\u0003B\tu\"A\u0002$jYR,'/A\u0004sK\u000e|g/\u001a:\u0015\u0007q\u00129\u0005C\u00030!\u0001\u0007A*\u0001\u0005pm\u0016\u0014H.\u00199t)!\u0011iEa\u0015\u0003h\t%\u0004cA\u001f\u0003P%\u0019!\u0011\u000b \u0003\u000f\t{w\u000e\\3b]\"9!QK\tA\u0002\t]\u0013!C5oi\u0016\u0014h/\u00197t!\u0019\u0011IF!\u0018\u0003b5\u0011!1\f\u0006\u0004\u0005o!\u0014\u0002\u0002B0\u00057\u0012ABR5mi\u0016\u0014h+\u00197vKN\u0004bA!\u0017\u0003d\u0005\u0015\u0018\u0002\u0002B3\u00057\u0012aAQ8v]\u0012\u001c\bb\u0002B\u000e#\u0001\u0007\u0011Q\u001d\u0005\b\u0005?\t\u0002\u0019AAs\u0001")
public class TimePartition
implements TablePartition {
    private final GeoMesaMetadata<String> metadata;
    private final String typeName;
    private final String dtg;
    private final int dtgIndex;
    private final Function1<ZonedDateTime, Object> toBin;
    private final Function1<BinnedTime, ZonedDateTime> toDate;
    private final CustomPartitionCache cache;

    public static String Name() {
        return TimePartition$.MODULE$.Name();
    }

    private Function1<ZonedDateTime, Object> toBin() {
        return this.toBin;
    }

    private Function1<BinnedTime, ZonedDateTime> toDate() {
        return this.toDate;
    }

    private CustomPartitionCache cache() {
        return this.cache;
    }

    public void register(String partition, ZonedDateTime start, ZonedDateTime end) {
        String dates = new StringBuilder(1).append(DateParsing$.MODULE$.format(start, DateParsing$.MODULE$.format$default$2())).append("/").append(DateParsing$.MODULE$.format(end, DateParsing$.MODULE$.format$default$2())).toString();
        this.metadata.insert(this.typeName, new StringBuilder(0).append(TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix()).append(partition).toString(), dates);
        this.cache().invalidate();
    }

    @Override
    public String partition(SimpleFeature feature) {
        Date date = (Date)feature.getAttribute(this.dtgIndex);
        short arg$macro$1 = BoxesRunTime.unboxToShort((Object)this.toBin().apply((Object)ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(date), ZoneOffset.UTC)));
        return new StringOps("%05d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)arg$macro$1)}));
    }

    @Override
    public Option<Seq<String>> partitions(Filter filter) {
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(filter, this.dtg, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
        if (intervals.disjoint()) {
            return new Some((Object)Nil$.MODULE$);
        }
        if (intervals.isEmpty() || !intervals.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isBoundedBothSides()))) {
            return None$.MODULE$;
        }
        Seq bins = (Seq)intervals.values().flatMap((Function1 & Serializable & scala.Serializable)i -> package$.MODULE$.Range().inclusive((int)BoxesRunTime.unboxToShort((Object)this.toBin().apply(i.lower().value().get())), (int)BoxesRunTime.unboxToShort((Object)this.toBin().apply(i.upper().value().get()))), Seq$.MODULE$.canBuildFrom());
        Seq names = (Seq)((TraversableLike)((TraversableLike)bins.distinct()).map((Function1 & Serializable & scala.Serializable)b -> TimePartition.$anonfun$partitions$3(BoxesRunTime.unboxToInt((Object)b)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.cache().customPartitions().collect((PartialFunction)new scala.Serializable(this, intervals){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimePartition $outer;
            private final FilterValues intervals$1;

            public final <A1 extends Tuple3<String, ZonedDateTime, ZonedDateTime>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    ZonedDateTime end;
                    String p = (String)A1._1();
                    ZonedDateTime start = (ZonedDateTime)A1._2();
                    if (this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start, end = (ZonedDateTime)A1._3())) {
                        return (B1)p;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple3<String, ZonedDateTime, ZonedDateTime> x1) {
                ZonedDateTime end;
                ZonedDateTime start;
                Tuple3<String, ZonedDateTime, ZonedDateTime> tuple3 = x1;
                return tuple3 != null && this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start = (ZonedDateTime)tuple3._2(), end = (ZonedDateTime)tuple3._3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.intervals$1 = intervals$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return new Some((Object)names);
    }

    @Override
    public Object recover(String partition) {
        return new Date(((ChronoZonedDateTime)this.toDate().apply((Object)new BinnedTime(new StringOps(Predef$.MODULE$.augmentString(partition)).toShort(), 0L))).toInstant().toEpochMilli());
    }

    public boolean org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps(FilterValues<Bounds<ZonedDateTime>> intervals, ZonedDateTime start, ZonedDateTime end) {
        return intervals.exists((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)TimePartition.$anonfun$overlaps$1(end, start, i)));
    }

    public static final /* synthetic */ String $anonfun$partitions$3(int b) {
        int arg$macro$1 = b;
        return new StringOps("%05d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    public static final /* synthetic */ boolean $anonfun$overlaps$1(ZonedDateTime end$1, ZonedDateTime start$1, Bounds i) {
        return i.lower().value().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isBefore(end$1))) && i.upper().value().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isAfter(start$1)));
    }

    public TimePartition(GeoMesaMetadata<String> metadata, String typeName, String dtg, int dtgIndex, Enumeration.Value period) {
        this.metadata = metadata;
        this.typeName = typeName;
        this.dtg = dtg;
        this.dtgIndex = dtgIndex;
        this.toBin = BinnedTime$.MODULE$.dateToBin(period);
        this.toDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.cache = new CustomPartitionCache(metadata, typeName);
    }

    private static class CustomPartitionCache {
        private final GeoMesaMetadata<String> metadata;
        private final String typeName;
        private final long expiry;
        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions;
        private long reload;

        private long expiry() {
            return this.expiry;
        }

        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions() {
            return this.partitions;
        }

        private void partitions_$eq(Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> x$1) {
            this.partitions = x$1;
        }

        private long reload() {
            return this.reload;
        }

        private void reload_$eq(long x$1) {
            this.reload = x$1;
        }

        public Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> customPartitions() {
            if (System.currentTimeMillis() < this.reload()) {
                return this.partitions();
            }
            this.reload_$eq(System.currentTimeMillis() + this.expiry());
            this.partitions_$eq((Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>>)((Seq)this.metadata.scan(this.typeName, TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix(), this.metadata.scan$default$3()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ZonedDateTime[] zonedDateTimeArray = (ZonedDateTime[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v.split("/"))).map((Function1 & Serializable & scala.Serializable)x$4 -> DateParsing$.MODULE$.parse(x$4, DateParsing$.MODULE$.parse$default$2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ZonedDateTime.class)));
                    Option option = Array$.MODULE$.unapplySeq((Object)zonedDateTimeArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)zonedDateTimeArray);
                    }
                    ZonedDateTime start = (ZonedDateTime)((SeqLike)option.get()).apply(0);
                    ZonedDateTime end = (ZonedDateTime)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
                    ZonedDateTime start2 = (ZonedDateTime)tuple22._1();
                    ZonedDateTime end2 = (ZonedDateTime)tuple22._2();
                    return new Tuple3((Object)k.substring(TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix().length()), (Object)start2, (Object)end2);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())));
            return this.partitions();
        }

        public void invalidate() {
            this.reload_$eq(0L);
        }

        public CustomPartitionCache(GeoMesaMetadata<String> metadata, String typeName) {
            this.metadata = metadata;
            this.typeName = typeName;
            this.expiry = ((Duration)TableBasedMetadata$.MODULE$.Expiry().toDuration().get()).toMillis();
            this.reload = 0L;
        }
    }

    public static class TimePartitionFactory
    implements TablePartitionFactory {
        @Override
        public String name() {
            return TimePartition$.MODULE$.Name();
        }

        @Override
        public TablePartition create(package.HasGeoMesaMetadata<String> ds, SimpleFeatureType sft) {
            String dtg = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Can't use time partitioning without a date field");
            });
            return (TablePartition)TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$cache().get((Object)new Tuple5(ds.metadata(), (Object)sft.getTypeName(), (Object)dtg, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).get(), (Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
        }
    }
}

