/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.Z3Filter;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.utils.conf.GeoMesaProperties$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.ShortRef;
import scala.runtime.java8.JFunction0;

public final class Z3Filter$
implements RowFilter.RowFilterFactory<Z3Filter> {
    public static Z3Filter$ MODULE$;
    private final String RangeSeparator;
    private final String TermSeparator;
    private final String EpochSeparator;
    private final String XYKey;
    private final String TKey;
    private final String EpochKey;
    private final String VersionKey;

    static {
        new Z3Filter$();
    }

    private String RangeSeparator() {
        return this.RangeSeparator;
    }

    private String TermSeparator() {
        return this.TermSeparator;
    }

    private String EpochSeparator() {
        return this.EpochSeparator;
    }

    public String XYKey() {
        return this.XYKey;
    }

    public String TKey() {
        return this.TKey;
    }

    public String EpochKey() {
        return this.EpochKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public Z3Filter apply(package.Z3IndexValues values) {
        package.Z3IndexValues z3IndexValues = values;
        if (z3IndexValues == null) {
            throw new MatchError((Object)z3IndexValues);
        }
        Z3SFC sfc = z3IndexValues.sfc();
        Seq<Tuple4<Object, Object, Object, Object>> spatialBounds = z3IndexValues.spatialBounds();
        scala.collection.immutable.Map<Object, Seq<Tuple2<Object, Object>>> temporalBounds = z3IndexValues.temporalBounds();
        Tuple3 tuple3 = new Tuple3((Object)sfc, spatialBounds, temporalBounds);
        Z3SFC sfc2 = (Z3SFC)tuple3._1();
        Seq spatialBounds2 = (Seq)tuple3._2();
        scala.collection.immutable.Map temporalBounds2 = (scala.collection.immutable.Map)tuple3._3();
        int[][] xy = (int[][])((TraversableOnce)spatialBounds2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new int[]{sfc2.lon().normalize(xmin), sfc2.lat().normalize(ymin), sfc2.lon().normalize(xmax), sfc2.lat().normalize(ymax)};
            }
            throw new MatchError((Object)tuple4);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        Seq wholePeriod = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp((long)sfc2.time().min(), (long)sfc2.time().max()), (List)Nil$.MODULE$);
        ShortRef minEpoch = ShortRef.create((short)Short.MAX_VALUE);
        ShortRef maxEpoch = ShortRef.create((short)Short.MIN_VALUE);
        Seq epochsAndTimes = (Seq)((TraversableLike)((SeqLike)temporalBounds2.toSeq().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Z3Filter$.$anonfun$apply$2(wholePeriod, x$3)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToShort((short)Z3Filter$.$anonfun$apply$3(x$4)), (Ordering)Ordering.Short$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short epoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq times = (Seq)tuple2._2();
                if (epoch < minEpoch$1.elem) {
                    minEpoch$1.elem = epoch;
                }
                if (epoch > maxEpoch$1.elem) {
                    maxEpoch$1.elem = epoch;
                }
                return new Tuple2((Object)BoxesRunTime.boxToShort((short)epoch), ((TraversableOnce)times.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        long t1 = tuple2._1$mcJ$sp();
                        long t2 = tuple2._2$mcJ$sp();
                        return new int[]{sfc2.time().normalize((double)t1), sfc2.time().normalize((double)t2)};
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        int[][][] t = minEpoch.elem == Short.MAX_VALUE && maxEpoch.elem == Short.MIN_VALUE ? (int[][][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))) : (int[][][])Array$.MODULE$.ofDim(maxEpoch.elem - minEpoch.elem + 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        epochsAndTimes.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Z3Filter$.$anonfun$apply$6(t, minEpoch, x0$4);
            return BoxedUnit.UNIT;
        });
        return new Z3Filter(xy, t, minEpoch.elem, maxEpoch.elem);
    }

    @Override
    public byte[] serializeToBytes(Z3Filter filter) {
        int xyLength = 4 + filter.xy().length * 16;
        int tLength = 4 + BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).map((Function1 & Serializable & scala.Serializable)bounds -> BoxesRunTime.boxToInteger((int)Z3Filter$.$anonfun$serializeToBytes$1(bounds)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer buffer = ByteBuffer.allocate(xyLength + tLength + 4);
        buffer.putInt(filter.xy().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            Z3Filter$.$anonfun$serializeToBytes$2(buffer, bounds);
            return BoxedUnit.UNIT;
        });
        buffer.putInt(filter.t().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).foreach((Function1 & Serializable & scala.Serializable)bounds -> {
            if (bounds == null) {
                return buffer.putInt(-1);
            }
            buffer.putInt(((int[][])bounds).length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds)).foreach((Function1 & Serializable & scala.Serializable)inner -> {
                Z3Filter$.$anonfun$serializeToBytes$5(buffer, inner);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        buffer.putShort(filter.minEpoch());
        buffer.putShort(filter.maxEpoch());
        return buffer.array();
    }

    @Override
    public Z3Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        int[][] xy = (int[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> buffer.getInt(), ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int[][][] t = (int[][][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable & scala.Serializable)() -> {
            int length = buffer.getInt();
            if (length == -1) {
                return null;
            }
            return (int[][])Array$.MODULE$.fill(length, (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> buffer.getInt(), ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        short minEpoch = buffer.getShort();
        short maxEpoch = buffer.getShort();
        return new Z3Filter(xy, t, minEpoch, maxEpoch);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(Z3Filter filter) {
        String xy = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.xy())).map((Function1 & Serializable & scala.Serializable)bounds -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bounds)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.TermSeparator());
        String t = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter.t())).map((Function1 & Serializable & scala.Serializable)bounds -> {
            if (bounds == null) {
                return "";
            }
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$5)).mkString(MODULE$.RangeSeparator()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(MODULE$.TermSeparator());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(this.EpochSeparator());
        String epoch = new StringBuilder(0).append(filter.minEpoch()).append(this.RangeSeparator()).append(filter.maxEpoch()).toString();
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TKey()), (Object)t), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EpochKey()), (Object)epoch), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)GeoMesaProperties$.MODULE$.ProjectVersion())}));
    }

    @Override
    public Z3Filter deserializeFromStrings(Map<String, String> serialized) {
        int[][] xy = (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Z3Filter$.$anonfun$deserializeFromStrings$2(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        int[][][] t = (int[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.TKey())).split(this.EpochSeparator()))).map((Function1 & Serializable & scala.Serializable)bounds -> {
            if (bounds.isEmpty()) {
                return null;
            }
            return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bounds.split(MODULE$.TermSeparator()))).map((Function1 & Serializable & scala.Serializable)x$8 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8.split(MODULE$.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Z3Filter$.$anonfun$deserializeFromStrings$5(x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))));
        short[] sArray = (short[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.EpochKey())).split(this.RangeSeparator()))).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToShort((short)Z3Filter$.$anonfun$deserializeFromStrings$6(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        Option option = Array$.MODULE$.unapplySeq((Object)sArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)sArray);
        }
        short minEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(0));
        short maxEpoch = BoxesRunTime.unboxToShort((Object)((SeqLike)option.get()).apply(1));
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)minEpoch), (Object)BoxesRunTime.boxToShort((short)maxEpoch));
        short minEpoch2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        short maxEpoch2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
        return new Z3Filter(xy, t, minEpoch2, maxEpoch2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Seq wholePeriod$1, Tuple2 x$3) {
        Object object = x$3._2();
        Seq seq = wholePeriod$1;
        return object == null ? seq != null : !object.equals(seq);
    }

    public static final /* synthetic */ short $anonfun$apply$3(Tuple2 x$4) {
        return BoxesRunTime.unboxToShort((Object)x$4._1());
    }

    public static final /* synthetic */ void $anonfun$apply$6(int[][][] t$1, ShortRef minEpoch$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            int[][] times = (int[][])tuple2._2();
            t$1[w - minEpoch$1.elem] = times;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$serializeToBytes$1(int[][] bounds) {
        if (bounds == null) {
            return 4;
        }
        return 4 + bounds.length * 8;
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$2(ByteBuffer buffer$1, int[] bounds) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bounds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ void $anonfun$serializeToBytes$5(ByteBuffer buffer$1, int[] inner) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(inner)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ int $anonfun$deserializeFromStrings$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public static final /* synthetic */ int $anonfun$deserializeFromStrings$5(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ short $anonfun$deserializeFromStrings$6(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toShort();
    }

    private Z3Filter$() {
        MODULE$ = this;
        this.RangeSeparator = ":";
        this.TermSeparator = ";";
        this.EpochSeparator = ",";
        this.XYKey = "zxy";
        this.TKey = "zt";
        this.EpochKey = "epoch";
        this.VersionKey = "v";
    }
}

