/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.locationtech.geomesa.index.conf.SchemaProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$VersionKey$;
import org.locationtech.geomesa.utils.conf.SemanticVersion;
import org.locationtech.geomesa.utils.conf.SemanticVersion$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;

public final class GeoMesaDataStore$
implements LazyLogging {
    public static GeoMesaDataStore$ MODULE$;
    private final ConcurrentHashMap<GeoMesaDataStore.VersionKey, Set<GeoMesaDataStore<?>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores;
    private final AsyncCacheLoader<GeoMesaDataStore.VersionKey, Either<Exception, Option<SemanticVersion>>> loader;
    private final AsyncLoadingCache<GeoMesaDataStore.VersionKey, Either<Exception, Option<SemanticVersion>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GeoMesaDataStore$();
    }

    private Logger logger$lzycompute() {
        GeoMesaDataStore$ geoMesaDataStore$ = this;
        synchronized (geoMesaDataStore$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ConcurrentHashMap<GeoMesaDataStore.VersionKey, Set<GeoMesaDataStore<?>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores() {
        return this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores;
    }

    private AsyncCacheLoader<GeoMesaDataStore.VersionKey, Either<Exception, Option<SemanticVersion>>> loader() {
        return this.loader;
    }

    public AsyncLoadingCache<GeoMesaDataStore.VersionKey, Either<Exception, Option<SemanticVersion>>> org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions() {
        return this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions;
    }

    public void initRemoteVersion(GeoMesaDataStore<?> ds) {
        GeoMesaDataStore.VersionKey key = GeoMesaDataStore$VersionKey$.MODULE$.apply(ds);
        Function loader = new Function<GeoMesaDataStore.VersionKey, Set<GeoMesaDataStore<?>>>(){

            public <V> Function<V, Set<GeoMesaDataStore<?>>> compose(Function<? super V, ? extends GeoMesaDataStore.VersionKey> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<GeoMesaDataStore.VersionKey, V> andThen(Function<? super Set<GeoMesaDataStore<?>>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Set<GeoMesaDataStore<?>> apply(GeoMesaDataStore.VersionKey t) {
                return Collections.newSetFromMap(new ConcurrentHashMap<K, V>());
            }
        };
        this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores().computeIfAbsent(key, loader).add(ds);
        if (ds.getTypeNames().length > 0) {
            this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions().get((Object)key);
            return;
        }
    }

    private GeoMesaDataStore$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores = new ConcurrentHashMap();
        this.loader = new CacheLoader<GeoMesaDataStore.VersionKey, Either<Exception, Option<SemanticVersion>>>(){

            public Map<? extends GeoMesaDataStore.VersionKey, ? extends Either<Exception, Option<SemanticVersion>>> loadAll(Set<? extends GeoMesaDataStore.VersionKey> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends GeoMesaDataStore.VersionKey, ? extends Either<Exception, Option<SemanticVersion>>>> asyncLoadAll(Set<? extends GeoMesaDataStore.VersionKey> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Either<Exception, Option<SemanticVersion>> load(GeoMesaDataStore.VersionKey key) {
                if (SchemaProperties$.MODULE$.CheckDistributedVersion().toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)false))) {
                    return package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                GeoMesaDataStore ds = (GeoMesaDataStore)Option$.MODULE$.apply(GeoMesaDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$liveStores().get(key)).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$12).asScala()).find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$load$2(x$13)))).orNull(Predef$.MODULE$.$conforms());
                if (ds == null) {
                    throw new RuntimeException("Can't load remote versions if there are no feature types");
                }
                SemanticVersion clientVersion = ds.getClientVersion();
                scala.collection.immutable.Set iterVersions = (scala.collection.immutable.Set)ds.loadIteratorVersions().map((Function1 & Serializable & scala.Serializable)v -> SemanticVersion$.MODULE$.apply(v, true), Set$.MODULE$.canBuildFrom());
                Option version = iterVersions.reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
                    if (right.$greater(left)) {
                        return right;
                    }
                    return left;
                });
                if (iterVersions.forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$load$5(clientVersion, x$14)))) {
                    return package$.MODULE$.Right().apply((Object)version);
                }
                if (SchemaProperties$.MODULE$.ValidateDistributedClasspath().toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)false)) || iterVersions.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$load$6(clientVersion, x$15)))) {
                    BoxedUnit boxedUnit;
                    if (GeoMesaDataStore$.MODULE$.logger().underlying().isWarnEnabled()) {
                        GeoMesaDataStore$.MODULE$.logger().underlying().warn(anon.1.message$1(clientVersion, iterVersions));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return package$.MODULE$.Right().apply((Object)version);
                }
                return package$.MODULE$.Left().apply((Object)new RuntimeException(new StringBuilder(71).append(anon.1.message$1(clientVersion, iterVersions)).append(". You may override this check by setting the system property ").append("'-D").append(SchemaProperties$.MODULE$.ValidateDistributedClasspath().property()).append("=false'").toString()));
            }

            public static final /* synthetic */ boolean $anonfun$load$2(GeoMesaDataStore x$13) {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$13.getTypeNames())).nonEmpty();
            }

            private static final String message$1(SemanticVersion clientVersion$1, scala.collection.immutable.Set iterVersions$1) {
                return new StringBuilder(124).append("Classpath errors detected: configured server-side iterators do not match ").append("client version. Client version: ").append(clientVersion$1).append(", server versions: ").append(iterVersions$1.mkString(", ")).toString();
            }

            public static final /* synthetic */ boolean $anonfun$load$5(SemanticVersion clientVersion$1, SemanticVersion x$14) {
                SemanticVersion semanticVersion = x$14;
                SemanticVersion semanticVersion2 = clientVersion$1;
                return !(semanticVersion != null ? !semanticVersion.equals(semanticVersion2) : semanticVersion2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$load$6(SemanticVersion clientVersion$1, SemanticVersion x$15) {
                return SemanticVersion.MinorOrdering$.MODULE$.compare(x$15, clientVersion$1) == 0;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(java.util.Set ), $anonfun$load$3(java.lang.String ), $anonfun$load$4(org.locationtech.geomesa.utils.conf.SemanticVersion org.locationtech.geomesa.utils.conf.SemanticVersion ), $anonfun$load$5$adapted(org.locationtech.geomesa.utils.conf.SemanticVersion org.locationtech.geomesa.utils.conf.SemanticVersion ), $anonfun$load$6$adapted(org.locationtech.geomesa.utils.conf.SemanticVersion org.locationtech.geomesa.utils.conf.SemanticVersion ), $anonfun$load$2$adapted(org.locationtech.geomesa.index.geotools.GeoMesaDataStore )}, serializedLambda);
            }
        };
        this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$versions = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.DAYS).buildAsync(this.loader());
    }
}

