/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource$GeoMesaQueryCapabilities$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import scala.Function0;
import scala.NotImplementedError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0016-\u0001]B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005+\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003a\u0011\u0015I\u0007\u0001\"\u0001k\u0011!q\u0007\u0001#b\u0001\n\u0013y\u0007bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\u000b\u0001\t\u0003\ny\u0004C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011Q\n\u0001\u0005B\u0005u\u0003bBA'\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011q\u0016\u0001\u0005B\u0005EvaBA[Y!\u0005\u0011q\u0017\u0004\u0007W1B\t!!/\t\r%4B\u0011AAa\u000f\u001d\t\u0019M\u0006E\u0001\u0003\u000b4q!!3\u0017\u0011\u0003\tY\r\u0003\u0004j3\u0011\u0005\u0011Q\u001a\u0005\b\u0003\u001fLB\u0011IAi\u0011\u001d\tI.\u0007C!\u0003#Dq!a7\u001a\t\u0003\n\t\u000eC\u0004\u0002^f!\t%a8\u0007\r\u0005]h\u0003AA}\u0011%\tYp\bB\u0001B\u0003%\u0001\t\u0003\u0004j?\u0011\u0005\u0011Q \u0005\n\u0005\u0007y\"\u0019!C\u0005\u0005\u000bA\u0001B!\u0007 A\u0003%!q\u0001\u0005\b\u0003gzB\u0011\tB\u000e\u0011\u001d\u0011ib\bC!\u00057AqAa\b \t\u0003\u0012Y\u0002C\u0004\u0003\"}!\tEa\t\t\u000f\u00055q\u0004\"\u0011\u0003&!9!1G\u0010\u0005B\tU\u0002bBA\u0016?\u0011\u0005\u0013Q\u0006\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\u000b\u00055r\u0013\u0001C4f_R|w\u000e\\:\u000b\u0005=\u0002\u0014!B5oI\u0016D(BA\u00193\u0003\u001d9Wm\\7fg\u0006T!a\r\u001b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u001dA\u0013B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB(cU\u0016\u001cG\u000f\u0005\u0002B\u000f6\t!I\u0003\u0002D\t\u0006!A-\u0019;b\u0015\t)e)A\u0002ba&T!!\f\u001b\n\u0005!\u0013%aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007C\u0001&R\u001b\u0005Y%B\u0001'N\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqu*\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0016aA2p[&\u0011!k\u0013\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0002egV\tQ\u000b\u0005\u0002W5:\u0011q\u000bW\u0007\u0002Y%\u0011\u0011\fL\u0001\ba\u0006\u001c7.Y4f\u0013\tYFL\u0001\tHK>lU-Y:CCN,7\u000b^8sK*\u0011\u0011\fL\u0001\u0004IN\u0004\u0013aA:giV\t\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u000611/[7qY\u0016T!!\u001a#\u0002\u000f\u0019,\u0017\r^;sK&\u0011qM\u0019\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\na\u0001P5oSRtDcA6m[B\u0011q\u000b\u0001\u0005\u0006'\u0016\u0001\r!\u0016\u0005\u0006=\u0016\u0001\r\u0001Y\u0001\u0006Q&tGo]\u000b\u0002aB\u0019\u0011\u000f\u001e<\u000e\u0003IT!a\u001d\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003kJ\u00141aU3u!\r9\u0018q\u0001\b\u0004q\u0006\u0005aBA=\u007f\u001d\tQX0D\u0001|\u0015\tah'\u0001\u0004=e>|GOP\u0005\u0002{%\u0011q\u0010P\u0001\u0004C^$\u0018\u0002BA\u0002\u0003\u000b\taBU3oI\u0016\u0014\u0018N\\4IS:$8O\u0003\u0002\u0000y%!\u0011\u0011BA\u0006\u0005\rYU-\u001f\u0006\u0005\u0003\u0007\t)!A\u0005hKR\u001c6\r[3nCR\t\u0001-\u0001\u0005hKR\u001cu.\u001e8u)\u0011\t)\"!\t\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q!!a\u0007\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005}\u0011\u0011\u0004\u0002\u0004\u0013:$\bbBA\u0012\u0011\u0001\u0007\u0011QE\u0001\u0006cV,'/\u001f\t\u0004\u0003\u0006\u001d\u0012bAA\u0015\u0005\n)\u0011+^3ss\u0006Iq-\u001a;C_VtGm\u001d\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0002kiNT1!!\u000fG\u0003!9Wm\\7fiJL\u0018\u0002BA\u001f\u0003g\u0011!CU3gKJ,gnY3e\u000b:4X\r\\8qKR!\u0011qFA!\u0011\u001d\t\u0019C\u0003a\u0001\u0003K\tAcZ3u#V,'/_\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCAA$!\r\t\u0015\u0011J\u0005\u0004\u0003\u0017\u0012%!E)vKJL8)\u00199bE&d\u0017\u000e^5fg\u0006Yq-\u001a;GK\u0006$XO]3t)\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\u0019\u0017q\u000b\u0006\u0003\u0007\u001aKA!a\u0017\u0002V\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0005\u0003#\ny\u0006C\u0004\u0002b5\u0001\r!a\u0019\u0002\r\u0019LG\u000e^3s!\u0011\t)'!\u001b\u000e\u0005\u0005\u001d$bAA1\t&!\u00111NA4\u0005\u00191\u0015\u000e\u001c;feR!\u0011\u0011KA8\u0011\u001d\t\tH\u0004a\u0001\u0003K\t\u0001b\u001c:jO&t\u0017\r\\\u0001\bO\u0016$h*Y7f)\t\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bZ\u0001\u0005if\u0004X-\u0003\u0003\u0002\u0002\u0006m$\u0001\u0002(b[\u0016\fAbZ3u\t\u0006$\u0018m\u0015;pe\u0016$\"!a\"\u0011\u0007\u0005\u000bI)C\u0002\u0002\f\n\u0013\u0011\u0002R1uCN#xN]3\u0002#\u001d,GoU;qa>\u0014H/\u001a3IS:$8\u000fF\u0001q\u0003\u001d9W\r^%oM>$\"!!&\u0011\u0007\u0005\u000b9*C\u0002\u0002\u001a\n\u0013ABU3t_V\u00148-Z%oM>\f!#\u00193e\r\u0016\fG/\u001e:f\u0019&\u001cH/\u001a8feR!\u0011qTAS!\u0011\t9\"!)\n\t\u0005\r\u0016\u0011\u0004\u0002\u0005+:LG\u000fC\u0004\u0002(N\u0001\r!!+\u0002\u00111L7\u000f^3oKJ\u00042!QAV\u0013\r\tiK\u0011\u0002\u0010\r\u0016\fG/\u001e:f\u0019&\u001cH/\u001a8fe\u0006)\"/Z7pm\u00164U-\u0019;ve\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BAP\u0003gCq!a*\u0015\u0001\u0004\tI+\u0001\u000bHK>lUm]1GK\u0006$XO]3T_V\u00148-\u001a\t\u0003/Z\u00192AFA^!\u0011\t9\"!0\n\t\u0005}\u0016\u0011\u0004\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005]\u0016\u0001G$f_6+7/Y)vKJL8)\u00199bE&d\u0017\u000e^5fgB\u0019\u0011qY\r\u000e\u0003Y\u0011\u0001dR3p\u001b\u0016\u001c\u0018-U;fef\u001c\u0015\r]1cS2LG/[3t'\rI\u0012q\t\u000b\u0003\u0003\u000b\f\u0011#[:PM\u001a\u001cX\r^*vaB|'\u000f^3e)\t\t\u0019\u000e\u0005\u0003\u0002\u0018\u0005U\u0017\u0002BAl\u00033\u0011qAQ8pY\u0016\fg.\u0001\fjgJ+G.[1cY\u00164\u0015\nR*vaB|'\u000f^3e\u0003eI7/V:f!J|g/\u001b3fI\u001aKEiU;qa>\u0014H/\u001a3\u0002\u001fM,\b\u000f]8siN\u001cvN\u001d;j]\u001e$B!a5\u0002b\"9\u00111\u001d\u0010A\u0002\u0005\u0015\u0018AD:peR\fE\u000f\u001e:jEV$Xm\u001d\t\u0007\u0003/\t9/a;\n\t\u0005%\u0018\u0011\u0004\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003BAw\u0003gl!!a<\u000b\t\u0005E\u0018qM\u0001\u0005g>\u0014H/\u0003\u0003\u0002v\u0006=(AB*peR\u0014\u0015P\u0001\fEK2,w-\u0019;j]\u001e\u0014Vm]8ve\u000e,\u0017J\u001c4p'\u0011y\u0002(!&\u0002\rM|WO]2f)\u0011\tyP!\u0001\u0011\u0007\u0005\u001dw\u0004\u0003\u0004\u0002|\u0006\u0002\r\u0001Q\u0001\tW\u0016Lxo\u001c:egV\u0011!q\u0001\t\u0005cR\u0014I\u0001\u0005\u0003\u0003\f\tMa\u0002\u0002B\u0007\u0005\u001f\u00012A_A\r\u0013\u0011\u0011\t\"!\u0007\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Ba\u0006\u0003\rM#(/\u001b8h\u0015\u0011\u0011\t\"!\u0007\u0002\u0013-,\u0017p^8sIN\u0004CC\u0001B\u0005\u0003!9W\r\u001e+ji2,\u0017AD4fi\u0012+7o\u0019:jaRLwN\\\u0001\fO\u0016$8*Z=x_J$7\u000f\u0006\u0002\u0003\bQ\u0011!q\u0005\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)\u0019!Q\u0006\u001f\u0002\u00079,G/\u0003\u0003\u00032\t-\"aA+S\u0013\u00061q-\u001a;D%N#\"Aa\u000e\u0011\t\te\"1I\u0007\u0003\u0005wQAA!\u0010\u0003@\u0005\u00191M]:\u000b\u0007\t\u0005C)A\u0006sK\u001a,'/\u001a8dS:<\u0017\u0002\u0002B#\u0005w\u0011\u0011dQ8pe\u0012Lg.\u0019;f%\u00164WM]3oG\u0016\u001c\u0016p\u001d;f[\u0002")
public class GeoMesaFeatureSource
implements SimpleFeatureSource,
LazyLogging {
    private Set<RenderingHints.Key> hints;
    private final DataStore ds;
    private final SimpleFeatureType sft;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        GeoMesaFeatureSource geoMesaFeatureSource = this;
        synchronized (geoMesaFeatureSource) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DataStore ds() {
        return this.ds;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    private Set<RenderingHints.Key> hints$lzycompute() {
        GeoMesaFeatureSource geoMesaFeatureSource = this;
        synchronized (geoMesaFeatureSource) {
            if (!this.bitmap$0) {
                this.hints = Collections.unmodifiableSet(Collections.emptySet());
                this.bitmap$0 = true;
            }
        }
        return this.hints;
    }

    private Set<RenderingHints.Key> hints() {
        if (!this.bitmap$0) {
            return this.hints$lzycompute();
        }
        return this.hints;
    }

    public SimpleFeatureType getSchema() {
        return this.sft();
    }

    public int getCount(Query query) {
        long count;
        long l;
        Hints hints = ((GeoMesaFeatureReader.HasGeoMesaFeatureReader)this.ds()).getFeatureReader(this.sft(), Transaction.AUTO_COMMIT, query).hints();
        boolean useExactCount = BoxesRunTime.unboxToBoolean((Object)QueryHints$.MODULE$.RichHints(hints).isExactCount().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(QueryProperties$.MODULE$.QueryExactCount().get())).toBoolean()));
        if (useExactCount && !query.isMaxFeaturesUnlimited() && query.getMaxFeatures() < new StringOps(Predef$.MODULE$.augmentString(QueryProperties$.MODULE$.QueryExactCountMaxFeatures().get())).toInt()) {
            l = SelfClosingIterator$.MODULE$.apply(this.getFeatures(query)).size();
        } else {
            long statsCount = BoxesRunTime.unboxToLong((Object)((package.HasGeoMesaStats)this.ds()).stats().getCount(this.getSchema(), query.getFilter(), useExactCount, hints).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            l = count = query.isMaxFeaturesUnlimited() ? statsCount : package$.MODULE$.min(statsCount, (long)query.getMaxFeatures());
        }
        if (count > Integer.MAX_VALUE) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Truncating count {} to Int.MaxValue ({})", new Object[]{BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    public ReferencedEnvelope getBounds() {
        return this.getBounds(new Query(this.sft().getTypeName(), (Filter)Filter.INCLUDE));
    }

    public ReferencedEnvelope getBounds(Query query) {
        GeoMesaStats qual$1 = ((package.HasGeoMesaStats)this.ds()).stats();
        SimpleFeatureType x$1 = this.getSchema();
        Filter x$2 = query.getFilter();
        boolean x$3 = qual$1.getBounds$default$3();
        return qual$1.getBounds(x$1, x$2, x$3);
    }

    public QueryCapabilities getQueryCapabilities() {
        return GeoMesaFeatureSource$GeoMesaQueryCapabilities$.MODULE$;
    }

    public SimpleFeatureCollection getFeatures() {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) {
        return this.getFeatures(new Query(this.sft().getTypeName(), filter));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureCollection getFeatures(Query original) {
        Query query;
        if (original.getTypeName() != null) {
            query = original;
        } else {
            void var3_2;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received Query with null typeName, setting to: {}", new Object[]{this.sft().getTypeName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Query nq = new Query(original);
            nq.setTypeName(this.sft().getTypeName());
            query = var3_2;
        }
        Query query2 = query;
        return new GeoMesaFeatureCollection(this, query2);
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public DataStore getDataStore() {
        return this.ds();
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.hints();
    }

    public ResourceInfo getInfo() {
        return new DelegatingResourceInfo(this);
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public GeoMesaFeatureSource(DataStore ds, SimpleFeatureType sft) {
        this.ds = ds;
        this.sft = sft;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class DelegatingResourceInfo
    implements ResourceInfo {
        private final SimpleFeatureSource source;
        private final Set<String> keywords;

        private Set<String> keywords() {
            return this.keywords;
        }

        public String getName() {
            return this.source.getSchema().getName().getURI();
        }

        public String getTitle() {
            return this.source.getSchema().getName().getLocalPart();
        }

        public String getDescription() {
            return null;
        }

        public Set<String> getKeywords() {
            return this.keywords();
        }

        public URI getSchema() {
            return (URI)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI($this.source.getSchema().getName().getNamespaceURI())).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        }

        public CoordinateReferenceSystem getCRS() {
            return this.source.getSchema().getCoordinateReferenceSystem();
        }

        public ReferencedEnvelope getBounds() {
            return this.source.getBounds();
        }

        public DelegatingResourceInfo(SimpleFeatureSource source) {
            this.source = source;
            this.keywords = Collections.unmodifiableSet((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", this.getName()}))).$plus$plus((GenTraversableOnce)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)source.getSchema())))).asJava());
        }
    }
}

