/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\n\u0015\u0001}A\u0011\"\f\u0001\u0003\u0002\u0003\u0006IAL\u001b\t\u0013Y\u0002!\u0011!Q\u0001\n]z\u0004\"\u0002!\u0001\t\u0003\t\u0005bB#\u0001\u0001\u0004%IA\u0012\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0011\u0019!\u0006\u0001)Q\u0005\u000f\")Q\u000b\u0001C!-\")\u0011\u000f\u0001C!e\")\u0001\u0010\u0001C!s\"1\u0001\u0010\u0001C!\u0003WAa\u0001\u001f\u0001\u0005B\u0005]\u0002B\u0002=\u0001\t\u0003\nY\u0005C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004B\u0002=\u0001\t\u0003\t)\u0007\u0003\u0004y\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016\u001cFo\u001c:f\u0015\t)b#\u0001\u0005hK>$xn\u001c7t\u0015\t9\u0002$A\u0003j]\u0012,\u0007P\u0003\u0002\u001a5\u00059q-Z8nKN\f'BA\u000e\u001d\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!IA\u0011\u0011EI\u0007\u0002)%\u00111\u0005\u0006\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\u0011\u0005\u0015ZS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00023bi\u0006T!!\u000b\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u00169%\u0011AF\n\u0002\u0013'&l\u0007\u000f\\3GK\u0006$XO]3Ti>\u0014X-\u0001\u0002egB\u0011qF\r\b\u0003CAJ!!\r\u000b\u0002\u000fA\f7m[1hK&\u00111\u0007\u000e\u0002\u0011\u000f\u0016|W*Z1t\u0005\u0006\u001cXm\u0015;pe\u0016T!!\r\u000b\n\u00055\u0012\u0013aA:giB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005qB\u0013a\u00024fCR,(/Z\u0005\u0003}e\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0013\t1$%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0005\u000e#\u0005CA\u0011\u0001\u0011\u0015i3\u00011\u0001/\u0011\u001514\u00011\u00018\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u0016\u0003\u001d\u0003\"!\n%\n\u0005%3#a\u0003+sC:\u001c\u0018m\u0019;j_:\fq\u0002\u001e:b]N\f7\r^5p]~#S-\u001d\u000b\u0003\u0019J\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013A!\u00168ji\"91+BA\u0001\u0002\u00049\u0015a\u0001=%c\u0005aAO]1og\u0006\u001cG/[8oA\u0005Y\u0011\r\u001a3GK\u0006$XO]3t)\t9v\rE\u0002Y;~k\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001C5eK:$\u0018\u000e^=\u000b\u0005\u0011D\u0013A\u00024jYR,'/\u0003\u0002gC\nIa)Z1ukJ,\u0017\n\u001a\u0005\u0006Q\u001e\u0001\r![\u0001\u000bG>dG.Z2uS>t\u0007\u0003\u00026mo9l\u0011a\u001b\u0006\u0003y)J!!\\6\u0003#\u0019+\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000e\u0005\u00029_&\u0011\u0001/\u000f\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u0017M,GOR3biV\u0014Xm\u001d\u000b\u0003\u0019NDQ\u0001\u001e\u0005A\u0002U\faA]3bI\u0016\u0014\b\u0003B\u0013wo9L!a\u001e\u0014\u0003\u001b\u0019+\u0017\r^;sKJ+\u0017\rZ3s\u00039iw\u000eZ5gs\u001a+\u0017\r^;sKN$b\u0001\u0014>\u0002\u0016\u0005\u0005\u0002\"B>\n\u0001\u0004a\u0018AC1uiJL'-\u001e;fgB\u0019Q*`@\n\u0005yt%!B!se\u0006L\b\u0003BA\u0001\u0003\u001fqA!a\u0001\u0002\fA\u0019\u0011Q\u0001(\u000e\u0005\u0005\u001d!bAA\u0005=\u00051AH]8pizJ1!!\u0004O\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0002(\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a\u00051a/\u00197vKN\u0004B!T?\u0002\u001cA\u0019Q*!\b\n\u0007\u0005}aJ\u0001\u0004B]f\u0014VM\u001a\u0005\u0007I&\u0001\r!a\t\u0011\t\u0005\u0015\u0012qE\u0007\u0002G&\u0019\u0011\u0011F2\u0003\r\u0019KG\u000e^3s)\u001da\u0015QFA\u0019\u0003kAa!a\f\u000b\u0001\u0004y\u0018!C1uiJL'-\u001e;f\u0011\u001d\t\u0019D\u0003a\u0001\u00037\tQA^1mk\u0016Da\u0001\u001a\u0006A\u0002\u0005\rBc\u0002'\u0002:\u0005\u001d\u0013\u0011\n\u0005\b\u0003_Y\u0001\u0019AA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!w\u0005!A/\u001f9f\u0013\u0011\t)%a\u0010\u0003\t9\u000bW.\u001a\u0005\b\u0003gY\u0001\u0019AA\u000e\u0011\u0019!7\u00021\u0001\u0002$Q9A*!\u0014\u0002R\u0005M\u0003BB>\r\u0001\u0004\ty\u0005\u0005\u0003N{\u0006m\u0002bBA\f\u0019\u0001\u0007\u0011\u0011\u0004\u0005\u0007I2\u0001\r!a\t\u0002\u001dI,Wn\u001c<f\r\u0016\fG/\u001e:fgR\u0019A*!\u0017\t\r\u0011l\u0001\u0019AA\u0012\u00039\u0019X\r\u001e+sC:\u001c\u0018m\u0019;j_:$2\u0001TA0\u0011\u0015)e\u00021\u0001H\u000399W\r\u001e+sC:\u001c\u0018m\u0019;j_:$\u0012a\u0012\u000b\b\u0019\u0006\u001d\u0014qNA9\u0011\u001d\ty\u0003\u0005a\u0001\u0003S\u0002B!!\u0010\u0002l%!\u0011QNA \u0005M\tE\u000f\u001e:jEV$X\rR3tGJL\u0007\u000f^8s\u0011\u001d\t\u0019\u0004\u0005a\u0001\u00037Aa\u0001\u001a\tA\u0002\u0005\rBc\u0002'\u0002v\u0005e\u00141\u0010\u0005\u0007wF\u0001\r!a\u001e\u0011\t5k\u0018\u0011\u000e\u0005\b\u0003/\t\u0002\u0019AA\r\u0011\u0019!\u0017\u00031\u0001\u0002$\u00051qO]5uKJ$B!!!\u0002\bB)Q%a!8]&\u0019\u0011Q\u0011\u0014\u0003\u001b\u0019+\u0017\r^;sK^\u0013\u0018\u000e^3s\u0011\u0019!'\u00031\u0001\u0002\nB)Q*a#\u0002$%\u0019\u0011Q\u0012(\u0003\r=\u0003H/[8o\u0001")
public class GeoMesaFeatureStore
extends GeoMesaFeatureSource
implements SimpleFeatureStore {
    private Transaction transaction = Transaction.AUTO_COMMIT;

    private Transaction transaction() {
        return this.transaction;
    }

    private void transaction_$eq(Transaction x$1) {
        this.transaction = x$1;
    }

    public java.util.List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeatureId> fids = new ArrayList<FeatureId>(collection.size());
        ArrayBuffer errors = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        package.WithClose$.MODULE$.apply((Object)collection.features(), (Function0 & Serializable & scala.Serializable)() -> this.writer((Option<Filter>)None$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            GeoMesaFeatureStore.$anonfun$addFeatures$2(fids, errors, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
        if (errors.isEmpty()) {
            return fids;
        }
        IllegalArgumentException e = new IllegalArgumentException("Some features were not written:");
        errors.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            e.addSuppressed(x$1);
            return BoxedUnit.UNIT;
        });
        throw e;
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.removeFeatures((Filter)Filter.INCLUDE);
        try {
            package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)None$.MODULE$), (Function1 & Serializable & scala.Serializable)writer -> {
                GeoMesaFeatureStore.$anonfun$setFeatures$1(reader, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        finally {
            reader.close();
        }
    }

    public void modifyFeatures(String[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).map((Function1 & Serializable & scala.Serializable)x$1 -> new NameImpl(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Name.class))), values, filter);
    }

    public void modifyFeatures(String attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{new NameImpl(attribute)}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{attribute}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name[] attributes2, Object[] values, Filter filter) {
        SimpleFeatureType sft = this.getSchema();
        Predef$.MODULE$.require(filter != null, (Function0 & Serializable & scala.Serializable)() -> "Filter must not be null");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Predef$.MODULE$.require(sft.getDescriptor(a) != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(a).append(" is not an attribute of ").append(sft$1.getName()).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.require(attributes2.length == values.length, (Function0 & Serializable & scala.Serializable)() -> "Modified names and values don't match");
        package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable & scala.Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$modifyFeatures$6(attributes2, values, writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void removeFeatures(Filter filter) {
        DataStore dataStore = super.ds();
        if (dataStore instanceof GeoMesaDataStore) {
            GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
                List indices = geoMesaDataStore.manager().indices(super.sft(), geoMesaDataStore.manager().indices$default$2()).toList();
                if (TablePartition$.MODULE$.partitioned(super.sft())) {
                    ((List)indices.map((Function1 & Serializable & scala.Serializable)i -> CachedThreadPool$.MODULE$.submit(() -> GeoMesaFeatureStore.deleteOne$1(i, geoMesaDataStore)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get());
                } else {
                    ((List)indices.map((Function1 & Serializable & scala.Serializable)i -> CachedThreadPool$.MODULE$.submit(() -> GeoMesaFeatureStore.deleteOne$2(i, geoMesaDataStore)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get());
                }
                geoMesaDataStore.stats().writer().clear(super.sft());
                return;
            }
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable & scala.Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$removeFeatures$8(writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void setTransaction(Transaction transaction) {
        Predef$.MODULE$.require(transaction != null, (Function0 & Serializable & scala.Serializable)() -> "Transaction can't be null - did you mean Transaction.AUTO_COMMIT?");
        this.transaction_$eq(transaction);
    }

    public Transaction getTransaction() {
        return this.transaction();
    }

    public void modifyFeatures(AttributeDescriptor attribute, Object value, Filter filter) {
        this.modifyFeatures(attribute.getName(), value, filter);
    }

    public void modifyFeatures(AttributeDescriptor[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes2)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Name.class))), values, filter);
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> writer(Option<Filter> filter) {
        DataStore dataStore = super.ds();
        if (dataStore instanceof MetadataBackedDataStore) {
            MetadataBackedDataStore metadataBackedDataStore = (MetadataBackedDataStore)dataStore;
            return metadataBackedDataStore.getFeatureWriter(super.sft(), this.transaction(), filter);
        }
        if (filter.isEmpty()) {
            return super.ds().getFeatureWriterAppend(super.sft().getTypeName(), this.transaction());
        }
        return super.ds().getFeatureWriter(super.sft().getTypeName(), (Filter)filter.get(), this.transaction());
    }

    public static final /* synthetic */ void $anonfun$addFeatures$2(ArrayList fids$1, ArrayBuffer errors$1, FeatureIterator x0$1, FeatureWriter x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            FeatureIterator features = (FeatureIterator)tuple2._1();
            FeatureWriter writer = (FeatureWriter)tuple2._2();
            while (features.hasNext()) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)fids$1.add(FeatureUtils$.MODULE$.write(writer, (SimpleFeature)features.next(), FeatureUtils$.MODULE$.write$default$3()).getIdentifier()));
                }
                catch (IllegalArgumentException e) {
                    errors$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{e}));
                    bl = BoxedUnit.UNIT;
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setFeatures$1(FeatureReader reader$1, FeatureWriter writer) {
        while (reader$1.hasNext()) {
            FeatureUtils$.MODULE$.write(writer, (SimpleFeature)reader$1.next(), FeatureUtils$.MODULE$.write$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$modifyFeatures$6(Name[] attributes$1, Object[] values$1, FeatureWriter writer) {
        while (writer.hasNext()) {
            SimpleFeature sf = (SimpleFeature)writer.next();
            for (int i = 0; i < attributes$1.length; ++i) {
                try {
                    sf.setAttribute(attributes$1[i], values$1[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new DataSourceException(new StringBuilder(32).append("Error updating feature ").append("'").append(sf.getID()).append("' with ").append(attributes$1[i]).append("=").append(values$1[i]).toString(), (Throwable)e);
                }
            }
            writer.write();
        }
    }

    private static final void deleteOne$1(GeoMesaFeatureIndex index, GeoMesaDataStore x2$1) {
        x2$1.adapter().deleteTables(index.deleteTableNames((Option<String>)None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$removeFeatures$4(byte[] x$3) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$3)).isEmpty();
    }

    private static final void deleteOne$2(GeoMesaFeatureIndex index, GeoMesaDataStore x2$1) {
        Option prefix = new Some((Object)index.keySpace().sharing()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureStore.$anonfun$removeFeatures$4(x$3)));
        x2$1.adapter().clearTables(index.getTableNames((Option<String>)None$.MODULE$), (Option<byte[]>)prefix);
    }

    public static final /* synthetic */ void $anonfun$removeFeatures$8(FeatureWriter writer) {
        while (writer.hasNext()) {
            writer.next();
            writer.remove();
        }
    }

    public GeoMesaFeatureStore(DataStore ds, SimpleFeatureType sft) {
        super(ds, sft);
    }
}

