/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.utils.DistributedLocking;
import org.locationtech.geomesa.index.utils.Releasable;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeComparator;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeComparator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.geomesa.utils.index.ReservedWordCheck$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rg!B\u0012%\u0003\u0003y\u0003\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!Q\u0011q\u0002\u0001C\u0002\u0013E\u0001&!\u0005\t\u0011\u0005%\u0002\u0001)A\u0005\u0003'Aq!a\u000b\u0001\r#\ti\u0003C\u0004\u0002f\u00011\t\"a\u001a\t\u000f\u0005E\u0004A\"\u0005\u0002t!9\u0011q\u000f\u0001\u0007\u0012\u0005e\u0004bBA@\u0001\u0019E\u0011\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\ty\t\u0001C!\u0003#Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005M\u0006\u0001\"\u0011\u0002<\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007bBAa\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\ty\r\u0001C!\u0003+Dq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002f\u0002!\t%a:\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!1\u0001\u0001\u0005B\t]\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\t\u0005\u0007\u0001a\u0011\u0001\u0015\u00034!9!\u0011\t\u0001\u0005B\t\r\u0003b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u0005+\u0002A\u0011\tB,\u0011\u001d\u0011I\u0006\u0001C\t\u00057B\u0001B!%\u0001\t#A#1S\u0004\b\u00057#\u0003\u0012\u0001BO\r\u0019\u0019C\u0005#\u0001\u0003 \"9\u0011QA\u0010\u0005\u0002\t\u001d\u0006\"\u0003BU?\t\u0007I\u0011\u0002BV\u0011!\u0011\tm\bQ\u0001\n\t5&aF'fi\u0006$\u0017\r^1CC\u000e\\W\r\u001a#bi\u0006\u001cFo\u001c:f\u0015\t)c%\u0001\u0005hK>$xn\u001c7t\u0015\t9\u0003&A\u0003j]\u0012,\u0007P\u0003\u0002*U\u00059q-Z8nKN\f'BA\u0016-\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0013aA8sO\u000e\u00011c\u0002\u00011q\u0005\u000b'\u000e\u001d\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3diB\u0011\u0011hP\u0007\u0002u)\u00111\bP\u0001\u0005I\u0006$\u0018M\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005\u0015b\u0013B\u0001!;\u0005%!\u0015\r^1Ti>\u0014X\rE\u0002C)^s!aQ)\u000f\u0005\u0011{eBA#O\u001d\t1UJ\u0004\u0002H\u0019:\u0011\u0001jS\u0007\u0002\u0013*\u0011!JL\u0001\u0007yI|w\u000e\u001e \n\u00035J!a\u000b\u0017\n\u0005%R\u0013BA\u0014)\u0013\t\u0001f%\u0001\u0005nKR\fG-\u0019;b\u0013\t\u00116+A\u0004qC\u000e\\\u0017mZ3\u000b\u0005A3\u0013BA+W\u0005IA\u0015m]$f_6+7/Y'fi\u0006$\u0017\r^1\u000b\u0005I\u001b\u0006C\u0001-_\u001d\tIF\f\u0005\u0002I5*\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\u00061\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti&\f\u0005\u0002cO:\u00111-\u001a\b\u0003\t\u0012L!!\n\u0014\n\u0005\u0019$\u0013\u0001F$f_6+7/\u0019$fCR,(/\u001a*fC\u0012,'/\u0003\u0002iS\n9\u0002*Y:HK>lUm]1GK\u0006$XO]3SK\u0006$WM\u001d\u0006\u0003M\u0012\u0002\"a\u001b8\u000e\u00031T!!\u001c\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005=d'A\u0005#jgR\u0014\u0018NY;uK\u0012dunY6j]\u001e\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005U4\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003]\f1aY8n\u0013\tI(OA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002}\u007f:\u00111-`\u0005\u0003}\u0012\nqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\n\t\u0005\u0005\u00111\u0001\u0002\u0010\u001d\u0006lWm\u001d9bG\u0016\u001cuN\u001c4jO*\u0011a\u0010J\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005%\u0011Q\u0002\t\u0004\u0003\u0017\u0001Q\"\u0001\u0013\t\u000bi\u0014\u0001\u0019A>\u0002\u0019%tG/\u001a:dKB$xN]:\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003GqA!a\u0006\u0002\u001e9\u0019A)!\u0007\n\u0007\u0005ma%\u0001\u0005qY\u0006tg.\u001b8h\u0013\u0011\ty\"!\t\u0002!E+XM]=J]R,'oY3qi>\u0014(bAA\u000eM%!\u0011QEA\u0014\u0005]\tV/\u001a:z\u0013:$XM]2faR|'OR1di>\u0014\u0018P\u0003\u0003\u0002 \u0005\u0005\u0012!D5oi\u0016\u00148-\u001a9u_J\u001c\b%A\bqe\u0016\u001c6\r[3nC\u000e\u0013X-\u0019;f)\u0011\ty#a\u000e\u0011\t\u0005E\u00121G\u0007\u00025&\u0019\u0011Q\u0007.\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003s)\u0001\u0019AA\u001e\u0003\r\u0019h\r\u001e\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0019\u0019\u0018.\u001c9mK*\u0019\u0011Q\t\u001f\u0002\u000f\u0019,\u0017\r^;sK&!\u0011\u0011JA \u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0015\u0006\u000b\u00055\u00131\r\t\u0007\u0003c\ty%a\u0015\n\u0007\u0005E#L\u0001\u0004uQJ|wo\u001d\t\u0005\u0003+\niF\u0004\u0003\u0002X\u0005mcb\u0001%\u0002Z%\t1,\u0003\u0002S5&!\u0011qLA1\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003%j\u001b#!a\u0015\u0002\u001fA\u0014XmU2iK6\fW\u000b\u001d3bi\u0016$b!a\f\u0002j\u0005-\u0004bBA\u001d\r\u0001\u0007\u00111\b\u0005\b\u0003[2\u0001\u0019AA\u001e\u0003!\u0001(/\u001a<j_V\u001c\b&\u0002\u0004\u0002N\u0005\r\u0014aD8o'\u000eDW-\\1De\u0016\fG/\u001a3\u0015\t\u0005=\u0012Q\u000f\u0005\b\u0003s9\u0001\u0019AA\u001e\u0003=ygnU2iK6\fW\u000b\u001d3bi\u0016$GCBA\u0018\u0003w\ni\bC\u0004\u0002:!\u0001\r!a\u000f\t\u000f\u00055\u0004\u00021\u0001\u0002<\u0005yqN\\*dQ\u0016l\u0017\rR3mKR,G\r\u0006\u0003\u00020\u0005\r\u0005bBA\u001d\u0013\u0001\u0007\u00111H\u0001\rO\u0016$H+\u001f9f\u001d\u0006lWm\u001d\u000b\u0003\u0003\u0013\u0003R!!\r\u0002\f^K1!!$[\u0005\u0015\t%O]1z\u0003!9W\r\u001e(b[\u0016\u001cHCAAJ!\u0019\t)*a'\u0002 6\u0011\u0011q\u0013\u0006\u0004\u00033#\u0014\u0001B;uS2LA!!(\u0002\u0018\n!A*[:u!\u0011\t\t+a*\u000e\u0005\u0005\r&\u0002BAS\u0003\u0007\nA\u0001^=qK&!\u0011\u0011VAR\u0005\u0011q\u0015-\\3\u0002\u0019\r\u0014X-\u0019;f'\u000eDW-\\1\u0015\t\u0005=\u0012q\u0016\u0005\b\u0003cc\u0001\u0019AA\u001e\u0003\u0019\u00198\r[3nC\u0006Iq-\u001a;TG\",W.\u0019\u000b\u0005\u0003w\t9\fC\u0004\u0002:6\u0001\r!a(\u0002\t9\fW.\u001a\u000b\u0005\u0003w\ti\f\u0003\u0004\u0002@:\u0001\raV\u0001\tif\u0004XMT1nK\u0006aQ\u000f\u001d3bi\u0016\u001c6\r[3nCR1\u0011qFAc\u0003\u000fDa!a0\u0010\u0001\u00049\u0006bBA\u001d\u001f\u0001\u0007\u00111\b\u000b\u0007\u0003_\tY-!4\t\u000f\u0005}\u0006\u00031\u0001\u0002 \"9\u0011\u0011\u0017\tA\u0002\u0005m\u0012\u0001\u0004:f[>4XmU2iK6\fG\u0003BA\u0018\u0003'Da!a0\u0012\u0001\u00049F\u0003BA\u0018\u0003/Dq!a0\u0013\u0001\u0004\ty*\u0001\thKR4U-\u0019;ve\u0016\u001cv.\u001e:dKR!\u0011Q\\Ar!\rI\u0014q\\\u0005\u0004\u0003CT$aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBA`'\u0001\u0007\u0011qT\u0001\u0011O\u0016$h)Z1ukJ,'+Z1eKJ$b!!;\u0002p\u0006e\bcA\u001d\u0002l&\u0019\u0011Q\u001e\u001e\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f%\u0016\fG-\u001a:\t\u000f\u0005EH\u00031\u0001\u0002t\u0006)\u0011/^3ssB\u0019\u0011(!>\n\u0007\u0005](HA\u0003Rk\u0016\u0014\u0018\u0010C\u0004\u0002|R\u0001\r!!@\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\t\u0004s\u0005}\u0018b\u0001B\u0001u\tYAK]1og\u0006\u001cG/[8o\u0003A9W\r\u001e$fCR,(/Z,sSR,'\u000f\u0006\u0004\u0003\b\tM!Q\u0003\t\u0005\u0005\u0013\u0011iAD\u0002E\u0005\u0017I!A\u0015\u0014\n\t\t=!\u0011\u0003\u0002\u0017\r2,8\u000f[1cY\u00164U-\u0019;ve\u0016<&/\u001b;fe*\u0011!K\n\u0005\u0007\u0003\u007f+\u0002\u0019A,\t\u000f\u0005mX\u00031\u0001\u0002~RA!q\u0001B\r\u00057\u0011I\u0003\u0003\u0004\u0002@Z\u0001\ra\u0016\u0005\b\u0005;1\u0002\u0019\u0001B\u0010\u0003\u00191\u0017\u000e\u001c;feB!!\u0011\u0005B\u0013\u001b\t\u0011\u0019CC\u0002\u0003\u001eqJAAa\n\u0003$\t1a)\u001b7uKJDq!a?\u0017\u0001\u0004\ti0\u0001\fhKR4U-\u0019;ve\u0016<&/\u001b;fe\u0006\u0003\b/\u001a8e)\u0019\u00119Aa\f\u00032!1\u0011qX\fA\u0002]Cq!a?\u0018\u0001\u0004\ti\u0010\u0006\u0005\u0003\b\tU\"q\u0007B\u001d\u0011\u001d\tI\u0004\u0007a\u0001\u0003wAq!a?\u0019\u0001\u0004\ti\u0010C\u0004\u0003\u001ea\u0001\rAa\u000f\u0011\r\u0005E\"Q\bB\u0010\u0013\r\u0011yD\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000f\u001d,G/\u00138g_R\u0011!Q\t\t\u0004s\t\u001d\u0013b\u0001B%u\tY1+\u001a:wS\u000e,\u0017J\u001c4p\u0003E9W\r\u001e'pG.LgnZ'b]\u0006<WM\u001d\u000b\u0003\u0005\u001f\u00022!\u000fB)\u0013\r\u0011\u0019F\u000f\u0002\u000f\u0019>\u001c7.\u001b8h\u001b\u0006t\u0017mZ3s\u0003\u001d!\u0017n\u001d9pg\u0016$\"!a\f\u0002)Y\fG.\u001b3bi\u0016\u001c6\r[3nCV\u0003H-\u0019;f)\u0019\u0011iFa#\u0003\u0010BA\u0011Q\u000bB0\u0005G\u0012I'\u0003\u0003\u0003b\u0005\u0005$AB#ji\",'\u000f\u0005\u0003\u0002V\t\u0015\u0014\u0002\u0002B4\u0003C\u0012Q$\u00168tkB\u0004xN\u001d;fI>\u0003XM]1uS>tW\t_2faRLwN\u001c\t\u0005\u0005W\u0012)I\u0004\u0003\u0003n\t}d\u0002\u0002B8\u0005srAA!\u001d\u0003v9\u0019QIa\u001d\n\u00055D\u0013bA\u0013\u0003x)\u0011Q\u000eK\u0005\u0005\u0005w\u0012i(A\u000eTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0006\u0004K\t]\u0014\u0002\u0002BA\u0005\u0007\u000ba\u0002V=qK\u000e{W\u000e]1sSN|gN\u0003\u0003\u0003|\tu\u0014\u0002\u0002BD\u0005\u0013\u0013!bQ8na\u0006$\u0018N\u00197f\u0015\u0011\u0011\tIa!\t\u000f\t5E\u00041\u0001\u0002<\u0005AQ\r_5ti&tw\rC\u0004\u00022r\u0001\r!a\u000f\u0002%\u0005\u001c\u0017/^5sK\u000e\u000bG/\u00197pO2{7m\u001b\u000b\u0003\u0005+\u00032a\u001bBL\u0013\r\u0011I\n\u001c\u0002\u000b%\u0016dW-Y:bE2,\u0017aF'fi\u0006$\u0017\r^1CC\u000e\\W\r\u001a#bi\u0006\u001cFo\u001c:f!\r\tYaH\n\u0004?\t\u0005\u0006\u0003BA\u0019\u0005GK1A!*[\u0005\u0019\te.\u001f*fMR\u0011!QT\u0001\u0019+:lw\u000eZ5gS\u0006\u0014G.Z+tKJ$\u0015\r^1LKf\u001cXC\u0001BW!\u0019\u0011yK!/\u0003>6\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013),A\u0005j[6,H/\u00192mK*\u0019!q\u0017.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003<\nE&aA*fiB\u0019\u0011Ga0\n\u0005}\u0013\u0014!G+o[>$\u0017NZ5bE2,Wk]3s\t\u0006$\u0018mS3zg\u0002\u0002")
public abstract class MetadataBackedDataStore
implements DataStore,
package.HasGeoMesaMetadata<String>,
GeoMesaFeatureReader.HasGeoMesaFeatureReader,
DistributedLocking,
LazyLogging {
    private final GeoMesaDataStoreFactory.NamespaceConfig config;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> T withLock(String key, Function0<T> fn) {
        return (T)DistributedLocking.withLock$(this, key, fn);
    }

    @Override
    public <T> T withLock(String key, long timeOut, Function0<T> fn, Function0<T> fallback) {
        return (T)DistributedLocking.withLock$(this, key, timeOut, fn, fallback);
    }

    private Logger logger$lzycompute() {
        MetadataBackedDataStore metadataBackedDataStore = this;
        synchronized (metadataBackedDataStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    public abstract void preSchemaCreate(SimpleFeatureType var1) throws IllegalArgumentException;

    public abstract void preSchemaUpdate(SimpleFeatureType var1, SimpleFeatureType var2) throws IllegalArgumentException;

    public abstract void onSchemaCreated(SimpleFeatureType var1);

    public abstract void onSchemaUpdated(SimpleFeatureType var1, SimpleFeatureType var2);

    public abstract void onSchemaDeleted(SimpleFeatureType var1);

    public String[] getTypeNames() {
        return this.metadata().getFeatureTypes();
    }

    public List<Name> getNames() {
        ArrayList<Name> names = new ArrayList<Name>();
        Option<String> option = this.config.namespace();
        if (None$.MODULE$.equals(option)) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(name))));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String ns = (String)some.value();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(ns, name))));
        } else {
            throw new MatchError(option);
        }
        return names;
    }

    public void createSchema(SimpleFeatureType schema) {
        if (this.getSchema(schema.getTypeName()) == null) {
            block10: {
                Releasable lock = this.acquireCatalogLock();
                try {
                    if (this.getSchema(schema.getTypeName()) != null) break block10;
                    SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
                    GeoMesaSchemaValidator$.MODULE$.validate(sft);
                    this.preSchemaCreate(sft);
                    try {
                        Map metadataMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.AttributesKey()), (Object)SimpleFeatureTypes$.MODULE$.encodeType(sft, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.StatsGenerationKey()), (Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.GeoToolsDateFormat().format(Instant.now().atOffset(ZoneOffset.UTC)))}));
                        this.metadata().insert(sft.getTypeName(), metadataMap);
                        String attributes2 = (String)this.metadata().readRequired(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey());
                        SimpleFeatureType reloadedSft = SimpleFeatureTypes$.MODULE$.createType(sft.getTypeName(), attributes2);
                        HashMap userData = new HashMap();
                        userData.putAll(reloadedSft.getUserData());
                        reloadedSft.getUserData().putAll(sft.getUserData());
                        reloadedSft.getUserData().putAll(userData);
                        this.onSchemaCreated(reloadedSft);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e;
                            block11: {
                                e = (Throwable)option.get();
                                try {
                                    this.metadata().delete(sft.getTypeName());
                                }
                                catch (Throwable throwable3) {
                                    Throwable throwable4 = throwable3;
                                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                                    if (!option2.isEmpty()) {
                                        Throwable e2 = (Throwable)option2.get();
                                        e.addSuppressed(e2);
                                        break block11;
                                    }
                                    throw throwable3;
                                }
                            }
                            throw e;
                        }
                        throw throwable;
                    }
                }
                finally {
                    lock.release();
                }
            }
            return;
        }
    }

    public SimpleFeatureType getSchema(Name name) {
        return this.getSchema(name.getLocalPart());
    }

    public SimpleFeatureType getSchema(String typeName) {
        boolean x$3;
        String x$2;
        String x$1;
        GeoMesaMetadata qual$1 = this.metadata();
        Option option = qual$1.read(x$1 = typeName, x$2 = GeoMesaMetadata$.MODULE$.AttributesKey(), x$3 = qual$1.read$default$3());
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String spec = (String)some.value();
            return SimpleFeatureTypes$.MODULE$.createImmutableType((String)this.config.namespace().orNull(Predef$.MODULE$.$conforms()), typeName, spec);
        }
        throw new MatchError(option);
    }

    public void updateSchema(String typeName, SimpleFeatureType sft) {
        this.updateSchema((Name)new NameImpl(typeName), sft);
    }

    public void updateSchema(Name typeName, SimpleFeatureType schema) {
        String string = typeName.getLocalPart();
        String string2 = schema.getTypeName();
        if ((string == null ? string2 != null : !string.equals(string2)) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames())).contains((Object)schema.getTypeName())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Updated type name already exists: '").append(typeName).append("' changed to '").append(schema.getTypeName()).append("'").toString());
        }
        Releasable lock = this.acquireCatalogLock();
        try {
            SimpleFeatureType previousSft = this.getSchema(typeName);
            if (previousSft == null) {
                throw new IllegalArgumentException(new StringBuilder(24).append("Schema '").append(typeName).append("' does not exist").toString());
            }
            GeoMesaSchemaValidator$.MODULE$.validate(schema);
            this.validateSchemaUpdate(previousSft, schema).left().foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw e;
            });
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
            this.preSchemaUpdate(sft, previousSft);
            if (Predef$.MODULE$.Boolean2boolean((Boolean)FastConverter$.MODULE$.convertOrElse(sft.getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.UpdateBackupMetadata()), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.boolean2Boolean(true), ClassTag$.MODULE$.apply(Boolean.class)))) {
                this.metadata().backup(typeName.getLocalPart());
            }
            String string3 = typeName.getLocalPart();
            String string4 = schema.getTypeName();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.metadata().scan(typeName.getLocalPart(), "", false).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    MetadataBackedDataStore.$anonfun$updateSchema$3(this, sft, typeName, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            this.metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey(), SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
            this.onSchemaUpdated(sft, previousSft);
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(String typeName) {
        Releasable lock = this.acquireCatalogLock();
        try {
            Option$.MODULE$.apply((Object)this.getSchema(typeName)).foreach((Function1 & Serializable & scala.Serializable)sft -> {
                MetadataBackedDataStore.$anonfun$removeSchema$1(this, typeName, sft);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public SimpleFeatureReader getFeatureReader(Query query, Transaction transaction) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0 & Serializable & scala.Serializable)() -> "Type name is required in the query");
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(query.getTypeName()).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureReader(sft, transaction, query).reader();
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)Option$.MODULE$.apply((Object)filter));
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)None$.MODULE$);
    }

    public abstract SimpleFeatureWriter getFeatureWriter(SimpleFeatureType var1, Transaction var2, Option<Filter> var3);

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringBuilder(14).append("Features from ").append(this.getClass().getSimpleName()).toString());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.metadata(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public Either<UnsupportedOperationException, SimpleFeatureTypeComparator.TypeComparison$.Compatible> validateSchemaUpdate(SimpleFeatureType existing, SimpleFeatureType schema) {
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema)) != RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing))) {
            return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException("Changing the default geometry attribute is not supported"));
        }
        Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema));
        Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing));
        if (option == null ? option2 != null : !option.equals(option2)) {
            return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException("Changing the default date attribute is not supported"));
        }
        Set userDataChanges = (Set)MetadataBackedDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$MetadataBackedDataStore$$UnmodifiableUserDataKeys().flatMap((Function1 & Serializable & scala.Serializable)key -> {
            Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema), key);
            Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing), key);
            if (!(option != null ? !option.equals(option2) : option2 != null)) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StringBuilder(2).append("'").append((String)key).append("'").toString()));
        }, Set$.MODULE$.canBuildFrom());
        if (userDataChanges.nonEmpty()) {
            String msg = new StringBuilder(1).append((Object)(userDataChanges.size() == 1 ? "" : "s")).append(" ").append(userDataChanges.mkString(", ")).toString();
            return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException(new StringBuilder(39).append("Updating user data key").append(msg).append(" is not supported").toString()));
        }
        SimpleFeatureTypeComparator.TypeComparison typeComparison = SimpleFeatureTypeComparator$.MODULE$.compare(existing, schema);
        if (SimpleFeatureTypeComparator.TypeComparison$.AttributeRemoved$.MODULE$.equals(typeComparison)) {
            return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException("Removing attributes from the schema is not supported"));
        }
        if (typeComparison instanceof SimpleFeatureTypeComparator.TypeComparison$.AttributeTypeChanged) {
            SimpleFeatureTypeComparator.TypeComparison$.AttributeTypeChanged attributeTypeChanged = (SimpleFeatureTypeComparator.TypeComparison$.AttributeTypeChanged)typeComparison;
            Map changes = attributeTypeChanged.changes();
            Iterable msg = (Iterable)changes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Class from = (Class)tuple22._1();
                        Class to = (Class)tuple22._2();
                        return new StringBuilder(10).append(name).append(" from ").append(from.getName()).append(" to ").append(to.getName()).toString();
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom());
            return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException(new StringBuilder(41).append("Incompatible schema column type changes: ").append(msg.mkString(", ")).toString()));
        }
        if (typeComparison instanceof SimpleFeatureTypeComparator.TypeComparison$.Compatible) {
            SimpleFeatureTypeComparator.TypeComparison$.Compatible compatible = (SimpleFeatureTypeComparator.TypeComparison$.Compatible)typeComparison;
            boolean reserved = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetadataBackedDataStore.$anonfun$validateSchemaUpdate$4(existing, name)));
            if (reserved) {
                try {
                    ReservedWordCheck$.MODULE$.validateAttributeNames(schema);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option3.isEmpty()) {
                        Throwable e = (Throwable)option3.get();
                        return scala.package$.MODULE$.Left().apply((Object)new UnsupportedOperationException(e.getMessage()));
                    }
                    throw throwable;
                }
            }
            return scala.package$.MODULE$.Right().apply((Object)compatible);
        }
        throw new MatchError((Object)typeComparison);
    }

    public Releasable acquireCatalogLock() {
        String dsTypeName = this.getClass().getSimpleName().replaceAll("[^A-Za-z]", "");
        String path = new StringBuilder(30).append("/org.locationtech.geomesa/ds/").append(dsTypeName).append("/").append(this.config.catalog()).toString();
        Duration timeout = (Duration)package$.MODULE$.DistributedLockTimeout().toDuration().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Couldn't convert '").append(package$.MODULE$.DistributedLockTimeout().get()).append("' to a duration").toString());
        });
        return (Releasable)this.acquireDistributedLock(path, timeout.toMillis()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(48).append("Could not acquire distributed lock at '").append(path).append("' within ").append(timeout).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$updateSchema$3(MetadataBackedDataStore $this, SimpleFeatureType sft$1, Name typeName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.metadata().insert(sft$1.getTypeName(), k, v);
            $this.metadata().remove(typeName$1.getLocalPart(), k);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$removeSchema$1(MetadataBackedDataStore $this, String typeName$2, SimpleFeatureType sft) {
        $this.onSchemaDeleted(sft);
        $this.metadata().delete(typeName$2);
    }

    public static final /* synthetic */ boolean $anonfun$validateSchemaUpdate$4(SimpleFeatureType existing$1, String name) {
        return existing$1.getDescriptor(name) == null && FeatureUtils$.MODULE$.ReservedWords().contains((Object)name.toUpperCase(Locale.US));
    }

    public MetadataBackedDataStore(GeoMesaDataStoreFactory.NamespaceConfig config) {
        this.config = config;
        DistributedLocking.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.apply(this);
    }
}

