/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.attribute;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Left;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002\u0017.\u0001eB\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tO\u0002\u0011\t\u0011)A\u00059\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!A!\u0002\u0013y\u0007\"\u0002>\u0001\t\u0003Y\b\"CA\u0001\u0001\t\u0007I\u0011CA\u0002\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u0015\u0001\"CA\u0007\u0001\t\u0007I\u0011CA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011CA\u000e\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\t)\u0004\u0001Q\u0001\n\u0005%\u0002\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\t)\u0006\u0001Q\u0001\n\u0005m\u0002\"CA0\u0001\t\u0007I\u0011CA1\u0011!\tI\u0007\u0001Q\u0001\n\u0005\r\u0004\"CA6\u0001\t\u0007I\u0011IA7\u0011!\t\t\t\u0001Q\u0001\n\u0005=\u0004\"CAB\u0001\t\u0007I\u0011IAC\u0011!\t\u0019\n\u0001Q\u0001\n\u0005\u001d\u0005\"CAK\u0001\t\u0007I\u0011IAL\u0011!\t)\u000b\u0001Q\u0001\n\u0005e\u0005bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqAa\u0007\u0001\t\u0003\u0012i\u0002C\u0004\u0003.\u0001!\tEa\f\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j!9!\u0011\u0011\u0001\u0005\u0012\t\r\u0005b\u0002BG\u0001\u0011E!q\u0012\u0005\b\u0005+\u0003A\u0011\u0003BL\u0011%\u0011\t\u000bAI\u0001\n#\u0011\u0019\u000bC\u0004\u0003:\u0002!\tBa/\t\u0013\t\u0005\u0007!%A\u0005\u0012\t\r\u0006b\u0002Bb\u0001\u0011E!Q\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u000f\u001d\u0011).\fE\u0001\u0005/4a\u0001L\u0017\t\u0002\te\u0007B\u0002>)\t\u0003\u0011I\u000fC\u0004\u0003l\"\"\tE!<\t\u000f\tM\b\u0006\"\u0011\u0003v\n1\u0012\t\u001e;sS\n,H/Z%oI\u0016D8*Z=Ta\u0006\u001cWM\u0003\u0002/_\u0005I\u0011\r\u001e;sS\n,H/\u001a\u0006\u0003aE\nQ!\u001b8eKbT!\u0001\r\u001a\u000b\u0005M\"\u0014aB4f_6,7/\u0019\u0006\u0003kY\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011aN\u0001\u0004_J<7\u0001A\n\u0005\u0001i\u0002\u0005\u000b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u00123U*D\u0001C\u0015\t\u0019\u0015'A\u0002ba&L!!\u0012\"\u0003\u001b%sG-\u001a=LKf\u001c\u0006/Y2f!\r9\u0005JS\u0007\u0002[%\u0011\u0011*\f\u0002\u0015\u0003R$(/\u001b2vi\u0016Le\u000eZ3y-\u0006dW/Z:\u0011\u0005mZ\u0015B\u0001'=\u0005\r\te.\u001f\t\u0003\u000f:K!aT\u0017\u0003#\u0005#HO]5ckR,\u0017J\u001c3fq.+\u0017\u0010\u0005\u0002R16\t!K\u0003\u0002T)\u0006a1oY1mC2|wmZ5oO*\u0011QKV\u0001\tif\u0004Xm]1gK*\tq+A\u0002d_6L!!\u0017*\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0004g\u001a$X#\u0001/\u0011\u0005u+W\"\u00010\u000b\u0005}\u0003\u0017AB:j[BdWM\u0003\u0002bE\u00069a-Z1ukJ,'BA\"d\u0015\t!g'\u0001\u0005hK>$xn\u001c7t\u0013\t1gLA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fAa\u001d4uA\u0005A1\u000f[1sI&tw-F\u0001k!\t\t5.\u0003\u0002m\u0005\ni1\u000b[1sIN#(/\u0019;fOf\f\u0011b\u001d5be\u0012Lgn\u001a\u0011\u0002\u001d\u0005$HO]5ckR,g)[3mIB\u0011\u0001o\u001e\b\u0003cV\u0004\"A\u001d\u001f\u000e\u0003MT!\u0001\u001e\u001d\u0002\rq\u0012xn\u001c;?\u0013\t1H(\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<=\u0003\u0019a\u0014N\\5u}Q!A0 @\u0000!\t9\u0005\u0001C\u0003[\r\u0001\u0007A\fC\u0003i\r\u0001\u0007!\u000eC\u0003o\r\u0001\u0007q.\u0001\u0006gS\u0016dG-\u00138eKb,\"!!\u0002\u0011\u0007m\n9!C\u0002\u0002\nq\u00121!\u00138u\u0003-1\u0017.\u001a7e\u0013:$W\r\u001f\u0011\u0002\u001f\u0019LW\r\u001c3J]\u0012,\u0007p\u00155peR,\"!!\u0005\u0011\u0007m\n\u0019\"C\u0002\u0002\u0016q\u0012Qa\u00155peR\f\u0001CZ5fY\u0012Le\u000eZ3y'\"|'\u000f\u001e\u0011\u0002\r%\u001cH*[:u+\t\ti\u0002E\u0002<\u0003?I1!!\t=\u0005\u001d\u0011un\u001c7fC:\fq![:MSN$\b%\u0001\u0006eKN\u001c'/\u001b9u_J,\"!!\u000b\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\fa\u0003\u0011!\u0018\u0010]3\n\t\u0005M\u0012Q\u0006\u0002\u0014\u0003R$(/\u001b2vi\u0016$Um]2sSB$xN]\u0001\fI\u0016\u001c8M]5qi>\u0014\b%A\u0004cS:$\u0017N\\4\u0016\u0005\u0005m\u0002\u0007BA\u001f\u0003#\u0002b!a\u0010\u0002J\u00055SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\nAA[1wC&!\u00111JA!\u0005\u0015\u0019E.Y:t!\u0011\ty%!\u0015\r\u0001\u0011Y\u00111\u000b\t\u0002\u0002\u0003\u0005)\u0011AA,\u0005\ryFEM\u0001\tE&tG-\u001b8hAE\u0019\u0011\u0011\f&\u0011\u0007m\nY&C\u0002\u0002^q\u0012qAT8uQ&tw-A\u0006eK\u000e|G-\u001a,bYV,WCAA2!\u0015Y\u0014QM8;\u0013\r\t9\u0007\u0010\u0002\n\rVt7\r^5p]F\nA\u0002Z3d_\u0012,g+\u00197vK\u0002\n!\"\u0019;ue&\u0014W\u000f^3t+\t\ty\u0007E\u0003\u0002r\u0005mtN\u0004\u0003\u0002t\u0005]db\u0001:\u0002v%\tQ(C\u0002\u0002zq\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$aA*fc*\u0019\u0011\u0011\u0010\u001f\u0002\u0017\u0005$HO]5ckR,7\u000fI\u0001\bg\"\f'/\u001b8h+\t\t9\tE\u0003<\u0003\u0013\u000bi)C\u0002\u0002\fr\u0012Q!\u0011:sCf\u00042aOAH\u0013\r\t\t\n\u0010\u0002\u0005\u0005f$X-\u0001\u0005tQ\u0006\u0014\u0018N\\4!\u0003IIg\u000eZ3y\u0017\u0016L()\u001f;f\u0019\u0016tw\r\u001e5\u0016\u0005\u0005e\u0005\u0003CA9\u00037\u000by*!\u0002\n\t\u0005u\u0015q\u0010\u0002\u0005\u0019\u00164G\u000fE\u0006<\u0003C\u000b9)!\u0002\u0002\u0006\u0005\u0015\u0011bAARy\tIa)\u001e8di&|gnM\u0001\u0014S:$W\r_&fs\nKH/\u001a'f]\u001e$\b\u000eI\u0001\u000bi>Le\u000eZ3y\u0017\u0016LHCCAV\u0003\u0017\f).!7\u0002^B)\u0011QVAc\u001b:!\u0011qVAb\u001d\u0011\t\t,!1\u000f\t\u0005M\u0016q\u0018\b\u0005\u0003k\u000biL\u0004\u0003\u00028\u0006mfb\u0001:\u0002:&\tq'\u0003\u00026m%\u00111\u0007N\u0005\u0003aIJ!aQ\u0019\n\u0007\u0005e$)\u0003\u0003\u0002H\u0006%'a\u0003*po.+\u0017PV1mk\u0016T1!!\u001fC\u0011\u001d\ti-\u0007a\u0001\u0003\u001f\f\u0001b\u001e:ji\u0006\u0014G.\u001a\t\u0004\u0003\u0006E\u0017bAAj\u0005\nyqK]5uC\ndWMR3biV\u0014X\rC\u0004\u0002Xf\u0001\r!a\"\u0002\tQLWM\u001d\u0005\b\u00037L\u0002\u0019AAD\u0003\tIG\rC\u0005\u0002`f\u0001\n\u00111\u0001\u0002\u001e\u00059A.\u001a8jK:$\u0018AD4fi&sG-\u001a=WC2,Xm\u001d\u000b\u0006\r\u0006\u0015\u00181\u001f\u0005\b\u0003OT\u0002\u0019AAu\u0003\u00191\u0017\u000e\u001c;feB!\u00111^Ax\u001b\t\tiOC\u0002\u0002h\nLA!!=\u0002n\n1a)\u001b7uKJDq!!>\u001b\u0001\u0004\t90A\u0004fqBd\u0017-\u001b8\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@2\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\t!a?\u0003\u0013\u0015C\b\u000f\\1j]\u0016\u0014\u0018!C4fiJ\u000bgnZ3t)\u0019\u00119Aa\u0005\u0003\u0018A1\u0011\u0011\u000fB\u0005\u0005\u001bIAAa\u0003\u0002\u0000\tA\u0011\n^3sCR|'\u000fE\u0003\u0002.\n=Q*\u0003\u0003\u0003\u0012\u0005%'!C*dC:\u0014\u0016M\\4f\u0011\u0019\u0011)b\u0007a\u0001\r\u00061a/\u00197vKND\u0011B!\u0007\u001c!\u0003\u0005\r!!\u0002\u0002\u00155,H\u000e^5qY&,'/A\u0007hKR\u0014\u0016M\\4f\u0005f$Xm\u001d\u000b\u0007\u0005?\u00119Ca\u000b\u0011\r\u0005E$\u0011\u0002B\u0011!\u0011\tiKa\t\n\t\t\u0015\u0012\u0011\u001a\u0002\n\u0005f$XMU1oO\u0016DqA!\u000b\u001d\u0001\u0004\u00119!\u0001\u0004sC:<Wm\u001d\u0005\n\u0003/d\u0002\u0013!a\u0001\u0003;\tQ\"^:f\rVdGNR5mi\u0016\u0014H\u0003CA\u000f\u0005c\u0011IDa\u0015\t\u000f\tUQ\u00041\u0001\u00034A!1H!\u000eG\u0013\r\u00119\u0004\u0010\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tmR\u00041\u0001\u0003>\u000511m\u001c8gS\u001e\u0004Ra\u000fB\u001b\u0005\u007f\u0001BA!\u0011\u0003N9!!1\tB$\u001d\u0011\t\tL!\u0012\n\u0005\u0011\f\u0014\u0002\u0002B%\u0005\u0017\nqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\u000b\u0005\u0011\f\u0014\u0002\u0002B(\u0005#\u0012acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0005\u0013\u0012Y\u0005C\u0004\u0003Vu\u0001\rAa\u0016\u0002\u000b!Lg\u000e^:\u0011\t\te#1M\u0007\u0003\u00057RAA!\u0018\u0003`\u00059a-Y2u_JL(b\u0001B1G\u0006!Q\u000f^5m\u0013\u0011\u0011)Ga\u0017\u0003\u000b!Kg\u000e^:\u0002\u001d\u0011,7m\u001c3f%><h+\u00197vKRA!1\u000eB;\u0005s\u0012i\bE\u0003\u0003n\tE$(\u0004\u0002\u0003p)\u0019!\u0011\r\u001f\n\t\tM$q\u000e\u0002\u0004)JL\bb\u0002B<=\u0001\u0007\u0011qQ\u0001\u0004e><\bb\u0002B>=\u0001\u0007\u0011QA\u0001\u0007_\u001a47/\u001a;\t\u000f\t}d\u00041\u0001\u0002\u0006\u00051A.\u001a8hi\"\f1cZ3u)&,'/\u001a3SC:<WMQ=uKN$bAa\b\u0003\u0006\n\u001d\u0005b\u0002B\u0015?\u0001\u0007!q\u0001\u0005\b\u0005\u0013{\u0002\u0019\u0001BF\u0003!\u0001(/\u001a4jq\u0016\u001c\bCBA9\u0003w\n9)A\u000bhKR\u001cF/\u00198eCJ$'+\u00198hK\nKH/Z:\u0015\r\t}!\u0011\u0013BJ\u0011\u001d\u0011I\u0003\ta\u0001\u0005\u000fAqA!#!\u0001\u0004\u0011Y)A\u0003m_^,'\u000f\u0006\u0004\u0002\b\ne%Q\u0014\u0005\u0007\u00057\u000b\u0003\u0019A'\u0002\u0007-,\u0017\u0010C\u0005\u0003 \u0006\u0002\n\u00111\u0001\u0002\u001e\u00051\u0001O]3gSb\fq\u0002\\8xKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005KSC!!\b\u0003(.\u0012!\u0011\u0016\t\u0005\u0005W\u0013),\u0004\u0002\u0003.*!!q\u0016BY\u0003%)hn\u00195fG.,GMC\u0002\u00034r\n!\"\u00198o_R\fG/[8o\u0013\u0011\u00119L!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0003vaB,'\u000f\u0006\u0004\u0002\b\nu&q\u0018\u0005\u0007\u00057\u001b\u0003\u0019A'\t\u0013\t}5\u0005%AA\u0002\u0005u\u0011aD;qa\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017QLWM]3e+B\u0004XM\u001d\u000b\u0005\u0005\u000f\u0014I\rE\u0003<\u0005k\t9\t\u0003\u0004\u0003\u001c\u0016\u0002\r!T\u0001\tS\u0012|eMZ:fiRA\u0011Q\u0001Bh\u0005#\u0014\u0019\u000eC\u0004\u0003x\u0019\u0002\r!a\"\t\u000f\tmd\u00051\u0001\u0002\u0006!9!q\u0010\u0014A\u0002\u0005\u0015\u0011AF!uiJL'-\u001e;f\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005\u001dC3\u0003\u0002\u0015;\u00057\u0004bA!8\u0003d\u001ake\u0002BAX\u0005?L1A!9C\u00035Ie\u000eZ3y\u0017\u0016L8\u000b]1dK&!!Q\u001dBt\u0005QIe\u000eZ3y\u0017\u0016L8\u000b]1dK\u001a\u000b7\r^8ss*\u0019!\u0011\u001d\"\u0015\u0005\t]\u0017\u0001C:vaB|'\u000f^:\u0015\r\u0005u!q\u001eBy\u0011\u0015Q&\u00061\u0001]\u0011\u001d\tYG\u000ba\u0001\u0003_\nQ!\u00199qYf$r\u0001 B|\u0005s\u0014Y\u0010C\u0003[W\u0001\u0007A\fC\u0004\u0002l-\u0002\r!a\u001c\t\u000f\u0005]7\u00061\u0001\u0002\u001e\u0001")
public class AttributeIndexKeySpace
implements IndexKeySpace<AttributeIndexValues<Object>, AttributeIndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String attributeField;
    private final int fieldIndex;
    private final short fieldIndexShort;
    private final boolean isList;
    private final AttributeDescriptor descriptor;
    private final Class<?> binding;
    private final Function1<String, Object> decodeValue;
    private final Seq<String> attributes;
    private final byte[] sharing;
    private final Left<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static AttributeIndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return AttributeIndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return AttributeIndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        AttributeIndexKeySpace attributeIndexKeySpace = this;
        synchronized (attributeIndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int fieldIndex() {
        return this.fieldIndex;
    }

    public short fieldIndexShort() {
        return this.fieldIndexShort;
    }

    public boolean isList() {
        return this.isList;
    }

    private AttributeDescriptor descriptor() {
        return this.descriptor;
    }

    private Class<?> binding() {
        return this.binding;
    }

    public Function1<String, Object> decodeValue() {
        return this.decodeValue;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    public Left<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public package.RowKeyValue<AttributeIndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard = this.sharding().apply(writable);
        if (this.isList()) {
            java.util.List attribute = (java.util.List)writable.getAttribute(this.fieldIndex());
            if (attribute == null) {
                return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)Nil$.MODULE$), this.sharing(), shard, (Seq)Nil$.MODULE$, tier, id, writable.values());
            }
            Builder rows = Seq$.MODULE$.newBuilder();
            rows.sizeHint(attribute.size());
            Builder keys = Seq$.MODULE$.newBuilder();
            keys.sizeHint(attribute.size());
            for (int i = 0; i < attribute.size(); ++i) {
                String encoded = AttributeIndexKey$.MODULE$.typeEncode(attribute.get(i));
                byte[] value = encoded.getBytes(StandardCharsets.UTF_8);
                byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + tier.length + id.length + 1 + value.length, ClassTag$.MODULE$.Byte());
                if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
                    System.arraycopy(value, 0, bytes, 0, value.length);
                    bytes[value.length] = ByteArrays$.MODULE$.ZeroByte();
                    System.arraycopy(tier, 0, bytes, value.length + 1, tier.length);
                    System.arraycopy(id, 0, bytes, value.length + 1 + tier.length, id.length);
                } else {
                    bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
                    System.arraycopy(value, 0, bytes, 1, value.length);
                    bytes[value.length + 1] = ByteArrays$.MODULE$.ZeroByte();
                    System.arraycopy(tier, 0, bytes, value.length + 2, tier.length);
                    System.arraycopy(id, 0, bytes, value.length + 2 + tier.length, id.length);
                }
                rows.$plus$eq((Object)bytes);
                keys.$plus$eq((Object)new AttributeIndexKey(this.fieldIndexShort(), encoded, AttributeIndexKey$.MODULE$.apply$default$3()));
            }
            return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)rows.result()), this.sharing(), shard, (Seq)keys.result(), tier, id, writable.values());
        }
        Object attribute = writable.getAttribute(this.fieldIndex());
        if (attribute == null) {
            return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)Nil$.MODULE$), this.sharing(), shard, (Seq)Nil$.MODULE$, tier, id, writable.values());
        }
        String encoded = AttributeIndexKey$.MODULE$.typeEncode(attribute);
        byte[] value = encoded.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + tier.length + id.length + 1 + value.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            System.arraycopy(value, 0, bytes, 0, value.length);
            bytes[value.length] = ByteArrays$.MODULE$.ZeroByte();
            System.arraycopy(tier, 0, bytes, value.length + 1, tier.length);
            System.arraycopy(id, 0, bytes, value.length + 1 + tier.length, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            System.arraycopy(value, 0, bytes, 1, value.length);
            bytes[value.length + 1] = ByteArrays$.MODULE$.ZeroByte();
            System.arraycopy(tier, 0, bytes, value.length + 2, tier.length);
            System.arraycopy(id, 0, bytes, value.length + 2 + tier.length, id.length);
        }
        return new package.SingleRowKeyValue<AttributeIndexKey>(bytes, this.sharing(), shard, new AttributeIndexKey(this.fieldIndexShort(), encoded, AttributeIndexKey$.MODULE$.apply$default$3()), tier, id, writable.values());
    }

    @Override
    public AttributeIndexValues<Object> getIndexValues(Filter filter, Explainer explain) {
        BoxedUnit boxedUnit;
        FilterValues bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter, this.attributeField, this.binding());
        if (bounds.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to extract any attribute bounds from: {}", new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(filter)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new AttributeIndexValues<Object>(this.attributeField, this.fieldIndex(), bounds, this.binding());
    }

    @Override
    public Iterator<package.ScanRange<AttributeIndexKey>> getRanges(AttributeIndexValues<Object> values, int multiplier) {
        if (values.values().isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey(this.fieldIndexShort(), null, false)));
        }
        if (values.values().disjoint() && !this.isList()) {
            return package$.MODULE$.Iterator().empty();
        }
        return values.values().values().iterator().flatMap((Function1 & Serializable & scala.Serializable)bounds -> {
            Tuple2 tuple2 = bounds.bounds();
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Iterator().single(new package.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey(this.fieldIndexShort(), null, false)));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object lower = some.value();
                    if (None$.MODULE$.equals(option3)) {
                        AttributeIndexKey start = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), bounds.lower().inclusive());
                        return package$.MODULE$.Iterator().single(new package.LowerBoundedRange<AttributeIndexKey>(start));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    Object upper = some.value();
                    AttributeIndexKey end = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding()), bounds.upper().inclusive());
                    return package$.MODULE$.Iterator().single(new package.UpperBoundedRange<AttributeIndexKey>(end));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option5 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object lower = some.value();
                    if (option5 instanceof Some) {
                        Some some2 = (Some)option5;
                        Object upper = some2.value();
                        if (BoxesRunTime.equals((Object)lower, (Object)upper)) {
                            AttributeIndexKey row = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), true);
                            return package$.MODULE$.Iterator().single(new package.SingleRowRange<AttributeIndexKey>(row));
                        }
                        String string = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lower), org.locationtech.geomesa.filter.package$.MODULE$.WildcardSuffix());
                        Object object = upper;
                        if (!(string != null ? !string.equals(object) : object != null)) {
                            AttributeIndexKey row = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), true);
                            return package$.MODULE$.Iterator().single(new package.PrefixRange<AttributeIndexKey>(row));
                        }
                        AttributeIndexKey start = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), bounds.lower().inclusive());
                        AttributeIndexKey end = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding()), bounds.upper().inclusive());
                        return package$.MODULE$.Iterator().single(new package.BoundedRange<AttributeIndexKey>(start, end));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, boolean tier) {
        if (tier) {
            return this.getTieredRangeBytes(ranges, this.sharding().shards());
        }
        return this.getStandardRangeBytes(ranges, this.sharding().shards());
    }

    @Override
    public boolean useFullFilter(Option<AttributeIndexValues<Object>> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return values.forall((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)AttributeIndexKeySpace.$anonfun$useFullFilter$1(v)));
    }

    public Try<Object> decodeRowValue(byte[] row, int offset, int length) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int valueStart = offset + this.sharding().length();
            int valueEnd = scala.math.package$.MODULE$.min(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(row)).indexOf((Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), valueStart), offset + length);
            return this.decodeValue().apply((Object)new String(row, valueStart, valueEnd - valueStart, StandardCharsets.UTF_8));
        });
    }

    public Iterator<package.ByteRange> getTieredRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, Seq<byte[]> prefixes) {
        Iterator bytes = ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            package.ScanRange scanRange = x0$1;
            if (scanRange instanceof package.SingleRowRange) {
                package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                return new package.SingleRowByteRange(this.lower(row, this.lower$default$2()));
            }
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                Option<byte[]> option = this.tieredUpper(hi);
                if (None$.MODULE$.equals(option)) {
                    return new package.LowerBoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(hi, this.upper$default$2()));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] up = (byte[])some.value();
                    return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), up);
                }
                throw new MatchError(option);
            }
            if (scanRange instanceof package.PrefixRange) {
                package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                return new package.UnboundedByteRange(this.lower(prefix, true), this.upper(prefix, true));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                return new package.LowerBoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.upper$default$2()));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                Option<byte[]> option = this.tieredUpper(hi);
                if (None$.MODULE$.equals(option)) {
                    return new package.UnboundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), this.upper(hi, this.upper$default$2()));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] up = (byte[])some.value();
                    return new package.UpperBoundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), up);
                }
                throw new MatchError(option);
            }
            if (scanRange instanceof package.UnboundedRange) {
                package.UnboundedRange unboundedRange = (package.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                return new package.UnboundedByteRange(this.lower(empty, this.lower$default$2()), this.upper(empty, this.upper$default$2()));
            }
            throw new MatchError((Object)scanRange);
        });
        if (prefixes.isEmpty()) {
            return bytes;
        }
        return bytes.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Product product = x0$2;
            if (product instanceof package.SingleRowByteRange) {
                package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)product;
                byte[] row = singleRowByteRange.row();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.SingleRowByteRange(ByteArrays$.MODULE$.concat(p, row)), Seq$.MODULE$.canBuildFrom());
            }
            if (product instanceof package.BoundedByteRange) {
                package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)product;
                byte[] lo = boundedByteRange.lower();
                byte[] hi = boundedByteRange.upper();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)), Seq$.MODULE$.canBuildFrom());
            }
            if (product instanceof package.LowerBoundedByteRange) {
                package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)product;
                byte[] lo = lowerBoundedByteRange.lower();
                byte[] hi = lowerBoundedByteRange.upper();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.LowerBoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)), Seq$.MODULE$.canBuildFrom());
            }
            if (product instanceof package.UpperBoundedByteRange) {
                package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)product;
                byte[] lo = upperBoundedByteRange.lower();
                byte[] hi = upperBoundedByteRange.upper();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.UpperBoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)), Seq$.MODULE$.canBuildFrom());
            }
            if (product instanceof package.UnboundedByteRange) {
                package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)product;
                byte[] lo = unboundedByteRange.lower();
                byte[] hi = unboundedByteRange.upper();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.UnboundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)product);
        });
    }

    public Iterator<package.ByteRange> getStandardRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, Seq<byte[]> prefixes) {
        Iterator bytes = ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            package.ScanRange scanRange = x0$1;
            if (scanRange instanceof package.SingleRowRange) {
                package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                return new package.BoundedByteRange(this.lower(row, this.lower$default$2()), this.upper(row, this.upper$default$2()));
            }
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(hi, this.upper$default$2()));
            }
            if (scanRange instanceof package.PrefixRange) {
                package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                return new package.BoundedByteRange(this.lower(prefix, true), this.upper(prefix, true));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.upper$default$2()));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                return new package.BoundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), this.upper(hi, this.upper$default$2()));
            }
            if (scanRange instanceof package.UnboundedRange) {
                package.UnboundedRange unboundedRange = (package.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                return new package.BoundedByteRange(this.lower(empty, this.lower$default$2()), this.upper(empty, this.upper$default$2()));
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
        if (prefixes.isEmpty()) {
            return bytes;
        }
        return bytes.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            package.BoundedByteRange boundedByteRange = x0$2;
            if (boundedByteRange != null) {
                byte[] lo = boundedByteRange.lower();
                byte[] hi = boundedByteRange.upper();
                return (GenTraversableOnce)prefixes.map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)boundedByteRange);
        });
    }

    public byte[] lower(AttributeIndexKey key, boolean prefix) {
        if (key.value() == null || key.value().isEmpty()) {
            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        }
        if (prefix) {
            return key.value().getBytes(StandardCharsets.UTF_8);
        }
        if (key.inclusive()) {
            return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray());
        }
        return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray());
    }

    public boolean lower$default$2() {
        return false;
    }

    public byte[] upper(AttributeIndexKey key, boolean prefix) {
        if (key.value() == null || key.value().isEmpty()) {
            return package$ByteRange$.MODULE$.UnboundedUpperRange();
        }
        if (prefix) {
            return ByteArrays$.MODULE$.rowFollowingPrefix(key.value().getBytes(StandardCharsets.UTF_8));
        }
        if (key.inclusive()) {
            return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray());
        }
        return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray());
    }

    public boolean upper$default$2() {
        return false;
    }

    public Option<byte[]> tieredUpper(AttributeIndexKey key) {
        if (key.value() == null || !key.inclusive()) {
            return None$.MODULE$;
        }
        return new Some((Object)ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray()));
    }

    private int idOffset(byte[] row, int offset, int length) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(row)).indexOf((Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), offset + this.sharding().length()) + 1 - offset;
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$1(AttributeIndexValues v) {
        return v.values().isEmpty() || !v.values().precise();
    }

    public AttributeIndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String attributeField) {
        this.sft = sft;
        this.sharding = sharding;
        this.attributeField = attributeField;
        LazyLogging.$init$((LazyLogging)this);
        this.fieldIndex = sft.indexOf(attributeField);
        this.fieldIndexShort = (short)this.fieldIndex();
        this.isList = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(sft.getDescriptor(this.fieldIndex())));
        this.descriptor = sft.getDescriptor(this.fieldIndex());
        this.binding = this.isList() ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.descriptor())) : this.descriptor().getType().getBinding();
        String alias = AttributeIndexKey$.MODULE$.alias(this.binding());
        this.decodeValue = this.isList() ? (Function1 & Serializable & scala.Serializable)encoded -> Collections.singletonList(AttributeIndexKey$.MODULE$.decode(alias, (String)encoded)) : (Function1 & Serializable & scala.Serializable)x$1 -> AttributeIndexKey$.MODULE$.decode(alias, (String)x$1);
        Predef$.MODULE$.require(AttributeIndexKey$.MODULE$.encodable(this.binding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Indexing is not supported for field ").append($this.attributeField).append(" of type ").append(this.binding().getName()).append(" - supported types are: ").append(((TraversableOnce)AttributeIndexKey$.MODULE$.lexicoders().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        this.attributes = (Seq)new .colon.colon((Object)attributeField, (List)Nil$.MODULE$);
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        this.indexKeyByteLength = package$.MODULE$.Left().apply((Function3 & Serializable & scala.Serializable)(row, offset, length) -> BoxesRunTime.boxToInteger((int)this.idOffset(row, BoxesRunTime.unboxToInt((Object)offset), BoxesRunTime.unboxToInt((Object)length))));
    }
}

