/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.s2;

import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.S2SFC;
import org.locationtech.geomesa.curve.S2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.s2.S2IndexKeySpace$;
import org.locationtech.geomesa.index.index.s2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.java8.JFunction0;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u000e\u001d\u0001!B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003Q\u0011!!\u0006A!A!\u0002\u0013)\u0006\"\u00021\u0001\t\u0003\t\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013\u0005c\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\n\u0003\u0003\u0001!\u0019!C!\u0003\u0007A\u0001\"!\b\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003?\u0001!\u0019!C!\u0003CA\u0001\"a\t\u0001A\u0003%\u0011\u0011\u0003\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\u001e9\u0011q\u001e\u000f\t\u0002\u0005EhAB\u000e\u001d\u0011\u0003\t\u0019\u0010\u0003\u0004a/\u0011\u0005!1\u0001\u0005\b\u0005\u000b9B\u0011\tB\u0004\u0011\u001d\u0011ia\u0006C!\u0005\u001f\u0011qb\u0015\u001aJ]\u0012,\u0007pS3z'B\f7-\u001a\u0006\u0003;y\t!a\u001d\u001a\u000b\u0005}\u0001\u0013!B5oI\u0016D(BA\u0010\"\u0015\t\u00113%A\u0004hK>lWm]1\u000b\u0005\u0011*\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0005aM*T(D\u00012\u0015\t\u0011\u0004%A\u0002ba&L!\u0001N\u0019\u0003\u001b%sG-\u001a=LKf\u001c\u0006/Y2f!\t1$H\u0004\u00028q5\tA$\u0003\u0002:9\u00059\u0001/Y2lC\u001e,\u0017BA\u001e=\u00055\u0019&'\u00138eKb4\u0016\r\\;fg*\u0011\u0011\b\b\t\u0003UyJ!aP\u0016\u0003\t1{gnZ\u0001\u0004g\u001a$X#\u0001\"\u0011\u0005\r[U\"\u0001#\u000b\u0005\u00153\u0015AB:j[BdWM\u0003\u0002H\u0011\u00069a-Z1ukJ,'B\u0001\u001aJ\u0015\tQU%\u0001\u0005hK>$xn\u001c7t\u0013\taEIA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fAa\u001d4uA\u0005A1\u000f[1sI&tw-F\u0001Q!\t\u0001\u0014+\u0003\u0002Sc\ti1\u000b[1sIN#(/\u0019;fOf\f\u0011b\u001d5be\u0012Lgn\u001a\u0011\u0002\u0013\u001d,w.\u001c$jK2$\u0007C\u0001,^\u001d\t96\f\u0005\u0002YW5\t\u0011L\u0003\u0002[O\u00051AH]8pizJ!\u0001X\u0016\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039.\na\u0001P5oSRtD\u0003\u00022dI\u0016\u0004\"a\u000e\u0001\t\u000b\u00013\u0001\u0019\u0001\"\t\u000b93\u0001\u0019\u0001)\t\u000bQ3\u0001\u0019A+\u0002\u0007M47-F\u0001i!\tIG.D\u0001k\u0015\tY\u0017%A\u0003dkJ4X-\u0003\u0002nU\n)1KM*G\u0007\u0006!1OZ2!\u0003%9Wm\\7J]\u0012,\u00070F\u0001r!\tQ#/\u0003\u0002tW\t\u0019\u0011J\u001c;\u0002\u0015\u001d,w.\\%oI\u0016D\b%\u0001\u0006biR\u0014\u0018NY;uKN,\u0012a\u001e\t\u0004qr,fBA=|\u001d\tA&0C\u0001-\u0013\tI4&\u0003\u0002~}\n\u00191+Z9\u000b\u0005eZ\u0013aC1uiJL'-\u001e;fg\u0002\n!#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQV\u0011\u0011Q\u0001\t\u0007q\u0006\u001d\u00111B9\n\u0007\u0005%aPA\u0003SS\u001eDG\u000f\u0005\u0005+\u0003\u001b\t\t\"]9r\u0013\r\tya\u000b\u0002\n\rVt7\r^5p]N\u0002RAKA\n\u0003/I1!!\u0006,\u0005\u0015\t%O]1z!\rQ\u0013\u0011D\u0005\u0004\u00037Y#\u0001\u0002\"zi\u0016\f1#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQ\u0002\nqa\u001d5be&tw-\u0006\u0002\u0002\u0012\u0005A1\u000f[1sS:<\u0007%\u0001\u0006u_&sG-\u001a=LKf$\"\"!\u000b\u0002J\u0005M\u0013qKA.!\u0015\tY#a\u0011>\u001d\u0011\ti#!\u0011\u000f\t\u0005=\u0012q\b\b\u0005\u0003c\tiD\u0004\u0003\u00024\u0005mb\u0002BA\u001b\u0003sq1\u0001WA\u001c\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002 C%\u0011!\u0007I\u0005\u0003sEJA!!\u0012\u0002H\tY!k\\<LKf4\u0016\r\\;f\u0015\tI\u0014\u0007C\u0004\u0002LE\u0001\r!!\u0014\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u00042\u0001MA(\u0013\r\t\t&\r\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"9\u0011QK\tA\u0002\u0005E\u0011\u0001\u0002;jKJDq!!\u0017\u0012\u0001\u0004\t\t\"\u0001\u0002jI\"I\u0011QL\t\u0011\u0002\u0003\u0007\u0011qL\u0001\bY\u0016t\u0017.\u001a8u!\rQ\u0013\u0011M\u0005\u0004\u0003GZ#a\u0002\"p_2,\u0017M\\\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015)\u0014\u0011NA<\u0011\u001d\tYG\u0005a\u0001\u0003[\naAZ5mi\u0016\u0014\b\u0003BA8\u0003gj!!!\u001d\u000b\u0007\u0005-\u0004*\u0003\u0003\u0002v\u0005E$A\u0002$jYR,'\u000fC\u0004\u0002zI\u0001\r!a\u001f\u0002\u000f\u0015D\b\u000f\\1j]B!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002\u0002\nQ!\u001e;jYNLA!!\"\u0002\u0000\tIQ\t\u001f9mC&tWM]\u0001\nO\u0016$(+\u00198hKN$b!a#\u0002\u0018\u0006m\u0005#\u0002=\u0002\u000e\u0006E\u0015bAAH}\nA\u0011\n^3sCR|'\u000fE\u0003\u0002,\u0005MU(\u0003\u0003\u0002\u0016\u0006\u001d#!C*dC:\u0014\u0016M\\4f\u0011\u0019\tIj\u0005a\u0001k\u00051a/\u00197vKND\u0001\"!(\u0014!\u0003\u0005\r!]\u0001\u000b[VdG/\u001b9mS\u0016\u0014\u0018!D4fiJ\u000bgnZ3CsR,7\u000f\u0006\u0004\u0002$\u0006E\u0016Q\u0017\t\u0006q\u00065\u0015Q\u0015\t\u0005\u0003O\u000biK\u0004\u0003\u0002*\u0006\u0005c\u0002BAV\u0003\u007fi\u0011\u0001I\u0005\u0005\u0003_\u000b9EA\u0005CsR,'+\u00198hK\"9\u00111\u0017\u000bA\u0002\u0005-\u0015A\u0002:b]\u001e,7\u000fC\u0005\u0002VQ\u0001\n\u00111\u0001\u0002`\u0005iQo]3Gk2dg)\u001b7uKJ$\u0002\"a\u0018\u0002<\u0006\r\u00171\u001c\u0005\b\u00033+\u0002\u0019AA_!\u0011Q\u0013qX\u001b\n\u0007\u0005\u00057F\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000b,\u0002\u0019AAd\u0003\u0019\u0019wN\u001c4jOB)!&a0\u0002JB!\u00111ZAk\u001d\u0011\ti-!5\u000e\u0005\u0005='B\u0001&!\u0013\u0011\t\u0019.a4\u0002/\u001d+w.T3tC\u0012\u000bG/Y*u_J,g)Y2u_JL\u0018\u0002BAl\u00033\u0014acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0003'\fy\rC\u0004\u0002^V\u0001\r!a8\u0002\u000b!Lg\u000e^:\u0011\t\u0005\u0005\u00181^\u0007\u0003\u0003GTA!!:\u0002h\u00069a-Y2u_JL(bAAu\u0013\u0006!Q\u000f^5m\u0013\u0011\ti/a9\u0003\u000b!Kg\u000e^:\u0002\u001fM\u0013\u0014J\u001c3fq.+\u0017p\u00159bG\u0016\u0004\"aN\f\u0014\t]I\u0013Q\u001f\t\u0007\u0003o\fi0N\u001f\u000f\t\u00055\u0012\u0011`\u0005\u0004\u0003w\f\u0014!D%oI\u0016D8*Z=Ta\u0006\u001cW-\u0003\u0003\u0002\u0000\n\u0005!\u0001F%oI\u0016D8*Z=Ta\u0006\u001cWMR1di>\u0014\u0018PC\u0002\u0002|F\"\"!!=\u0002\u0011M,\b\u000f]8siN$b!a\u0018\u0003\n\t-\u0001\"\u0002!\u001a\u0001\u0004\u0011\u0005\"B;\u001a\u0001\u00049\u0018!B1qa2LHc\u00022\u0003\u0012\tM!Q\u0003\u0005\u0006\u0001j\u0001\rA\u0011\u0005\u0006kj\u0001\ra\u001e\u0005\b\u0003+R\u0002\u0019AA0\u0001")
public class S2IndexKeySpace
implements IndexKeySpace<package.S2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final S2SFC sfc;
    private final int geomIndex;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static S2IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return S2IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return S2IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    private S2SFC sfc() {
        return this.sfc;
    }

    private int geomIndex() {
        return this.geomIndex;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        try {
            l = this.sfc().index(geom.getX(), geom.getY(), lenient);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(31).append("Invalid s value from geometry: ").append(geom).toString(), e);
            }
            throw throwable;
        }
        long s = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            ByteArrays$.MODULE$.writeLong(s, bytes, ByteArrays$.MODULE$.writeLong$default$3());
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            ByteArrays$.MODULE$.writeLong(s, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)s), tier, id, writable.values());
    }

    @Override
    public package.S2IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, FilterHelper$.MODULE$.extractGeometries$default$3());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        if (geometries.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Non-intersecting geometries extracted, short-circuiting to empty query");
            return new package.S2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Nil$.MODULE$));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> GeometryUtils$.MODULE$.bounds(x$1, multiplier, bits), Seq$.MODULE$.canBuildFrom());
        return new package.S2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.S2IndexValues values, int multiplier) {
        package.S2IndexValues s2IndexValues = values;
        if (s2IndexValues == null) {
            throw new MatchError((Object)s2IndexValues);
        }
        FilterValues<Geometry> geoms = s2IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = s2IndexValues.spatialBounds();
        Tuple2 tuple2 = new Tuple2(geoms, xy);
        FilterValues geoms2 = (FilterValues)tuple2._1();
        Seq xy2 = (Seq)tuple2._2();
        if (geoms2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / multiplier)));
        return this.sfc().ranges(xy2, -1, target).iterator().map((Function1 & Serializable & scala.Serializable)r -> new package$BoundedRange$mcJ$sp(r.lower(), r.upper()));
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                long lo = boundedRange.lower$mcJ$sp();
                long hi = boundedRange.upper$mcJ$sp();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.S2IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        LazyBoolean simpleGeoms$lzy = new LazyBoolean();
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)S2IndexKeySpace.$anonfun$useFullFilter$1(x))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> config.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S2IndexKeySpace.$anonfun$useFullFilter$3(x$3)))));
        return !looseBBox || !S2IndexKeySpace.simpleGeoms$1(simpleGeoms$lzy, values);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$1(Object x) {
        return BoxesRunTime.unboxToBoolean((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$3(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$3) {
        return x$3.queries().looseBBox();
    }

    private static final /* synthetic */ boolean simpleGeoms$lzycompute$1(LazyBoolean simpleGeoms$lzy$1, Option values$1) {
        boolean bl;
        LazyBoolean lazyBoolean = simpleGeoms$lzy$1;
        synchronized (lazyBoolean) {
            bl = simpleGeoms$lzy$1.initialized() ? simpleGeoms$lzy$1.value() : simpleGeoms$lzy$1.initialize(((IterableLike)Option$.MODULE$.option2Iterable(values$1).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.geometries().values(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)geometry -> BoxesRunTime.boxToBoolean((boolean)GeometryUtils$.MODULE$.isRectangular(geometry))));
        }
        return bl;
    }

    private static final boolean simpleGeoms$1(LazyBoolean simpleGeoms$lzy$1, Option values$1) {
        if (simpleGeoms$lzy$1.initialized()) {
            return simpleGeoms$lzy$1.value();
        }
        return S2IndexKeySpace.simpleGeoms$lzycompute$1(simpleGeoms$lzy$1, values$1);
    }

    public S2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Expected field ").append($this.geomField).append(" to have a point binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        this.sfc = S2SFC$.MODULE$.apply(QueryProperties$.MODULE$.S2MinLevel(), QueryProperties$.MODULE$.S2MaxLevel(), QueryProperties$.MODULE$.S2LevelMod(), QueryProperties$.MODULE$.S2MaxCells());
        this.geomIndex = sft.indexOf(geomField);
        this.attributes = (Seq)new .colon.colon((Object)geomField, (List)Nil$.MODULE$);
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

