/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.s3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.S2SFC;
import org.locationtech.geomesa.curve.S2SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.s3.S3IndexKeySpace$;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001\u0002\u0014(\u0001MB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005/\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000bY\u0004A\u0011A<\t\u000fu\u0004!\u0019!C\u0005}\"9\u00111\u0002\u0001!\u0002\u0013y\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011BA\b\u0011!\tY\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\ty\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA!\u0001\t\u0007I\u0011BA\b\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005E\u0001\"CA#\u0001\t\u0007I\u0011BA$\u0011!\t\t\u0006\u0001Q\u0001\n\u0005%\u0003\"CA*\u0001\t\u0007I\u0011BA+\u0011!\tY\b\u0001Q\u0001\n\u0005]\u0003\"CA?\u0001\t\u0007I\u0011IA@\u0011!\t\t\n\u0001Q\u0001\n\u0005\u0005\u0005\"CAJ\u0001\t\u0007I\u0011IAK\u0011!\ty\u000b\u0001Q\u0001\n\u0005]\u0005\"CAY\u0001\t\u0007I\u0011IAZ\u0011!\t)\f\u0001Q\u0001\n\u0005\r\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003W\u0004A\u0011IAw\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqA!\n\u0001\t\u0003\u00129\u0003C\u0004\u00038\u0001!\tE!\u000f\b\u000f\t-t\u0005#\u0001\u0003n\u00191ae\nE\u0001\u0005_BaA\u001e\u0012\u0005\u0002\t}\u0004b\u0002BAE\u0011\u0005#1\u0011\u0005\b\u0005\u0013\u0013C\u0011\tBF\u0005=\u00196'\u00138eKb\\U-_*qC\u000e,'B\u0001\u0015*\u0003\t\u00198G\u0003\u0002+W\u0005)\u0011N\u001c3fq*\u0011!\u0006\f\u0006\u0003[9\nqaZ3p[\u0016\u001c\u0018M\u0003\u00020a\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001iiZ\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0003<}\u0001CU\"\u0001\u001f\u000b\u0005uZ\u0013aA1qS&\u0011q\b\u0010\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005\u0005+eB\u0001\"D\u001b\u00059\u0013B\u0001#(\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u001bM\u001b\u0014J\u001c3fqZ\u000bG.^3t\u0015\t!u\u0005\u0005\u0002B\u0013&\u0011!j\u0012\u0002\u000b'NJe\u000eZ3y\u0017\u0016L\bC\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012a\u0016\t\u00031\u0002l\u0011!\u0017\u0006\u00035n\u000baa]5na2,'B\u0001/^\u0003\u001d1W-\u0019;ve\u0016T!!\u00100\u000b\u0005}\u0003\u0014\u0001C4f_R|w\u000e\\:\n\u0005\u0005L&!E*j[BdWMR3biV\u0014X\rV=qK\u0006!1O\u001a;!\u0003!\u0019\b.\u0019:eS:<W#A3\u0011\u0005m2\u0017BA4=\u00055\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hs\u0006I1\u000f[1sI&tw\rI\u0001\nO\u0016|WNR5fY\u0012\u0004\"a\u001b:\u000f\u00051\u0004\bCA77\u001b\u0005q'BA83\u0003\u0019a$o\\8u}%\u0011\u0011ON\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rm\u0005AA\r^4GS\u0016dG-\u0001\u0004=S:LGO\u0010\u000b\u0006qfT8\u0010 \t\u0003\u0005\u0002AQ!V\u0004A\u0002]CQaY\u0004A\u0002\u0015DQ![\u0004A\u0002)DQ!^\u0004A\u0002)\f1a\u001d4d+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015A&A\u0003dkJ4X-\u0003\u0003\u0002\n\u0005\r!!B*3'\u001a\u001b\u0015\u0001B:gG\u0002\n\u0011bZ3p[&sG-\u001a=\u0016\u0005\u0005E\u0001cA\u001b\u0002\u0014%\u0019\u0011Q\u0003\u001c\u0003\u0007%sG/\u0001\u0006hK>l\u0017J\u001c3fq\u0002\n\u0001\u0002\u001a;h\u0013:$W\r_\u0001\nIR<\u0017J\u001c3fq\u0002\n1\u0002^5nKR{\u0017J\u001c3fqV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tID\u0004\u0003\u0002&\u0005Ub\u0002BA\u0014\u0003gqA!!\u000b\u000229!\u00111FA\u0018\u001d\ri\u0017QF\u0005\u0002c%\u0011q\u0006M\u0005\u0003[9J1!!\u0002-\u0013\u0011\t9$a\u0001\u0002\u0015\tKgN\\3e)&lW-\u0003\u0003\u0002<\u0005u\"\u0001\u0005+j[\u0016$vNQ5o]\u0016$G+[7f\u0015\u0011\t9$a\u0001\u0002\u0019QLW.\u001a+p\u0013:$W\r\u001f\u0011\u0002\u000f5\f\u0007\u0010V5nK\u0006AQ.\u0019=US6,\u0007%A\u0006eCR,Gk\\%oI\u0016DXCAA%!\u0011\tY%!\u0014\u000f\t\u0005\u0005\u0011QG\u0005\u0005\u0003\u001f\niD\u0001\tECR,Gk\u001c\"j]:,G\rV5nK\u0006aA-\u0019;f)>Le\u000eZ3yA\u0005i!m\\;oIN$v\u000eR1uKN,\"!a\u0016\u0011\u000fU\nI&!\u0018\u0002z%\u0019\u00111\f\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cB\u001b\u0002`\u0005\r\u00141M\u0005\u0004\u0003C2$A\u0002+va2,'\u0007E\u00036\u0003K\nI'C\u0002\u0002hY\u0012aa\u00149uS>t\u0007\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0005i&lWM\u0003\u0002\u0002t\u0005!!.\u0019<b\u0013\u0011\t9(!\u001c\u0003\u001bi{g.\u001a3ECR,G+[7f!\u001d)\u0014qLA5\u0003S\naBY8v]\u0012\u001cHk\u001c#bi\u0016\u001c\b%\u0001\u0006biR\u0014\u0018NY;uKN,\"!!!\u0011\u000b\u0005\r\u00151\u00126\u000f\t\u0005\u0015\u0015\u0011\u0012\b\u0004[\u0006\u001d\u0015\"A\u001c\n\u0005\u00113\u0014\u0002BAG\u0003\u001f\u00131aU3r\u0015\t!e'A\u0006biR\u0014\u0018NY;uKN\u0004\u0013AE5oI\u0016D8*Z=CsR,G*\u001a8hi\",\"!a&\u0011\u0011\u0005\r\u0015\u0011TAO\u0003#IA!a'\u0002\u0010\n)!+[4iiBYQ'a(\u0002$\u0006E\u0011\u0011CA\t\u0013\r\t\tK\u000e\u0002\n\rVt7\r^5p]N\u0002R!NAS\u0003SK1!a*7\u0005\u0015\t%O]1z!\r)\u00141V\u0005\u0004\u0003[3$\u0001\u0002\"zi\u0016\f1#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQ\u0002\nqa\u001d5be&tw-\u0006\u0002\u0002$\u0006A1\u000f[1sS:<\u0007%\u0001\u0006u_&sG-\u001a=LKf$\"\"a/\u0002P\u0006e\u0017Q\\Aq!\u0015\ti,!3I\u001d\u0011\ty,a2\u000f\t\u0005\u0005\u0017Q\u0019\b\u0005\u0003O\t\u0019-\u0003\u0002+Y%\u0011QhK\u0005\u0003\trJA!a3\u0002N\nY!k\\<LKf4\u0016\r\\;f\u0015\t!E\bC\u0004\u0002Rr\u0001\r!a5\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u00042aOAk\u0013\r\t9\u000e\u0010\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"9\u00111\u001c\u000fA\u0002\u0005\r\u0016\u0001\u0002;jKJDq!a8\u001d\u0001\u0004\t\u0019+\u0001\u0002jI\"I\u00111\u001d\u000f\u0011\u0002\u0003\u0007\u0011Q]\u0001\bY\u0016t\u0017.\u001a8u!\r)\u0014q]\u0005\u0004\u0003S4$a\u0002\"p_2,\u0017M\\\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015\u0001\u0015q^A\u007f\u0011\u001d\t\t0\ba\u0001\u0003g\faAZ5mi\u0016\u0014\b\u0003BA{\u0003sl!!a>\u000b\u0007\u0005EX,\u0003\u0003\u0002|\u0006](A\u0002$jYR,'\u000fC\u0004\u0002\u0000v\u0001\rA!\u0001\u0002\u000f\u0015D\b\u000f\\1j]B!!1\u0001B\u0005\u001b\t\u0011)AC\u0002\u0003\b-\nQ!\u001e;jYNLAAa\u0003\u0003\u0006\tIQ\t\u001f9mC&tWM]\u0001\nO\u0016$(+\u00198hKN$bA!\u0005\u0003\u001e\t\u0005\u0002CBAB\u0005'\u00119\"\u0003\u0003\u0003\u0016\u0005=%\u0001C%uKJ\fGo\u001c:\u0011\u000b\u0005u&\u0011\u0004%\n\t\tm\u0011Q\u001a\u0002\n'\u000e\fgNU1oO\u0016DaAa\b\u001f\u0001\u0004\u0001\u0015A\u0002<bYV,7\u000fC\u0005\u0003$y\u0001\n\u00111\u0001\u0002\u0012\u0005QQ.\u001e7uSBd\u0017.\u001a:\u0002\u001b\u001d,GOU1oO\u0016\u0014\u0015\u0010^3t)\u0019\u0011IC!\r\u00036A1\u00111\u0011B\n\u0005W\u0001B!!0\u0003.%!!qFAg\u0005%\u0011\u0015\u0010^3SC:<W\rC\u0004\u00034}\u0001\rA!\u0005\u0002\rI\fgnZ3t\u0011%\tYn\bI\u0001\u0002\u0004\t)/A\u0007vg\u00164U\u000f\u001c7GS2$XM\u001d\u000b\t\u0003K\u0014YDa\u0010\u0003X!9!q\u0004\u0011A\u0002\tu\u0002\u0003B\u001b\u0002f\u0001CqA!\u0011!\u0001\u0004\u0011\u0019%\u0001\u0004d_:4\u0017n\u001a\t\u0006k\u0005\u0015$Q\t\t\u0005\u0005\u000f\u0012\tF\u0004\u0003\u0003J\t5SB\u0001B&\u0015\ty6&\u0003\u0003\u0003P\t-\u0013aF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\r\u0006\u001cGo\u001c:z\u0013\u0011\u0011\u0019F!\u0016\u0003-\u001d+w.T3tC\u0012\u000bG/Y*u_J,7i\u001c8gS\u001eTAAa\u0014\u0003L!9!\u0011\f\u0011A\u0002\tm\u0013!\u00025j]R\u001c\b\u0003\u0002B/\u0005Oj!Aa\u0018\u000b\t\t\u0005$1M\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\u0011)GX\u0001\u0005kRLG.\u0003\u0003\u0003j\t}#!\u0002%j]R\u001c\u0018aD*4\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005\t\u00133\u0003\u0002\u00125\u0005c\u0002bAa\u001d\u0003z\u0001Ce\u0002BA`\u0005kJ1Aa\u001e=\u00035Ie\u000eZ3y\u0017\u0016L8\u000b]1dK&!!1\u0010B?\u0005QIe\u000eZ3y\u0017\u0016L8\u000b]1dK\u001a\u000b7\r^8ss*\u0019!q\u000f\u001f\u0015\u0005\t5\u0014\u0001C:vaB|'\u000f^:\u0015\r\u0005\u0015(Q\u0011BD\u0011\u0015)F\u00051\u0001X\u0011\u001d\ti\b\na\u0001\u0003\u0003\u000bQ!\u00199qYf$r\u0001\u001fBG\u0005\u001f\u0013\t\nC\u0003VK\u0001\u0007q\u000bC\u0004\u0002~\u0015\u0002\r!!!\t\u000f\u0005mW\u00051\u0001\u0002f\u0002")
public class S3IndexKeySpace
implements IndexKeySpace<package.S3IndexValues, package.S3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final String dtgField;
    private final S2SFC sfc;
    private final int geomIndex;
    private final int dtgIndex;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final int maxTime;
    private final Function1<ZonedDateTime, BinnedTime> dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static S3IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return S3IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return S3IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        S3IndexKeySpace s3IndexKeySpace = this;
        synchronized (s3IndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    private S2SFC sfc() {
        return this.sfc;
    }

    private int geomIndex() {
        return this.geomIndex;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    private Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    private int maxTime() {
        return this.maxTime;
    }

    private Function1<ZonedDateTime, BinnedTime> dateToIndex() {
        return this.dateToIndex;
    }

    private Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates() {
        return this.boundsToDates;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<package.S3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        try {
            l = this.sfc().index(geom.getX(), geom.getY(), lenient);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(37).append("Invalid s value from geometry/time: ").append(geom).append(",").append(dtg).toString(), e);
            }
            throw throwable;
        }
        long s = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 14 + id.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, ByteArrays$.MODULE$.writeShort$default$3());
            ByteArrays$.MODULE$.writeLong(s, bytes, 2);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 10);
            System.arraycopy(id, 0, bytes, 14, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(s, bytes, 3);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 11);
            System.arraycopy(id, 0, bytes, 15, id.length);
        }
        return new package.SingleRowKeyValue<package.S3IndexKey>(bytes, this.sharing(), shard, new package.S3IndexKey(b2, s, (int)t2), tier, id, writable.values());
    }

    @Override
    public package.S3IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, FilterHelper$.MODULE$.extractGeometries$default$3());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$1 = filter;
        String x$22 = this.dtgField;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$22, x$4, x$3);
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Intervals: ").append(intervals).toString());
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disjoint geometries or dates extracted, short-circuiting to empty query");
            return new package.S3IndexValues(this.sfc(), this.maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Nil$.MODULE$), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Nil$.MODULE$));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> GeometryUtils$.MODULE$.bounds(x$2, multiplier, bits), Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        intervals.foreach((Function1 & Serializable & scala.Serializable)interval -> {
            Tuple2 tuple2 = (Tuple2)this.boundsToDates().apply((Object)interval.bounds());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZonedDateTime lower = (ZonedDateTime)tuple2._1();
            ZonedDateTime upper = (ZonedDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
            ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
            ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
            BinnedTime binnedTime = (BinnedTime)this.dateToIndex().apply((Object)lower2);
            if (binnedTime == null) {
                throw new MatchError((Object)binnedTime);
            }
            short lb = binnedTime.bin();
            long lt = binnedTime.offset();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
            short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long lt2 = tuple23._2$mcJ$sp();
            BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex().apply((Object)upper2);
            if (binnedTime2 == null) {
                throw new MatchError((Object)binnedTime2);
            }
            short ub = binnedTime2.bin();
            long ut = binnedTime2.offset();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
            short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
            long ut2 = tuple24._2$mcJ$sp();
            if (interval.isBoundedBothSides()) {
                if (lb2 == ub2) {
                    timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, (int)ut2), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                    return BoxedUnit.UNIT;
                }
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, this.maxTime()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(0, (int)ut2), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> timesByBin.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)new .colon.colon((Object)new Tuple2.mcII.sp(0, this.maxTime()), (List)Nil$.MODULE$)));
                return BoxedUnit.UNIT;
            }
            if (interval.lower().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, this.maxTime()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            }
            if (interval.upper().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(0, (int)ut2), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
            }
            return BoxedUnit.UNIT;
        });
        return new package.S3IndexValues(this.sfc(), this.maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.S3IndexKey>> getRanges(package.S3IndexValues values, int multiplier) {
        package.S3IndexValues s3IndexValues = values;
        if (s3IndexValues == null) {
            throw new MatchError((Object)s3IndexValues);
        }
        S2SFC s3 = s3IndexValues.sfc();
        FilterValues<Geometry> geoms = s3IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = s3IndexValues.spatialBounds();
        FilterValues<Bounds<ZonedDateTime>> intervals = s3IndexValues.intervals();
        Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = s3IndexValues.temporalBounds();
        Seq<Tuple2<Object, Object>> unboundedBins = s3IndexValues.temporalUnbounded();
        Tuple6 tuple6 = new Tuple6((Object)s3, geoms, xy, intervals, timesByBin, unboundedBins);
        S2SFC s32 = (S2SFC)tuple6._1();
        FilterValues geoms2 = (FilterValues)tuple6._2();
        Seq xy2 = (Seq)tuple6._3();
        FilterValues intervals2 = (FilterValues)tuple6._4();
        Map timesByBin2 = (Map)tuple6._5();
        Seq unboundedBins2 = (Seq)tuple6._6();
        if (geoms2.disjoint() || intervals2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (timesByBin2.isEmpty() && unboundedBins2.isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<Object>(null));
        }
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, timesByBin2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / timesByBin2.size() / multiplier)));
        Seq s2CellId = s32.ranges(xy2, -1, target);
        Iterator bounded = timesByBin2.iterator().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq times = (Seq)tuple2._2();
                return (Seq)times.flatMap((Function1 & Serializable & scala.Serializable)time -> (Seq)s2CellId.map((Function1 & Serializable & scala.Serializable)s -> new package.BoundedRange<package.S3IndexKey>(new package.S3IndexKey(bin, s.lower(), time._1$mcI$sp()), new package.S3IndexKey(bin, s.upper(), time._2$mcI$sp())), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator unbounded = unboundedBins2.iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s && Short.MAX_VALUE == s2) {
                    return new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
                }
            }
            if (tuple2 != null) {
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (Short.MAX_VALUE == s) {
                    return new package.LowerBoundedRange<package.S3IndexKey>(new package.S3IndexKey(lower, 0L, 0));
                }
            }
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s) {
                    return new package.UpperBoundedRange<package.S3IndexKey>(new package.S3IndexKey(upper, 0L, Integer.MAX_VALUE));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
            }
            throw new MatchError((Object)tuple2);
        });
        return bounded.$plus$plus((Function0 & Serializable & scala.Serializable)() -> unbounded);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.S3IndexKey>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                    package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                    return new package.BoundedByteRange(lower, upper);
                }
                if (scanRange instanceof package.LowerBoundedRange) {
                    package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                    package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                if (scanRange instanceof package.UpperBoundedRange) {
                    package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                    package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset()));
                }
                if (scanRange instanceof package.UnboundedRange) {
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.UnboundedRange) {
                return new .colon.colon((Object)new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange()), (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.S3IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public S3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        this.dtgField = dtgField;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Expected field ").append($this.geomField).append(" to have a point binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Expected field ").append($this.dtgField).append(" to have a date binding, but instead it has: ").append(this.sft().getDescriptor($this.dtgField).getType().getBinding().getSimpleName()).toString());
        this.sfc = S2SFC$.MODULE$.apply(QueryProperties$.MODULE$.S2MinLevel(), QueryProperties$.MODULE$.S2MaxLevel(), QueryProperties$.MODULE$.S2LevelMod(), QueryProperties$.MODULE$.S2MaxCells());
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.maxTime = (int)BinnedTime$.MODULE$.maxOffset(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.attributes = (Seq)new .colon.colon((Object)geomField, (List)new .colon.colon((Object)dtgField, (List)Nil$.MODULE$));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(14 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

