/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u000f\u001f\u0001)B\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!A!\u0002\u00139\u0006\"\u00022\u0001\t\u0003\u0019\u0007b\u00025\u0001\u0005\u0004%\t\"\u001b\u0005\u0007[\u0002\u0001\u000b\u0011\u00026\t\u000f9\u0004!\u0019!C\t_\"1a\u000f\u0001Q\u0001\nADqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0011\u007f\u0011\u001d\ty\u0001\u0001Q\u0001\n}D\u0011\"!\u0005\u0001\u0005\u0004%\t%a\u0005\t\u0011\u00055\u0002\u0001)A\u0005\u0003+A\u0011\"a\f\u0001\u0005\u0004%\t%!\r\t\u0011\u0005M\u0002\u0001)A\u0005\u0003CAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBA^\u0001\u0011\u0005\u0013QX\u0004\b\u0003kt\u0002\u0012AA|\r\u0019ib\u0004#\u0001\u0002z\"1!-\u0007C\u0001\u0005\u0013AqAa\u0003\u001a\t\u0003\u0012i\u0001C\u0004\u0003\u0014e!\tE!\u0006\u0003!aS&'\u00138eKb\\U-_*qC\u000e,'BA\u0010!\u0003\tQ(G\u0003\u0002\"E\u0005)\u0011N\u001c3fq*\u0011\u0011e\t\u0006\u0003I\u0015\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002'O\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u001a6o}j\u0011a\r\u0006\u0003i\t\n1!\u00199j\u0013\t14GA\u0007J]\u0012,\u0007pS3z'B\f7-\u001a\t\u0003qqr!!\u000f\u001e\u000e\u0003yI!a\u000f\u0010\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u000f1j\u0013\u0014J\u001c3fqZ\u000bG.^3t\u0015\tYd\u0004\u0005\u0002-\u0001&\u0011\u0011)\f\u0002\u0005\u0019>tw-A\u0002tMR,\u0012\u0001\u0012\t\u0003\u000b6k\u0011A\u0012\u0006\u0003\u000f\"\u000baa]5na2,'BA%K\u0003\u001d1W-\u0019;ve\u0016T!\u0001N&\u000b\u00051;\u0013\u0001C4f_R|w\u000e\\:\n\u000593%!E*j[BdWMR3biV\u0014X\rV=qK\u0006!1O\u001a;!\u0003!\u0019\b.\u0019:eS:<W#\u0001*\u0011\u0005I\u001a\u0016B\u0001+4\u00055\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hs\u0006I1\u000f[1sI&tw\rI\u0001\nO\u0016|WNR5fY\u0012\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001..\u001b\u0005Y&B\u0001/*\u0003\u0019a$o\\8u}%\u0011a,L\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_[\u00051A(\u001b8jiz\"B\u0001Z3gOB\u0011\u0011\b\u0001\u0005\u0006\u0005\u001a\u0001\r\u0001\u0012\u0005\u0006!\u001a\u0001\rA\u0015\u0005\u0006-\u001a\u0001\raV\u0001\nO\u0016|W.\u00138eKb,\u0012A\u001b\t\u0003Y-L!\u0001\\\u0017\u0003\u0007%sG/\u0001\u0006hK>l\u0017J\u001c3fq\u0002\n1a\u001d4d+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:$\u0003\u0015\u0019WO\u001d<f\u0013\t)(O\u0001\u0004Y5J\u001afiQ\u0001\u0005g\u001a\u001c\u0007%\u0001\u0005jgB{\u0017N\u001c;t+\u0005I\bC\u0001\u0017{\u0013\tYXFA\u0004C_>dW-\u00198\u0002\u0013%\u001c\bk\\5oiN\u0004\u0013AC1uiJL'-\u001e;fgV\tq\u0010E\u0003\u0002\u0002\u0005%qK\u0004\u0003\u0002\u0004\u0005\u001dab\u0001.\u0002\u0006%\ta&\u0003\u0002<[%!\u00111BA\u0007\u0005\r\u0019V-\u001d\u0006\u0003w5\n1\"\u0019;ue&\u0014W\u000f^3tA\u0005\u0011\u0012N\u001c3fq.+\u0017PQ=uK2+gn\u001a;i+\t\t)\u0002E\u0004\u0002\u0002\u0005]\u00111\u00046\n\t\u0005e\u0011Q\u0002\u0002\u0006%&<\u0007\u000e\u001e\t\tY\u0005u\u0011\u0011\u00056kU&\u0019\u0011qD\u0017\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004#\u0002\u0017\u0002$\u0005\u001d\u0012bAA\u0013[\t)\u0011I\u001d:bsB\u0019A&!\u000b\n\u0007\u0005-RF\u0001\u0003CsR,\u0017aE5oI\u0016D8*Z=CsR,G*\u001a8hi\"\u0004\u0013aB:iCJLgnZ\u000b\u0003\u0003C\t\u0001b\u001d5be&tw\rI\u0001\u000bi>Le\u000eZ3y\u0017\u0016LHCCA\u001d\u00033\n\u0019'a\u001a\u0002lA)\u00111HA*\u007f9!\u0011QHA)\u001d\u0011\ty$a\u0014\u000f\t\u0005\u0005\u0013Q\n\b\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005%cb\u0001.\u0002H%\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0003C\rJ!\u0001\u000e\u0012\n\u0005m\u001a\u0014\u0002BA+\u0003/\u00121BU8x\u0017\u0016Lh+\u00197vK*\u00111h\r\u0005\b\u00037\u001a\u0002\u0019AA/\u0003!9(/\u001b;bE2,\u0007c\u0001\u001a\u0002`%\u0019\u0011\u0011M\u001a\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016Dq!!\u001a\u0014\u0001\u0004\t\t#\u0001\u0003uS\u0016\u0014\bbBA5'\u0001\u0007\u0011\u0011E\u0001\u0003S\u0012D\u0001\"!\u001c\u0014!\u0003\u0005\r!_\u0001\bY\u0016t\u0017.\u001a8u\u000399W\r^%oI\u0016Dh+\u00197vKN$RaNA:\u0003\u0003Cq!!\u001e\u0015\u0001\u0004\t9(\u0001\u0004gS2$XM\u001d\t\u0005\u0003s\ni(\u0004\u0002\u0002|)\u0019\u0011Q\u000f&\n\t\u0005}\u00141\u0010\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\rE\u00031\u0001\u0002\u0006\u00069Q\r\u001f9mC&t\u0007\u0003BAD\u0003\u001bk!!!#\u000b\u0007\u0005-%%A\u0003vi&d7/\u0003\u0003\u0002\u0010\u0006%%!C#ya2\f\u0017N\\3s\u0003%9W\r\u001e*b]\u001e,7\u000f\u0006\u0004\u0002\u0016\u0006\u0005\u0016Q\u0015\t\u0007\u0003\u0003\t9*a'\n\t\u0005e\u0015Q\u0002\u0002\t\u0013R,'/\u0019;peB)\u00111HAO\u007f%!\u0011qTA,\u0005%\u00196-\u00198SC:<W\r\u0003\u0004\u0002$V\u0001\raN\u0001\u0007m\u0006dW/Z:\t\u0011\u0005\u001dV\u0003%AA\u0002)\f!\"\\;mi&\u0004H.[3s\u000359W\r\u001e*b]\u001e,')\u001f;fgR1\u0011QVA[\u0003s\u0003b!!\u0001\u0002\u0018\u0006=\u0006\u0003BA\u001e\u0003cKA!a-\u0002X\tI!)\u001f;f%\u0006tw-\u001a\u0005\b\u0003o3\u0002\u0019AAK\u0003\u0019\u0011\u0018M\\4fg\"A\u0011Q\r\f\u0011\u0002\u0003\u0007\u00110A\u0007vg\u00164U\u000f\u001c7GS2$XM\u001d\u000b\bs\u0006}\u0016qYAq\u0011\u001d\t\u0019k\u0006a\u0001\u0003\u0003\u0004B\u0001LAbo%\u0019\u0011QY\u0017\u0003\r=\u0003H/[8o\u0011\u001d\tIm\u0006a\u0001\u0003\u0017\faaY8oM&<\u0007#\u0002\u0017\u0002D\u00065\u0007\u0003BAh\u00037tA!!5\u0002V:!\u0011qHAj\u0013\ta%%\u0003\u0003\u0002X\u0006e\u0017aF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\r\u0006\u001cGo\u001c:z\u0015\ta%%\u0003\u0003\u0002^\u0006}'AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\t\u0005]\u0017\u0011\u001c\u0005\b\u0003G<\u0002\u0019AAs\u0003\u0015A\u0017N\u001c;t!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\fqAZ1di>\u0014\u0018PC\u0002\u0002p.\u000bA!\u001e;jY&!\u00111_Au\u0005\u0015A\u0015N\u001c;t\u0003AA&LM%oI\u0016D8*Z=Ta\u0006\u001cW\r\u0005\u0002:3M!\u0011dKA~!\u0019\tiPa\u00018\u007f9!\u0011QHA\u0000\u0013\r\u0011\taM\u0001\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\n\t\t\u0015!q\u0001\u0002\u0015\u0013:$W\r_&fsN\u0003\u0018mY3GC\u000e$xN]=\u000b\u0007\t\u00051\u0007\u0006\u0002\u0002x\u0006A1/\u001e9q_J$8\u000fF\u0003z\u0005\u001f\u0011\t\u0002C\u0003C7\u0001\u0007A\tC\u0003~7\u0001\u0007q0A\u0003baBd\u0017\u0010F\u0004e\u0005/\u0011IBa\u0007\t\u000b\tc\u0002\u0019\u0001#\t\u000bud\u0002\u0019A@\t\r\u0005\u0015D\u00041\u0001z\u0001")
public class XZ2IndexKeySpace
implements IndexKeySpace<package.XZ2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final int geomIndex;
    private final XZ2SFC sfc;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static XZ2IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return XZ2IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return XZ2IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public XZ2SFC sfc() {
        return this.sfc;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Envelope envelope = geom.getEnvelopeInternal();
        try {
            l = this.sfc().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), lenient);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(32).append("Invalid xz value from geometry: ").append(geom).toString(), e);
            }
            throw throwable;
        }
        long xz = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            ByteArrays$.MODULE$.writeLong(xz, bytes, 0);
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            ByteArrays$.MODULE$.writeLong(xz, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)xz), tier, id, writable.values());
    }

    @Override
    public package.XZ2IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> GeometryUtils$.MODULE$.bounds(x$1, multiplier, bits), Seq$.MODULE$.canBuildFrom());
        return new package.XZ2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.XZ2IndexValues values, int multiplier) {
        package.XZ2IndexValues xZ2IndexValues = values;
        if (xZ2IndexValues == null) {
            throw new MatchError((Object)xZ2IndexValues);
        }
        XZ2SFC sfc = xZ2IndexValues.sfc();
        Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.spatialBounds();
        Tuple2 tuple2 = new Tuple2((Object)sfc, xy);
        XZ2SFC sfc2 = (XZ2SFC)tuple2._1();
        Seq xy2 = (Seq)tuple2._2();
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / multiplier)));
        return sfc2.ranges(xy2, target).iterator().map((Function1 & Serializable & scala.Serializable)r -> new package$BoundedRange$mcJ$sp(r.lower(), r.upper()));
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                long lo = boundedRange.lower$mcJ$sp();
                long hi = boundedRange.upper$mcJ$sp();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ2IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public XZ2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Expected field ").append($this.geomField).append(" to have a geometry binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        this.geomIndex = sft.indexOf(geomField);
        this.sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Class clazz = sft.getDescriptor(this.geomIndex()).getType().getBinding();
        Class<Point> clazz2 = Point.class;
        this.isPoints = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        this.attributes = (Seq)new .colon.colon((Object)geomField, (List)Nil$.MODULE$);
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

