/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2.legacy;

import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.ShardStrategy$Z2ShardStrategy$;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.z2.Z2Index;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001\u0002\u000f\u001e\u0001-B\u0011\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r$\t\u0013-\u0003!\u0011!Q\u0001\n13\u0006\"C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\\\u0011!a\u0006A!A!\u0002\u0013i\u0006\"\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5~\u0011\u0015q\b\u0001\"\u0005\u0000\u0011\u0019q\b\u0001\"\u0001\u0002\u0018!I\u00111\u0006\u0001C\u0002\u0013E\u0013Q\u0006\u0005\b\u0003_\u0001\u0001\u0015!\u0003^\u0011%\t\t\u0004\u0001b\u0001\n\u0003\n\u0019\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001b\u000f\u001d\ti$\bE\u0001\u0003\u007f1a\u0001H\u000f\t\u0002\u0005\u0005\u0003B\u0002@\u000e\t\u0003\tIE\u0002\u0004\u0002L5\u0001\u0011Q\n\u0005\u000b\u0017>\u0011\t\u0011)A\u0005\u0019\u0006=\u0003BCA)\u001f\t\u0015\r\u0011\"\u0011\u0002T!Q\u0011\u0011M\b\u0003\u0002\u0003\u0006I!!\u0016\t\u0019\u0005\rtB!A!\u0002\u0013\t)'!\u001c\t\u0013\u0005=tB!A!\u0002\u0013i\u0006B\u0002@\u0010\t\u0003\t\t\bC\u0005\u0002\u0000=\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011QS\b!\u0002\u0013\t\u0019\tC\u0005\u0002\u0018>\u0011\r\u0011\"\u0011\u0002\u001a\"A\u0011qU\b!\u0002\u0013\tY\nC\u0004\u0002*>!\t%a+\t\u000f\u0005\rx\u0002\"\u0011\u0002f\nI!LM%oI\u0016Dh\u000b\u000e\u0006\u0003=}\ta\u0001\\3hC\u000eL(B\u0001\u0011\"\u0003\tQ(G\u0003\u0002#G\u0005)\u0011N\u001c3fq*\u0011!\u0005\n\u0006\u0003K\u0019\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002(Q\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001YA\u0011QFL\u0007\u0002?%\u0011qf\b\u0002\b5JJe\u000eZ3y\u0003\t!7\u000f\r\u00023uA\u00191G\u000e\u001d\u000e\u0003QR!!N\u0012\u0002\u0011\u001d,w\u000e^8pYNL!a\u000e\u001b\u0003!\u001d+w.T3tC\u0012\u000bG/Y*u_J,\u0007CA\u001d;\u0019\u0001!\u0011bO\u0001\u0002\u0002\u0003\u0005)\u0011\u0001\u001f\u0003\u0007}#\u0013'\u0005\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9aj\u001c;iS:<\u0007C\u0001 E\u0013\t)uHA\u0002B]fL!\u0001M$\n\u0005!K%aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D(B\u0001&$\u0003\r\t\u0007/[\u0001\u0004g\u001a$\bCA'U\u001b\u0005q%BA(Q\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011KU\u0001\bM\u0016\fG/\u001e:f\u0015\tQ5K\u0003\u00026Q%\u0011QK\u0014\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017BA&H\u0003\u001d1XM]:j_:\u0004\"AP-\n\u0005i{$aA%oi&\u0011qkR\u0001\u0005O\u0016|W\u000e\u0005\u0002_K:\u0011ql\u0019\t\u0003A~j\u0011!\u0019\u0006\u0003E*\na\u0001\u0010:p_Rt\u0014B\u00013@\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011|\u0014\u0001B7pI\u0016\u0004\"A\u001b>\u000f\u0005-<hB\u00017v\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003ABL\u0011!K\u0005\u0003O!J!!\n\u0014\n\u0005Q$\u0013!B;uS2\u001c\u0018B\u0001\u0012w\u0015\t!H%\u0003\u0002ys\u0006I\u0011J\u001c3fq6{G-\u001a\u0006\u0003EYL!a\u001f?\u0003\u0013%sG-\u001a=N_\u0012,'B\u0001=z\u0013\tAw)\u0001\u0004=S:LGO\u0010\u000b\r\u0003\u0003\t)!a\u0004\u0002\u0012\u0005M\u0011Q\u0003\t\u0004\u0003\u0007\u0001Q\"A\u000f\t\rA2\u0001\u0019AA\u0004a\u0011\tI!!\u0004\u0011\tM2\u00141\u0002\t\u0004s\u00055AAC\u001e\u0002\u0006\u0005\u0005\t\u0011!B\u0001y!)1J\u0002a\u0001\u0019\")qK\u0002a\u00011\")AL\u0002a\u0001;\")\u0001N\u0002a\u0001SRQ\u0011\u0011AA\r\u0003K\t9#!\u000b\t\rA:\u0001\u0019AA\u000ea\u0011\ti\"!\t\u0011\tM2\u0014q\u0004\t\u0004s\u0005\u0005BaCA\u0012\u00033\t\t\u0011!A\u0003\u0002q\u00121a\u0018\u00133\u0011\u0015Yu\u00011\u0001M\u0011\u0015av\u00011\u0001^\u0011\u0015Aw\u00011\u0001j\u00031!\u0018M\u00197f\u001d\u0006lWmS3z+\u0005i\u0016!\u0004;bE2,g*Y7f\u0017\u0016L\b%\u0001\u0005lKf\u001c\u0006/Y2f+\t\t)\u0004E\u0002.\u0003oI1!!\u000f \u0005=Q&'\u00138eKb\\U-_*qC\u000e,\u0017!C6fsN\u0003\u0018mY3!\u0003%Q&'\u00138eKb4F\u0007E\u0002\u0002\u00045\u00192!DA\"!\rq\u0014QI\u0005\u0004\u0003\u000fz$AB!osJ+g\r\u0006\u0002\u0002@\t\t\"LM%oI\u0016D8*Z=Ta\u0006\u001cWM\u0016\u001b\u0014\u0007=\t)$C\u0002L\u0003o\tqa\u001d5be&tw-\u0006\u0002\u0002VA)a(a\u0016\u0002\\%\u0019\u0011\u0011L \u0003\u000b\u0005\u0013(/Y=\u0011\u0007y\ni&C\u0002\u0002`}\u0012AAQ=uK\u0006A1\u000f[1sS:<\u0007%\u0001\u0005tQ\u0006\u0014H-\u001b8h!\u0011\t9'!\u001b\u000e\u0003%K1!a\u001bJ\u00055\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hs&!\u00111MA\u001c\u0003%9Wm\\7GS\u0016dG\r\u0006\u0006\u0002t\u0005]\u0014\u0011PA>\u0003{\u00022!!\u001e\u0010\u001b\u0005i\u0001\"B&\u0016\u0001\u0004a\u0005bBA)+\u0001\u0007\u0011Q\u000b\u0005\b\u0003G*\u0002\u0019AA3\u0011\u0019\ty'\u0006a\u0001;\u0006i!/\u00198hKB\u0013XMZ5yKN,\"!a!\u0011\r\u0005\u0015\u0015qRA+\u001d\u0011\t9)a#\u000f\u0007\u0001\fI)C\u0001A\u0013\r\tiiP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t*a%\u0003\u0007M+\u0017OC\u0002\u0002\u000e~\naB]1oO\u0016\u0004&/\u001a4jq\u0016\u001c\b%\u0001\nj]\u0012,\u0007pS3z\u0005f$X\rT3oORDWCAAN!\u001d\t))!(\u0002\"bKA!a(\u0002\u0014\n)!+[4iiBAa(a)\u0002VaC\u0006,C\u0002\u0002&~\u0012\u0011BR;oGRLwN\\\u001a\u0002'%tG-\u001a=LKf\u0014\u0015\u0010^3MK:<G\u000f\u001b\u0011\u0002\u0015Q|\u0017J\u001c3fq.+\u0017\u0010\u0006\u0006\u0002.\u0006\u001d\u0017\u0011[Ak\u00033\u0004b!a,\u0002<\u0006\u0005g\u0002BAY\u0003ssA!a-\u00028:\u0019Q.!.\n\u0005\t\"\u0013B\u0001&$\u0013\r\ti)S\u0005\u0005\u0003{\u000byLA\u0006S_^\\U-\u001f,bYV,'bAAG\u0013B\u0019a(a1\n\u0007\u0005\u0015wH\u0001\u0003M_:<\u0007bBAe5\u0001\u0007\u00111Z\u0001\toJLG/\u00192mKB!\u0011qMAg\u0013\r\ty-\u0013\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"9\u00111\u001b\u000eA\u0002\u0005U\u0013\u0001\u0002;jKJDq!a6\u001b\u0001\u0004\t)&\u0001\u0002jI\"I\u00111\u001c\u000e\u0011\u0002\u0003\u0007\u0011Q\\\u0001\bY\u0016t\u0017.\u001a8u!\rq\u0014q\\\u0005\u0004\u0003C|$a\u0002\"p_2,\u0017M\\\u0001\u000eO\u0016$(+\u00198hK\nKH/Z:\u0015\r\u0005\u001d\u00181_A\u0000!\u0019\t))!;\u0002n&!\u00111^AJ\u0005!IE/\u001a:bi>\u0014\b\u0003BAX\u0003_LA!!=\u0002@\nI!)\u001f;f%\u0006tw-\u001a\u0005\b\u0003k\\\u0002\u0019AA|\u0003\u0019\u0011\u0018M\\4fgB1\u0011QQAu\u0003s\u0004b!a,\u0002|\u0006\u0005\u0017\u0002BA\u007f\u0003\u007f\u0013\u0011bU2b]J\u000bgnZ3\t\u0013\u0005M7\u0004%AA\u0002\u0005u\u0007")
public class Z2IndexV4
extends Z2Index {
    private final String tableNameKey = new StringBuilder(10).append("table.z2.v").append(super.version()).toString();
    private final Z2IndexKeySpace keySpace;

    @Override
    public String tableNameKey() {
        return this.tableNameKey;
    }

    @Override
    public Z2IndexKeySpace keySpace() {
        return this.keySpace;
    }

    public Z2IndexV4(GeoMesaDataStore<?> ds, SimpleFeatureType sft, int version, String geom, IndexMode.IndexMode mode) {
        super(ds, sft, version, geom, mode);
        this.keySpace = new Z2IndexKeySpaceV4(super.sft(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(super.sft())), ShardStrategy$Z2ShardStrategy$.MODULE$.apply(super.sft()), geom);
    }

    public Z2IndexV4(GeoMesaDataStore<?> ds, SimpleFeatureType sft, String geom, IndexMode.IndexMode mode) {
        this(ds, sft, 4, geom, mode);
    }

    public static class Z2IndexKeySpaceV4
    extends Z2IndexKeySpace {
        private final byte[] sharing;
        private final Seq<byte[]> rangePrefixes;
        private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;

        @Override
        public byte[] sharing() {
            return this.sharing;
        }

        private Seq<byte[]> rangePrefixes() {
            return this.rangePrefixes;
        }

        @Override
        public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
            return this.indexKeyByteLength;
        }

        @Override
        public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
            long l;
            Point geom = (Point)writable.getAttribute(this.geomIndex());
            if (geom == null) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
            }
            try {
                l = this.sfc().index(geom.getX(), geom.getY(), lenient);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringBuilder(31).append("Invalid z value from geometry: ").append(geom).toString(), e);
                }
                throw throwable;
            }
            long z = l;
            byte[] shard = super.sharding().apply(writable);
            byte[] bytes = (byte[])Array$.MODULE$.ofDim(this.sharing().length + shard.length + 8 + id.length, ClassTag$.MODULE$.Byte());
            int i = 0;
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.sharing())).isEmpty()) {
                bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.sharing())).head());
                ++i;
            }
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
                bytes[i] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
                ++i;
            }
            ByteArrays$.MODULE$.writeLong(z, bytes, i);
            System.arraycopy(id, 0, bytes, i + 8, id.length);
            return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)z), tier, id, writable.values());
        }

        @Override
        public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
            if (this.rangePrefixes().isEmpty()) {
                return ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    package.ScanRange scanRange = x0$1;
                    if (scanRange instanceof package.BoundedRange) {
                        package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                        long lo = boundedRange.lower$mcJ$sp();
                        long hi = boundedRange.upper$mcJ$sp();
                        return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    }
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
                });
            }
            return ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                package.ScanRange scanRange = x0$2;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    return (GenTraversableOnce)this.rangePrefixes().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }

        public Z2IndexKeySpaceV4(SimpleFeatureType sft, byte[] sharing, ShardStrategy sharding, String geomField) {
            this.sharing = sharing;
            super(sft, sharding, geomField);
            this.rangePrefixes = super.sharding().length() == 0 && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(sharing)).isEmpty() ? (Seq)Nil$.MODULE$ : (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(sharing)).isEmpty() ? super.sharding().shards() : (super.sharding().length() == 0 ? (Seq)new .colon.colon((Object)sharing, (List)Nil$.MODULE$) : (Seq)super.sharding().shards().map((Function1 & Serializable & scala.Serializable)x$1 -> ByteArrays$.MODULE$.concat(this.sharing(), x$1), Seq$.MODULE$.canBuildFrom())));
            this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharing.length + super.sharding().length())));
        }
    }
}

