/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.XZ3SFC;
import org.locationtech.geomesa.curve.XZ3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001\u0002\u0014(\u0001MB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005/\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000bY\u0004A\u0011A<\t\u000fu\u0004!\u0019!C\t}\"9\u0011Q\u0001\u0001!\u0002\u0013y\b\u0002CA\u0004\u0001\t\u0007I\u0011\u0003@\t\u000f\u0005%\u0001\u0001)A\u0005\u007f\"I\u00111\u0002\u0001C\u0002\u0013E\u0011Q\u0002\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011Q\u0004\u0001C\u0002\u0013E\u0011q\u0004\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002\"!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002F!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002T!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002~!I\u0011Q\u0011\u0001C\u0002\u0013\u0005\u0013q\u0011\u0005\t\u00033\u0003\u0001\u0015!\u0003\u0002\n\"I\u00111\u0014\u0001C\u0002\u0013\u0005\u0013Q\u0014\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002 \"I\u0011\u0011\u0018\u0001C\u0002\u0013\u0005\u00131\u0018\u0005\t\u0003{\u0003\u0001\u0015!\u0003\u0002,\"9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0007bBAw\u0001\u0011\u0005\u0013q\u001e\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u00119\u0003\u0001C!\u0005SAqA!\u000f\u0001\t\u0003\u0012YdB\u0004\u0003p\u001dB\tA!\u001d\u0007\r\u0019:\u0003\u0012\u0001B:\u0011\u00191(\u0005\"\u0001\u0003\u0004\"9!Q\u0011\u0012\u0005B\t\u001d\u0005b\u0002BGE\u0011\u0005#q\u0012\u0002\u00111j\u001b\u0014J\u001c3fq.+\u0017p\u00159bG\u0016T!\u0001K\u0015\u0002\u0005i\u001c$B\u0001\u0016,\u0003\u0015Ig\u000eZ3y\u0015\tQCF\u0003\u0002.]\u00059q-Z8nKN\f'BA\u00181\u00031awnY1uS>tG/Z2i\u0015\u0005\t\u0014aA8sO\u000e\u00011\u0003\u0002\u00015u-\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007\u0003B\u001e?\u0001\"k\u0011\u0001\u0010\u0006\u0003{-\n1!\u00199j\u0013\tyDHA\u0007J]\u0012,\u0007pS3z'B\f7-\u001a\t\u0003\u0003\u0016s!AQ\"\u000e\u0003\u001dJ!\u0001R\u0014\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\u000f1j\u001b\u0014J\u001c3fqZ\u000bG.^3t\u0015\t!u\u0005\u0005\u0002B\u0013&\u0011!j\u0012\u0002\u000b5NJe\u000eZ3y\u0017\u0016L\bC\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012a\u0016\t\u00031\u0002l\u0011!\u0017\u0006\u00035n\u000baa]5na2,'B\u0001/^\u0003\u001d1W-\u0019;ve\u0016T!!\u00100\u000b\u0005}\u0003\u0014\u0001C4f_R|w\u000e\\:\n\u0005\u0005L&!E*j[BdWMR3biV\u0014X\rV=qK\u0006!1O\u001a;!\u0003!\u0019\b.\u0019:eS:<W#A3\u0011\u0005m2\u0017BA4=\u00055\u0019\u0006.\u0019:e'R\u0014\u0018\r^3hs\u0006I1\u000f[1sI&tw\rI\u0001\nO\u0016|WNR5fY\u0012\u0004\"a\u001b:\u000f\u00051\u0004\bCA77\u001b\u0005q'BA83\u0003\u0019a$o\\8u}%\u0011\u0011ON\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rm\u0005AA\r^4GS\u0016dG-\u0001\u0004=S:LGO\u0010\u000b\u0006qfT8\u0010 \t\u0003\u0005\u0002AQ!V\u0004A\u0002]CQaY\u0004A\u0002\u0015DQ![\u0004A\u0002)DQ!^\u0004A\u0002)\f\u0011bZ3p[&sG-\u001a=\u0016\u0003}\u00042!NA\u0001\u0013\r\t\u0019A\u000e\u0002\u0004\u0013:$\u0018AC4f_6Le\u000eZ3yA\u0005AA\r^4J]\u0012,\u00070A\u0005ei\u001eLe\u000eZ3yA\u0005\u00191OZ2\u0016\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UA&A\u0003dkJ4X-\u0003\u0003\u0002\u001a\u0005M!A\u0002-[gM35)\u0001\u0003tM\u000e\u0004\u0013a\u0003;j[\u0016$v.\u00138eKb,\"!!\t\u0011\t\u0005\r\u0012\u0011\b\b\u0005\u0003K\t)D\u0004\u0003\u0002(\u0005Mb\u0002BA\u0015\u0003cqA!a\u000b\u000209\u0019Q.!\f\n\u0003EJ!a\f\u0019\n\u00055r\u0013bAA\u000bY%!\u0011qGA\n\u0003)\u0011\u0015N\u001c8fIRKW.Z\u0005\u0005\u0003w\tiD\u0001\tUS6,Gk\u001c\"j]:,G\rV5nK*!\u0011qGA\n\u00031!\u0018.\\3U_&sG-\u001a=!\u0003-!\u0017\r^3U_&sG-\u001a=\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u0013rA!!\u0005\u00026%!\u00111JA\u001f\u0005A!\u0015\r^3U_\nKgN\\3e)&lW-\u0001\u0007eCR,Gk\\%oI\u0016D\b%A\u0007c_VtGm\u001d+p\t\u0006$Xm]\u000b\u0003\u0003'\u0002r!NA+\u00033\n)(C\u0002\u0002XY\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000fU\nY&a\u0018\u0002`%\u0019\u0011Q\f\u001c\u0003\rQ+\b\u000f\\33!\u0015)\u0014\u0011MA3\u0013\r\t\u0019G\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!A/[7f\u0015\t\ty'\u0001\u0003kCZ\f\u0017\u0002BA:\u0003S\u0012QBW8oK\u0012$\u0015\r^3US6,\u0007cB\u001b\u0002\\\u0005\u0015\u0014QM\u0001\u000fE>,h\u000eZ:U_\u0012\u000bG/Z:!\u0003!I7\u000fU8j]R\u001cXCAA?!\r)\u0014qP\u0005\u0004\u0003\u00033$a\u0002\"p_2,\u0017M\\\u0001\nSN\u0004v.\u001b8ug\u0002\n!\"\u0019;ue&\u0014W\u000f^3t+\t\tI\tE\u0003\u0002\f\u0006M%N\u0004\u0003\u0002\u000e\u0006EebA7\u0002\u0010&\tq'\u0003\u0002Em%!\u0011QSAL\u0005\r\u0019V-\u001d\u0006\u0003\tZ\n1\"\u0019;ue&\u0014W\u000f^3tA\u0005\u0011\u0012N\u001c3fq.+\u0017PQ=uK2+gn\u001a;i+\t\ty\nE\u0004\u0002\f\u0006\u0005\u0016QU@\n\t\u0005\r\u0016q\u0013\u0002\u0006%&<\u0007\u000e\u001e\t\tk\u0005\u001d\u00161V@\u0000\u007f&\u0019\u0011\u0011\u0016\u001c\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004#B\u001b\u0002.\u0006E\u0016bAAXm\t)\u0011I\u001d:bsB\u0019Q'a-\n\u0007\u0005UfG\u0001\u0003CsR,\u0017aE5oI\u0016D8*Z=CsR,G*\u001a8hi\"\u0004\u0013aB:iCJLgnZ\u000b\u0003\u0003W\u000b\u0001b\u001d5be&tw\rI\u0001\u000bi>Le\u000eZ3y\u0017\u0016LHCCAb\u0003/\f\t/!:\u0002jB)\u0011QYAi\u0011:!\u0011qYAh\u001d\u0011\tI-!4\u000f\t\u0005\u001d\u00121Z\u0005\u0003U1J!!P\u0016\n\u0005\u0011c\u0014\u0002BAj\u0003+\u00141BU8x\u0017\u0016Lh+\u00197vK*\u0011A\t\u0010\u0005\b\u00033d\u0002\u0019AAn\u0003!9(/\u001b;bE2,\u0007cA\u001e\u0002^&\u0019\u0011q\u001c\u001f\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016Dq!a9\u001d\u0001\u0004\tY+\u0001\u0003uS\u0016\u0014\bbBAt9\u0001\u0007\u00111V\u0001\u0003S\u0012D\u0011\"a;\u001d!\u0003\u0005\r!! \u0002\u000f1,g.[3oi\u0006qq-\u001a;J]\u0012,\u0007PV1mk\u0016\u001cH#\u0002!\u0002r\u0006}\bbBAz;\u0001\u0007\u0011Q_\u0001\u0007M&dG/\u001a:\u0011\t\u0005]\u00181`\u0007\u0003\u0003sT1!a=^\u0013\u0011\ti0!?\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0011\t!\ba\u0001\u0005\u0007\tq!\u001a=qY\u0006Lg\u000e\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\r\u0011IaK\u0001\u0006kRLGn]\u0005\u0005\u0005\u001b\u00119AA\u0005FqBd\u0017-\u001b8fe\u0006Iq-\u001a;SC:<Wm\u001d\u000b\u0007\u0005'\u0011yBa\t\u0011\r\u0005-%Q\u0003B\r\u0013\u0011\u00119\"a&\u0003\u0011%#XM]1u_J\u0004R!!2\u0003\u001c!KAA!\b\u0002V\nI1kY1o%\u0006tw-\u001a\u0005\u0007\u0005Cq\u0002\u0019\u0001!\u0002\rY\fG.^3t\u0011!\u0011)C\bI\u0001\u0002\u0004y\u0018AC7vYRL\u0007\u000f\\5fe\u0006iq-\u001a;SC:<WMQ=uKN$bAa\u000b\u00034\t]\u0002CBAF\u0005+\u0011i\u0003\u0005\u0003\u0002F\n=\u0012\u0002\u0002B\u0019\u0003+\u0014\u0011BQ=uKJ\u000bgnZ3\t\u000f\tUr\u00041\u0001\u0003\u0014\u00051!/\u00198hKND\u0011\"a9 !\u0003\u0005\r!! \u0002\u001bU\u001cXMR;mY\u001aKG\u000e^3s)!\tiH!\u0010\u0003B\tm\u0003b\u0002B\u0011A\u0001\u0007!q\b\t\u0005k\u0005\u0005\u0004\tC\u0004\u0003D\u0001\u0002\rA!\u0012\u0002\r\r|gNZ5h!\u0015)\u0014\u0011\rB$!\u0011\u0011IE!\u0016\u000f\t\t-#q\n\b\u0005\u0003\u0013\u0014i%\u0003\u0002`W%!!\u0011\u000bB*\u0003]9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018P\u0003\u0002`W%!!q\u000bB-\u0005Y9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XmQ8oM&<'\u0002\u0002B)\u0005'BqA!\u0018!\u0001\u0004\u0011y&A\u0003iS:$8\u000f\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\u000f\u0019\f7\r^8ss*\u0019!\u0011\u000e0\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005[\u0012\u0019GA\u0003IS:$8/\u0001\tY5NJe\u000eZ3y\u0017\u0016L8\u000b]1dKB\u0011!II\n\u0005EQ\u0012)\b\u0005\u0004\u0003x\tu\u0004\t\u0013\b\u0005\u0003\u000f\u0014I(C\u0002\u0003|q\nQ\"\u00138eKb\\U-_*qC\u000e,\u0017\u0002\u0002B@\u0005\u0003\u0013A#\u00138eKb\\U-_*qC\u000e,g)Y2u_JL(b\u0001B>yQ\u0011!\u0011O\u0001\tgV\u0004\bo\u001c:ugR1\u0011Q\u0010BE\u0005\u0017CQ!\u0016\u0013A\u0002]Cq!!\"%\u0001\u0004\tI)A\u0003baBd\u0017\u0010F\u0004y\u0005#\u0013\u0019J!&\t\u000bU+\u0003\u0019A,\t\u000f\u0005\u0015U\u00051\u0001\u0002\n\"9\u00111]\u0013A\u0002\u0005u\u0004")
public class XZ3IndexKeySpace
implements IndexKeySpace<package.XZ3IndexValues, package.Z3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final String dtgField;
    private final int geomIndex;
    private final int dtgIndex;
    private final XZ3SFC sfc;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final Function1<ZonedDateTime, BinnedTime> dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static XZ3IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return XZ3IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return XZ3IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        XZ3IndexKeySpace xZ3IndexKeySpace = this;
        synchronized (xZ3IndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public XZ3SFC sfc() {
        return this.sfc;
    }

    public Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    private Function1<ZonedDateTime, BinnedTime> dateToIndex() {
        return this.dateToIndex;
    }

    private Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates() {
        return this.boundsToDates;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<package.Z3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Envelope envelope = geom.getEnvelopeInternal();
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        try {
            l = this.sfc().index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, lenient);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(38).append("Invalid xz value from geometry/time: ").append(geom).append(",").append(dtg).toString(), e);
            }
            throw throwable;
        }
        long xz = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 10 + id.length, ClassTag$.MODULE$.Byte());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).isEmpty()) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, 0);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 2);
            System.arraycopy(id, 0, bytes, 10, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(shard)).head());
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 3);
            System.arraycopy(id, 0, bytes, 11, id.length);
        }
        return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, xz), tier, id, writable.values());
    }

    @Override
    public package.XZ3IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$1 = filter;
        String x$22 = this.dtgField;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$22, x$4, x$3);
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Intervals: ").append(intervals).toString());
        if (intervals.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disjoint dates extracted, short-circuiting to empty query");
            return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Nil$.MODULE$), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Nil$.MODULE$));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> GeometryUtils$.MODULE$.bounds(x$2, multiplier, bits), Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty();
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        intervals.foreach((Function1 & Serializable & scala.Serializable)interval -> {
            Tuple2 tuple2 = (Tuple2)this.boundsToDates().apply((Object)interval.bounds());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZonedDateTime lower = (ZonedDateTime)tuple2._1();
            ZonedDateTime upper = (ZonedDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
            ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
            ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
            BinnedTime binnedTime = (BinnedTime)this.dateToIndex().apply((Object)lower2);
            if (binnedTime == null) {
                throw new MatchError((Object)binnedTime);
            }
            short lb = binnedTime.bin();
            long lt = binnedTime.offset();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
            short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long lt2 = tuple23._2$mcJ$sp();
            BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex().apply((Object)upper2);
            if (binnedTime2 == null) {
                throw new MatchError((Object)binnedTime2);
            }
            short ub = binnedTime2.bin();
            long ut = binnedTime2.offset();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
            short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
            long ut2 = tuple24._2$mcJ$sp();
            if (interval.isBoundedBothSides()) {
                if (lb2 == ub2) {
                    XZ3IndexKeySpace.updateTime$1(lb2, lt2, ut2, timesByBin);
                    return BoxedUnit.UNIT;
                }
                XZ3IndexKeySpace.updateTime$1(lb2, lt2, this.sfc().zBounds()._2$mcD$sp(), timesByBin);
                XZ3IndexKeySpace.updateTime$1(ub2, this.sfc().zBounds()._1$mcD$sp(), ut2, timesByBin);
                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> timesByBin.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.sfc().zBounds()));
                return BoxedUnit.UNIT;
            }
            if (interval.lower().value().isDefined()) {
                XZ3IndexKeySpace.updateTime$1(lb2, lt2, this.sfc().zBounds()._2$mcD$sp(), timesByBin);
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            }
            if (interval.upper().value().isDefined()) {
                XZ3IndexKeySpace.updateTime$1(ub2, this.sfc().zBounds()._1$mcD$sp(), ut2, timesByBin);
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
            }
            return BoxedUnit.UNIT;
        });
        return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.Z3IndexKey>> getRanges(package.XZ3IndexValues values, int multiplier) {
        package.XZ3IndexValues xZ3IndexValues = values;
        if (xZ3IndexValues == null) {
            throw new MatchError((Object)xZ3IndexValues);
        }
        XZ3SFC sfc = xZ3IndexValues.sfc();
        FilterValues<Geometry> geoms = xZ3IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = xZ3IndexValues.spatialBounds();
        FilterValues<Bounds<ZonedDateTime>> intervals = xZ3IndexValues.intervals();
        Map<Object, Tuple2<Object, Object>> timesByBin = xZ3IndexValues.temporalBounds();
        Seq<Tuple2<Object, Object>> unboundedBins = xZ3IndexValues.temporalUnbounded();
        Tuple6 tuple6 = new Tuple6((Object)sfc, geoms, xy, intervals, timesByBin, unboundedBins);
        XZ3SFC sfc2 = (XZ3SFC)tuple6._1();
        FilterValues geoms2 = (FilterValues)tuple6._2();
        Seq xy2 = (Seq)tuple6._3();
        FilterValues intervals2 = (FilterValues)tuple6._4();
        Map timesByBin2 = (Map)tuple6._5();
        Seq unboundedBins2 = (Seq)tuple6._6();
        if (geoms2.disjoint() || intervals2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (timesByBin2.isEmpty() && unboundedBins2.isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<Object>(null));
        }
        LazyRef wholePeriodRanges$lzy = new LazyRef();
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, timesByBin2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / timesByBin2.size() / multiplier)));
        Iterator bounded = timesByBin2.iterator().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Tuple2 times = (Tuple2)tuple2._2();
                Seq zs = times == sfc2.zBounds() ? XZ3IndexKeySpace.wholePeriodRanges$1(wholePeriodRanges$lzy, sfc2, xy2, target) : XZ3IndexKeySpace.toZRanges$1(times, sfc2, xy2, target);
                return (Seq)zs.map((Function1 & Serializable & scala.Serializable)r -> new package.BoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(bin, r.lower()), new package.Z3IndexKey(bin, r.upper())), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator unbounded = unboundedBins2.iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (Short.MAX_VALUE == s) {
                    return new package.LowerBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(lower, 0L));
                }
            }
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s) {
                    return new package.UpperBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(upper, Long.MAX_VALUE));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
            }
            throw new MatchError((Object)tuple2);
        });
        return bounded.$plus$plus((Function0 & Serializable & scala.Serializable)() -> unbounded);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.Z3IndexKey>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.LowerBoundedRange) {
                    package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                if (scanRange instanceof package.UpperBoundedRange) {
                    package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                    package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.UnboundedRange) {
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (GenTraversableOnce)this.sharding().shards().map((Function1 & Serializable & scala.Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)), Seq$.MODULE$.canBuildFrom());
            }
            if (scanRange instanceof package.UnboundedRange) {
                return new .colon.colon((Object)new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange()), (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ3IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    private static final void updateTime$1(short bin, double lt, double ut, scala.collection.mutable.Map timesByBin$1) {
        Some some;
        Tuple2 tuple2;
        Tuple2.mcDD.sp sp2;
        Option option = timesByBin$1.get((Object)BoxesRunTime.boxToShort((short)bin));
        if (None$.MODULE$.equals(option)) {
            sp2 = new Tuple2.mcDD.sp(lt, ut);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            double min2 = tuple2._1$mcD$sp();
            double max2 = tuple2._2$mcD$sp();
            sp2 = new Tuple2.mcDD.sp(scala.math.package$.MODULE$.min(min2, lt), scala.math.package$.MODULE$.max(max2, ut));
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2.mcDD.sp times = sp2;
        timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)bin), (Object)times);
    }

    private static final Seq toZRanges$1(Tuple2 t, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        return sfc$1.ranges((Seq)xy$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new Tuple6((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)t._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax), (Object)BoxesRunTime.boxToDouble((double)t._2$mcD$sp()));
            }
            throw new MatchError((Object)tuple4);
        }, Seq$.MODULE$.canBuildFrom()), target$1);
    }

    private static final /* synthetic */ Seq wholePeriodRanges$lzycompute$1(LazyRef wholePeriodRanges$lzy$1, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        Seq seq;
        LazyRef lazyRef = wholePeriodRanges$lzy$1;
        synchronized (lazyRef) {
            seq = wholePeriodRanges$lzy$1.initialized() ? (Seq)wholePeriodRanges$lzy$1.value() : (Seq)wholePeriodRanges$lzy$1.initialize((Object)XZ3IndexKeySpace.toZRanges$1(sfc$1.zBounds(), sfc$1, xy$1, target$1));
        }
        return seq;
    }

    private static final Seq wholePeriodRanges$1(LazyRef wholePeriodRanges$lzy$1, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        if (wholePeriodRanges$lzy$1.initialized()) {
            return (Seq)wholePeriodRanges$lzy$1.value();
        }
        return XZ3IndexKeySpace.wholePeriodRanges$lzycompute$1(wholePeriodRanges$lzy$1, sfc$1, xy$1, target$1);
    }

    public XZ3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        this.dtgField = dtgField;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Expected field ").append($this.geomField).append(" to have a geometry binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Expected field ").append($this.dtgField).append(" to have a date binding, but instead it has: ").append(this.sft().getDescriptor($this.dtgField).getType().getBinding().getSimpleName()).toString());
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.isPoints = Point.class.isAssignableFrom(sft.getDescriptor(this.geomIndex()).getType().getBinding());
        this.attributes = (Seq)new .colon.colon((Object)geomField, (List)new .colon.colon((Object)dtgField, (List)Nil$.MODULE$));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(10 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

