/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$Configuration$;
import org.locationtech.geomesa.index.utils.bin.BinSorter$;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015aa\u0002\u001b6!\u0003\r\t\u0001\u0011\u0005\b\u0005[\u0004A\u0011\u0001B<\u0011\u001d\u0011y\u000f\u0001C)\u0005cDqa!\u0001\u0001\t#\u001a\u0019aB\u0003[k!\u00051LB\u00035k!\u0005A\fC\u0003^\u000b\u0011\u0005alB\u0003`\u000b!\u0005\u0001MB\u0003c\u000b!\u00051\rC\u0003^\u0011\u0011\u0005A\rC\u0004f\u0011\t\u0007I\u0011\u00014\t\r=D\u0001\u0015!\u0003h\u0011\u001d\u0001\bB1A\u0005\u0002\u0019Da!\u001d\u0005!\u0002\u00139\u0007b\u0002:\t\u0005\u0004%\tA\u001a\u0005\u0007g\"\u0001\u000b\u0011B4\t\u000fQD!\u0019!C\u0001M\"1Q\u000f\u0003Q\u0001\n\u001dDqA\u001e\u0005C\u0002\u0013\u0005a\r\u0003\u0004x\u0011\u0001\u0006Ia\u001a\u0005\bq\"\u0011\r\u0011\"\u0001g\u0011\u0019I\b\u0002)A\u0005O\"9!\u0010\u0003b\u0001\n\u00031\u0007bBA\u0013\u0011\u0001\u0006Ia\u001a\u0005\b\u0003_)A\u0011AA\u0019\u0011\u001d\tY-\u0002C\u0001\u0003\u001b4a!a>\u0006\u0001\u0005e\bB\u0003B\r5\t\u0005\t\u0015!\u0003\u0003\u001c!Q!q\u0005\u000e\u0003\u0002\u0004%IA!\u000b\t\u0015\t-\"D!a\u0001\n\u0013\u0011i\u0003\u0003\u0006\u0003:i\u0011\t\u0011)Q\u0005\u00057A!Ba\u000f\u001b\u0005\u0003\u0005\u000b\u0011\u0002B\u001f\u0011)\u0011\u0019E\u0007B\u0001B\u0003%\u0011\u0011\u0016\u0005\u000b\u0003cS\"\u0011!Q\u0001\n\u0005M\u0006BB/\u001b\t\u0003\u0011)\u0005C\u0004\u0003Ti!\tE!\u0016\t\u000f\tM#\u0004\"\u0011\u0003j!9!Q\u000f\u000e\u0005B\t]\u0004b\u0002B=5\u0011\u0005#1\u0010\u0005\b\u0005\u000fSB\u0011\tBE\u0011\u001d\u00119J\u0007C!\u0005oBqA!'\u001b\t\u0013\u0011YJB\u0004\u0003\"\u0016\t\tAa)\t\ruSC\u0011\u0001B`\u0011\u001d\u0011)H\u000bC!\u0005\u0007DqAa2+\t\u0003\u0012I\rC\u0004\u0003L*\"\tE!4\t\u000f\tM#\u0006\"\u0011\u0003P\"9!Q\u001b\u0016\u0007\u0012\t]\u0007b\u0002BnU\u0011\u0005!Q\u001c\u0005\b\u0005GTC\u0011\tBs\u0011\u001d\u0011IO\u000bC!\u0005W\u0014!CQ5o\u0003\u001e<'/Z4bi&twmU2b]*\u0011agN\u0001\nSR,'/\u0019;peNT!\u0001O\u001d\u0002\u000b%tG-\u001a=\u000b\u0005iZ\u0014aB4f_6,7/\u0019\u0006\u0003yu\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AP\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\rE\u0002I\u0013.k\u0011!N\u0005\u0003\u0015V\u0012q\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\t\u0003\u0019jq!!\u0014\u0003\u000f\u00059KfBA(Y\u001d\t\u0001vK\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AkP\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!\u0001P\u001f\n\u0005iZ\u0014B\u0001\u001d:\u0013\t1t'\u0001\nCS:\fum\u001a:fO\u0006$\u0018N\\4TG\u0006t\u0007C\u0001%\u0006'\t)\u0011)\u0001\u0004=S:LGO\u0010\u000b\u00027\u0006i1i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\u0019\u0005\u000e\u0003\u0015\u0011QbQ8oM&<WO]1uS>t7C\u0001\u0005B)\u0005\u0001\u0017aB*peR|\u0005\u000f^\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw-\u0001\u0005T_J$x\n\u001d;!\u0003!!&/Y2l\u001fB$\u0018!\u0003+sC\u000e\\w\n\u001d;!\u0003\u001d9Um\\7PaR\f\u0001bR3p[>\u0003H\u000fI\u0001\b\t\u0006$Xm\u00149u\u0003!!\u0015\r^3PaR\u0004\u0013\u0001\u0003'bE\u0016dw\n\u001d;\u0002\u00131\u000b'-\u001a7PaR\u0004\u0013\u0001\u0004#bi\u0016\f%O]1z\u001fB$\u0018!\u0004#bi\u0016\f%O]1z\u001fB$\b%\u0001\u0007CCR\u001c\u0007nU5{K>\u0003H\u000fK\u0003\u0017y~\f\u0019\u0001\u0005\u0002C{&\u0011ap\u0011\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA\u0001\u0003)\num\u001a:fO\u0006$\u0018N\\4TG\u0006tgfQ8oM&<WO]1uS>tgFQ1uG\"\u001c\u0016N_3PaR\f\u0014bIA\u0003\u0003'\tY\"!\u0006\u0011\t\u0005\u001d\u0011q\u0002\b\u0005\u0003\u0013\tY\u0001\u0005\u0002S\u0007&\u0019\u0011QB\"\u0002\rA\u0013X\rZ3g\u0013\rq\u0017\u0011\u0003\u0006\u0004\u0003\u001b\u0019\u0015\u0002BA\u000b\u0003/\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$bAA\r\u0007\u0006QA-\u001a9sK\u000e\fG/\u001a32\u0013\r\ni\"a\b\u0002\"\u0005eab\u0001\"\u0002 %\u0019\u0011\u0011D\"2\u000b\t\u00125)a\t\u0003\u000bM\u001c\u0017\r\\1\u0002\u001b\t\u000bGo\u00195TSj,w\n\u001d;!Q\u00159Bp`A\u0015c%\u0019\u0013QAA\n\u0003W\t)\"M\u0005$\u0003;\ty\"!\f\u0002\u001aE*!EQ\"\u0002$\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0017\u0003g\tI$!\u0016\u0002\u0000\u0005M\u0015qSAN\u0003C\u000b)+a,\u0002:BA\u0011qAA\u001b\u0003\u000b\t)!\u0003\u0003\u00028\u0005E!aA'ba\"9\u00111\b\rA\u0002\u0005u\u0012aA:giB!\u0011qHA)\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013AB:j[BdWM\u0003\u0003\u0002H\u0005%\u0013a\u00024fCR,(/\u001a\u0006\u0005\u0003\u0017\ni%A\u0002ba&T1!a\u0014>\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BA*\u0003\u0003\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u0019A\u0004\u00041\u0001\u0002XA2\u0011\u0011LA4\u0003w\u0002\u0002\"a\u0017\u0002`\u0005\r\u0014\u0011P\u0007\u0003\u0003;R1!a\u00138\u0013\u0011\t\t'!\u0018\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u0011\t\u0005\u0015\u0014q\r\u0007\u0001\t1\tI'!\u0016\u0002\u0002\u0003\u0005)\u0011AA6\u0005\ryF%M\t\u0005\u0003[\n\u0019\bE\u0002C\u0003_J1!!\u001dD\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AQA;\u0013\r\t9h\u0011\u0002\u0004\u0003:L\b\u0003BA3\u0003w\"A\"! \u0002V\u0005\u0005\t\u0011!B\u0001\u0003W\u00121a\u0018\u00133\u0011\u001d\t\t\t\u0007a\u0001\u0003\u0007\u000baAZ5mi\u0016\u0014\b#\u0002\"\u0002\u0006\u0006%\u0015bAAD\u0007\n1q\n\u001d;j_:\u0004B!a#\u0002\u00106\u0011\u0011Q\u0012\u0006\u0005\u0003\u0003\u000bI%\u0003\u0003\u0002\u0012\u00065%A\u0002$jYR,'\u000fC\u0004\u0002\u0016b\u0001\r!!\u0002\u0002\u000fQ\u0014\u0018mY6JI\"9\u0011\u0011\u0014\rA\u0002\u0005\u0015\u0011\u0001B4f_6Dq!!(\u0019\u0001\u0004\ty*A\u0002ei\u001e\u0004RAQAC\u0003\u000bAq!a)\u0019\u0001\u0004\ty*A\u0003mC\n,G\u000eC\u0004\u0002(b\u0001\r!!+\u0002\u0013\t\fGo\u00195TSj,\u0007c\u0001\"\u0002,&\u0019\u0011QV\"\u0003\u0007%sG\u000fC\u0004\u00022b\u0001\r!a-\u0002\tM|'\u000f\u001e\t\u0004\u0005\u0006U\u0016bAA\\\u0007\n9!i\\8mK\u0006t\u0007bBA^1\u0001\u0007\u0011QX\u0001\tg\u0006l\u0007\u000f\\5oOB)!)!\"\u0002@B9!)!1\u0002F\u0006}\u0015bAAb\u0007\n1A+\u001e9mKJ\u00022AQAd\u0013\r\tIm\u0011\u0002\u0006\r2|\u0017\r^\u0001\u000eaJ|\u0007/\u001a:us:\u000bW.Z:\u0015\r\u0005=\u0017\u0011]A{!\u0019\t\t.a7\u0002\u00069!\u00111[Al\u001d\r\u0011\u0016Q[\u0005\u0002\t&\u0019\u0011\u0011\\\"\u0002\u000fA\f7m[1hK&!\u0011Q\\Ap\u0005\r\u0019V-\u001d\u0006\u0004\u00033\u001c\u0005bBAr3\u0001\u0007\u0011Q]\u0001\u0006Q&tGo\u001d\t\u0005\u0003O\f\t0\u0004\u0002\u0002j*!\u00111^Aw\u0003\u001d1\u0017m\u0019;pefTA!a<\u0002N\u0005!Q\u000f^5m\u0013\u0011\t\u00190!;\u0003\u000b!Kg\u000e^:\t\u000f\u0005m\u0012\u00041\u0001\u0002>\tq!+Z:vYR\u001c\u0015\r\u001c7cC\u000e\\7C\u0002\u000eB\u0003w\u0014I\u0001\u0005\u0003\u0002~\n\rab\u0001%\u0002\u0000&\u0019!\u0011A\u001b\u0002\u001f\u0005;wM]3hCRLgnZ*dC:LAA!\u0002\u0003\b\t1!+Z:vYRT1A!\u00016!\u0011\u0011YA!\u0006\u000e\u0005\t5!\u0002\u0002B\b\u0005#\t1AY5o\u0015\r\u0011\u0019\"O\u0001\u0006kRLGn]\u0005\u0005\u0005/\u0011iA\u0001\u000bCS:\f'/_(viB,HoQ1mY\n\f7m[\u0001\u0007EV4g-\u001a:\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\tl\u0003\rq\u0017n\\\u0005\u0005\u0005K\u0011yB\u0001\u0006CsR,')\u001e4gKJ\f\u0001b\u001c<fe\u001adwn^\u000b\u0003\u00057\tAb\u001c<fe\u001adwn^0%KF$BAa\f\u00036A\u0019!I!\r\n\u0007\tM2I\u0001\u0003V]&$\b\"\u0003B\u001c;\u0005\u0005\t\u0019\u0001B\u000e\u0003\rAH%M\u0001\n_Z,'O\u001a7po\u0002\nq!\u001a8d_\u0012,'\u000f\u0005\u0003\u0003\f\t}\u0012\u0002\u0002B!\u0005\u001b\u00111CQ5oCJLx*\u001e;qkR,enY8eKJ\fqAY5o'&TX\r\u0006\u0007\u0003H\t%#1\nB'\u0005\u001f\u0012\t\u0006\u0005\u0002b5!9!\u0011\u0004\u0012A\u0002\tm\u0001b\u0002B\u0014E\u0001\u0007!1\u0004\u0005\b\u0005w\u0011\u0003\u0019\u0001B\u001f\u0011\u001d\u0011\u0019E\ta\u0001\u0003SCq!!-#\u0001\u0004\t\u0019,A\u0003baBd\u0017\u0010\u0006\u0006\u00030\t]#\u0011\fB/\u0005CBq!!&$\u0001\u0004\tI\u000bC\u0004\u0003\\\r\u0002\r!!2\u0002\u00071\fG\u000fC\u0004\u0003`\r\u0002\r!!2\u0002\u00071|g\u000eC\u0004\u0002\u001e\u000e\u0002\rAa\u0019\u0011\u0007\t\u0013)'C\u0002\u0003h\r\u0013A\u0001T8oORa!q\u0006B6\u0005[\u0012yG!\u001d\u0003t!9\u0011Q\u0013\u0013A\u0002\u0005%\u0006b\u0002B.I\u0001\u0007\u0011Q\u0019\u0005\b\u0005?\"\u0003\u0019AAc\u0011\u001d\ti\n\na\u0001\u0005GBq!a)%\u0001\u0004\u0011\u0019'\u0001\u0003j]&$HC\u0001B\u0018\u0003%\twm\u001a:fO\u0006$X\r\u0006\u0003\u0002*\nu\u0004b\u0002B@M\u0001\u0007!\u0011Q\u0001\u0003g\u001a\u0004B!a\u0010\u0003\u0004&!!QQA!\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u00061QM\\2pI\u0016$\"Aa#\u0011\u000b\t\u0013iI!%\n\u0007\t=5IA\u0003BeJ\f\u0017\u0010E\u0002C\u0005'K1A!&D\u0005\u0011\u0011\u0015\u0010^3\u0002\u000f\rdW-\u00198va\u0006qQM\\:ve\u0016\u001c\u0015\r]1dSRLH\u0003\u0002B\u000e\u0005;CqAa(*\u0001\u0004\tI+\u0001\u0003tSj,'\u0001\u0006\"j]J+7/\u001e7ugR{g)Z1ukJ,7/\u0006\u0003\u0003&\nm6\u0003\u0002\u0016B\u0005O\u0003bA!+\u00034\nef\u0002\u0002BV\u0005_s1A\u0014BW\u0013\r\tYeN\u0005\u0005\u0005c\u000bi&A\u0005Rk\u0016\u0014\u0018\u0010\u00157b]&!!Q\u0017B\\\u0005E\u0011Vm];miN$vNR3biV\u0014Xm\u001d\u0006\u0005\u0005c\u000bi\u0006\u0005\u0003\u0002f\tmFa\u0002B_U\t\u0007\u00111\u000e\u0002\u0002)R\u0011!\u0011\u0019\t\u0005C*\u0012I\f\u0006\u0003\u00030\t\u0015\u0007b\u0002BdY\u0001\u0007\u00111G\u0001\u0006gR\fG/Z\u000b\u0003\u0003g\taa]2iK6\fWCAA\u001f)\u0011\u0011\tI!5\t\u000f\tMw\u00061\u0001\u0003:\u00061!/Z:vYR\fQAY=uKN$BAa#\u0003Z\"9!1\u001b\u0019A\u0002\te\u0016\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M&q\u001c\u0005\b\u0005C\f\u0004\u0019AA:\u0003\u0015yG\u000f[3s\u0003\u0019)\u0017/^1mgR!\u00111\u0017Bt\u0011\u001d\u0011\tO\ra\u0001\u0003g\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003S\u000ba\u0001J5oSR$\u0013\u0001D2sK\u0006$XMU3tk2$H#C&\u0003t\nU(1 B\u007f\u0011\u001d\tYD\u0001a\u0001\u0003{AqAa>\u0003\u0001\u0004\u0011I0A\u0005ue\u0006t7OZ8s[B)!)!\"\u0002>!9\u0011q\u0015\u0002A\u0002\u0005%\u0006b\u0002B\u0000\u0005\u0001\u0007\u00111G\u0001\b_B$\u0018n\u001c8t\u0003A!WMZ1vYR\u0014\u0015\r^2i'&TX-\u0006\u0002\u0002*\u0002")
public interface BinAggregatingScan
extends AggregatingScan<ResultCallback> {
    public static Seq<String> propertyNames(Hints hints, SimpleFeatureType simpleFeatureType) {
        return BinAggregatingScan$.MODULE$.propertyNames(hints, simpleFeatureType);
    }

    public static Map<String, String> configure(SimpleFeatureType simpleFeatureType, GeoMesaFeatureIndex<?, ?> geoMesaFeatureIndex, Option<Filter> option, String string, String string2, Option<String> option2, Option<String> option3, int n, boolean bl, Option<Tuple2<Object, Option<String>>> option4) {
        return BinAggregatingScan$.MODULE$.configure(simpleFeatureType, geoMesaFeatureIndex, option, string, string2, option2, option3, n, bl, option4);
    }

    public static /* synthetic */ ResultCallback createResult$(BinAggregatingScan $this, SimpleFeatureType sft, Option transform, int batchSize, Map options) {
        return $this.createResult(sft, (Option<SimpleFeatureType>)transform, batchSize, (Map<String, String>)options);
    }

    @Override
    default public ResultCallback createResult(SimpleFeatureType sft, Option<SimpleFeatureType> transform, int batchSize, Map<String, String> options) {
        Option geom = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.GeomOpt()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BinAggregatingScan.$anonfun$createResult$1(x$1))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != -1);
        Option dtg = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.DateOpt()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BinAggregatingScan.$anonfun$createResult$3(x$3))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != -1);
        Option track = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.TrackOpt()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BinAggregatingScan.$anonfun$createResult$5(x$5))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != -1);
        Option label = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.LabelOpt()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BinAggregatingScan.$anonfun$createResult$7(x$7))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != -1);
        BinaryOutputEncoder encoder = BinaryOutputEncoder$.MODULE$.apply(sft, new BinaryOutputEncoder.EncodingOptions(geom, dtg, track, label, BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5()));
        int binSize = label.isEmpty() ? 16 : 24;
        boolean sort = new StringOps(Predef$.MODULE$.augmentString((String)options.apply((Object)BinAggregatingScan$Configuration$.MODULE$.SortOpt()))).toBoolean();
        ByteBuffer buffer = ByteBuffer.wrap((byte[])Array$.MODULE$.ofDim(batchSize * binSize, ClassTag$.MODULE$.Byte())).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer overflow = ByteBuffer.wrap((byte[])Array$.MODULE$.ofDim(binSize * 16, ClassTag$.MODULE$.Byte())).order(ByteOrder.LITTLE_ENDIAN);
        return new ResultCallback(buffer, overflow, encoder, binSize, sort);
    }

    public static /* synthetic */ int defaultBatchSize$(BinAggregatingScan $this) {
        return $this.defaultBatchSize();
    }

    @Override
    default public int defaultBatchSize() {
        throw new IllegalArgumentException("Batch scan is specified per scan");
    }

    public static /* synthetic */ int $anonfun$createResult$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static /* synthetic */ int $anonfun$createResult$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static /* synthetic */ int $anonfun$createResult$5(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static /* synthetic */ int $anonfun$createResult$7(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public static void $init$(BinAggregatingScan $this) {
    }

    public static abstract class BinResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        }

        @Override
        public SimpleFeature apply(T result) {
            return new ScalaSimpleFeature(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), "", new Object[]{this.bytes(result), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof BinResultsToFeatures;
        }

        public boolean equals(Object other) {
            BinResultsToFeatures binResultsToFeatures;
            Object object = other;
            return object instanceof BinResultsToFeatures && (binResultsToFeatures = (BinResultsToFeatures)object).canEqual(this);
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }

    public static class ResultCallback
    implements AggregatingScan.Result,
    BinaryOutputCallback {
        private final ByteBuffer buffer;
        private ByteBuffer overflow;
        private final BinaryOutputEncoder encoder;
        private final int binSize;
        private final boolean sort;

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg) {
            BinaryOutputCallback.put$((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg);
        }

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg, long label) {
            BinaryOutputCallback.put$((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg, (long)label);
        }

        private ByteBuffer overflow() {
            return this.overflow;
        }

        private void overflow_$eq(ByteBuffer x$1) {
            this.overflow = x$1;
        }

        public void apply(int trackId, float lat, float lon, long dtg) {
            this.put(this.ensureCapacity(16), trackId, lat, lon, dtg);
        }

        public void apply(int trackId, float lat, float lon, long dtg, long label) {
            this.put(this.ensureCapacity(24), trackId, lat, lon, dtg, label);
        }

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            int pos = this.buffer.position() + this.overflow().position();
            this.encoder.encode(sf, (BinaryOutputCallback)this);
            return (this.buffer.position() + this.overflow().position() - pos) / this.binSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] encode() {
            byte[] bytes;
            block8: {
                byte[] byArray;
                try {
                    if (this.overflow().position() > 0) {
                        byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position() + this.overflow().position(), ClassTag$.MODULE$.Byte());
                        System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                        System.arraycopy(this.overflow().array(), 0, copy, this.buffer.position(), this.overflow().position());
                        byArray = copy;
                    } else if (this.buffer.position() == this.buffer.limit()) {
                        byArray = this.buffer.array();
                    } else {
                        void var3_2;
                        byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position(), ClassTag$.MODULE$.Byte());
                        System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                        byArray = var3_2;
                    }
                }
                finally {
                    this.buffer.clear();
                    this.overflow().clear();
                }
                bytes = byArray;
                if (!this.sort) break block8;
                BinSorter$.MODULE$.quickSort(bytes, 0, bytes.length - this.binSize, this.binSize);
            }
            return bytes;
        }

        @Override
        public void cleanup() {
        }

        private ByteBuffer ensureCapacity(int size) {
            if (this.buffer.position() < this.buffer.limit() - size) {
                return this.buffer;
            }
            if (this.overflow().position() < this.overflow().limit() - size) {
                return this.overflow();
            }
            byte[] expanded = (byte[])Array$.MODULE$.ofDim(this.overflow().limit() * 2, ClassTag$.MODULE$.Byte());
            System.arraycopy(this.overflow().array(), 0, expanded, 0, this.overflow().limit());
            ByteOrder order = this.overflow().order();
            int position = this.overflow().position();
            this.overflow_$eq(ByteBuffer.wrap(expanded).order(order).position(position));
            return this.overflow();
        }

        public ResultCallback(ByteBuffer buffer, ByteBuffer overflow, BinaryOutputEncoder encoder, int binSize, boolean sort) {
            this.buffer = buffer;
            this.overflow = overflow;
            this.encoder = encoder;
            this.binSize = binSize;
            this.sort = sort;
            BinaryOutputCallback.$init$((BinaryOutputCallback)this);
        }
    }
}

