/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011mfaB:u!\u0003\r\ta \u0005\b\t3\u0003A\u0011\u0001C#\u0011-!I\u0004\u0001a\u0001\u0002\u0004%\t\u0002b'\t\u0017\u0011}\u0005\u00011AA\u0002\u0013EA\u0011\u0015\u0005\b\tK\u0003A\u0011\u000bCT\u0011\u001d!I\f\u0001C)\u0007_9q!a\ru\u0011\u0003\t)D\u0002\u0004ti\"\u0005\u0011q\u0007\u0005\b\u0003\u001b:A\u0011AA(\u000b\u0019\t\tf\u0002\u0001\u0002T!I\u0011qR\u0004C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003c;\u0001\u0015!\u0003\u0002\u0014\"I\u00111W\u0004C\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003{;\u0001\u0015!\u0003\u00028\"I\u0011qX\u0004C\u0002\u0013\u0005\u0011\u0011\u0019\u0005\t\u0003K<\u0001\u0015!\u0003\u0002D\u001e9\u0011q]\u0004\t\u0002\u0005%haBAw\u000f!\u0005\u0011q\u001e\u0005\b\u0003\u001b\nB\u0011AAy\u0011%\t\u00190\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\bE\u0001\u000b\u0011BA|\u0011%\u0011I!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\fE\u0001\u000b\u0011BA|\u0011%\u0011i!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0010E\u0001\u000b\u0011BA|\u0011%\u0011\t\"\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0014E\u0001\u000b\u0011BA|\u0011\u001d\u0011)b\u0002C\u0001\u0005/AqAa\u001f\b\t\u0003\u0011i\bC\u0004\u0003\u001a\u001e!\tAa'\t\u000f\teu\u0001\"\u0001\u0003B\"9!1[\u0004\u0005\u0002\tU\u0007b\u0002Bq\u000f\u0011\u0005!1\u001d\u0005\b\t?9A\u0011\u0001C\u0011\r\u0019!9c\u0002\u0001\u0005*!QA\u0011\b\u0012\u0003\u0002\u0003\u0006IA!:\t\u0015\t](E!A!\u0002\u0013\u0011y\tC\u0004\u0002N\t\"\t\u0001b\u000f\t\u000f\u0011\r#\u0005\"\u0011\u0005F!9Aq\t\u0012\u0005B\u0011%\u0003b\u0002C'E\u0011\u0005Cq\n\u0005\b\t#\u0012C\u0011\tC#\r\u001d!\u0019fBA\u0001\t+Bq!!\u0014+\t\u0003!\t\bC\u0004\u0005D)\"\t\u0005\"\u001e\t\u000f\u0011e$\u0006\"\u0011\u0005|!9AQ\u0010\u0016\u0005B\u0005U\u0006b\u0002C@U\u0011\u0005C\u0011\u0011\u0005\b\t\u000bSc\u0011\u0003CD\u0011\u001d\u00199E\u000bC\u0001\t\u0017Cq\u0001\"%+\t\u0003\"\u0019\nC\u0004\u0004T)\"\te!\u0016\u0007\u0013\r\u001dq\u0001%A\u0012\"\r%\u0001bBB\u0006i\u0019\u00051QB\u0004\b\t/;\u0001\u0012QB\u0013\r\u001d\u0019\u0019b\u0002EA\u0007+Aq!!\u00148\t\u0003\u0019\u0019\u0003C\u0004\u0004\f]\"\tea\n\t\u0013\r-r'!A\u0005B\u0005U\b\"CB\u0017o\u0005\u0005I\u0011AB\u0018\u0011%\u0019\tdNA\u0001\n\u0003\u0019\u0019\u0004C\u0005\u0004:]\n\t\u0011\"\u0011\u0004<!I1qI\u001c\u0002\u0002\u0013\u00051\u0011\n\u0005\n\u0007':\u0014\u0011!C!\u0007+B\u0011ba\u00168\u0003\u0003%\te!\u0017\t\u0013\rms'!A\u0005\n\rucABBH\u000f\u0001\u0019\t\n\u0003\u0006\u0004\u0002\t\u0013\t\u0011)A\u0005\u0005oCq!!\u0014C\t\u0003\u0019\u0019\nC\u0004\u0004\f\t#\te!'\u0007\r\r\u0005u\u0001ABB\u0011)\u0019\tA\u0012B\u0001B\u0003%!q\u0017\u0005\b\u0003\u001b2E\u0011ABC\u0011\u001d\u0019YA\u0012C!\u0007\u00173aa!\u001a\b\u0001\r\u001d\u0004BCB5\u0015\n\u0005\t\u0015!\u0003\u0004l!9\u0011Q\n&\u0005\u0002\r]\u0004bBB\u0006\u0015\u0012\u00053Q\u0010\u0004\n\u0005O<\u0001\u0013aI\u0011\u0005SDqAa;O\r\u0003\u0011iO\u0002\u0004\u0004t\u001e\u00011Q\u001f\u0005\u000b\u0007\u0003\u0001&\u0011!Q\u0001\n\t]\u0006BCB\u0002!\n\u0005\t\u0015!\u0003\u0004\u0006!9\u0011Q\n)\u0005\u0002\r]\bb\u0002Bv!\u0012\u00053q \u0004\u0007\u0007{;\u0001aa0\t\u0015\r\u0005QK!A!\u0002\u0013\u00119\f\u0003\u0006\u0004\u0004U\u0013\t\u0011)A\u0005\u0007\u000bAq!!\u0014V\t\u0003\u0019\t\rC\u0004\u0003lV#\te!3\u0007\r\tux\u0001\u0001B\u0000\u0011)\u0019\tA\u0017B\u0001B\u0003%!q\u0017\u0005\u000b\u0007\u0007Q&\u0011!Q\u0001\n\r\u0015\u0001bBA'5\u0012\u00051Q\u0014\u0005\b\u0005WTF\u0011IBS\r\u0019\u0019Yk\u0002\u0001\u0004.\"Q1\u0011A0\u0003\u0002\u0003\u0006IAa.\t\u0015\r\rqL!A!\u0002\u0013\u0019)\u0001C\u0004\u0002N}#\taa,\t\u000f\t-x\f\"\u0011\u00048\u001a1AQA\u0004\u0001\t\u000fA!b!\u0001e\u0005\u0003\u0005\u000b\u0011\u0002B\\\u0011)\u0019\u0019\u0001\u001aB\u0001B\u0003%1Q\u0001\u0005\b\u0003\u001b\"G\u0011\u0001C\u0005\u0011\u001d\u0011Y\u000f\u001aC!\t#1aaa4\b\u0001\rE\u0007BCB\u0001S\n\u0005\t\u0015!\u0003\u00038\"Q11A5\u0003\u0002\u0003\u0006Ia!\u0002\t\u000f\u00055\u0013\u000e\"\u0001\u0004T\"9!1^5\u0005B\rmgABBq\u000f\u0001\u0019\u0019\u000f\u0003\u0006\u0004\u00029\u0014\t\u0011)A\u0005\u0005oC!ba\u0001o\u0005\u0003\u0005\u000b\u0011BB\u0003\u0011\u001d\tiE\u001cC\u0001\u0007KDqAa;o\t\u0003\u001aiOA\u0006EK:\u001c\u0018\u000e^=TG\u0006t'BA;w\u0003%IG/\u001a:bi>\u00148O\u0003\u0002xq\u0006)\u0011N\u001c3fq*\u0011\u0011P_\u0001\bO\u0016|W.Z:b\u0015\tYH0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001~\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011\u0011AA\u0007!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!BAA\u0004\u0003\u0015\u00198-\u00197b\u0013\u0011\tY!!\u0002\u0003\r\u0005s\u0017PU3g!\u0019\ty!!\u0005\u0002\u00165\tA/C\u0002\u0002\u0014Q\u0014q\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\t\u0004\u0003/\u0011cbAA\r\r9!\u00111DA\u0019\u001d\u0011\ti\"a\f\u000f\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tYC\u0004\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9C`\u0001\u0007yI|w\u000e\u001e \n\u0003uL!a\u001f?\n\u0005eT\u0018BA<y\u0013\t)h/A\u0006EK:\u001c\u0018\u000e^=TG\u0006t\u0007cAA\b\u000fM)q!!\u0001\u0002:A!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001D:dC2\fGn\\4hS:<'\u0002BA\"\u0003\u000b\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u000f\n1aY8n\u0013\u0011\tY%!\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005U\"\u0001D$sS\u0012LE/\u001a:bi>\u0014\b\u0003CA\u0002\u0003+\nI&!\u001d\n\t\u0005]\u0013Q\u0001\u0002\n\rVt7\r^5p]F\u0002B!a\u0017\u0002n5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003G\n)'A\u0004gK\u0006$XO]3\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0004CBL'bAA6y\u0006Aq-Z8u_>d7/\u0003\u0003\u0002p\u0005u#!D*j[BdWMR3biV\u0014X\r\u0005\u0004\u0002t\u0005u\u00141\u0011\b\u0005\u0003k\nIH\u0004\u0003\u0002$\u0005]\u0014BAA\u0004\u0013\u0011\tY(!\u0002\u0002\u000fA\f7m[1hK&!\u0011qPAA\u0005!IE/\u001a:bi>\u0014(\u0002BA>\u0003\u000b\u0001\"\"a\u0001\u0002\u0006\u0006%\u0015\u0011RAE\u0013\u0011\t9)!\u0002\u0003\rQ+\b\u000f\\34!\u0011\t\u0019!a#\n\t\u00055\u0015Q\u0001\u0002\u0007\t>,(\r\\3\u0002\u0013\t\u000bGo\u00195TSj,WCAAJ!\u0011\t)*a+\u000f\t\u0005]\u0015Q\u0015\b\u0005\u00033\u000byJ\u0004\u0003\u0002\u001e\u0005m\u0015bAAOq\u0006)Q\u000f^5mg&!\u0011\u0011UAR\u0003\u0011\u0019wN\u001c4\u000b\u0007\u0005u\u00050\u0003\u0003\u0002(\u0006%\u0016aF$f_6+7/Y*zgR,W\u000e\u0015:pa\u0016\u0014H/[3t\u0015\u0011\t\t+a)\n\t\u00055\u0016q\u0016\u0002\u000f'f\u001cH/Z7Qe>\u0004XM\u001d;z\u0015\u0011\t9+!+\u0002\u0015\t\u000bGo\u00195TSj,\u0007%\u0001\u0006EK:\u001c\u0018\u000e^=TMR,\"!a.\u0011\t\u0005m\u0013\u0011X\u0005\u0005\u0003w\u000biFA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\f1\u0002R3og&$\u0018p\u00154uA\u0005yA)\u001a8tSRLh+\u00197vK.+\u00170\u0006\u0002\u0002DB!\u0011QYAp\u001d\u0011\t9-!7\u000f\t\u0005%\u00171\u001b\b\u0005\u0003\u0017\fyM\u0004\u0003\u0002\"\u00055\u0017bAA6y&!\u0011\u0011[A5\u0003\u0011)H/\u001b7\n\t\u0005U\u0017q[\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\t.!\u001b\n\t\u0005m\u0017Q\\\u0001\u0006\u0011&tGo\u001d\u0006\u0005\u0003+\f9.\u0003\u0003\u0002b\u0006\r(\u0001C\"mCN\u001c8*Z=\u000b\t\u0005m\u0017Q\\\u0001\u0011\t\u0016t7/\u001b;z-\u0006dW/Z&fs\u0002\nQbQ8oM&<WO]1uS>t\u0007cAAv#5\tqAA\u0007D_:4\u0017nZ;sCRLwN\\\n\u0004#\u0005\u0005ACAAu\u0003-9Um\\7fiJLx\n\u001d;\u0016\u0005\u0005]\b\u0003BA}\u0005\u0007i!!a?\u000b\t\u0005u\u0018q`\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0002\u0005!!.\u0019<b\u0013\u0011\u0011)!a?\u0003\rM#(/\u001b8h\u000319Um\\7fiJLx\n\u001d;!\u0003-)eN^3m_B,w\n\u001d;\u0002\u0019\u0015sg/\u001a7pa\u0016|\u0005\u000f\u001e\u0011\u0002\u000f\u001d\u0013\u0018\u000eZ(qi\u0006AqI]5e\u001fB$\b%A\u0005XK&<\u0007\u000e^(qi\u0006Qq+Z5hQR|\u0005\u000f\u001e\u0011\u0002\u0013\r|gNZ5hkJ,GC\u0003B\r\u0005[\u0011\tDa\u0017\u0003pAA!1\u0004B\u0012\u0005S\u0011IC\u0004\u0003\u0003\u001e\t}\u0001\u0003BA\u0012\u0003\u000bIAA!\t\u0002\u0006\u00051\u0001K]3eK\u001aLAA!\n\u0003(\t\u0019Q*\u00199\u000b\t\t\u0005\u0012Q\u0001\t\u0005\u00057\u0011Y#\u0003\u0003\u0003\u0006\t\u001d\u0002b\u0002B\u00187\u0001\u0007\u0011qW\u0001\u0004g\u001a$\bBB<\u001c\u0001\u0004\u0011\u0019\u0004\r\u0004\u00036\t\r#q\u000b\t\t\u0005o\u0011YDa\u0010\u0003V5\u0011!\u0011\b\u0006\u0004\u0003O2\u0018\u0002\u0002B\u001f\u0005s\u00111cR3p\u001b\u0016\u001c\u0018MR3biV\u0014X-\u00138eKb\u0004BA!\u0011\u0003D1\u0001A\u0001\u0004B#\u0005c\t\t\u0011!A\u0003\u0002\t\u001d#aA0%cE!!\u0011\nB(!\u0011\t\u0019Aa\u0013\n\t\t5\u0013Q\u0001\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019A!\u0015\n\t\tM\u0013Q\u0001\u0002\u0004\u0003:L\b\u0003\u0002B!\u0005/\"AB!\u0017\u00032\u0005\u0005\t\u0011!B\u0001\u0005\u000f\u00121a\u0018\u00133\u0011\u001d\u0011if\u0007a\u0001\u0005?\naAZ5mi\u0016\u0014\bCBA\u0002\u0005C\u0012)'\u0003\u0003\u0003d\u0005\u0015!AB(qi&|g\u000e\u0005\u0003\u0003h\t-TB\u0001B5\u0015\u0011\u0011i&!\u001a\n\t\t5$\u0011\u000e\u0002\u0007\r&dG/\u001a:\t\u000f\tE4\u00041\u0001\u0003t\u0005)\u0001.\u001b8ugB!!Q\u000fB<\u001b\t\ti.\u0003\u0003\u0003z\u0005u'!\u0002%j]R\u001c\u0018\u0001D3oG>$WMU3tk2$H\u0003\u0002B@\u0005\u0017\u0003b!a\u0001\u0003\u0002\n\u0015\u0015\u0002\u0002BB\u0003\u000b\u0011Q!\u0011:sCf\u0004B!a\u0001\u0003\b&!!\u0011RA\u0003\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t5E\u00041\u0001\u0003\u0010\u00061!/Z:vYR\u0004BA!%\u0003\u00166\u0011!1\u0013\u0006\u0005\u0003W\n\u0019+\u0003\u0003\u0003\u0018\nM%!\u0004*f]\u0012,'/\u001b8h\u000fJLG-\u0001\u0007eK\u000e|G-\u001a*fgVdG\u000f\u0006\u0005\u0003\u001e\n}%1\u0017B_!\r\tY/\u0003\u0005\b\u0005Ck\u0002\u0019\u0001BR\u0003!)gN^3m_B,\u0007\u0003\u0002BS\u0005_k!Aa*\u000b\t\t%&1V\u0001\u0005O\u0016|WNC\u0002\u0003.j\f1A\u001b;t\u0013\u0011\u0011\tLa*\u0003\u0011\u0015sg/\u001a7pa\u0016DqA!.\u001e\u0001\u0004\u00119,A\u0005he&$w+\u001b3uQB!\u00111\u0001B]\u0013\u0011\u0011Y,!\u0002\u0003\u0007%sG\u000fC\u0004\u0003@v\u0001\rAa.\u0002\u0015\u001d\u0014\u0018\u000e\u001a%fS\u001eDG\u000f\u0006\u0003\u0003D\n%G\u0003BA9\u0005\u000bDqAa2\u001f\u0001\u0004\tI&\u0001\u0002tM\"9!1\u001a\u0010A\u0002\t5\u0017\u0001C4sS\u0012\u001cf.\u00199\u0011\t\tE%qZ\u0005\u0005\u0005#\u0014\u0019J\u0001\u0005He&$7K\\1q\u00035\u0001(o\u001c9feRLh*Y7fgR1!q\u001bBo\u0005?\u0004b!a\u001d\u0003Z\n%\u0012\u0002\u0002Bn\u0003\u0003\u00131aU3r\u0011\u001d\u0011\th\ba\u0001\u0005gBqAa\f \u0001\u0004\t9,A\u0006hKR\u0014VM\u001c3fe\u0016\u0014H\u0003\u0003Bs\t/!I\u0002b\u0007\u0011\u0007\u0005-hJ\u0001\tHK>lW\r\u001e:z%\u0016tG-\u001a:feN\u0019a*!\u0001\u0002\rI,g\u000eZ3s)\u0019\u0011yO!>\u0003zB!\u00111\u0001By\u0013\u0011\u0011\u00190!\u0002\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005o|\u0005\u0019\u0001BH\u0003\u00119'/\u001b3\t\u000f\t\u001dw\n1\u0001\u0002Z%BaJW0VS:\u0004FM\u0001\nMS:,7\u000b\u001e:j]\u001e\u0014VM\u001c3fe\u0016\u00148#\u0002.\u0002\u0002\t\u0015\u0018!A5\u0002\u000f],\u0017n\u001a5feB\u0019\u00111\u001e\u001b\u0003\u000f]+\u0017n\u001a5feN\u0019A'!\u0001\u0002\r],\u0017n\u001a5u)\u0011\tIia\u0004\t\u000f\t\u001dW\u00071\u0001\u0002Z%*Ag\u000e&G\u0005\nYQ)];bY^+\u0017n\u001a5u'%9\u0014\u0011AB\u0003\u0007/\u0019i\u0002\u0005\u0003\u0002\u0004\re\u0011\u0002BB\u000e\u0003\u000b\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0004\r}\u0011\u0002BB\u0011\u0003\u000b\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"a!\n\u0011\u0007\u0005-x\u0007\u0006\u0003\u0002\n\u000e%\u0002b\u0002Bds\u0001\u0007\u0011\u0011L\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t]\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001f\u001a)\u0004C\u0005\u00048q\n\t\u00111\u0001\u00038\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0010\u0011\r\r}2Q\tB(\u001b\t\u0019\tE\u0003\u0003\u0004D\u0005\u0015\u0011AC2pY2,7\r^5p]&!\u0011qPB!\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BB&\u0007#\u0002B!a\u0001\u0004N%!1qJA\u0003\u0005\u001d\u0011un\u001c7fC:D\u0011ba\u000e?\u0003\u0003\u0005\rAa\u0014\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa.\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a>\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007?\u0002B!!?\u0004b%!11MA~\u0005\u0019y%M[3di\n\u0011r+Z5hQR\u0014\u00150\u0012=qe\u0016\u001c8/[8o'\u0015Q\u0015\u0011AB\u0003\u0003\u0005)\u0007\u0003BB7\u0007gj!aa\u001c\u000b\t\rE$\u0011N\u0001\u000bKb\u0004(/Z:tS>t\u0017\u0002BB;\u0007_\u0012!\"\u0012=qe\u0016\u001c8/[8o)\u0011\u0019Iha\u001f\u0011\u0007\u0005-(\nC\u0004\u0004j1\u0003\raa\u001b\u0015\t\u0005%5q\u0010\u0005\b\u0005\u000fl\u0005\u0019AA-\u0005E9V-[4ii\nKhj\u001c8Ok6\u0014WM]\n\u0006\r\u0006\u00051Q\u0001\u000b\u0005\u0007\u000f\u001bI\tE\u0002\u0002l\u001aCqa!\u0001I\u0001\u0004\u00119\f\u0006\u0003\u0002\n\u000e5\u0005b\u0002Bd\u0013\u0002\u0007\u0011\u0011\f\u0002\u000f/\u0016Lw\r\u001b;Cs:+XNY3s'\u0015\u0011\u0015\u0011AB\u0003)\u0011\u0019)ja&\u0011\u0007\u0005-(\tC\u0004\u0004\u0002\u0011\u0003\rAa.\u0015\t\u0005%51\u0014\u0005\b\u0005\u000f,\u0005\u0019AA-)\u0019\u0019yj!)\u0004$B\u0019\u00111\u001e.\t\u000f\r\u0005Q\f1\u0001\u00038\"911A/A\u0002\r\u0015AC\u0002Bx\u0007O\u001bI\u000bC\u0004\u0003xz\u0003\rAa$\t\u000f\t\u001dg\f1\u0001\u0002Z\t9R*\u001e7uS2Kg.Z*ue&twMU3oI\u0016\u0014XM]\n\u0006?\u0006\u0005!Q\u001d\u000b\u0007\u0007c\u001b\u0019l!.\u0011\u0007\u0005-x\fC\u0004\u0004\u0002\t\u0004\rAa.\t\u000f\r\r!\r1\u0001\u0004\u0006Q1!q^B]\u0007wCqAa>d\u0001\u0004\u0011y\tC\u0004\u0003H\u000e\u0004\r!!\u0017\u0003%5+H\u000e^5Q_&tGOU3oI\u0016\u0014XM]\n\u0006+\u0006\u0005!Q\u001d\u000b\u0007\u0007\u0007\u001c)ma2\u0011\u0007\u0005-X\u000bC\u0004\u0004\u0002a\u0003\rAa.\t\u000f\r\r\u0001\f1\u0001\u0004\u0006Q1!q^Bf\u0007\u001bDqAa>Z\u0001\u0004\u0011y\tC\u0004\u0003Hf\u0003\r!!\u0017\u0003)5+H\u000e^5Q_2Lxm\u001c8SK:$WM]3s'\u0015I\u0017\u0011\u0001Bs)\u0019\u0019)na6\u0004ZB\u0019\u00111^5\t\u000f\r\u0005A\u000e1\u0001\u00038\"911\u00017A\u0002\r\u0015AC\u0002Bx\u0007;\u001cy\u000eC\u0004\u0003x6\u0004\rAa$\t\u000f\t\u001dW\u000e1\u0001\u0002Z\tiQ*\u001e7uSJ+g\u000eZ3sKJ\u001cRA\\A\u0001\u0005K$baa:\u0004j\u000e-\bcAAv]\"91\u0011A9A\u0002\t]\u0006bBB\u0002c\u0002\u00071Q\u0001\u000b\u0007\u0005_\u001cyo!=\t\u000f\t](\u000f1\u0001\u0003\u0010\"9!q\u0019:A\u0002\u0005e#!\u0004)pS:$(+\u001a8eKJ,'oE\u0003Q\u0003\u0003\u0011)\u000f\u0006\u0004\u0004z\u000em8Q \t\u0004\u0003W\u0004\u0006bBB\u0001'\u0002\u0007!q\u0017\u0005\b\u0007\u0007\u0019\u0006\u0019AB\u0003)\u0019\u0011y\u000f\"\u0001\u0005\u0004!9!q\u001f+A\u0002\t=\u0005b\u0002Bd)\u0002\u0007\u0011\u0011\f\u0002\u0010!>d\u0017pZ8o%\u0016tG-\u001a:feN)A-!\u0001\u0003fR1A1\u0002C\u0007\t\u001f\u00012!a;e\u0011\u001d\u0019\ta\u001aa\u0001\u0005oCqaa\u0001h\u0001\u0004\u0019)\u0001\u0006\u0004\u0003p\u0012MAQ\u0003\u0005\b\u0005oD\u0007\u0019\u0001BH\u0011\u001d\u00119\r\u001ba\u0001\u00033BqAa\f!\u0001\u0004\t9\fC\u0004\u0003*\u0002\u0002\rA!\u000b\t\u000f\r-\u0001\u00051\u0001\u0005\u001eA1\u00111\u0001B1\u0005S\t!cZ3u\t\u0016t7/\u001b;z\u000f\u0016|W.\u001a;ssR1!\u0011\u0006C\u0012\tKAqAa\f\"\u0001\u0004\t9\fC\u0004\u0003r\u0005\u0002\rAa\u001d\u0003#\u0011+gn]5usN\u001b\u0017M\u001c*fgVdGoE\u0003#\u0003\u0003!Y\u0003\u0005\u0003\u0005.\u0011Mb\u0002BA\b\t_I1\u0001\"\ru\u0003=\tum\u001a:fO\u0006$\u0018N\\4TG\u0006t\u0017\u0002\u0002C\u001b\to\u0011aAU3tk2$(b\u0001C\u0019i\u0006A!/\u001a8eKJ,'\u000f\u0006\u0004\u0005>\u0011}B\u0011\t\t\u0004\u0003W\u0014\u0003b\u0002C\u001dK\u0001\u0007!Q\u001d\u0005\b\u0005o,\u0003\u0019\u0001BH\u0003\u0011Ig.\u001b;\u0015\u0005\t=\u0018!C1hOJ,w-\u0019;f)\u0011\u00119\fb\u0013\t\u000f\t\u001dw\u00051\u0001\u0002Z\u00051QM\\2pI\u0016$\"Aa \u0002\u000f\rdW-\u00198va\nAB)\u001a8tSRL(+Z:vYR\u001cHk\u001c$fCR,(/Z:\u0016\t\u0011]CQN\n\u0006U\u0005\u0005A\u0011\f\t\u0007\t7\")\u0007b\u001b\u000f\t\u0011uC\u0011\r\b\u0005\u00037!y&C\u0002\u0002hYLA\u0001b\u0019\u0003:\u0005I\u0011+^3ssBc\u0017M\\\u0005\u0005\tO\"IGA\tSKN,H\u000e^:U_\u001a+\u0017\r^;sKNTA\u0001b\u0019\u0003:A!!\u0011\tC7\t\u001d!yG\u000bb\u0001\u0005\u000f\u0012\u0011\u0001\u0016\u000b\u0003\tg\u0002R!a;+\tW\"BAa<\u0005x!9A\u0011\u0010\u0017A\u0002\te\u0011!B:uCR,WC\u0001B\r\u0003\u0019\u00198\r[3nC\u0006)\u0011\r\u001d9msR!\u0011\u0011\fCB\u0011\u001d\u0011ii\fa\u0001\tW\nQAY=uKN$BAa \u0005\n\"9!Q\u0012\u0019A\u0002\u0011-D\u0003BB&\t\u001bCq\u0001b$2\u0001\u0004\u0011y%A\u0003pi\",'/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0007\u0017\")\nC\u0004\u0005\u0010J\u0002\rAa\u0014\u0002\u0017\u0015\u000bX/\u00197XK&<\u0007\u000e^\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0016\u0005\u0011u\u0005cAA\f\u001d\u0006a!/\u001a8eKJ,'o\u0018\u0013fcR!!q\u001eCR\u0011%\u00199dAA\u0001\u0002\u0004!i*\u0001\u0007de\u0016\fG/\u001a*fgVdG\u000f\u0006\u0006\u0002\u0016\u0011%F1\u0016CY\tkCqAa\f\u0005\u0001\u0004\t9\fC\u0004\u0005.\u0012\u0001\r\u0001b,\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007CBA\u0002\u0005C\n9\fC\u0004\u00054\u0012\u0001\rAa.\u0002\u0013\t\fGo\u00195TSj,\u0007b\u0002C\\\t\u0001\u0007!\u0011D\u0001\b_B$\u0018n\u001c8t\u0003A!WMZ1vYR\u0014\u0015\r^2i'&TX\r")
public interface DensityScan
extends AggregatingScan<DensityScanResult> {
    public static String getDensityGeometry(SimpleFeatureType simpleFeatureType, Hints hints) {
        return DensityScan$.MODULE$.getDensityGeometry(simpleFeatureType, hints);
    }

    public static GeometryRenderer getRenderer(SimpleFeatureType simpleFeatureType, String string, Option<String> option) {
        return DensityScan$.MODULE$.getRenderer(simpleFeatureType, string, option);
    }

    public static Seq<String> propertyNames(Hints hints, SimpleFeatureType simpleFeatureType) {
        return DensityScan$.MODULE$.propertyNames(hints, simpleFeatureType);
    }

    public static Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature simpleFeature) {
        return DensityScan$.MODULE$.decodeResult(gridSnap, simpleFeature);
    }

    public static Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int n, int n2) {
        return DensityScan$.MODULE$.decodeResult(envelope, n, n2);
    }

    public static byte[] encodeResult(RenderingGrid renderingGrid) {
        return DensityScan$.MODULE$.encodeResult(renderingGrid);
    }

    public static Map<String, String> configure(SimpleFeatureType simpleFeatureType, GeoMesaFeatureIndex<?, ?> geoMesaFeatureIndex, Option<Filter> option, Hints hints) {
        return DensityScan$.MODULE$.configure(simpleFeatureType, geoMesaFeatureIndex, option, hints);
    }

    public static Hints.ClassKey DensityValueKey() {
        return DensityScan$.MODULE$.DensityValueKey();
    }

    public static SimpleFeatureType DensitySft() {
        return DensityScan$.MODULE$.DensitySft();
    }

    public static GeoMesaSystemProperties.SystemProperty BatchSize() {
        return DensityScan$.MODULE$.BatchSize();
    }

    public GeometryRenderer renderer();

    public void renderer_$eq(GeometryRenderer var1);

    public static /* synthetic */ DensityScanResult createResult$(DensityScan $this, SimpleFeatureType sft, Option transform, int batchSize, Map options) {
        return $this.createResult(sft, (Option<SimpleFeatureType>)transform, batchSize, (Map<String, String>)options);
    }

    @Override
    default public DensityScanResult createResult(SimpleFeatureType sft, Option<SimpleFeatureType> transform, int batchSize, Map<String, String> options) {
        String geom = (String)options.getOrElse((Object)DensityScan$Configuration$.MODULE$.GeometryOpt(), (Function0 & Serializable & scala.Serializable)() -> sft.getGeometryDescriptor().getLocalName());
        GeometryRenderer renderer = DensityScan$.MODULE$.getRenderer(sft, geom, (Option<String>)options.get((Object)DensityScan$Configuration$.MODULE$.WeightOpt()));
        double[] bounds = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt())).split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)DensityScan.$anonfun$createResult$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Envelope envelope = new Envelope(bounds[0], bounds[1], bounds[2], bounds[3]);
        int[] nArray = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.GridOpt())).split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DensityScan.$anonfun$createResult$3(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Option option = Array$.MODULE$.unapplySeq((Object)nArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)nArray);
        }
        int width = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
        int height = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        int width2 = sp2._1$mcI$sp();
        int height2 = sp2._2$mcI$sp();
        return new DensityScanResult(renderer, new RenderingGrid(envelope, width2, height2));
    }

    public static /* synthetic */ int defaultBatchSize$(DensityScan $this) {
        return $this.defaultBatchSize();
    }

    @Override
    default public int defaultBatchSize() {
        return BoxesRunTime.unboxToInt((Object)DensityScan$.MODULE$.BatchSize().toInt().get());
    }

    public static /* synthetic */ double $anonfun$createResult$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    public static /* synthetic */ int $anonfun$createResult$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static void $init$(DensityScan $this) {
    }

    public static abstract class DensityResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return DensityScan$.MODULE$.DensitySft();
        }

        @Override
        public SimpleFeature apply(T result) {
            ScalaSimpleFeature sf = new ScalaSimpleFeature(DensityScan$.MODULE$.DensitySft(), "", new Object[]{GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            sf.getUserData().put(DensityScan$.MODULE$.DensityValueKey(), this.bytes(result));
            return sf;
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof DensityResultsToFeatures;
        }

        public boolean equals(Object other) {
            DensityResultsToFeatures densityResultsToFeatures;
            Object object = other;
            return object instanceof DensityResultsToFeatures && (densityResultsToFeatures = (DensityResultsToFeatures)object).canEqual(this);
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }

    public static class DensityScanResult
    implements AggregatingScan.Result {
        private final GeometryRenderer renderer;
        private final RenderingGrid grid;

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            this.renderer.render(this.grid, sf);
            return 1;
        }

        @Override
        public byte[] encode() {
            byte[] byArray;
            try {
                byArray = DensityScan$.MODULE$.encodeResult(this.grid);
            }
            finally {
                this.grid.clear();
            }
            return byArray;
        }

        @Override
        public void cleanup() {
        }

        public DensityScanResult(GeometryRenderer renderer, RenderingGrid grid) {
            this.renderer = renderer;
            this.grid = grid;
        }
    }

    public static interface GeometryRenderer {
        public void render(RenderingGrid var1, SimpleFeature var2);
    }

    public static class LineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((LineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public LineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiLineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiLineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiLineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPoint)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPolygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Geometry)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Point)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Polygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static interface Weigher {
        public double weight(SimpleFeature var1);
    }

    public static class WeightByExpression
    implements Weigher {
        private final Expression e;

        @Override
        public double weight(SimpleFeature sf) {
            Double d = (Double)this.e.evaluate((Object)sf, Double.class);
            if (d == null) {
                return 0.0;
            }
            return Predef$.MODULE$.Double2double(d);
        }

        public WeightByExpression(Expression e) {
            this.e = e;
        }
    }

    public static class WeightByNonNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Object d = sf.getAttribute(this.i);
            if (d == null) {
                return 0.0;
            }
            Double converted = (Double)FastConverter$.MODULE$.convert(d, Double.class);
            if (converted == null) {
                return 1.0;
            }
            return converted;
        }

        public WeightByNonNumber(int i) {
            this.i = i;
        }
    }

    public static class WeightByNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Number d = (Number)sf.getAttribute(this.i);
            if (d == null) {
                return 0.0;
            }
            return d.doubleValue();
        }

        public WeightByNumber(int i) {
            this.i = i;
        }
    }
}

