/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndexFactory$;
import org.locationtech.geomesa.utils.cache.ThreadLocalCache;
import org.locationtech.geomesa.utils.cache.ThreadLocalCache$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.conf.IndexId$;
import org.locationtech.geomesa.utils.geotools.SimpleFeaturePropertyAccessor$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IteratorCache$
implements StrictLogging {
    public static IteratorCache$ MODULE$;
    private final Duration expiry;
    private final Cache<Tuple2<String, String>, KryoFeatureSerializer> serializerCache;
    private final Cache<Tuple2<String, String>, GeoMesaFeatureIndex<?, ?>> indexCache;
    private final ThreadLocalCache<Tuple2<String, String>, Filter> filterCache;
    private final Logger logger;

    static {
        new IteratorCache$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Duration expiry() {
        return this.expiry;
    }

    private Cache<Tuple2<String, String>, KryoFeatureSerializer> serializerCache() {
        return this.serializerCache;
    }

    private Cache<Tuple2<String, String>, GeoMesaFeatureIndex<?, ?>> indexCache() {
        return this.indexCache;
    }

    private ThreadLocalCache<Tuple2<String, String>, Filter> filterCache() {
        return this.filterCache;
    }

    public SimpleFeatureType sft(String spec) {
        return SimpleFeatureTypes$.MODULE$.createImmutableType("", spec);
    }

    public KryoFeatureSerializer serializer(String spec, Set<Enumeration.Value> options) {
        KryoFeatureSerializer cached = (KryoFeatureSerializer)this.serializerCache().getIfPresent((Object)new Tuple2((Object)spec, (Object)options.mkString()));
        if (cached != null) {
            return cached;
        }
        KryoFeatureSerializer serializer = KryoFeatureSerializer$.MODULE$.apply(this.sft(spec), options);
        this.serializerCache().put((Object)new Tuple2((Object)spec, (Object)options.mkString()), (Object)serializer);
        return serializer;
    }

    public Filter filter(SimpleFeatureType sft, String spec, String ecql) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Filter cache estimated size: {}", new Object[]{BoxesRunTime.boxToLong((long)this.filterCache().estimatedGlobalSize())});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Filter cache entries: {}", new Object[]{this.filterCache().globalIterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    long t = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    Tuple2 tuple2 = (Tuple2)tuple3._2();
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return new StringBuilder(10).append("thread ").append(t).append(" ").append(k).append("=>").append(v).toString();
                    }
                }
                throw new MatchError((Object)tuple3);
            }).mkString(", ")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Filter)this.filterCache().getOrElseUpdate((Object)new Tuple2((Object)spec, (Object)ecql), (Function0 & Serializable & scala.Serializable)() -> FastFilterFactory$.MODULE$.toFilter(sft, ecql));
    }

    public GeoMesaFeatureIndex<?, ?> index(SimpleFeatureType sft, String spec, String identifier) {
        GeoMesaFeatureIndex cached = (GeoMesaFeatureIndex)this.indexCache().getIfPresent((Object)new Tuple2((Object)spec, (Object)identifier));
        if (cached != null) {
            return cached;
        }
        GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)GeoMesaFeatureIndexFactory$.MODULE$.create(null, sft, (Seq<IndexId>)((Seq)new .colon.colon((Object)IndexId$.MODULE$.id(identifier), (List)Nil$.MODULE$))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(39).append("Index option not configured correctly: ").append(identifier).toString());
        });
        if (!index.mode().supports(IndexMode$.MODULE$.Read())) {
            throw new RuntimeException(new StringBuilder(50).append("Index option configured for a non-readable index: ").append(identifier).toString());
        }
        this.indexCache().put((Object)new Tuple2((Object)spec, (Object)identifier), (Object)index);
        return index;
    }

    private IteratorCache$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SimpleFeaturePropertyAccessor$.MODULE$.initialize();
        this.expiry = (Duration)new GeoMesaSystemProperties.SystemProperty("geomesa.filter.remote.cache.expiry", "10 minutes").toDuration().get();
        this.serializerCache = Caffeine.newBuilder().expireAfterAccess(this.expiry().toMillis(), TimeUnit.MILLISECONDS).build();
        this.indexCache = Caffeine.newBuilder().expireAfterAccess(this.expiry().toMillis(), TimeUnit.MILLISECONDS).build();
        this.filterCache = new ThreadLocalCache(this.expiry(), ThreadLocalCache$.MODULE$.$lessinit$greater$default$2(), ThreadLocalCache$.MODULE$.$lessinit$greater$default$3());
    }
}

