/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.index.utils.Reprojection$QueryReferenceSystems$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.geomesa.utils.geotools.Transform$;
import org.locationtech.geomesa.utils.stats.StatParser$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class QueryPlanner$
implements LazyLogging {
    public static QueryPlanner$ MODULE$;
    private final SoftThreadLocal<Map<Object, Object>> threadedHints;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new QueryPlanner$();
    }

    private Logger logger$lzycompute() {
        QueryPlanner$ queryPlanner$ = this;
        synchronized (queryPlanner$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SoftThreadLocal<Map<Object, Object>> threadedHints() {
        return this.threadedHints;
    }

    public void setPerThreadQueryHints(Map<Object, Object> hints) {
        this.threadedHints().put(hints);
    }

    public Option<Map<Object, Object>> getPerThreadQueryHints() {
        return this.threadedHints().get();
    }

    public void clearPerThreadQueryHints() {
        this.threadedHints().clear();
    }

    public void setQueryTransforms(SimpleFeatureType sft, Query query) {
        this.extractQueryTransforms(sft, query).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                SimpleFeatureType schema = (SimpleFeatureType)tuple3._1();
                String transforms = (String)tuple3._3();
                query.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORMS(), (Object)transforms);
                return query.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORM_SCHEMA(), (Object)schema);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public Option<Tuple3<SimpleFeatureType, Seq<Transform>, String>> extractQueryTransforms(SimpleFeatureType sft, Query query) {
        return Option$.MODULE$.apply((Object)query.getPropertyNames()).map((Function1 & Serializable & scala.Serializable)props -> QueryPlanner$.withSort$1(props, query)).filterNot((Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner$.noop$1(props, sft))).orElse((Function0 & Serializable & scala.Serializable)() -> QueryPlanner$.fromQueryType$1(query, sft)).map((Function1 & Serializable & scala.Serializable)props -> {
            Seq transforms = Transform.Transforms$.MODULE$.apply(sft, props);
            SimpleFeatureType schema = Transform.Transforms$.MODULE$.schema(sft, transforms);
            String definition = props.mkString(Transform$.MODULE$.DefinitionDelimiter());
            return new Tuple3((Object)schema, (Object)transforms, (Object)definition);
        });
    }

    public void setQuerySort(SimpleFeatureType sft, Query query) {
        block8: {
            Hints hints;
            SortBy[] sortBy;
            block9: {
                block11: {
                    block10: {
                        sortBy = query.getSortBy();
                        if (sortBy == null || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).nonEmpty()) break block8;
                        hints = query.getHints();
                        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
                            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).lengthCompare(1) > 0) {
                                throw new IllegalArgumentException(new StringBuilder(51).append("Arrow queries only support sort by a single field: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).mkString(", ")).toString());
                            }
                            if (((SortBy)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).head()).getPropertyName() == null) {
                                throw new IllegalArgumentException(new StringBuilder(47).append("Arrow queries only support sort by properties: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).mkString(", ")).toString());
                            }
                            String field = ((SortBy)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).head()).getPropertyName().getPropertyName();
                            SortOrder sortOrder = ((SortBy)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).head()).getSortOrder();
                            SortOrder sortOrder2 = SortOrder.DESCENDING;
                            boolean reverse = !(sortOrder != null ? !sortOrder.equals(sortOrder2) : sortOrder2 != null);
                            QueryHints$.MODULE$.RichHints(hints).getArrowSort().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                QueryPlanner$.$anonfun$setQuerySort$1(field, reverse, sortBy, x0$1);
                                return BoxedUnit.UNIT;
                            });
                            hints.put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), (Object)field);
                            hints.put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)reverse));
                            return;
                        }
                        if (!QueryHints$.MODULE$.RichHints(hints).isBinQuery()) break block9;
                        String dtg = (String)QueryHints$.MODULE$.RichHints(hints).getBinDtgField().orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).orNull(Predef$.MODULE$.$conforms());
                        if (dtg == null) break block10;
                        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).map((Function1 & Serializable & scala.Serializable)s -> (String)Option$.MODULE$.apply((Object)s.getPropertyName()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getPropertyName()).orNull(Predef$.MODULE$.$conforms()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
                        .colon.colon colon2 = new .colon.colon((Object)dtg, (List)Nil$.MODULE$);
                        if (!(seq == null ? colon2 != null : !seq.equals(colon2))) break block11;
                    }
                    throw new IllegalArgumentException(new StringBuilder(52).append("BIN queries only support sort by a date-type field: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).mkString(", ")).toString());
                }
                SortOrder sortOrder = ((SortBy)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).head()).getSortOrder();
                SortOrder sortOrder3 = SortOrder.DESCENDING;
                if (!(sortOrder != null ? !sortOrder.equals(sortOrder3) : sortOrder3 != null)) {
                    throw new IllegalArgumentException(new StringBuilder(50).append("BIN queries only support sort in ASCENDING order: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).mkString(", ")).toString());
                }
                if (hints.get((Object)QueryHints$.MODULE$.BIN_SORT()) != null && !QueryHints$.MODULE$.RichHints(hints).isBinSorting()) {
                    throw new IllegalArgumentException(new StringBuilder(47).append("Query sort order contradicts BIN sorting hint: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy)).mkString(", ")).toString());
                }
                hints.put((Object)QueryHints$.MODULE$.BIN_SORT(), (Object)Boolean.TRUE);
                return;
            }
            hints.put((Object)QueryHints$Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints$Internal$.MODULE$.toSortHint(sortBy));
            return;
        }
    }

    public void setProjection(SimpleFeatureType sft, Query query) {
        Reprojection$QueryReferenceSystems$.MODULE$.apply(query).foreach((Function1 & Serializable & scala.Serializable)crs -> query.getHints().put((Object)QueryHints$Internal$.MODULE$.REPROJECTION(), (Object)QueryHints$Internal$.MODULE$.toProjectionHint((Reprojection.QueryReferenceSystems)crs)));
    }

    public void setMaxFeatures(Query query) {
        if (!query.isMaxFeaturesUnlimited()) {
            query.getHints().put((Object)QueryHints$Internal$.MODULE$.MAX_FEATURES(), (Object)BoxesRunTime.boxToInteger((int)query.getMaxFeatures()));
            return;
        }
    }

    private static final Option fromQueryType$1(Query query$5, SimpleFeatureType sft$2) {
        Hints hints = query$5.getHints();
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            return new Some(BinAggregatingScan$.MODULE$.propertyNames(hints, sft$2));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            return new Some(DensityScan$.MODULE$.propertyNames(hints, sft$2));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return new Some((Object)StatParser$.MODULE$.propertyNames(sft$2, QueryHints$.MODULE$.RichHints(hints).getStatsQuery(), StatParser$.MODULE$.propertyNames$default$3()));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractQueryTransforms$5(Object[] eta$0$1$2, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$2).contains(elem);
    }

    private static final Seq withSort$1(String[] props, Query query$5) {
        String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])props)).map((Function1 & Serializable & scala.Serializable)p -> {
            if (new StringOps(Predef$.MODULE$.augmentString(p)).contains((Object)BoxesRunTime.boxToCharacter((char)'='))) {
                return p.substring(0, p.indexOf(61));
            }
            return p;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])props)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)query$5.getSortBy())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)sort -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sort)).flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)s.getPropertyName()).flatMap((Function1 & Serializable & scala.Serializable)p -> {
            Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])names$1);
            return Option$.MODULE$.apply((Object)p.getPropertyName()).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner$.$anonfun$extractQueryTransforms$5(objectArray, elem)));
        })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private static final boolean noop$1(Seq props, SimpleFeatureType sft$2) {
        Seq seq = props;
        Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft$2.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getLocalName(), Buffer$.MODULE$.canBuildFrom());
        return !(seq != null ? !seq.equals(object) : object != null);
    }

    public static final /* synthetic */ void $anonfun$setQuerySort$1(String field$1, boolean reverse$1, SortBy[] sortBy$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String f = (String)tuple2._1();
            boolean r = tuple2._2$mcZ$sp();
            String string = f;
            String string2 = field$1;
            if ((string != null ? !string.equals(string2) : string2 != null) || r != reverse$1) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Query sort does not match Arrow hints sort: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortBy$1)).mkString(", ")).append(" != ").append(f).append(":").append((Object)(r ? "DESC" : "ASC")).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private QueryPlanner$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.threadedHints = new SoftThreadLocal();
    }
}

