/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GraduatedQueryGuard$
implements LazyLogging {
    public static GraduatedQueryGuard$ MODULE$;
    private final String ConfigPath;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GraduatedQueryGuard$();
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard$ graduatedQueryGuard$ = this;
        synchronized (graduatedQueryGuard$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public boolean disabled(String typeName) {
        return new GeoMesaSystemProperties.SystemProperty(new StringBuilder(32).append("geomesa.guard.graduated.").append(typeName).append(".disable").toString(), GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private Seq<GraduatedQueryGuard.SizeAndLimits> evaluateLimits(Seq<GraduatedQueryGuard.SizeAndLimits> limits, SimpleFeatureType sft) {
        Seq candidate = (Seq)limits.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sizeLimit()), (Ordering)Ordering.Int$.MODULE$);
        if (candidate.size() > 1) {
            BooleanRef hasDuration = BooleanRef.create((boolean)false);
            BooleanRef hasPercentage = BooleanRef.create((boolean)false);
            candidate.sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GraduatedQueryGuard$.$anonfun$evaluateLimits$2(hasDuration, hasPercentage, sft, x0$1);
                return BoxedUnit.UNIT;
            });
        } else if (candidate.isEmpty()) {
            throw new IllegalArgumentException("Graduated query guard configuration is empty.");
        }
        if (((GraduatedQueryGuard.SizeAndLimits)candidate.last()).sizeLimit() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Graduated query guard configuration must include ").append("unbounded restriction.").toString());
        }
        return candidate;
    }

    public Seq<GraduatedQueryGuard.SizeAndLimits> buildLimits(java.util.List<? extends Config> guardConfig, SimpleFeatureType sft) {
        Buffer confs = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(guardConfig).asScala()).map((Function1 & Serializable & scala.Serializable)limitsConfig -> {
            int size = limitsConfig.hasPath("size") ? limitsConfig.getInt("size") : Integer.MAX_VALUE;
            None$ duration = limitsConfig.hasPath("duration") ? new Some((Object)Duration$.MODULE$.apply(limitsConfig.getString("duration"))) : None$.MODULE$;
            None$ percentage = limitsConfig.hasPath("sampling-percentage") ? new Some((Object)BoxesRunTime.boxToDouble((double)limitsConfig.getDouble("sampling-percentage"))) : None$.MODULE$;
            None$ percentageAttr = limitsConfig.hasPath("sampling-attribute") ? new Some((Object)limitsConfig.getString("sampling-attribute")) : None$.MODULE$;
            return new GraduatedQueryGuard.SizeAndLimits(size, (Option<Duration>)duration, (Option<Object>)percentage, (Option<String>)percentageAttr);
        }, Buffer$.MODULE$.canBuildFrom());
        return this.evaluateLimits((Seq<GraduatedQueryGuard.SizeAndLimits>)confs.toSeq(), sft);
    }

    public static final /* synthetic */ void $anonfun$evaluateLimits$3(SimpleFeatureType sft$1, GraduatedQueryGuard.SizeAndLimits first$1, Option x0$2) {
        Some some;
        String attr;
        Option option = x0$2;
        if (option instanceof Some && sft$1.indexOf(attr = (String)(some = (Some)option).value()) == -1) {
            throw new IllegalArgumentException(new StringBuilder(87).append("Graduated query guard configuration ").append("has invalid attribute name for filter. ").append(first$1.sampleAttribute().get()).append(" not in sft ").append(sft$1.getTypeName()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$evaluateLimits$2(BooleanRef hasDuration$1, BooleanRef hasPercentage$1, SimpleFeatureType sft$1, Seq x0$1) {
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            GraduatedQueryGuard.SizeAndLimits first = (GraduatedQueryGuard.SizeAndLimits)((SeqLike)some.get()).apply(0);
            GraduatedQueryGuard.SizeAndLimits second = (GraduatedQueryGuard.SizeAndLimits)((SeqLike)some.get()).apply(1);
            if (first.sizeLimit() == second.sizeLimit()) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Graduated query guard configuration ").append("has repeated size: ").append(first.sizeLimit()).toString());
            }
            if (first.durationLimit().isDefined() || hasDuration$1.elem) {
                hasDuration$1.elem = true;
                if (second.durationLimit().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(67).append("Graduated query guard configuration ").append("has missing duration in size = ").append(second.sizeLimit()).toString());
                }
                if (((Ordered)first.durationLimit().get()).compareTo(second.durationLimit().get()) <= 0) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Graduated query guard configuration ").append("has durations out of order: ").append(first.durationLimit().get()).append(" is less than ").append(second.durationLimit().get()).toString());
                }
            }
            if (first.percentageLimit().isDefined() || hasPercentage$1.elem) {
                hasPercentage$1.elem = true;
                if (second.percentageLimit().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(69).append("Graduated query guard configuration ").append("has missing percentage in size = ").append(second.sizeLimit()).toString());
                }
                if (BoxesRunTime.unboxToDouble((Object)first.percentageLimit().get()) < BoxesRunTime.unboxToDouble((Object)second.percentageLimit().get())) {
                    throw new IllegalArgumentException(new StringBuilder(91).append("Graduated query guard configuration ").append("has percentages out of order or missing: ").append(first.percentageLimit().get()).append(" is less than ").append(second.durationLimit().get()).toString());
                }
            }
            ((IterableLike)new .colon.colon(first.sampleAttribute(), (List)new .colon.colon(second.sampleAttribute(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                GraduatedQueryGuard$.$anonfun$evaluateLimits$3(sft$1, first, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)seq);
    }

    private GraduatedQueryGuard$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.ConfigPath = "geomesa.guard.graduated";
    }
}

