/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard$;
import org.locationtech.geomesa.index.planning.guard.package$;
import org.locationtech.jts.geom.Envelope;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001\u0002\u0011\"\u00019BQ!\u0012\u0001\u0005\u0002\u0019C\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0002&\t\u0017\u0005]\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0018\u0005\u000b\u0003\u000b\u0004\u0001\u0019!A!B\u0013Y\u0005\"CA(\u0001\u0001\u0007I\u0011BAd\u0011%\tI\r\u0001a\u0001\n\u0013\tY\r\u0003\u0005\u0002P\u0002\u0001\u000b\u0015BA*\u0011\u001d\t\t\u000e\u0001C!\u0003'Dq!a:\u0001\t\u0003\nI\u000f\u0003\u0004#\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u0005+\u0001A\u0011\tB\f\u000f\u00159\u0017\u0005#\u0001i\r\u0015\u0001\u0013\u0005#\u0001j\u0011\u0015)U\u0002\"\u0001o\u0011\u001dyWB1A\u0005\u0002ADa\u0001^\u0007!\u0002\u0013\th\u0001B;\u000e\u0001YD\u0001b^\t\u0003\u0006\u0004%\t\u0001\u001f\u0005\tyF\u0011\t\u0011)A\u0005s\"AQ0\u0005BC\u0002\u0013\u0005a\u0010C\u0005\u0002\u0016E\u0011\t\u0011)A\u0005\u007f\"Q\u0011qC\t\u0003\u0002\u0003\u0006I!!\u0007\t\u0015\u0005\u0005\u0012C!b\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u00026E\u0011\t\u0011)A\u0005\u0003KAa!R\t\u0005\u0002\u0005]\u0002\"CA##\t\u0007I\u0011AA$\u0011!\tI%\u0005Q\u0001\n\u0005e\u0001bBA&#\u0011\u0005\u0013Q\n\u0005\b\u0003\u001fjA\u0011AA)\u0011\u001d\ti&\u0004C\u0005\u0003?Bq!a!\u000e\t\u0003\t)IA\nHe\u0006$W/\u0019;fIF+XM]=Hk\u0006\u0014HM\u0003\u0002#G\u0005)q-^1sI*\u0011A%J\u0001\ta2\fgN\\5oO*\u0011aeJ\u0001\u0006S:$W\r\u001f\u0006\u0003Q%\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002+W\u0005aAn\\2bi&|g\u000e^3dQ*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001_]Z\u0004C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011a\u0017M\\4\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005aJT\"A\u0012\n\u0005i\u001a#\u0001E)vKJL\u0018J\u001c;fe\u000e,\u0007\u000f^8s!\ta4)D\u0001>\u0015\tqt(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002A\u0003\u0006AA/\u001f9fg\u00064WMC\u0001C\u0003\r\u0019w.\\\u0005\u0003\tv\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011!I\u0001\fOV\f'\u000f\u001a'j[&$8/F\u0001L!\rae+\u0017\b\u0003\u001bNs!AT)\u000e\u0003=S!\u0001U\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+V\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AU\u0005\u0003/b\u00131aU3r\u0015\t!V\u000b\u0005\u0002[#9\u00111\f\u0004\b\u00039\u001at!!X3\u000f\u0005y#gBA0d\u001d\t\u0001'M\u0004\u0002OC&\tA&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0005\t\u001a\u0013aE$sC\u0012,\u0018\r^3e#V,'/_$vCJ$\u0007C\u0001%\u000e'\ri!n\u000f\t\u0003W2l\u0011!V\u0005\u0003[V\u0013a!\u00118z%\u00164G#\u00015\u0002\u0015\r{gNZ5h!\u0006$\b.F\u0001r!\t\u0001$/\u0003\u0002tc\t11\u000b\u001e:j]\u001e\f1bQ8oM&<\u0007+\u0019;iA\ti1+\u001b>f\u0003:$G*[7jiN\u001c\"!\u00056\u0002\u0013ML'0\u001a'j[&$X#A=\u0011\u0005-T\u0018BA>V\u0005\rIe\u000e^\u0001\u000bg&TX\rT5nSR\u0004\u0013!\u00043ve\u0006$\u0018n\u001c8MS6LG/F\u0001\u0000!\u0015Y\u0017\u0011AA\u0003\u0013\r\t\u0019!\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005AA-\u001e:bi&|gNC\u0002\u0002\u0010U\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019\"!\u0003\u0003\u0011\u0011+(/\u0019;j_:\fa\u0002Z;sCRLwN\u001c'j[&$\b%A\u0007tC6\u0004H.\u001a)fe\u000e,g\u000e\u001e\t\u0006W\u0006\u0005\u00111\u0004\t\u0004W\u0006u\u0011bAA\u0010+\n1Ai\\;cY\u0016\fqb]1na2,\u0017\t\u001e;sS\n,H/Z\u000b\u0003\u0003K\u0001Ra[A\u0001\u0003O\u0001B!!\u000b\u000229!\u00111FA\u0017!\tqU+C\u0002\u00020U\u000ba\u0001\u0015:fI\u00164\u0017bA:\u00024)\u0019\u0011qF+\u0002!M\fW\u000e\u001d7f\u0003R$(/\u001b2vi\u0016\u0004CCCA\u001d\u0003{\ty$!\u0011\u0002DA\u0019\u00111H\t\u000e\u00035AQa^\rA\u0002eDQ!`\rA\u0002}Dq!a\u0006\u001a\u0001\u0004\tI\u0002C\u0004\u0002\"e\u0001\r!!\n\u0002\u001fA,'oY3oi\u0006<W\rT5nSR,\"!!\u0007\u0002!A,'oY3oi\u0006<W\rT5nSR\u0004\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0012\u0001\u00033jg\u0006\u0014G.\u001a3\u0015\t\u0005M\u0013\u0011\f\t\u0004W\u0006U\u0013bAA,+\n9!i\\8mK\u0006t\u0007bBA.;\u0001\u0007\u0011qE\u0001\tif\u0004XMT1nK\u0006qQM^1mk\u0006$X\rT5nSR\u001cHCBA1\u0003G\n9\u0007\u0005\u0003M-\u0006e\u0002bBA3=\u0001\u0007\u0011\u0011M\u0001\u0007Y&l\u0017\u000e^:\t\u000f\u0005%d\u00041\u0001\u0002l\u0005\u00191O\u001a;\u0011\t\u00055\u0014qP\u0007\u0003\u0003_RA!!\u001d\u0002t\u000511/[7qY\u0016TA!!\u001e\u0002x\u00059a-Z1ukJ,'\u0002BA=\u0003w\n1!\u00199j\u0015\r\tihK\u0001\tO\u0016|Go\\8mg&!\u0011\u0011QA8\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\fEVLG\u000e\u001a'j[&$8\u000f\u0006\u0004\u0002b\u0005\u001d\u0015Q\u0017\u0005\b\u0003\u0013{\u0002\u0019AAF\u0003-9W/\u0019:e\u0007>tg-[41\t\u00055\u0015Q\u0014\t\u0007\u0003\u001f\u000b)*!'\u000e\u0005\u0005E%bAAJg\u0005!Q\u000f^5m\u0013\u0011\t9*!%\u0003\t1K7\u000f\u001e\t\u0005\u00037\u000bi\n\u0004\u0001\u0005\u0019\u0005}\u0015qQA\u0001\u0002\u0003\u0015\t!!)\u0003\u0007}#3'\u0005\u0003\u0002$\u0006%\u0006cA6\u0002&&\u0019\u0011qU+\u0003\u000f9{G\u000f[5oOB!\u00111VAY\u001b\t\tiKC\u0002\u00020~\naaY8oM&<\u0017\u0002BAZ\u0003[\u0013aaQ8oM&<\u0007bBA5?\u0001\u0007\u00111N\u0001\u0010OV\f'\u000f\u001a'j[&$8o\u0018\u0013fcR!\u00111XAa!\rY\u0017QX\u0005\u0004\u0003\u007f+&\u0001B+oSRD\u0001\"a1\u0004\u0003\u0003\u0005\raS\u0001\u0004q\u0012\n\u0014\u0001D4vCJ$G*[7jiN\u0004SCAA*\u00031!\u0017n]1cY\u0016$w\fJ3r)\u0011\tY,!4\t\u0013\u0005\rg!!AA\u0002\u0005M\u0013!\u00033jg\u0006\u0014G.\u001a3!\u0003\u0011Ig.\u001b;\u0015\r\u0005m\u0016Q[As\u0011\u001d\t9\u000e\u0003a\u0001\u00033\f!\u0001Z:\u0011\t\u0005m\u0017\u0011]\u0007\u0003\u0003;TA!a8\u0002x\u0005!A-\u0019;b\u0013\u0011\t\u0019/!8\u0003\u0013\u0011\u000bG/Y*u_J,\u0007bBA5\u0011\u0001\u0007\u00111N\u0001\be\u0016<(/\u001b;f)\u0011\tY,a;\t\u000f\u00055\u0018\u00021\u0001\u0002p\u0006)\u0011/^3ssB!\u00111\\Ay\u0013\u0011\t\u00190!8\u0003\u000bE+XM]=\u0015\t\u0005]\u0018q \t\u0006W\u0006\u0005\u0011\u0011 \t\u0004\u0019\u0006m\u0018bAA\u007f1\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\t\u0005!\u00021\u0001\u0003\u0004\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0003\u0006\t=a\u0002\u0002B\u0004\u0005\u0017q1!\u0018B\u0005\u0013\r\tI(J\u0005\u0004)\n5!bAA=K%!!\u0011\u0003B\n\u00055\tV/\u001a:z'R\u0014\u0018\r^3hs*\u0019AK!\u0004\u0002\u000b\rdwn]3\u0015\u0005\u0005m\u0006")
public class GraduatedQueryGuard
implements QueryInterceptor,
LazyLogging {
    private Seq<SizeAndLimits> guardLimits;
    private boolean disabled;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<SizeAndLimits> buildLimits(List<? extends Config> list, SimpleFeatureType simpleFeatureType) {
        return GraduatedQueryGuard$.MODULE$.buildLimits(list, simpleFeatureType);
    }

    public static String ConfigPath() {
        return GraduatedQueryGuard$.MODULE$.ConfigPath();
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard graduatedQueryGuard = this;
        synchronized (graduatedQueryGuard) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Seq<SizeAndLimits> guardLimits() {
        return this.guardLimits;
    }

    private void guardLimits_$eq(Seq<SizeAndLimits> x$1) {
        this.guardLimits = x$1;
    }

    private boolean disabled() {
        return this.disabled;
    }

    private void disabled_$eq(boolean x$1) {
        this.disabled = x$1;
    }

    @Override
    public void init(DataStore ds, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        this.disabled_$eq(GraduatedQueryGuard$.MODULE$.disabled(sft.getTypeName()));
        if (this.disabled()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("This guard is disabled for schema '{}' via system property", new Object[]{sft.getTypeName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.guardLimits_$eq(GraduatedQueryGuard$.MODULE$.buildLimits(ConfigFactory.load().getConfigList(new StringBuilder(1).append(GraduatedQueryGuard$.MODULE$.ConfigPath()).append(".").append(sft.getTypeName()).toString()), sft));
        Predef$.MODULE$.require(this.guardLimits().nonEmpty());
    }

    @Override
    public void rewrite(Query query) {
        if (!this.disabled()) {
            Envelope bounds = (Envelope)query.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
            double spatialExtent = (bounds.getMaxX() - bounds.getMinX()) * (bounds.getMaxY() - bounds.getMinY());
            SizeAndLimits limit = (SizeAndLimits)this.guardLimits().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GraduatedQueryGuard.$anonfun$rewrite$1(spatialExtent, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Invalid extents/limits: {} / {}", new Object[]{query.getFilter().toString(), this.guardLimits().mkString(", ")});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (SizeAndLimits)this.guardLimits().last();
            });
            limit.percentageLimit().map((Function1 & Serializable & scala.Serializable)percentage -> GraduatedQueryGuard.$anonfun$rewrite$3(query, limit, BoxesRunTime.unboxToDouble((Object)percentage)));
            return;
        }
    }

    @Override
    public Option<IllegalArgumentException> guard(package.QueryStrategy strategy) {
        None$ none$;
        if (this.disabled() || !(strategy.index() instanceof package.SpatioTemporalIndex)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            Tuple2 tuple2;
            Option values = strategy.values().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof package.SpatialIndexValues && A1 instanceof package.TemporalIndexValues) {
                        A1 A12 = A1;
                        return (B1)new Tuple2(((package.SpatialIndexValues)A12).spatialBounds(), ((package.TemporalIndexValues)A12).intervals());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof package.SpatialIndexValues && object instanceof package.TemporalIndexValues;
                }
            });
            Option option = values;
            if (None$.MODULE$.equals(option)) {
                none$ = new Some((Object)new StringBuilder(98).append("Query does not have a temporal filter. Maximum allowed filter duration for ").append("whole world queries is ").append(((SizeAndLimits)this.guardLimits().last()).durationLimit()).toString());
            } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Seq s = (Seq)tuple2._1();
                FilterValues i = (FilterValues)tuple2._2();
                double spatialExtent = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)s.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GraduatedQueryGuard.$anonfun$guard$1(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                SizeAndLimits limit = (SizeAndLimits)this.guardLimits().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GraduatedQueryGuard.$anonfun$guard$2(spatialExtent, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Invalid extents/limits: {} / {}", new Object[]{s.mkString(", "), this.guardLimits().mkString(", ")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (SizeAndLimits)this.guardLimits().last();
                });
                none$ = limit.durationLimit().flatMap((Function1 & Serializable & scala.Serializable)l -> {
                    if (!package$.MODULE$.validate((FilterValues<Bounds<ZonedDateTime>>)i, (Duration)l)) {
                        return new Some((Object)new StringBuilder(61).append("Query exceeds maximum allowed filter duration of ").append(limit.durationLimit()).append(" ").append("at ").append(limit.sizeLimit()).append(" degrees").toString());
                    }
                    return None$.MODULE$;
                });
            } else {
                throw new MatchError((Object)option);
            }
        }
        None$ msg = none$;
        return msg.map((Function1 & Serializable & scala.Serializable)m -> new IllegalArgumentException(new StringBuilder(2).append((String)m).append(": ").append(package$.MODULE$.filterString(strategy)).toString()));
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ boolean $anonfun$rewrite$1(double spatialExtent$1, SizeAndLimits x$1) {
        return (double)x$1.sizeLimit() >= spatialExtent$1;
    }

    public static final /* synthetic */ Option $anonfun$rewrite$3(Query query$1, SizeAndLimits limit$1, double percentage) {
        query$1.getHints().put((Object)QueryHints$.MODULE$.SAMPLING(), (Object)BoxesRunTime.boxToFloat((float)((float)percentage)));
        return limit$1.sampleAttribute().map((Function1 & Serializable & scala.Serializable)attr -> query$1.getHints().put((Object)QueryHints$.MODULE$.SAMPLE_BY(), attr));
    }

    public static final /* synthetic */ double $anonfun$guard$1(Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double lx = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ly = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double ux = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double uy = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            return (ux - lx) * (uy - ly);
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$guard$2(double spatialExtent$2, SizeAndLimits x$2) {
        return (double)x$2.sizeLimit() >= spatialExtent$2;
    }

    public GraduatedQueryGuard() {
        QueryInterceptor.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.disabled = false;
    }

    public static class SizeAndLimits {
        private final int sizeLimit;
        private final Option<Duration> durationLimit;
        private final Option<String> sampleAttribute;
        private final Option<Object> percentageLimit;

        public int sizeLimit() {
            return this.sizeLimit;
        }

        public Option<Duration> durationLimit() {
            return this.durationLimit;
        }

        public Option<String> sampleAttribute() {
            return this.sampleAttribute;
        }

        public Option<Object> percentageLimit() {
            return this.percentageLimit;
        }

        public String toString() {
            return new StringBuilder(77).append("SizeAndLimits(sizeLimit=").append(this.sizeLimit()).append(", durationLimit=").append(this.durationLimit()).append(", ").append("percentageLimit=").append(this.percentageLimit()).append(", sampleAttribute=").append(this.sampleAttribute()).append(")").toString();
        }

        public SizeAndLimits(int sizeLimit, Option<Duration> durationLimit, Option<Object> samplePercent, Option<String> sampleAttribute) {
            boolean bl;
            this.sizeLimit = sizeLimit;
            this.durationLimit = durationLimit;
            this.sampleAttribute = sampleAttribute;
            Option<Object> option = samplePercent;
            if (option instanceof Some) {
                Some some = (Some)option;
                double p = BoxesRunTime.unboxToDouble((Object)some.value());
                bl = 0.0 < p && p <= 1.0;
            } else if (None$.MODULE$.equals(option)) {
                bl = true;
            } else {
                throw new MatchError(option);
            }
            Predef$.MODULE$.require(bl, (Function0 & Serializable & scala.Serializable)() -> "Graduated query guard percentages must be in range (0,1]");
            this.percentageLimit = samplePercent;
        }
    }
}

