/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.stats;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.StatsBasedEstimator$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.stats.Frequency;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Z3Histogram;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!\u0003\u000b\u0016!\u0003\r\t\u0001IA\u001a\u0011\u00159\u0003\u0001\"\u0001)\u0011\u0015a\u0003\u0001\"\u0005.\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u00159\u0006\u0001\"\u0003Y\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u00159\b\u0001\"\u0003y\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\ti\u0002\u0001C\u0005\u0003?9q!a\u0011\u0016\u0011\u0003\t)E\u0002\u0004\u0015+!\u0005\u0011q\t\u0005\b\u0003\u0013jA\u0011AA&\u0011%\ti%\u0004b\u0001\n\u0003\ty\u0005\u0003\u0005\u0002X5\u0001\u000b\u0011BA)\u0011%\tI&\u0004b\u0001\n\u0003\tY\u0006\u0003\u0005\u0002f5\u0001\u000b\u0011BA/\u0011!\t9'\u0004C\u0001+\u0005%$aE*uCR\u001c()Y:fI\u0016\u001bH/[7bi>\u0014(B\u0001\f\u0018\u0003\u0015\u0019H/\u0019;t\u0015\tA\u0012$A\u0003j]\u0012,\u0007P\u0003\u0002\u001b7\u00059q-Z8nKN\f'B\u0001\u000f\u001e\u00031awnY1uS>tG/Z2i\u0015\u0005q\u0012aA8sO\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\"\u0012!\u000b\t\u0003E)J!aK\u0012\u0003\tUs\u0017\u000e^\u0001\u000eKN$\u0018.\\1uK\u000e{WO\u001c;\u0015\u00079\"$\tE\u0002#_EJ!\u0001M\u0012\u0003\r=\u0003H/[8o!\t\u0011#'\u0003\u00024G\t!Aj\u001c8h\u0011\u0015)$\u00011\u00017\u0003\r\u0019h\r\u001e\t\u0003o\u0001k\u0011\u0001\u000f\u0006\u0003si\naa]5na2,'BA\u001e=\u0003\u001d1W-\u0019;ve\u0016T!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@;\u0005Aq-Z8u_>d7/\u0003\u0002Bq\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u000b\r\u0013\u0001\u0019\u0001#\u0002\r\u0019LG\u000e^3s!\t)u)D\u0001G\u0015\t\u0019E(\u0003\u0002I\r\n1a)\u001b7uKJ\f\u0001#Z:uS6\fG/Z!oI\u000e{WO\u001c;\u0015\u00079ZE\nC\u00036\u0007\u0001\u0007a\u0007C\u0003D\u0007\u0001\u0007Q\n\u0005\u0002F\u001d&\u0011qJ\u0012\u0002\u0004\u0003:$\u0017aD3ti&l\u0017\r^3Pe\u000e{WO\u001c;\u0015\u00079\u00126\u000bC\u00036\t\u0001\u0007a\u0007C\u0003D\t\u0001\u0007A\u000b\u0005\u0002F+&\u0011aK\u0012\u0002\u0003\u001fJ\f\u0001#Z:uS6\fG/\u001a(pi\u000e{WO\u001c;\u0015\u00079J&\fC\u00036\u000b\u0001\u0007a\u0007C\u0003D\u000b\u0001\u00071\f\u0005\u0002F9&\u0011QL\u0012\u0002\u0004\u001d>$\u0018aG3ti&l\u0017\r^3Ta\u0006$\u0018n\u001c+f[B|'/\u00197D_VtG\u000fF\u0002/A\u0006DQ!\u000e\u0004A\u0002YBQa\u0011\u0004A\u00025\u000ba#Z:uS6\fG/Z!uiJL'-\u001e;f\u0007>,h\u000e\u001e\u000b\u0005]\u0011,g\rC\u00036\u000f\u0001\u0007a\u0007C\u0003D\u000f\u0001\u0007A\tC\u0003h\u000f\u0001\u0007\u0001.A\u0005biR\u0014\u0018NY;uKB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[\u0012\u000e\u00031T!!\\\u0010\u0002\rq\u0012xn\u001c;?\u0013\ty7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8$\u0003Q)7\u000f^5nCR,7\u000b]1uS\u0006d7i\\;oiR\u0019a&\u001e<\t\u000bUB\u0001\u0019\u0001\u001c\t\u000b\rC\u0001\u0019\u0001#\u0002+\u0015\u001cH/[7bi\u0016$V-\u001c9pe\u0006d7i\\;oiR\u0019a&\u001f>\t\u000bUJ\u0001\u0019\u0001\u001c\t\u000b\rK\u0001\u0019\u0001#\u0002'\u0015\u001cH/[7bi\u0016,\u0015/^1mg\u000e{WO\u001c;\u0015\r9jhp`A\u0001\u0011\u0015)$\u00021\u00017\u0011\u0015\u0019%\u00021\u0001E\u0011\u00159'\u00021\u0001i\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000b\taA^1mk\u0016\u001c\bCBA\u0004\u0003#\t9B\u0004\u0003\u0002\n\u00055abA6\u0002\f%\tA%C\u0002\u0002\u0010\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0005U!aA*fc*\u0019\u0011qB\u0012\u0011\u0007\t\nI\"C\u0002\u0002\u001c\r\u00121!\u00118z\u0003I)7\u000f^5nCR,'+\u00198hK\u000e{WO\u001c;\u0015\u000f9\n\t#a\t\u0002&!)Qg\u0003a\u0001m!)qm\u0003a\u0001Q\"9\u0011qE\u0006A\u0002\u0005%\u0012A\u0002:b]\u001e,7\u000f\u0005\u0004\u0002\b\u0005E\u00111\u0006\t\bE\u00055\u0012\u0011GA\u0019\u0013\r\tyc\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\tz\u0013q\u0003\n\u0007\u0003k\tI$!\u0010\u0007\r\u0005]\u0002\u0001AA\u001a\u00051a$/\u001a4j]\u0016lWM\u001c;?!\r\tY\u0004A\u0007\u0002+A!\u00111HA \u0013\r\t\t%\u0006\u0002\r\u000f\u0016|W*Z:b'R\fGo]\u0001\u0014'R\fGo\u001d\"bg\u0016$Wi\u001d;j[\u0006$xN\u001d\t\u0004\u0003wi1CA\u0007\"\u0003\u0019a\u0014N\\5u}Q\u0011\u0011QI\u0001\u00145\"K7\u000f^8he\u0006l\u0007K]3dSNLwN\\\u000b\u0003\u0003#\u00022AIA*\u0013\r\t)f\t\u0002\u0004\u0013:$\u0018\u0001\u0006.ISN$xn\u001a:b[B\u0013XmY5tS>t\u0007%A\bFeJ|'\u000f\u00165sKNDw\u000e\u001c3t+\t\ti\u0006\u0005\u0004\u0002\b\u0005E\u0011q\f\t\u0004E\u0005\u0005\u0014bAA2G\t1Ai\\;cY\u0016\f\u0001#\u0012:s_J$\u0006N]3tQ>dGm\u001d\u0011\u0002\u0019\u0015DHO]1di\u0012\u000bG/Z:\u0015\r\u0005-\u0014qQAE!\u0011\u0011s&!\u001c\u0011\r\u0005=\u00141OA<\u001b\t\t\tH\u0003\u0002D3%!\u0011QOA9\u0005\u0019\u0011u.\u001e8egB!\u0011\u0011PAB\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014\u0001B;uS2T!!!!\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\u000bYH\u0001\u0003ECR,\u0007\"B\u001b\u0014\u0001\u00041\u0004\"B\"\u0014\u0001\u0004!\u0005")
public interface StatsBasedEstimator {
    public static Seq<Object> ErrorThresholds() {
        return StatsBasedEstimator$.MODULE$.ErrorThresholds();
    }

    public static int ZHistogramPrecision() {
        return StatsBasedEstimator$.MODULE$.ZHistogramPrecision();
    }

    public static /* synthetic */ Option estimateCount$(StatsBasedEstimator $this, SimpleFeatureType sft, Filter filter) {
        return $this.estimateCount(sft, filter);
    }

    default public Option<Object> estimateCount(SimpleFeatureType sft, Filter filter) {
        Filter filter2 = filter;
        IncludeFilter includeFilter = Filter.INCLUDE;
        Filter filter3 = filter2;
        if (!(includeFilter != null ? !includeFilter.equals(filter3) : filter3 != null)) {
            return ((GeoMesaStats)((Object)this)).getCount(sft, ((GeoMesaStats)((Object)this)).getCount$default$2(), ((GeoMesaStats)((Object)this)).getCount$default$3(), ((GeoMesaStats)((Object)this)).getCount$default$4());
        }
        ExcludeFilter excludeFilter = Filter.EXCLUDE;
        Filter filter4 = filter2;
        if (!(excludeFilter != null ? !excludeFilter.equals(filter4) : filter4 != null)) {
            return new Some((Object)BoxesRunTime.boxToLong((long)0L));
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            return this.estimateAndCount(sft, and);
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            return this.estimateOrCount(sft, or);
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            return this.estimateNotCount(sft, not);
        }
        if (filter2 instanceof Id) {
            Id id = (Id)filter2;
            return new Some((Object)BoxesRunTime.boxToLong((long)id.getIdentifiers().size()));
        }
        Option attribute = FilterHelper$.MODULE$.propertyNames(filter, sft).headOption();
        return attribute.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.estimateAttributeCount(sft, filter, (String)x$1));
    }

    private Option<Object> estimateAndCount(SimpleFeatureType sft, And filter) {
        Option<Object> stCount = this.estimateSpatioTemporalCount(sft, filter);
        Buffer individualCounts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(filter.getChildren()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.estimateCount(sft, (Filter)x$2)), Buffer$.MODULE$.canBuildFrom());
        Iterable counts = (Iterable)Option$.MODULE$.option2Iterable(stCount).$plus$plus((GenTraversableOnce)individualCounts, scala.collection.Iterable$.MODULE$.canBuildFrom());
        if (counts.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(counts.min((Ordering)Ordering.Long$.MODULE$));
    }

    private Option<Object> estimateOrCount(SimpleFeatureType sft, Or filter) {
        Buffer counts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(filter.getChildren()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(this.estimateCount(sft, (Filter)x$3)), Buffer$.MODULE$.canBuildFrom());
        if (counts.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(counts.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private Option<Object> estimateNotCount(SimpleFeatureType sft, Not filter) {
        Filter filter2 = filter.getFilter();
        if (filter2 instanceof PropertyIsNull) {
            PropertyIsNull propertyIsNull = (PropertyIsNull)filter2;
            Expression expression = propertyIsNull.getExpression();
            if (expression instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)expression;
                return this.estimateRangeCount(sft, propertyName.getPropertyName(), (Seq<Tuple2<Option<Object>, Option<Object>>>)((Seq)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$), (List)Nil$.MODULE$)));
            }
            return this.estimateCount(sft, (Filter)Filter.INCLUDE);
        }
        return this.estimateCount(sft, (Filter)Filter.INCLUDE).flatMap((Function1 & Serializable & scala.Serializable)all -> StatsBasedEstimator.$anonfun$estimateNotCount$1(this, sft, filter2, BoxesRunTime.unboxToLong((Object)all)));
    }

    private Option<Object> estimateSpatioTemporalCount(SimpleFeatureType sft, And filter) {
        return Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).flatMap((Function1 & Serializable & scala.Serializable)geomField -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).map((Function1 & Serializable & scala.Serializable)dateField -> {
            FilterValues geometries = FilterHelper$.MODULE$.extractGeometries((Filter)filter, geomField, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            return new Tuple2(dateField, (Object)geometries);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$3(x$13))).map((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                String dateField = (String)tuple2._1();
                FilterValues intervals = FilterHelper$.MODULE$.extractIntervals((Filter)filter, dateField, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
                return new Tuple2((Object)tuple2, (Object)intervals);
            }
            throw new MatchError((Object)tuple2);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$5(x$16))).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                FilterValues intervals = (FilterValues)tuple2._2();
                if (tuple22 != null) {
                    String dateField = (String)tuple22._1();
                    FilterValues geometries = (FilterValues)tuple22._2();
                    return ((GeoMesaStats)((Object)this)).getMinMax(sft, dateField, ((GeoMesaStats)((Object)this)).getMinMax$default$3(), ((GeoMesaStats)((Object)this)).getMinMax$default$4()).map((Function1 & Serializable & scala.Serializable)bounds -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$7(this, geometries, intervals, sft, geomField, dateField, filter, bounds)));
                }
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private Option<Object> estimateAttributeCount(SimpleFeatureType sft, Filter filter, String attribute) {
        String string = attribute;
        String string2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.estimateSpatialCount(sft, filter);
        }
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).contains((Object)attribute)) {
            return this.estimateTemporalCount(sft, filter);
        }
        Option extractedBounds = Option$.MODULE$.apply((Object)sft.getDescriptor(attribute)).map((Function1 & Serializable & scala.Serializable)descriptor -> {
            Class binding = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) : descriptor.getType().getBinding();
            return new Tuple2(descriptor, (Object)binding);
        }).map((Function1 & Serializable & scala.Serializable)x$18 -> {
            Tuple2 tuple2 = x$18;
            if (tuple2 != null) {
                Class binding = (Class)tuple2._2();
                return FilterHelper$.MODULE$.extractAttributeBounds(filter, attribute, binding);
            }
            throw new MatchError((Object)tuple2);
        });
        return extractedBounds.flatMap(arg_0 -> StatsBasedEstimator.$anonfun$estimateAttributeCount$3(this, sft, filter, attribute, arg_0));
    }

    private Option<Object> estimateSpatialCount(SimpleFeatureType sft, Filter filter) {
        FilterValues geometries = FilterHelper$.MODULE$.extractGeometries(filter, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        if (geometries.isEmpty()) {
            return None$.MODULE$;
        }
        if (geometries.disjoint()) {
            return new Some((Object)BoxesRunTime.boxToLong((long)0L));
        }
        Point zero = GeometryUtils$.MODULE$.zeroPoint();
        return ((GeoMesaStats)((Object)this)).getHistogram(sft, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), 0, zero, zero, ((GeoMesaStats)((Object)this)).getHistogram$default$6(), ((GeoMesaStats)((Object)this)).getHistogram$default$7()).map((Function1 & Serializable & scala.Serializable)histogram -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateSpatialCount$1(geometries, histogram)));
    }

    private Option<Object> estimateTemporalCount(SimpleFeatureType sft, Filter filter) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).map((Function1 & Serializable & scala.Serializable)dateField -> {
            FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(filter, dateField, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
            return new Tuple2(dateField, (Object)intervals);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateTemporalCount$2(x$31))).flatMap((Function1 & Serializable & scala.Serializable)x$32 -> {
            Tuple2 tuple2 = x$32;
            if (tuple2 != null) {
                String dateField = (String)tuple2._1();
                FilterValues intervals = (FilterValues)tuple2._2();
                return ((GeoMesaStats)((Object)this)).getHistogram(sft, dateField, 0, new Date(), new Date(), ((GeoMesaStats)((Object)this)).getHistogram$default$6(), ((GeoMesaStats)((Object)this)).getHistogram$default$7()).map((Function1 & Serializable & scala.Serializable)histogram -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateTemporalCount$4(intervals, histogram)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Option<Object> estimateEqualsCount(SimpleFeatureType sft, Filter filter, String attribute, Seq<Object> values) {
        return ((GeoMesaStats)((Object)this)).getFrequency(sft, attribute, 0, filter, ((GeoMesaStats)((Object)this)).getFrequency$default$5()).map((Function1 & Serializable & scala.Serializable)freq -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateEqualsCount$1(values, freq)));
    }

    private Option<Object> estimateRangeCount(SimpleFeatureType sft, String attribute, Seq<Tuple2<Option<Object>, Option<Object>>> ranges) {
        return ((GeoMesaStats)((Object)this)).getHistogram(sft, attribute, 0, BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), ((GeoMesaStats)((Object)this)).getHistogram$default$6(), ((GeoMesaStats)((Object)this)).getHistogram$default$7()).map((Function1 & Serializable & scala.Serializable)histogram -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateRangeCount$1(ranges, histogram)));
    }

    public static /* synthetic */ Option $anonfun$estimateNotCount$1(StatsBasedEstimator $this, SimpleFeatureType sft$4, Filter x1$1, long all) {
        return $this.estimateCount(sft$4, x1$1).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)neg -> scala.math.package$.MODULE$.max(0L, all - neg));
    }

    public static /* synthetic */ boolean $anonfun$estimateSpatioTemporalCount$3(Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 != null) {
            FilterValues geometries = (FilterValues)tuple2._2();
            return geometries.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$estimateSpatioTemporalCount$5(Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            FilterValues intervals = (FilterValues)tuple2._2();
            if (tuple22 != null) {
                return intervals.nonEmpty();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$estimateSpatioTemporalCount$9(long maxTime$1, ZonedDateTime x$4) {
        return x$4.toInstant().toEpochMilli() <= maxTime$1;
    }

    public static /* synthetic */ boolean $anonfun$estimateSpatioTemporalCount$10(long minTime$1, ZonedDateTime x$5) {
        return x$5.toInstant().toEpochMilli() >= minTime$1;
    }

    public static /* synthetic */ boolean $anonfun$estimateSpatioTemporalCount$8(long maxTime$1, long minTime$1, Bounds i) {
        return i.lower().value().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$9(maxTime$1, x$4))) && i.upper().value().forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$10(minTime$1, x$5)));
    }

    private static Seq getIndices$1(long t1, long t2, Z3Histogram histogram$1, Z3SFC sfc$1, Seq xy$1) {
        short w = BoxesRunTime.unboxToShort((Object)histogram$1.timeBins().head());
        Seq zs = sfc$1.ranges(xy$1, (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(t1, t2), (List)Nil$.MODULE$), StatsBasedEstimator$.MODULE$.ZHistogramPrecision(), sfc$1.ranges$default$4());
        return (Seq)zs.flatMap((Function1 & Serializable & scala.Serializable)r -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(histogram$1.directIndex(w, r.lower())), histogram$1.directIndex(w, r.upper())), Seq$.MODULE$.canBuildFrom());
    }

    private static /* synthetic */ Seq middleIndices$lzycompute$1(LazyRef middleIndices$lzy$1, long tmin$1, long tmax$1, Z3Histogram histogram$1, Z3SFC sfc$1, Seq xy$1) {
        Seq seq;
        LazyRef lazyRef = middleIndices$lzy$1;
        synchronized (lazyRef) {
            seq = middleIndices$lzy$1.initialized() ? (Seq)middleIndices$lzy$1.value() : (Seq)middleIndices$lzy$1.initialize((Object)StatsBasedEstimator.getIndices$1(tmin$1, tmax$1, histogram$1, sfc$1, xy$1));
        }
        return seq;
    }

    private static Seq middleIndices$1(LazyRef middleIndices$lzy$1, long tmin$1, long tmax$1, Z3Histogram histogram$1, Z3SFC sfc$1, Seq xy$1) {
        if (middleIndices$lzy$1.initialized()) {
            return (Seq)middleIndices$lzy$1.value();
        }
        return StatsBasedEstimator.middleIndices$lzycompute$1(middleIndices$lzy$1, tmin$1, tmax$1, histogram$1, sfc$1, xy$1);
    }

    public static /* synthetic */ short $anonfun$estimateSpatioTemporalCount$14(int x$10) {
        return (short)x$10;
    }

    public static /* synthetic */ void $anonfun$estimateSpatioTemporalCount$15(Map timeBinsAndIndices$1, long tmax$1, long tmin$1, Z3Histogram histogram$1, Z3SFC sfc$1, Seq xy$1, LazyRef middleIndices$lzy$1, Tuple3 x0$1) {
        Tuple3 tuple3;
        block4: {
            Option option;
            short last;
            long ut;
            long lt;
            block6: {
                List list;
                block5: {
                    tuple3 = x0$1;
                    if (tuple3 == null) break block4;
                    IndexedSeq bins = (IndexedSeq)tuple3._1();
                    lt = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    ut = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    if (bins.length() == 1) {
                        short s = BoxesRunTime.unboxToShort((Object)bins.head());
                        timeBinsAndIndices$1.update((Object)BoxesRunTime.boxToShort((short)s), ((TraversableLike)timeBinsAndIndices$1.apply((Object)BoxesRunTime.boxToShort((short)s))).$plus$plus((GenTraversableOnce)StatsBasedEstimator.getIndices$1(lt, ut, histogram$1, sfc$1, xy$1), Seq$.MODULE$.canBuildFrom()));
                        return;
                    }
                    list = bins.toList();
                    Option option2 = package$.MODULE$.$colon$plus().unapply((SeqLike)list);
                    if (option2.isEmpty()) break block5;
                    List list2 = (List)((Tuple2)option2.get())._1();
                    last = BoxesRunTime.unboxToShort((Object)((Tuple2)option2.get())._2());
                    option = package$.MODULE$.$plus$colon().unapply((SeqLike)list2);
                    if (!option.isEmpty()) break block6;
                }
                throw new MatchError((Object)list);
            }
            short head = BoxesRunTime.unboxToShort((Object)((Tuple2)option.get())._1());
            List middle = (List)((Tuple2)option.get())._2();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToShort((short)head), (Object)middle, (Object)BoxesRunTime.boxToShort((short)last));
            short head2 = BoxesRunTime.unboxToShort((Object)tuple32._1());
            List middle2 = (List)tuple32._2();
            short last2 = BoxesRunTime.unboxToShort((Object)tuple32._3());
            timeBinsAndIndices$1.update((Object)BoxesRunTime.boxToShort((short)head2), ((TraversableLike)timeBinsAndIndices$1.apply((Object)BoxesRunTime.boxToShort((short)head2))).$plus$plus((GenTraversableOnce)StatsBasedEstimator.getIndices$1(lt, tmax$1, histogram$1, sfc$1, xy$1), Seq$.MODULE$.canBuildFrom()));
            timeBinsAndIndices$1.update((Object)BoxesRunTime.boxToShort((short)last2), ((TraversableLike)timeBinsAndIndices$1.apply((Object)BoxesRunTime.boxToShort((short)last2))).$plus$plus((GenTraversableOnce)StatsBasedEstimator.getIndices$1(tmin$1, ut, histogram$1, sfc$1, xy$1), Seq$.MODULE$.canBuildFrom()));
            middle2.foreach((Function1 & Serializable & scala.Serializable)m -> {
                timeBinsAndIndices$1.update((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)m)), ((TraversableLike)timeBinsAndIndices$1.apply((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)m)))).$plus$plus((GenTraversableOnce)StatsBasedEstimator.middleIndices$1(middleIndices$lzy$1, tmin$1, tmax$1, histogram$1, sfc$1, xy$1), Seq$.MODULE$.canBuildFrom()));
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static /* synthetic */ long $anonfun$estimateSpatioTemporalCount$17(Z3Histogram histogram$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            short b = BoxesRunTime.unboxToShort((Object)tuple2._1());
            Seq indices = (Seq)tuple2._2();
            return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)indices.distinct()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$12 -> histogram$1.count(b, x$12), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ long $anonfun$estimateSpatioTemporalCount$7(StatsBasedEstimator $this, FilterValues geometries$1, FilterValues intervals$1, SimpleFeatureType sft$5, String geomField$1, String dateField$1, And filter$2, MinMax bounds) {
        if (geometries$1.disjoint() || intervals$1.disjoint()) {
            return 0L;
        }
        long minTime = ((Date)bounds.min()).getTime();
        long maxTime = ((Date)bounds.max()).getTime();
        Seq inRangeIntervals = (Seq)intervals$1.values().filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$8(maxTime, minTime, i)));
        Enumeration.Value period = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$5));
        Option<Z3Histogram> option = ((GeoMesaStats)((Object)$this)).getZ3Histogram(sft$5, geomField$1, dateField$1, period, 0, (Filter)filter$2, ((GeoMesaStats)((Object)$this)).getZ3Histogram$default$7());
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Z3Histogram histogram = (Z3Histogram)some.value();
            LazyRef middleIndices$lzy = new LazyRef();
            Z3SFC sfc = Z3SFC$.MODULE$.apply(period);
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)sfc.time().min(), (long)sfc.time().max());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            long tmin = sp2._1$mcJ$sp();
            long tmax = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(tmin, tmax);
            long tmin2 = sp3._1$mcJ$sp();
            long tmax2 = sp3._2$mcJ$sp();
            Seq xy = (Seq)geometries$1.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom());
            Map timeBinsAndIndices = Map$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
            Function1 dateToBins = BinnedTime$.MODULE$.dateToBinnedTime(period);
            Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(period);
            Seq binnedTimes = (Seq)inRangeIntervals.map((Function1 & Serializable & scala.Serializable)interval -> {
                Tuple2 tuple2 = (Tuple2)boundsToDates.apply((Object)interval.bounds());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
                ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
                ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
                BinnedTime binnedTime = (BinnedTime)dateToBins.apply((Object)lower2);
                if (binnedTime == null) {
                    throw new MatchError((Object)binnedTime);
                }
                short lb = binnedTime.bin();
                long lt = binnedTime.offset();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long lt2 = tuple23._2$mcJ$sp();
                BinnedTime binnedTime2 = (BinnedTime)dateToBins.apply((Object)upper2);
                if (binnedTime2 == null) {
                    throw new MatchError((Object)binnedTime2);
                }
                short ub = binnedTime2.bin();
                long ut = binnedTime2.offset();
                Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
                long ut2 = tuple24._2$mcJ$sp();
                return new Tuple3(package$.MODULE$.Range().inclusive((int)lb2, (int)ub2).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToShort((short)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$14(BoxesRunTime.unboxToInt((Object)x$10))), IndexedSeq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToLong((long)lt2), (Object)BoxesRunTime.boxToLong((long)ut2));
            }, Seq$.MODULE$.canBuildFrom());
            binnedTimes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$15(timeBinsAndIndices, tmax2, tmin2, histogram, sfc, xy, middleIndices$lzy, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxesRunTime.unboxToLong((Object)((TraversableOnce)timeBinsAndIndices.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateSpatioTemporalCount$17(histogram, x0$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ Tuple2 $anonfun$estimateAttributeCount$5(Bounds b) {
        return new Tuple2((Object)b.lower().value(), (Object)b.upper().value());
    }

    public static /* synthetic */ boolean $anonfun$estimateAttributeCount$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option l = (Option)tuple2._1();
            Option r = (Option)tuple2._2();
            Option option = l;
            Option option2 = r;
            return !(option != null ? !option.equals(option2) : option2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ Object $anonfun$estimateAttributeCount$7(Tuple2 x$21) {
        return ((Option)x$21._1()).get();
    }

    /*
     * Unable to fully structure code
     */
    public static /* synthetic */ Option $anonfun$estimateAttributeCount$3(StatsBasedEstimator $this, SimpleFeatureType sft$6, Filter filter$3, String attribute$1, FilterValues bounds) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (bounds.disjoint()) {
                            return new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        if (!bounds.values().exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$estimateAttributeCount$4$adapted(org.locationtech.geomesa.filter.Bounds ), (Lorg/locationtech/geomesa/filter/Bounds;)Ljava/lang/Object;)())) {
                            return $this.estimateCount(sft$6, (Filter)Filter.INCLUDE);
                        }
                        boundsValues = (Seq)bounds.values().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$estimateAttributeCount$5(org.locationtech.geomesa.filter.Bounds ), (Lorg/locationtech/geomesa/filter/Bounds;)Lscala/Tuple2;)(), Seq$.MODULE$.canBuildFrom());
                        var9_6 = boundsValues.partition((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$estimateAttributeCount$6$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)());
                        if (var9_6 == null) {
                            throw new MatchError((Object)var9_6);
                        }
                        equalsBounds = (Seq)var9_6._1();
                        rangeBounds = (Seq)var9_6._2();
                        var8_9 = new Tuple2((Object)equalsBounds, (Object)rangeBounds);
                        equalsBounds = (Seq)var8_9._1();
                        rangeBounds = (Seq)var8_9._2();
                        if (!equalsBounds.isEmpty()) break block5;
                        v0 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        break block6;
                    }
                    equals = $this.estimateEqualsCount(sft$6, filter$3, attribute$1, (Seq<Object>)((Seq)equalsBounds.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$estimateAttributeCount$7(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(), Seq$.MODULE$.canBuildFrom())));
                    var17_14 = new Tuple2(equals, range = $this.estimateRangeCount(sft$6, attribute$1, (Seq<Tuple2<Option<Object>, Option<Object>>>)equalsBounds));
                    if (var17_14 == null) break block7;
                    var18_15 = (Option)var17_14._1();
                    var19_16 = (Option)var17_14._2();
                    if (!(var18_15 instanceof Some)) break block7;
                    var20_17 = (Some)var18_15;
                    e = BoxesRunTime.unboxToLong((Object)var20_17.value());
                    if (!(var19_16 instanceof Some)) break block7;
                    var23_19 = (Some)var19_16;
                    r = BoxesRunTime.unboxToLong((Object)var23_19.value());
                    v0 = new Some((Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.min(e, r)));
                    break block6;
                }
                if (var17_14 == null) break block8;
                var26_21 = (Option)var17_14._1();
                r = (Option)var17_14._2();
                if (!None$.MODULE$.equals(var26_21)) break block8;
                v0 = r;
                break block6;
            }
            if (var17_14 == null) ** GOTO lbl-1000
            e = (Option)var17_14._1();
            var29_24 = (Option)var17_14._2();
            if (None$.MODULE$.equals(var29_24)) {
                v0 = e;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var17_14);
            }
        }
        equalsCount = v0;
        rangeCount = rangeBounds.isEmpty() != false ? new Option<Object>((Object)BoxesRunTime.boxToLong((long)0L)) : $this.estimateRangeCount(sft$6, attribute$1, (Seq<Tuple2<Option<Object>, Option<Object>>>)rangeBounds);
        return equalsCount.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$estimateAttributeCount$8$adapted(scala.Option java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)(rangeCount));
    }

    private static boolean inRange$1(package.IndexRange r, long zHi$1, long zLo$1) {
        return r.lower() < zHi$1 && r.upper() > zLo$1;
    }

    public static /* synthetic */ long $anonfun$estimateSpatialCount$1(FilterValues geometries$2, Histogram histogram) {
        Tuple4 tuple4 = GeometryUtils$.MODULE$.bounds((Geometry)histogram.min());
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(xmin, ymin);
        double xmin2 = sp2._1$mcD$sp();
        double ymin2 = sp2._2$mcD$sp();
        Tuple4 tuple42 = GeometryUtils$.MODULE$.bounds((Geometry)histogram.max());
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        double xmax = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double ymax = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(xmax, ymax);
        double xmax2 = sp3._1$mcD$sp();
        double ymax2 = sp3._2$mcD$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(Z2SFC$.MODULE$.index(xmin2, ymin2, Z2SFC$.MODULE$.index$default$3()), Z2SFC$.MODULE$.index(xmax2, ymax2, Z2SFC$.MODULE$.index$default$3()));
        if (sp4 == null) {
            throw new MatchError((Object)sp4);
        }
        long zLo = sp4._1$mcJ$sp();
        long zHi = sp4._2$mcJ$sp();
        Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(zLo, zHi);
        long zLo2 = sp5._1$mcJ$sp();
        long zHi2 = sp5._2$mcJ$sp();
        Seq ranges = Z2SFC$.MODULE$.ranges((Seq)geometries$2.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom()), StatsBasedEstimator$.MODULE$.ZHistogramPrecision(), Z2SFC$.MODULE$.ranges$default$3());
        Seq indices = (Seq)((TraversableLike)ranges.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.inRange$1(r, zHi2, zLo2)))).flatMap((Function1 & Serializable & scala.Serializable)range -> {
            int loIndex = BoxesRunTime.unboxToInt((Object)new Some((Object)BoxesRunTime.boxToInteger((int)histogram.directIndex(range.lower()))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$25 -> x$25 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int hiIndex = BoxesRunTime.unboxToInt((Object)new Some((Object)BoxesRunTime.boxToInteger((int)histogram.directIndex(range.upper()))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$26 -> x$26 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> histogram.length() - 1));
            return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(loIndex), hiIndex);
        }, Seq$.MODULE$.canBuildFrom());
        if (indices.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)indices.distinct()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> histogram.count(i), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static /* synthetic */ boolean $anonfun$estimateTemporalCount$2(Tuple2 x$31) {
        Tuple2 tuple2 = x$31;
        if (tuple2 != null) {
            FilterValues intervals = (FilterValues)tuple2._2();
            return intervals.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$estimateTemporalCount$5(Histogram histogram$3, ZonedDateTime x$27) {
        return x$27.toInstant().toEpochMilli() <= ((Date)histogram$3.max()).getTime();
    }

    public static /* synthetic */ boolean $anonfun$estimateTemporalCount$6(Histogram histogram$3, ZonedDateTime x$28) {
        return x$28.toInstant().toEpochMilli() >= ((Date)histogram$3.min()).getTime();
    }

    private static boolean inRange$2(Bounds interval, Histogram histogram$3) {
        return interval.lower().value().forall((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateTemporalCount$5(histogram$3, x$27))) && interval.upper().value().forall((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateTemporalCount$6(histogram$3, x$28)));
    }

    public static /* synthetic */ long $anonfun$estimateTemporalCount$4(FilterValues intervals$2, Histogram histogram) {
        if (intervals$2.disjoint()) {
            return 0L;
        }
        Seq indices = (Seq)((TraversableLike)intervals$2.values().filter((Function1 & Serializable & scala.Serializable)interval -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.inRange$2(interval, histogram)))).flatMap((Function1 & Serializable & scala.Serializable)interval -> {
            int loIndex = BoxesRunTime.unboxToInt((Object)interval.lower().value().map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToInteger((int)histogram.indexOf((Object)Date.from(i.toInstant())))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$29 -> x$29 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int hiIndex = BoxesRunTime.unboxToInt((Object)interval.upper().value().map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToInteger((int)histogram.indexOf((Object)Date.from(i.toInstant())))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$30 -> x$30 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> histogram.length() - 1));
            return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(loIndex), hiIndex);
        }, Seq$.MODULE$.canBuildFrom());
        if (indices.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)indices.distinct()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> histogram.count(i), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static /* synthetic */ long $anonfun$estimateEqualsCount$3(Frequency freq$1, double absoluteError$1, Object v) {
        long estimate = freq$1.count(v);
        if (estimate == 0L) {
            return 0L;
        }
        if ((double)estimate > absoluteError$1) {
            double relativeError = absoluteError$1 / (double)estimate;
            return estimate - (long)(BoxesRunTime.unboxToDouble((Object)((IterableLike)StatsBasedEstimator$.MODULE$.ErrorThresholds().dropWhile((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$33 -> x$33 <= relativeError)).head()) * 0.5 * absoluteError$1);
        }
        double relativeError = (double)estimate / absoluteError$1;
        return (long)(BoxesRunTime.unboxToDouble((Object)((IterableLike)StatsBasedEstimator$.MODULE$.ErrorThresholds().dropWhile((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$34 -> x$34 < relativeError)).head()) * 0.5 * (double)estimate);
    }

    public static /* synthetic */ long $anonfun$estimateEqualsCount$1(Seq values$1, Frequency freq) {
        double absoluteError = scala.math.package$.MODULE$.floor((double)freq.size() * freq.eps());
        Seq counts = absoluteError < 1.0 ? (Seq)values$1.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToLong((long)freq.count(value)), Seq$.MODULE$.canBuildFrom()) : (Seq)values$1.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)StatsBasedEstimator.$anonfun$estimateEqualsCount$3(freq, absoluteError, v)), Seq$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)counts.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static /* synthetic */ boolean $anonfun$estimateRangeCount$2(Histogram histogram$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (None$.MODULE$.equals(option3)) {
                    return BoxesRunTime.equals((Object)histogram$4.defaults().min(lo, histogram$4.max()), (Object)lo);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Object up = some.value();
                return BoxesRunTime.equals((Object)histogram$4.defaults().max(up, histogram$4.min()), (Object)up);
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (option5 instanceof Some) {
                    Some some2 = (Some)option5;
                    Object up = some2.value();
                    return BoxesRunTime.equals((Object)histogram$4.defaults().min(lo, histogram$4.max()), (Object)lo) && BoxesRunTime.equals((Object)histogram$4.defaults().max(up, histogram$4.min()), (Object)up);
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ long $anonfun$estimateRangeCount$1(Seq ranges$1, Histogram histogram) {
        Seq inRangeRanges = (Seq)ranges$1.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateRangeCount$2(histogram, x0$1)));
        Seq indices = (Seq)inRangeRanges.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Option lower = (Option)tuple2._1();
                Option upper = (Option)tuple2._2();
                int lowerIndex = BoxesRunTime.unboxToInt((Object)lower.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToInteger((int)histogram.indexOf(value))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$35 -> x$35 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                int upperIndex = BoxesRunTime.unboxToInt((Object)upper.map((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToInteger((int)histogram.indexOf(value))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$36 -> x$36 != -1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> histogram.length() - 1));
                return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lowerIndex), upperIndex);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        if (indices.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)indices.distinct()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> histogram.count(i), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static void $init$(StatsBasedEstimator $this) {
    }

    public static /* synthetic */ Object $anonfun$estimateAttributeCount$4$adapted(Bounds x$19) {
        return BoxesRunTime.boxToBoolean((boolean)x$19.isBounded());
    }

    public static /* synthetic */ Object $anonfun$estimateAttributeCount$6$adapted(Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)StatsBasedEstimator.$anonfun$estimateAttributeCount$6(x0$1));
    }

    public static /* synthetic */ Option $anonfun$estimateAttributeCount$8$adapted(Option rangeCount$1, Object e) {
        return rangeCount$1.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)r -> e + r);
    }
}

