/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.view;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$StatsReducer$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.view.package$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.locationtech.geomesa.utils.iterators.SortedMergeIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0016-\u0001]B\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"Q!1\u0004\u0001\u0003\u0002\u0003\u0006I!!2\t\u0015\tu\u0001A!A!\u0002\u0013\t)\r\u0003\u0004z\u0001\u0011\u0005!q\u0004\u0005\n\u0005W\u0001!\u0019!C)\u0005[A\u0001B!\u0011\u0001A\u0003%!q\u0006\u0005\b\u0005\u0007\u0002A\u0011\tB#\u0011!\u0011i\u0007\u0001C)a\t=\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[CqA!.\u0001\t\u0013\u00119\f\u0003\u0005\u0003@\u0002!\t\u0006\rBa\u0011\u001d\u00119\r\u0001C\u0005\u0005\u0013<Q!\u001e\u0017\t\u0002Y4Qa\u000b\u0017\t\u0002aDQ!_\t\u0005\u0002i4qa_\t\u0011\u0002G\u0005A\u0010C\u0003~'\u0019\u0005aP\u0002\u0004\u0002>E\u0001\u0015q\b\u0005\n\u001dV\u0011)\u001a!C\u0001\u0003#B!\"!\u0017\u0016\u0005#\u0005\u000b\u0011BA*\u0011\u0019IX\u0003\"\u0001\u0002\\!1Q0\u0006C!\u0003CB\u0011\"a\u001a\u0016\u0003\u0003%\t!!\u001b\t\u0013\u00055T#%A\u0005\u0002\u0005=\u0004\"CAC+\u0005\u0005I\u0011IAD\u0011%\tI*FA\u0001\n\u0003\tY\nC\u0005\u0002$V\t\t\u0011\"\u0001\u0002&\"I\u0011\u0011W\u000b\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003\u0003,\u0012\u0011!C\u0001\u0003\u0007D\u0011\"!4\u0016\u0003\u0003%\t%a4\t\u0013\u0005EW#!A\u0005B\u0005M\u0007\"CAk+\u0005\u0005I\u0011IAl\u000f%\tY.EA\u0001\u0012\u0003\tiNB\u0005\u0002>E\t\t\u0011#\u0001\u0002`\"1\u00110\nC\u0001\u0003[D\u0011\"!5&\u0003\u0003%)%a5\t\u0013\u0005=X%!A\u0005\u0002\u0006E\b\"CA{K\u0005\u0005I\u0011QA|\u0011%\u0011\u0019!JA\u0001\n\u0013\u0011)AA\tNKJ<W\rZ)vKJL(+\u001e8oKJT!!\f\u0018\u0002\tYLWm\u001e\u0006\u0003_A\nQ!\u001b8eKbT!!\r\u001a\u0002\u000f\u001d,w.\\3tC*\u00111\u0007N\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000f E!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fMB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IL\u0001\ta2\fgN\\5oO&\u00111\t\u0011\u0002\f#V,'/\u001f*v]:,'\u000f\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006a1oY1mC2|wmZ5oO*\u0011\u0011JS\u0001\tif\u0004Xm]1gK*\t1*A\u0002d_6L!!\u0014$\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0003IN\u0004\"\u0001\u00152\u000f\u0005E{fB\u0001*^\u001d\t\u0019FL\u0004\u0002U7:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031Z\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005M\"\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002_]\u0005)1\u000f^1ug&\u0011\u0001-Y\u0001\ba\u0006\u001c7.Y4f\u0015\tqf&\u0003\u0002dI\ny\u0001*Y:HK>lUm]1Ti\u0006$8O\u0003\u0002aC\u000611\u000f^8sKN\u00042aZ6o\u001d\tA'N\u0004\u0002WS&\t1(\u0003\u0002au%\u0011A.\u001c\u0002\u0004'\u0016\f(B\u00011;!\u0015It.\u001dB\u0007\u0013\t\u0001(H\u0001\u0004UkBdWM\r\t\u0003eNq!a\u001d\t\u000f\u0005I#\u0018BA\u0017/\u0003EiUM]4fIF+XM]=Sk:tWM\u001d\t\u0003oFi\u0011\u0001L\n\u0003#a\na\u0001P5oSRtD#\u0001<\u0003\u0013E+XM]=bE2,7CA\n9\u0003A9W\r\u001e$fCR,(/\u001a*fC\u0012,'\u000fF\u0003\u0000\u0003S\t\u0019\u0004\u0005\u0005\u0002\u0002\u0005=\u00111CA\u0012\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00023bi\u0006TA!!\u0003\u0002\f\u0005\u0019\u0011\r]5\u000b\u0007\u00055A'\u0001\u0005hK>$xn\u001c7t\u0013\u0011\t\t\"a\u0001\u0003\u001b\u0019+\u0017\r^;sKJ+\u0017\rZ3s!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\taa]5na2,'\u0002BA\u000f\u0003\u000f\tqAZ3biV\u0014X-\u0003\u0003\u0002\"\u0005]!!E*j[BdWMR3biV\u0014X\rV=qKB!\u0011QCA\u0013\u0013\u0011\t9#a\u0006\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u001d\tY\u0003\u0006a\u0001\u0003[\t\u0011!\u001d\t\u0005\u0003\u0003\ty#\u0003\u0003\u00022\u0005\r!!B)vKJL\bbBA\u001b)\u0001\u0007\u0011qG\u0001\u0002iB!\u0011\u0011AA\u001d\u0013\u0011\tY$a\u0001\u0003\u0017Q\u0013\u0018M\\:bGRLwN\u001c\u0002\u0013\t\u0006$\u0018m\u0015;pe\u0016\fV/\u001a:zC\ndWm\u0005\u0005\u0016q\u0005\u0005\u0013QIA&!\r\t\u0019eE\u0007\u0002#A\u0019\u0011(a\u0012\n\u0007\u0005%#HA\u0004Qe>$Wo\u0019;\u0011\u0007e\ni%C\u0002\u0002Pi\u0012AbU3sS\u0006d\u0017N_1cY\u0016,\"!a\u0015\u0011\t\u0005\u0005\u0011QK\u0005\u0005\u0003/\n\u0019AA\u0005ECR\f7\u000b^8sK\u0006\u0019Am\u001d\u0011\u0015\t\u0005u\u0013q\f\t\u0004\u0003\u0007*\u0002B\u0002(\u0019\u0001\u0004\t\u0019\u0006F\u0003\u0000\u0003G\n)\u0007C\u0004\u0002,e\u0001\r!!\f\t\u000f\u0005U\u0012\u00041\u0001\u00028\u0005!1m\u001c9z)\u0011\ti&a\u001b\t\u00119S\u0002\u0013!a\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r)\"\u00111KA:W\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u0013Ut7\r[3dW\u0016$'bAA@u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015\u0001\u00027b]\u001eT!!a%\u0002\t)\fg/Y\u0005\u0005\u0003/\u000biI\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00032!OAP\u0013\r\t\tK\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003O\u000bi\u000bE\u0002:\u0003SK1!a+;\u0005\r\te.\u001f\u0005\n\u0003_s\u0012\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA[!\u0019\t9,!0\u0002(6\u0011\u0011\u0011\u0018\u0006\u0004\u0003wS\u0014AC2pY2,7\r^5p]&!\u0011qXA]\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00171\u001a\t\u0004s\u0005\u001d\u0017bAAeu\t9!i\\8mK\u0006t\u0007\"CAXA\u0005\u0005\t\u0019AAT\u0003!A\u0017m\u001d5D_\u0012,GCAAO\u0003!!xn\u0015;sS:<GCAAE\u0003\u0019)\u0017/^1mgR!\u0011QYAm\u0011%\tykIA\u0001\u0002\u0004\t9+\u0001\nECR\f7\u000b^8sKF+XM]=bE2,\u0007cAA\"KM)Q%!9\u0002LAA\u00111]Au\u0003'\ni&\u0004\u0002\u0002f*\u0019\u0011q\u001d\u001e\u0002\u000fI,h\u000e^5nK&!\u00111^As\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003;\fQ!\u00199qYf$B!!\u0018\u0002t\"1a\n\u000ba\u0001\u0003'\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002z\u0006}\b#B\u001d\u0002|\u0006M\u0013bAA\u007fu\t1q\n\u001d;j_:D\u0011B!\u0001*\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0004!\u0011\tYI!\u0003\n\t\t-\u0011Q\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u000be\nYPa\u0004\u0011\t\tE!qC\u0007\u0003\u0005'QAA!\u0006\u0002\b\u00051a-\u001b7uKJLAA!\u0007\u0003\u0014\t1a)\u001b7uKJ\f1\u0002Z3ekBd\u0017nY1uK\u0006A\u0001/\u0019:bY2,G\u000e\u0006\u0006\u0003\"\t\r\"Q\u0005B\u0014\u0005S\u0001\"a\u001e\u0001\t\u000b9+\u0001\u0019A(\t\u000b\u0015,\u0001\u0019\u00014\t\u000f\tmQ\u00011\u0001\u0002F\"9!QD\u0003A\u0002\u0005\u0015\u0017\u0001D5oi\u0016\u00148-\u001a9u_J\u001cXC\u0001B\u0018!\u0011\u0011\tDa\u000f\u000f\t\tM\"q\u0007\b\u0004%\nU\u0012BA!/\u0013\r\u0011I\u0004Q\u0001\u0011#V,'/_%oi\u0016\u00148-\u001a9u_JLAA!\u0010\u0003@\t9\u0012+^3ss&sG/\u001a:dKB$xN\u001d$bGR|'/\u001f\u0006\u0004\u0005s\u0001\u0015!D5oi\u0016\u00148-\u001a9u_J\u001c\b%\u0001\u0005sk:\fV/\u001a:z)!\u00119E!\u0016\u0003Z\tu\u0003\u0003\u0002B%\u0005\u001frAAa\r\u0003L%\u0019!Q\n!\u0002\u0017E+XM]=Sk:tWM]\u0005\u0005\u0005#\u0012\u0019FA\u0006Rk\u0016\u0014\u0018PU3tk2$(b\u0001B'\u0001\"9!q\u000b\u0005A\u0002\u0005M\u0011aA:gi\"9!1\f\u0005A\u0002\u00055\u0012\u0001C8sS\u001eLg.\u00197\t\u0013\t}\u0003\u0002%AA\u0002\t\u0005\u0014aB3ya2\f\u0017N\u001c\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)\u0019!q\r\u0018\u0002\u000bU$\u0018\u000e\\:\n\t\t-$Q\r\u0002\n\u000bb\u0004H.Y5oKJ\fabY8oM&<WO]3Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002.\tE$1\u000f\u0005\b\u0005/J\u0001\u0019AA\n\u0011\u001d\u0011Y&\u0003a\u0001\u0003[\t!\"\u0019:s_^\fV/\u001a:z)\u0019\u0011IH!\"\u0003\bB1!1\u0010BA\u0003Gi!A! \u000b\t\u0005m&q\u0010\u0006\u0004\u0005O\u0002\u0014\u0002\u0002BB\u0005{\u0012\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s\u0011\u001d\u00119F\u0003a\u0001\u0003'AqA!#\u000b\u0001\u0004\ti#A\u0003rk\u0016\u0014\u00180\u0001\u0007eK:\u001c\u0018\u000e^=Rk\u0016\u0014\u0018\u0010\u0006\u0005\u0003z\t=%\u0011\u0013BL\u0011\u001d\u00119f\u0003a\u0001\u0003'AqAa%\f\u0001\u0004\u0011)*A\u0004sK\u0006$WM]:\u0011\u0007\u001d\\w\u0010C\u0004\u0003\u001a.\u0001\rAa'\u0002\u000b!Lg\u000e^:\u0011\t\tu%qU\u0007\u0003\u0005?SAA!)\u0003$\u00069a-Y2u_JL(\u0002\u0002BS\u0003\u0017\tA!\u001e;jY&!!\u0011\u0016BP\u0005\u0015A\u0015N\u001c;t\u0003)\u0019H/\u0019;t#V,'/\u001f\u000b\t\u0005s\u0012yK!-\u00034\"9!q\u000b\u0007A\u0002\u0005M\u0001b\u0002BJ\u0019\u0001\u0007!Q\u0013\u0005\b\u00053c\u0001\u0019\u0001BN\u0003!\u0011\u0017N\\)vKJLH\u0003\u0003B=\u0005s\u0013YL!0\t\u000f\t]S\u00021\u0001\u0002\u0014!9!1S\u0007A\u0002\tU\u0005b\u0002BM\u001b\u0001\u0007!1T\u0001\rO\u0016$(+\u001a;ve:\u001cf\r\u001e\u000b\u0007\u0003'\u0011\u0019M!2\t\u000f\t]c\u00021\u0001\u0002\u0014!9!\u0011\u0014\bA\u0002\tm\u0015A\u00043p!\u0006\u0014\u0018\r\u001c7fYN\u001b\u0017M\u001c\u000b\u0007\u0005s\u0012YM!4\t\u000f\tMu\u00021\u0001\u0003\u0016\"9!qZ\bA\u0002\tE\u0017AB:j]\u001edW\r\u0005\u0004:\u0005'|(\u0011P\u0005\u0004\u0005+T$!\u0003$v]\u000e$\u0018n\u001c82\u0001")
public class MergedQueryRunner
implements QueryRunner,
LazyLogging {
    private final Seq<Tuple2<Queryable, Option<Filter>>> stores;
    private final boolean deduplicate;
    private final boolean parallel;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Explainer runQuery$default$3() {
        return QueryRunner.runQuery$default$3$(this);
    }

    private Logger logger$lzycompute() {
        MergedQueryRunner mergedQueryRunner = this;
        synchronized (mergedQueryRunner) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    @Override
    public QueryRunner.QueryResult runQuery(SimpleFeatureType sft, Query original, Explainer explain) {
        Query query = this.configureQuery(sft, original);
        Hints hints = query.getHints();
        None$ maxFeatures = query.isMaxFeaturesUnlimited() ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)query.getMaxFeatures()));
        Object object = QueryHints$.MODULE$.RichHints(hints).isStatsQuery() || QueryHints$.MODULE$.RichHints(hints).isArrowQuery() ? hints.put((Object)QueryHints$Internal$.MODULE$.SKIP_REDUCE(), (Object)Boolean.TRUE) : BoxedUnit.UNIT;
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            return new QueryRunner.QueryResult(org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable & scala.Serializable)() -> this.arrowQuery(sft, query));
        }
        LazyRef readers$lzy = new LazyRef();
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            return new QueryRunner.QueryResult(DensityScan$.MODULE$.DensitySft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable & scala.Serializable)() -> this.densityQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return new QueryRunner.QueryResult(StatsScan$.MODULE$.StatsSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable & scala.Serializable)() -> this.statsQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            BoxedUnit boxedUnit;
            if (query.getSortBy() != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.getSortBy())).isEmpty()) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Ignoring sort for BIN query");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new QueryRunner.QueryResult(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable & scala.Serializable)() -> this.binQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        SimpleFeatureType resultSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable & scala.Serializable)x$1 -> (SimpleFeatureType)x$1._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
        return new QueryRunner.QueryResult(resultSft, hints, (Function0<CloseableIterator<SimpleFeature>>)((Function0 & Serializable & scala.Serializable)() -> MergedQueryRunner.$anonfun$runQuery$13(this, query, resultSft, (Option)maxFeatures, readers$lzy, sft)));
    }

    @Override
    public Query configureQuery(SimpleFeatureType sft, Query original) {
        Query query = new Query(original);
        QueryPlanner$.MODULE$.getPerThreadQueryHints().foreach((Function1 & Serializable & scala.Serializable)hints -> {
            MergedQueryRunner.$anonfun$configureQuery$1(query, hints);
            return BoxedUnit.UNIT;
        });
        ViewParams$.MODULE$.setHints(query);
        return query;
    }

    private CloseableIterator<SimpleFeature> arrowQuery(SimpleFeatureType sft, Query query) {
        Hints hints = query.getHints();
        QueryPlanner$.MODULE$.setQuerySort(sft, query);
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable & scala.Serializable)x$4 -> (SimpleFeatureType)x$4._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = ArrowScan$.MODULE$.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options((String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get()));
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
        ArrowScan.DeltaReducer reduce = new ArrowScan.DeltaReducer(arrowSft, dictionaryFields, encoding, ipcOpts, batchSize, sort, false, process);
        Seq readers = (Seq)this.stores.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Queryable store = (Queryable)tuple2._1();
                Option filter = (Option)tuple2._2();
                return store.getFeatureReader(package$.MODULE$.mergeFilter(sft, new Query(query), (Option<Filter>)filter), Transaction.AUTO_COMMIT);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return reduce.apply(this.doParallelScan((Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$1(reader, sft, hints)));
    }

    private CloseableIterator<SimpleFeature> densityQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$2(reader, sft, hints));
    }

    private CloseableIterator<SimpleFeature> statsQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        CloseableIterator<SimpleFeature> results = this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$3(reader, sft, hints));
        return StatsScan$StatsReducer$.MODULE$.apply(sft, hints).apply(results);
    }

    private CloseableIterator<SimpleFeature> binQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable & scala.Serializable)reader -> MergedQueryRunner.getSingle$4(reader, sft, hints));
    }

    @Override
    public SimpleFeatureType getReturnSft(SimpleFeatureType sft, Hints hints) {
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            return BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            return org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            return DensityScan$.MODULE$.DensitySft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return StatsScan$.MODULE$.StatsSft();
        }
        return QueryRunner.getReturnSft$(this, sft, hints);
    }

    private CloseableIterator<SimpleFeature> doParallelScan(Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>> single) {
        if (this.parallel) {
            return SelfClosingIterator$.MODULE$.apply(((LinearSeqLike)readers.toList().map(single, List$.MODULE$.canBuildFrom())).iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> i);
        }
        return SelfClosingIterator$.MODULE$.apply(readers.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap(single);
    }

    private final /* synthetic */ Seq readers$lzycompute$1(LazyRef readers$lzy$1, SimpleFeatureType sft$1, Query query$1) {
        Seq seq;
        LazyRef lazyRef = readers$lzy$1;
        synchronized (lazyRef) {
            seq = readers$lzy$1.initialized() ? (Seq)readers$lzy$1.value() : (Seq)readers$lzy$1.initialize(this.stores.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Queryable store = (Queryable)tuple2._1();
                    Option filter = (Option)tuple2._2();
                    return store.getFeatureReader(package$.MODULE$.mergeFilter(sft$1, new Query(query$1), (Option<Filter>)filter), Transaction.AUTO_COMMIT);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return seq;
    }

    private final Seq readers$1(LazyRef readers$lzy$1, SimpleFeatureType sft$1, Query query$1) {
        if (readers$lzy$1.initialized()) {
            return (Seq)readers$lzy$1.value();
        }
        return this.readers$lzycompute$1(readers$lzy$1, sft$1, query$1);
    }

    public static final /* synthetic */ boolean $anonfun$runQuery$10(SortBy[] x$3) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3)).isEmpty();
    }

    private final CloseableIterator run$1(Query query$1, SimpleFeatureType resultSft$1, Option maxFeatures$1, LazyRef readers$lzy$1, SimpleFeatureType sft$1) {
        CloseableIterator closeableIterator;
        Seq seq;
        if (this.deduplicate) {
            HashSet cache = HashSet$.MODULE$.empty();
            seq = (Seq)this.readers$1(readers$lzy$1, sft$1, query$1).map((Function1 & Serializable & scala.Serializable)r -> new DeduplicatingSimpleFeatureIterator((CloseableIterator)SelfClosingIterator$.MODULE$.apply(r), (Set)cache, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$3()), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)this.readers$1(readers$lzy$1, sft$1, query$1).map((Function1 & Serializable & scala.Serializable)x$2 -> SelfClosingIterator$.MODULE$.apply(x$2), Seq$.MODULE$.canBuildFrom());
        }
        Seq iters = seq;
        Option option = Option$.MODULE$.apply((Object)query$1.getSortBy()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MergedQueryRunner.$anonfun$runQuery$10(x$3)));
        if (None$.MODULE$.equals(option)) {
            closeableIterator = SelfClosingIterator$.MODULE$.apply(iters.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> i);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SortBy[] sort = (SortBy[])some.value();
            closeableIterator = new SortedMergeIterator(iters, SimpleFeatureOrdering$.MODULE$.apply(resultSft$1, sort));
        } else {
            throw new MatchError((Object)option);
        }
        CloseableIterator results = closeableIterator;
        Option option2 = maxFeatures$1;
        if (None$.MODULE$.equals(option2)) {
            return results;
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int m = BoxesRunTime.unboxToInt((Object)some.value());
            return results.take(m);
        }
        throw new MatchError((Object)option2);
    }

    public static final /* synthetic */ CloseableIterator $anonfun$runQuery$13(MergedQueryRunner $this, Query query$1, SimpleFeatureType resultSft$1, Option maxFeatures$1, LazyRef readers$lzy$1, SimpleFeatureType sft$1) {
        return $this.run$1(query$1, resultSft$1, maxFeatures$1, readers$lzy$1, sft$1);
    }

    public static final /* synthetic */ void $anonfun$configureQuery$1(Query query$2, Map hints) {
        hints.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                return query$2.getHints().put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        QueryPlanner$.MODULE$.clearPerThreadQueryHints();
    }

    private static final CloseableIterator getSingle$1(FeatureReader reader, SimpleFeatureType sft$2, Hints hints$2) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$2.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$2, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$2(FeatureReader reader, SimpleFeatureType sft$3, Hints hints$3) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = DensityScan$.MODULE$.DensitySft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$3.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$3, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$3(FeatureReader reader, SimpleFeatureType sft$4, Hints hints$4) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = StatsScan$.MODULE$.StatsSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$4.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$4, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$4(FeatureReader reader, SimpleFeatureType sft$5, Hints hints$5) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$5.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$5, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    public MergedQueryRunner(package.HasGeoMesaStats ds, Seq<Tuple2<Queryable, Option<Filter>>> stores, boolean deduplicate, boolean parallel) {
        this.stores = stores;
        this.deduplicate = deduplicate;
        this.parallel = parallel;
        QueryRunner.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.empty();
    }

    public static class DataStoreQueryable
    implements Queryable,
    Product,
    scala.Serializable {
        private final DataStore ds;

        public DataStore ds() {
            return this.ds;
        }

        @Override
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query q, Transaction t) {
            return this.ds().getFeatureReader(q, t);
        }

        public DataStoreQueryable copy(DataStore ds) {
            return new DataStoreQueryable(ds);
        }

        public DataStore copy$default$1() {
            return this.ds();
        }

        public String productPrefix() {
            return "DataStoreQueryable";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.ds();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DataStoreQueryable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DataStoreQueryable)) return false;
            boolean bl = true;
            if (!bl) return false;
            DataStoreQueryable dataStoreQueryable = (DataStoreQueryable)x$1;
            DataStore dataStore = this.ds();
            DataStore dataStore2 = dataStoreQueryable.ds();
            if (dataStore == null) {
                if (dataStore2 != null) {
                    return false;
                }
            } else if (!dataStore.equals(dataStore2)) return false;
            if (!dataStoreQueryable.canEqual(this)) return false;
            return true;
        }

        public DataStoreQueryable(DataStore ds) {
            this.ds = ds;
            Product.$init$((Product)this);
        }
    }

    public static interface Queryable {
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query var1, Transaction var2);
    }
}

