/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Function4;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class GeoMesaFeatureIndex$ {
    public static final GeoMesaFeatureIndex$ MODULE$ = new GeoMesaFeatureIndex$();

    public String identifier(String name, int version, Seq<String> attributes2) {
        return new StringBuilder(2).append(name).append(":").append(version).append(":").append(attributes2.mkString(":")).toString();
    }

    public String identifier(IndexId id) {
        return this.identifier(id.name(), id.version(), (Seq<String>)id.attributes());
    }

    public String identifier(GeoMesaFeatureIndex<?, ?> index) {
        return this.identifier(index.name(), index.version(), index.attributes());
    }

    public String baseTableNameKey(String name, Seq<String> attributes2, int version) {
        String attrs = attributes2.isEmpty() ? "" : ((IterableOnceOps)attributes2.map((Function1 & Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input))).mkString(".", ".", "");
        return new StringBuilder(8).append("table.").append(name).append(attrs).append(".v").append(version).toString();
    }

    public Function1<String, byte[]> idToBytes(SimpleFeatureType sft) {
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            return (Function1 & Serializable)id -> MODULE$.uuidToBytes((String)id);
        }
        return (Function1 & Serializable)id -> MODULE$.stringToBytes((String)id);
    }

    public Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes(SimpleFeatureType sft) {
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            return (Function4 & Serializable)(bytes, offset, ignored, sf) -> GeoMesaFeatureIndex$.MODULE$.uuidFromBytes(bytes, BoxesRunTime.unboxToInt((Object)offset), BoxesRunTime.unboxToInt((Object)ignored), sf);
        }
        return (Function4 & Serializable)(bytes, offset, length, ignored) -> GeoMesaFeatureIndex$.MODULE$.stringFromBytes(bytes, BoxesRunTime.unboxToInt((Object)offset), BoxesRunTime.unboxToInt((Object)length), ignored);
    }

    private byte[] uuidToBytes(String id) {
        UUID uuid = UUID.fromString(id);
        return ByteArrays$.MODULE$.uuidToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private String uuidFromBytes(byte[] bytes, int offset, int ignored, SimpleFeature sf) {
        Tuple2 uuid = ByteArrays$.MODULE$.uuidFromBytes(bytes, offset);
        if (sf != null) {
            Conversions.RichSimpleFeature$.MODULE$.cacheUuid$extension(Conversions$.MODULE$.RichSimpleFeature(sf), uuid);
        }
        return new UUID(uuid._1$mcJ$sp(), uuid._2$mcJ$sp()).toString();
    }

    private byte[] stringToBytes(String id) {
        return id.getBytes(StandardCharsets.UTF_8);
    }

    private String stringFromBytes(byte[] bytes, int offset, int length, SimpleFeature ignored) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    private GeoMesaFeatureIndex$() {
    }
}

