/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$IdFromRow$;
import org.locationtech.geomesa.index.api.IndexAdapter$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.conf.splitter.TableSplitter$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.utils.ExplainNull$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0011-d!B.]\u0003\u00039\u0007BCA\u000f\u0001\t\u0015\r\u0011\"\u0001\u0002 !Q\u0011q\u0007\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u001d\u0003A!b\u0001\n\u0003\tI\u0005\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"!\u0019\u0001\u0005\u000b\u0007I\u0011AA2\u0011)\t)\b\u0001B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003o\u0002!Q1A\u0005\u0002\u0005e\u0004BCAA\u0001\t\u0005\t\u0015!\u0003\u0002|!Q\u00111\u0011\u0001\u0003\u0006\u0004%\t!!\"\t\u0015\u0005]\u0005A!A!\u0002\u0013\t9\t\u0003\u0006\u0002\u001a\u0002\u0011)\u0019!C\u0001\u00037C!\"!/\u0001\u0005\u0003\u0005\u000b\u0011BAO\u0011\u001d\tY\f\u0001C\u0001\u0003{C\u0011\"a9\u0001\u0005\u0004%\t\"a\u0019\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003KB!\"a:\u0001\u0011\u000b\u0007I\u0011CAu\u0011%\u0011y\u0002\u0001b\u0001\n\u0003\t\u0019\u0007\u0003\u0005\u0004V\u0001\u0001\u000b\u0011BA3\u0011%\u00199\u0006\u0001b\u0001\n\u0003\u0019I\u0006\u0003\u0005\u0004b\u0001\u0001\u000b\u0011BB.\u0011\u001d\u0011)\f\u0001D\u0001\u0007GBqA!4\u0001\r\u0003\u00199\u0007C\u0004\u0002d\u0002!\taa\u001f\t\u0013\r\r\u0005!%A\u0005\u0002\r\u0015\u0005bBBN\u0001\u0011\u00051Q\u0014\u0005\n\u0007O\u0003\u0011\u0013!C\u0001\u0007\u000bC\u0011b!+\u0001#\u0003%\taa+\t\u000f\r=\u0006\u0001\"\u0001\u00042\"I1Q\u0017\u0001\u0012\u0002\u0013\u00051Q\u0011\u0005\b\u0007o\u0003A\u0011AB]\u0011%\u0019y\fAI\u0001\n\u0003\u0019)\tC\u0004\u0004B\u0002!\t!!\"\t\u000f\r\r\u0007\u0001\"\u0001\u0004F\"I1\u0011\u001a\u0001\u0012\u0002\u0013\u00051Q\u0011\u0005\b\u0007\u0017\u0004A\u0011ABg\u0011\u001d\u0019y\u000e\u0001C\u0001\u0007CDqa!;\u0001\t\u0003\u0019Y\u000fC\u0004\u0004v\u0002!\taa>\t\u000f\r}\bA\"\u0001\u0005\u0002!9A\u0011\u0004\u0001\u0005\u0002\u0011m\u0001\"\u0003C%\u0001E\u0005I\u0011\u0001C&\u0011\u001d!y\u0005\u0001C\t\t#B\u0011\u0002b\u0016\u0001#\u0003%\tb!\"\t\u0013\u0011e\u0003!%A\u0005\u0012\r-\u0006b\u0002C.\u0001\u0011\u0005CQ\f\u0005\b\t?\u0002A\u0011\tC1\u0011\u001d!9\u0007\u0001C!\tS:q!a=]\u0011\u0003\t)P\u0002\u0004\\9\"\u0005\u0011q\u001f\u0005\b\u0003w\u000bD\u0011AA}\u000f\u001d\tY0\rE\u0001\u0003{4qA!\u00012\u0011\u0003\u0011\u0019\u0001C\u0004\u0002<R\"\tA!\u0002\t\u0013\t\u001dAG1A\u0005\u0002\t%\u0001\u0002\u0003B\ti\u0001\u0006IAa\u0003\t\u0013\tMAG1A\u0005\u0002\t%\u0001\u0002\u0003B\u000bi\u0001\u0006IAa\u0003\t\u0013\t]AG1A\u0005\u0002\t%\u0001\u0002\u0003B\ri\u0001\u0006IAa\u0003\t\u0013\tmAG1A\u0005\u0002\t%\u0001\u0002\u0003B\u000fi\u0001\u0006IAa\u0003\t\u000f\t}\u0011\u0007\"\u0001\u0003\"!9!qD\u0019\u0005\u0002\t%\u0002b\u0002B\u0010c\u0011\u0005!1\b\u0005\b\u0005\u001f\nD\u0011\u0001B)\u0011\u001d\u0011I&\rC\u0001\u00057BqA!\u001d2\t\u0003\u0011\u0019HB\u0005\u0003\u0004F\u0002\n1%\t\u0003\u0006\"9!q\u0011#\u0007\u0002\t%\u0005b\u0002BM\t\u001a\u0005!1T\u0004\b\u0007S\t\u0004\u0012\u0001BV\r\u001d\u0011\u0019)\rE\u0001\u0005OCq!a/I\t\u0003\u0011I\u000bC\u0004\u0003\b\"#\tA!,\u0007\r\t\u0015\bJ\u0001Bt\u0011)\u0011\th\u0013B\u0001B\u0003%!Q\u000f\u0005\u000b\u0005S\\%\u0011!Q\u0001\n\u0005m\u0004bBA^\u0017\u0012\u0005!1\u001e\u0005\b\u0005\u000f[E\u0011\tB{\u0011\u001d\u0011Ij\u0013C!\u0005\u007f4aA!*I\u0005\r\u001d\u0001B\u0003B9#\n\u0005\t\u0015!\u0003\u0003v!Q!\u0011^)\u0003\u0002\u0003\u0006Ia!\u0003\t\u000f\u0005m\u0016\u000b\"\u0001\u0004\u0010!9!qQ)\u0005B\r]\u0001b\u0002BM#\u0012\u00053\u0011\u0005\u0005\b\u0007W\tD\u0011BB\u0017\u0011\u001d\u0019\t$\rC\u0005\u0007gAqaa\u00112\t\u0013\u0019)\u0005C\u0004\u0004JE\"Iaa\u0013\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u000b\u0005us\u0016aA1qS*\u0011q\fY\u0001\u0006S:$W\r\u001f\u0006\u0003C\n\fqaZ3p[\u0016\u001c\u0018M\u0003\u0002dI\u0006aAn\\2bi&|g\u000e^3dQ*\tQ-A\u0002pe\u001e\u001c\u0001!F\u0003i\u0003\u000b\fYmE\u0003\u0001S>\fI\u0001\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7N\u0001\u0004B]f\u0014VM\u001a\t\u0004a\u0006\raBA9\u007f\u001d\t\u0011XP\u0004\u0002ty:\u0011Ao\u001f\b\u0003kjt!A^=\u000e\u0003]T!\u0001\u001f4\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0017BA2e\u0013\t\t'-\u0003\u0002`A&\u0011qLX\u0005\u0004\u007f\u0006\u0005\u0011a\u00029bG.\fw-\u001a\u0006\u0003?zKA!!\u0002\u0002\b\tQa*Y7fI&sG-\u001a=\u000b\u0007}\f\t\u0001\u0005\u0003\u0002\f\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005M\u0011QC\u0001\tif\u0004Xm]1gK*\u0011\u0011qC\u0001\u0004G>l\u0017\u0002BA\u000e\u0003\u001b\u00111\u0002T1{s2{wmZ5oO\u0006\u0011Am]\u000b\u0003\u0003C\u0001D!a\t\u00024A1\u0011QEA\u0016\u0003_i!!a\n\u000b\u0007\u0005%b,\u0001\u0005hK>$xn\u001c7t\u0013\u0011\ti#a\n\u0003!\u001d+w.T3tC\u0012\u000bG/Y*u_J,\u0007\u0003BA\u0019\u0003ga\u0001\u0001B\u0006\u00026\t\t\t\u0011!A\u0003\u0002\u0005e\"aA0%c\u0005\u0019Am\u001d\u0011\u0012\t\u0005m\u0012\u0011\t\t\u0004U\u0006u\u0012bAA W\n9aj\u001c;iS:<\u0007c\u00016\u0002D%\u0019\u0011QI6\u0003\u0007\u0005s\u00170A\u0002tMR,\"!a\u0013\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u000511/[7qY\u0016TA!!\u0016\u0002X\u00059a-Z1ukJ,'bAA-I\u00069q\u000e]3oO&\u001c\u0018\u0002BA/\u0003\u001f\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0003\u0011\u0019h\r\u001e\u0011\u0002\t9\fW.Z\u000b\u0003\u0003K\u0002B!a\u001a\u0002p9!\u0011\u0011NA6!\t18.C\u0002\u0002n-\fa\u0001\u0015:fI\u00164\u0017\u0002BA9\u0003g\u0012aa\u0015;sS:<'bAA7W\u0006)a.Y7fA\u00059a/\u001a:tS>tWCAA>!\rQ\u0017QP\u0005\u0004\u0003\u007fZ'aA%oi\u0006Aa/\u001a:tS>t\u0007%\u0001\u0006biR\u0014\u0018NY;uKN,\"!a\"\u0011\r\u0005%\u0015\u0011SA3\u001d\u0011\tY)a$\u000f\u0007Y\fi)C\u0001m\u0013\ty8.\u0003\u0003\u0002\u0014\u0006U%aA*fc*\u0011qp[\u0001\fCR$(/\u001b2vi\u0016\u001c\b%\u0001\u0003n_\u0012,WCAAO!\u0011\ty*a-\u000f\t\u0005\u0005\u0016Q\u0016\b\u0005\u0003G\u000bIKD\u0002t\u0003KK1!a*a\u0003\u0015)H/\u001b7t\u0013\ry\u00161\u0016\u0006\u0004\u0003O\u0003\u0017\u0002BAX\u0003c\u000b\u0011\"\u00138eKblu\u000eZ3\u000b\u0007}\u000bY+\u0003\u0003\u00026\u0006]&!C%oI\u0016DXj\u001c3f\u0015\u0011\ty+!-\u0002\u000b5|G-\u001a\u0011\u0002\rqJg.\u001b;?)9\ty,a4\u0002Z\u0006m\u0017Q\\Ap\u0003C\u0004r!!1\u0001\u0003\u0007\fI-D\u0001]!\u0011\t\t$!2\u0005\u000f\u0005\u001d\u0007A1\u0001\u0002:\t\tA\u000b\u0005\u0003\u00022\u0005-GaBAg\u0001\t\u0007\u0011\u0011\b\u0002\u0002+\"9\u0011QD\u0007A\u0002\u0005E\u0007\u0007BAj\u0003/\u0004b!!\n\u0002,\u0005U\u0007\u0003BA\u0019\u0003/$A\"!\u000e\u0002P\u0006\u0005\t\u0011!B\u0001\u0003sAq!a\u0012\u000e\u0001\u0004\tY\u0005C\u0004\u0002b5\u0001\r!!\u001a\t\u000f\u0005]T\u00021\u0001\u0002|!9\u00111Q\u0007A\u0002\u0005\u001d\u0005bBAM\u001b\u0001\u0007\u0011QT\u0001\ri\u0006\u0014G.\u001a(b[\u0016\\U-_\u0001\u000ei\u0006\u0014G.\u001a(b[\u0016\\U-\u001f\u0011\u0002\u0013%$gI]8n%><XCAAv!\r\ti\u000f\u0012\b\u0004\u0003_\u0004db\u0001:\u0002r&\u0011QLX\u0001\u0014\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f\u0013:$W\r\u001f\t\u0004\u0003\u0003\f4CA\u0019j)\t\t)0A\u0004TG\",W.Z:\u0011\u0007\u0005}H'D\u00012\u0005\u001d\u00196\r[3nKN\u001c\"\u0001N5\u0015\u0005\u0005u\u0018!\u0004.4)\u0006\u0014G.Z*dQ\u0016lW-\u0006\u0002\u0003\fA1\u0011\u0011\u0012B\u0007\u0003KJAAa\u0004\u0002\u0016\n!A*[:u\u00039Q6\u0007V1cY\u0016\u001c6\r[3nK\u0002\nQB\u0017\u001aUC\ndWmU2iK6,\u0017A\u0004.3)\u0006\u0014G.Z*dQ\u0016lW\rI\u0001\u000f1j\u001bD+\u00192mKN\u001b\u0007.Z7f\u0003=A&l\r+bE2,7k\u00195f[\u0016\u0004\u0013A\u0004-[eQ\u000b'\r\\3TG\",W.Z\u0001\u00101j\u0013D+\u00192mKN\u001b\u0007.Z7fA\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0015\u0011\u0005\u0015$1\u0005B\u0013\u0005OAq!!\u0019?\u0001\u0004\t)\u0007C\u0004\u0002xy\u0002\r!a\u001f\t\u000f\u0005\re\b1\u0001\u0002\bR!\u0011Q\rB\u0016\u0011\u001d\u0011ic\u0010a\u0001\u0005_\t!!\u001b3\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002,\u0006!1m\u001c8g\u0013\u0011\u0011IDa\r\u0003\u000f%sG-\u001a=JIR!\u0011Q\rB\u001f\u0011\u0019y\u0006\t1\u0001\u0003@A2!\u0011\tB#\u0005\u0017\u0002r!!1\u0001\u0005\u0007\u0012I\u0005\u0005\u0003\u00022\t\u0015C\u0001\u0004B$\u0005{\t\t\u0011!A\u0003\u0002\u0005e\"aA0%iA!\u0011\u0011\u0007B&\t1\u0011iE!\u0010\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryF%N\u0001\u0011E\u0006\u001cX\rV1cY\u0016t\u0015-\\3LKf$\u0002\"!\u001a\u0003T\tU#q\u000b\u0005\b\u0003C\n\u0005\u0019AA3\u0011\u001d\t\u0019)\u0011a\u0001\u0003\u000fCq!a\u001eB\u0001\u0004\tY(A\u0005jIR{')\u001f;fgR!!Q\fB8!\u001dQ'qLA3\u0005GJ1A!\u0019l\u0005%1UO\\2uS>t\u0017\u0007E\u0003k\u0005K\u0012I'C\u0002\u0003h-\u0014Q!\u0011:sCf\u00042A\u001bB6\u0013\r\u0011ig\u001b\u0002\u0005\u0005f$X\rC\u0004\u0002H\t\u0003\r!a\u0013\u0002\u0017%$gI]8n\u0005f$Xm\u001d\u000b\u0005\u0005k\u0012\t\tE\u0007k\u0005o\u0012\u0019'a\u001f\u0002|\tm\u0014QM\u0005\u0004\u0005sZ'!\u0003$v]\u000e$\u0018n\u001c85!\u0011\tiE! \n\t\t}\u0014q\n\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005\u001d3\t1\u0001\u0002L\tI\u0011\n\u001a$s_6\u0014vn^\n\u0003\t&\fQ!\u00199qYf$\"\"!\u001a\u0003\f\n=%1\u0013BL\u0011\u001d\u0011i)\u0012a\u0001\u0005G\n1A]8x\u0011\u001d\u0011\t*\u0012a\u0001\u0003w\naa\u001c4gg\u0016$\bb\u0002BK\u000b\u0002\u0007\u00111P\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005US\t1\u0001\u0003|\u0005)1\u000f^1siRA\u00111\u0010BO\u0005?\u0013\t\u000bC\u0004\u0003\u000e\u001a\u0003\rAa\u0019\t\u000f\tEe\t1\u0001\u0002|!9!Q\u0013$A\u0002\u0005m\u0014f\u0001#R\u0017\n\u0001B)\u001f8b[&\u001c\u0017\n\u001a$s_6\u0014vn^\n\u0003\u0011&$\"Aa+\u0011\u0007\u0005}\b\n\u0006\u0005\u00030\nE&1\u0017Bf!\r\ty\u0010\u0012\u0005\b\u0003\u000fR\u0005\u0019AA&\u0011\u001d\u0011)L\u0013a\u0001\u0005o\u000b\u0001b[3z'B\f7-\u001a\u0019\u0007\u0005s\u0013\tMa2\u0011\u0011\u0005\u0005'1\u0018B`\u0005\u000bL1A!0]\u00055Ie\u000eZ3y\u0017\u0016L8\u000b]1dKB!\u0011\u0011\u0007Ba\t1\u0011\u0019Ma-\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryFE\u000e\t\u0005\u0003c\u00119\r\u0002\u0007\u0003J\nM\u0016\u0011!A\u0001\u0006\u0003\tIDA\u0002`I]BqA!4K\u0001\u0004\u0011y-\u0001\buS\u0016\u0014X\rZ&fsN\u0003\u0018mY3\u0011\u000b)\u0014\tN!6\n\u0007\tM7N\u0001\u0004PaRLwN\u001c\u0019\u0007\u0005/\u0014YN!9\u0011\u0011\u0005\u0005'1\u0018Bm\u0005?\u0004B!!\r\u0003\\\u0012a!Q\u001cBf\u0003\u0003\u0005\tQ!\u0001\u0002:\t\u0019q\f\n\u001d\u0011\t\u0005E\"\u0011\u001d\u0003\r\u0005G\u0014Y-!A\u0001\u0002\u000b\u0005\u0011\u0011\b\u0002\u0004?\u0012J$A\u0004$jq\u0016$\u0017\n\u001a$s_6\u0014vn^\n\u0005\u0017&\u0014y+\u0001\u0004qe\u00164\u0017\u000e\u001f\u000b\u0007\u0005[\u0014\tPa=\u0011\u0007\t=8*D\u0001I\u0011\u001d\u0011\tH\u0014a\u0001\u0005kBqA!;O\u0001\u0004\tY\b\u0006\u0006\u0002f\t](\u0011 B~\u0005{DqA!$P\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\u0012>\u0003\r!a\u001f\t\u000f\tUu\n1\u0001\u0002|!9\u0011QK(A\u0002\tmD\u0003CA>\u0007\u0003\u0019\u0019a!\u0002\t\u000f\t5\u0005\u000b1\u0001\u0003d!9!\u0011\u0013)A\u0002\u0005m\u0004b\u0002BK!\u0002\u0007\u00111P\n\u0005#&\u0014y\u000bE\u0006k\u0007\u0017\u0011\u0019'a\u001f\u0002|\u0005m\u0014bAB\u0007W\nIa)\u001e8di&|gn\r\u000b\u0007\u0007#\u0019\u0019b!\u0006\u0011\u0007\t=\u0018\u000bC\u0004\u0003rQ\u0003\rA!\u001e\t\u000f\t%H\u000b1\u0001\u0004\nQQ\u0011QMB\r\u00077\u0019iba\b\t\u000f\t5U\u000b1\u0001\u0003d!9!\u0011S+A\u0002\u0005m\u0004b\u0002BK+\u0002\u0007\u00111\u0010\u0005\b\u0003+*\u0006\u0019\u0001B>)!\tYha\t\u0004&\r\u001d\u0002b\u0002BG-\u0002\u0007!1\r\u0005\b\u0005#3\u0006\u0019AA>\u0011\u001d\u0011)J\u0016a\u0001\u0003w\n\u0011\"\u00133Ge>l'k\\<\u0002\u0017U,\u0018\u000e\u001a+p\u0005f$Xm\u001d\u000b\u0005\u0005G\u001ay\u0003C\u0004\u0003.]\u0003\r!!\u001a\u0002\u001bU,\u0018\u000e\u001a$s_6\u0014\u0015\u0010^3t))\t)g!\u000e\u0004:\rm2q\b\u0005\b\u0007oA\u0006\u0019\u0001B2\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u0011\t\n\u0017a\u0001\u0003wBqa!\u0010Y\u0001\u0004\tY(A\u0004jO:|'/\u001a3\t\u000f\r\u0005\u0003\f1\u0001\u0003|\u0005\u00111OZ\u0001\u000egR\u0014\u0018N\\4U_\nKH/Z:\u0015\t\t\r4q\t\u0005\b\u0005[I\u0006\u0019AA3\u0003=\u0019HO]5oO\u001a\u0013x.\u001c\"zi\u0016\u001cHCCA3\u0007\u001b\u001aye!\u0015\u0004T!91q\u0007.A\u0002\t\r\u0004b\u0002BI5\u0002\u0007\u00111\u0010\u0005\b\u0005+S\u0006\u0019AA>\u0011\u001d\u0019iD\u0017a\u0001\u0005w\n1\"\u001b3f]RLg-[3sA\u0005\u00012/\u001a:jC2L'0\u001a3XSRD\u0017\nZ\u000b\u0003\u00077\u00022A[B/\u0013\r\u0019yf\u001b\u0002\b\u0005>|G.Z1o\u0003E\u0019XM]5bY&TX\rZ,ji\"LE\rI\u000b\u0003\u0007K\u0002\u0002\"!1\u0003<\u0006\r\u0017\u0011Z\u000b\u0003\u0007S\u0002RA\u001bBi\u0007W\u0002da!\u001c\u0004r\r]\u0004\u0003CAa\u0005w\u001byg!\u001e\u0011\t\u0005E2\u0011\u000f\u0003\f\u0007g2\u0012\u0011!A\u0001\u0006\u0003\tIDA\u0002`II\u0002B!!\r\u0004x\u0011Y1\u0011\u0010\f\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryFe\r\u000b\u0005\u0003K\u001ai\bC\u0005\u0004\u0000]\u0001\n\u00111\u0001\u0004\u0002\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0006U\nE\u0017QM\u0001\u0017i\u0006\u0014G.\u001a(b[\u0016\\U-\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\u0011\u0016\u0005\u0007\u0003\u001bIi\u000b\u0002\u0004\fB!1QRBL\u001b\t\u0019yI\u0003\u0003\u0004\u0012\u000eM\u0015!C;oG\",7m[3e\u0015\r\u0019)j[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBM\u0007\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0019wN\u001c4jOV\u0014X\rV1cY\u0016t\u0015-\\3\u0015\r\u0005\u00154qTBQ\u0011%\u0019y(\u0007I\u0001\u0002\u0004\u0019\t\tC\u0005\u0004$f\u0001\n\u00111\u0001\u0004&\u0006)A.[7jiB)!N!5\u0002|\u0005a2m\u001c8gS\u001e,(/\u001a+bE2,g*Y7fI\u0011,g-Y;mi\u0012\n\u0014\u0001H2p]\u001aLw-\u001e:f)\u0006\u0014G.\u001a(b[\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0007[SCa!*\u0004\n\u0006\u0001B-\u001a7fi\u0016$\u0016M\u00197f\u001d\u0006lWm\u001d\u000b\u0005\u0003\u000f\u001b\u0019\fC\u0005\u0004\u0000q\u0001\n\u00111\u0001\u0004\u0002\u0006QB-\u001a7fi\u0016$\u0016M\u00197f\u001d\u0006lWm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005Iq-\u001a;Ta2LGo\u001d\u000b\u0005\u0007w\u001bi\f\u0005\u0004\u0002\n\u0006E%1\r\u0005\n\u0007\u007fr\u0002\u0013!a\u0001\u0007\u0003\u000b1cZ3u'Bd\u0017\u000e^:%I\u00164\u0017-\u001e7uIE\nQbZ3u!\u0006\u0014H/\u001b;j_:\u001c\u0018!D4fiR\u000b'\r\\3OC6,7\u000f\u0006\u0003\u0002\b\u000e\u001d\u0007\"CB@CA\u0005\t\u0019ABA\u0003]9W\r\u001e+bE2,g*Y7fg\u0012\"WMZ1vYR$\u0013'A\thKR$\u0016M\u00197fg\u001a{'/U;fef$B!a\"\u0004P\"91\u0011[\u0012A\u0002\rM\u0017A\u00024jYR,'\u000fE\u0003k\u0005#\u001c)\u000e\u0005\u0003\u0004X\u000emWBABm\u0015\u0011\u0019\t.a\u0016\n\t\ru7\u0011\u001c\u0002\u0007\r&dG/\u001a:\u0002\u001f\r\u0014X-\u0019;f\u0007>tg/\u001a:uKJ$\"aa9\u0011\r\u0005\u00057Q]Ae\u0013\r\u00199\u000f\u0018\u0002\u000f/JLG/Z\"p]Z,'\u000f^3s\u000319W\r^%e\rJ|WNU8x))\t)g!<\u0004p\u000eE81\u001f\u0005\b\u0005\u001b+\u0003\u0019\u0001B2\u0011\u001d\u0011\t*\na\u0001\u0003wBqA!&&\u0001\u0004\tY\bC\u0004\u0002V\u0015\u0002\rAa\u001f\u0002\u0017\u001d,G/\u00133PM\u001a\u001cX\r\u001e\u000b\t\u0003w\u001aIpa?\u0004~\"9!Q\u0012\u0014A\u0002\t\r\u0004b\u0002BIM\u0001\u0007\u00111\u0010\u0005\b\u0005+3\u0003\u0019AA>\u0003E9W\r\u001e$jYR,'o\u0015;sCR,w-\u001f\u000b\u0007\t\u0007!\t\u0002b\u0005\u0011\u000b)\u0014\t\u000e\"\u0002\u0011\t\u0011\u001dA1\u0002\b\u0005\u0003\u0003$I!\u0003\u0002\u00009&!AQ\u0002C\b\u000591\u0015\u000e\u001c;feN#(/\u0019;fOfT!a /\t\u000f\rEw\u00051\u0001\u0004V\"9AQC\u0014A\u0002\u0011]\u0011!\u0003;sC:\u001chm\u001c:n!\u0015Q'\u0011[A&\u0003A9W\r^)vKJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0005\u0005\u001e\u0011\rBQ\u0005C\u001e!\u0011!9\u0001b\b\n\t\u0011\u0005Bq\u0002\u0002\u000e#V,'/_*ue\u0006$XmZ=\t\u000f\rE\u0007\u00061\u0001\u0005\u0006!9Aq\u0005\u0015A\u0002\u0011%\u0012!\u00025j]R\u001c\b\u0003\u0002C\u0016\toi!\u0001\"\f\u000b\t\u0011=B\u0011G\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011!\u0019\u0004\"\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003S!\u0017\u0002\u0002C\u001d\t[\u0011Q\u0001S5oiND\u0011\u0002\"\u0010)!\u0003\u0005\r\u0001b\u0010\u0002\u000f\u0015D\b\u000f\\1j]B!A\u0011\tC#\u001b\t!\u0019EC\u0002\u0002(zKA\u0001b\u0012\u0005D\tIQ\t\u001f9mC&tWM]\u0001\u001bO\u0016$\u0018+^3ssN#(/\u0019;fOf$C-\u001a4bk2$HeM\u000b\u0003\t\u001bRC\u0001b\u0010\u0004\n\u0006\tr-\u001a8fe\u0006$X\rV1cY\u0016t\u0015-\\3\u0015\r\u0005\u0015D1\u000bC+\u0011%\u0019yH\u000bI\u0001\u0002\u0004\u0019\t\tC\u0005\u0004$*\u0002\n\u00111\u0001\u0004&\u0006Yr-\u001a8fe\u0006$X\rV1cY\u0016t\u0015-\\3%I\u00164\u0017-\u001e7uIE\n1dZ3oKJ\fG/\u001a+bE2,g*Y7fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0004\\\u0011\r\u0004b\u0002C3]\u0001\u0007\u0011\u0011I\u0001\u0006_RDWM]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111\u0010")
public abstract class GeoMesaFeatureIndex<T, U>
implements package.NamedIndex,
LazyLogging {
    private IdFromRow idFromRow;
    private final GeoMesaDataStore<?> ds;
    private final SimpleFeatureType sft;
    private final String name;
    private final int version;
    private final Seq<String> attributes;
    private final IndexMode.IndexMode mode;
    private final String tableNameKey;
    private final String identifier;
    private final boolean serializedWithId;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes(SimpleFeatureType sft) {
        return GeoMesaFeatureIndex$.MODULE$.idFromBytes(sft);
    }

    public static Function1<String, byte[]> idToBytes(SimpleFeatureType sft) {
        return GeoMesaFeatureIndex$.MODULE$.idToBytes(sft);
    }

    public static String baseTableNameKey(String name, Seq<String> attributes2, int version) {
        return GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(name, attributes2, version);
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public GeoMesaDataStore<?> ds() {
        return this.ds;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Seq<String> attributes() {
        return this.attributes;
    }

    public IndexMode.IndexMode mode() {
        return this.mode;
    }

    public String tableNameKey() {
        return this.tableNameKey;
    }

    private IdFromRow idFromRow$lzycompute() {
        GeoMesaFeatureIndex geoMesaFeatureIndex = this;
        synchronized (geoMesaFeatureIndex) {
            if (!this.bitmap$0) {
                this.idFromRow = GeoMesaFeatureIndex$IdFromRow$.MODULE$.apply(this.sft(), this.keySpace(), this.tieredKeySpace());
                this.bitmap$0 = true;
            }
        }
        return this.idFromRow;
    }

    public IdFromRow idFromRow() {
        if (!this.bitmap$0) {
            return this.idFromRow$lzycompute();
        }
        return this.idFromRow;
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean serializedWithId() {
        return this.serializedWithId;
    }

    public abstract IndexKeySpace<T, U> keySpace();

    public abstract Option<IndexKeySpace<?, ?>> tieredKeySpace();

    public String tableNameKey(Option<String> partition) {
        return (String)partition.map((Function1 & Serializable)p -> new StringBuilder(1).append(this.tableNameKey()).append(".").append((String)p).toString()).getOrElse((Function0 & Serializable)() -> this.tableNameKey());
    }

    public Option<String> tableNameKey$default$1() {
        return None$.MODULE$;
    }

    public String configureTableName(Option<String> partition, Option<Object> limit) {
        String key = this.tableNameKey(partition);
        GeoMesaMetadata qual$1 = this.ds().metadata();
        String x$1 = this.sft().getTypeName();
        String x$2 = key;
        boolean x$3 = qual$1.read$default$3();
        return (String)qual$1.read(x$1, x$2, x$3).getOrElse((Function0 & Serializable)() -> {
            String name = this.generateTableName(partition, limit);
            this.ds().metadata().insert(this.sft().getTypeName(), key, name);
            return name;
        });
    }

    public Option<String> configureTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> configureTableName$default$2() {
        return None$.MODULE$;
    }

    public Seq<String> deleteTableNames(Option<String> partition) {
        Seq<String> tables = this.getTableNames(partition);
        Option<String> option = partition;
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            this.ds().metadata().remove(this.sft().getTypeName(), new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString());
        } else if (None$.MODULE$.equals(option)) {
            this.ds().metadata().scan(this.sft().getTypeName(), this.tableNameKey(), false).foreach((Function1 & Serializable)x0$1 -> {
                GeoMesaFeatureIndex.$anonfun$deleteTableNames$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            throw new MatchError(option);
        }
        return tables;
    }

    public Option<String> deleteTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<byte[]> getSplits(Option<String> partition) {
        Seq shards = GeoMesaFeatureIndex.nonEmpty$1(this.keySpace().sharding().shards());
        Seq splits = GeoMesaFeatureIndex.nonEmpty$1((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)TableSplitter$.MODULE$.getSplits(this.sft(), this.identifier(), partition)));
        Seq result = (Seq)shards.flatMap((Function1 & Serializable)shard -> (Seq)splits.map((Function1 & Serializable)split -> ByteArrays$.MODULE$.concat(shard, split)));
        return (Seq)result.drop(1);
    }

    public Option<String> getSplits$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getPartitions() {
        if (!TablePartition$.MODULE$.partitioned(this.sft())) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        int offset = this.tableNameKey().length() + 1;
        GeoMesaMetadata qual$1 = this.ds().metadata();
        String x$1 = this.sft().getTypeName();
        String x$2 = this.tableNameKey();
        boolean x$3 = qual$1.scan$default$3();
        return (Seq)qual$1.scan(x$1, x$2, x$3).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return k.substring(offset);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<String> getTableNames(Option<String> partition) {
        Option<String> option = partition;
        if (None$.MODULE$.equals(option)) {
            GeoMesaMetadata qual$1 = this.ds().metadata();
            String x$12 = this.sft().getTypeName();
            String x$2 = this.tableNameKey();
            boolean x$3 = qual$1.scan$default$3();
            return (Seq)qual$1.scan(x$12, x$2, x$3).map((Function1 & Serializable)x$1 -> (String)x$1._2());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            GeoMesaMetadata qual$2 = this.ds().metadata();
            String x$4 = this.sft().getTypeName();
            String x$5 = new StringBuilder(1).append(this.tableNameKey()).append(".").append(p).toString();
            boolean x$6 = qual$2.read$default$3();
            return Option$.MODULE$.option2Iterable(qual$2.read(x$4, x$5, x$6)).toSeq();
        }
        throw new MatchError(option);
    }

    public Option<String> getTableNames$default$1() {
        return None$.MODULE$;
    }

    public Seq<String> getTablesForQuery(Option<Filter> filter) {
        Option partitioned = filter.flatMap((Function1 & Serializable)f -> TablePartition$.MODULE$.apply(this.ds(), this.sft()).flatMap((Function1 & Serializable)tp -> tp.partitions((Filter)f).map((Function1 & Serializable)partitions -> (Seq)partitions.flatMap((Function1 & Serializable)p -> this.getTableNames((Option<String>)new Some(p))))));
        return (Seq)partitioned.getOrElse((Function0 & Serializable)() -> this.getTableNames((Option<String>)None$.MODULE$));
    }

    public WriteConverter<U> createConverter() {
        Option<IndexKeySpace<?, ?>> option = this.tieredKeySpace();
        if (None$.MODULE$.equals(option)) {
            return new WriteConverter.WriteConverterImpl<U>(this.keySpace());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexKeySpace tier = (IndexKeySpace)some.value();
            return new WriteConverter.TieredWriteConverter<U>(this.keySpace(), tier);
        }
        throw new MatchError(option);
    }

    public String getIdFromRow(byte[] row, int offset, int length, SimpleFeature feature) {
        return this.idFromRow().apply(row, offset, length, feature);
    }

    public int getIdOffset(byte[] row, int offset, int length) {
        return this.idFromRow().start(row, offset, length);
    }

    public abstract Option<package.FilterStrategy> getFilterStrategy(Filter var1, Option<SimpleFeatureType> var2);

    public package.QueryStrategy getQueryStrategy(package.FilterStrategy filter, Hints hints, Explainer explain) {
        byte[] sharing = this.keySpace().sharing();
        Option indexValues = filter.primary().map((Function1 & Serializable)x$2 -> this.keySpace().getIndexValues((Filter)x$2, explain));
        boolean useFullFilter = this.keySpace().useFullFilter(indexValues, (Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig>)new Some((Object)this.ds().config()), hints);
        Option<Filter> ecql = useFullFilter ? filter.filter() : filter.secondary();
        Option option = indexValues;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (filter.filter().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$2(x$3)))) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), (Seq)package$.MODULE$.Seq().empty(), (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), ecql, hints, indexValues);
            }
            if (QueryHints$.MODULE$.RichHints(hints).getMaxFeatures().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.BlockMaxThreshold().toInt().get()))) {
                LazyRef filterString$lzy = new LazyRef();
                boolean block = BoxesRunTime.unboxToBoolean((Object)QueryProperties$.MODULE$.blockFullTableScansForFeatureType(this.sft().getTypeName()).orElse((Function0 & Serializable)() -> QueryProperties$.MODULE$.BlockFullTableScans().toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                if (block) {
                    throw new RuntimeException(new StringBuilder(57).append("Full-table scans are disabled. Query being stopped for ").append(this.sft().getTypeName()).append(": ").append(GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)).toString());
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Running full table scan for schema '{}' with filter: {}", new Object[]{this.sft().getTypeName(), GeoMesaFeatureIndex.filterString$1(filterString$lzy, filter)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            .colon.colon keyRanges = new .colon.colon(new package.UnboundedRange<Object>(null), (List)Nil$.MODULE$);
            .colon.colon byteRanges = new .colon.colon((Object)new package.BoundedByteRange(sharing, ByteArrays$.MODULE$.rowFollowingPrefix(sharing)), (List)Nil$.MODULE$);
            return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, (Seq<package.ScanRange<?>>)keyRanges, (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), ecql, hints, (Option<?>)indexValues);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object values = some.value();
            LazyRef tiers$lzy = new LazyRef();
            IndexKeySpace<Object, U> qual$1 = this.keySpace();
            Object x$1 = values;
            int x$22 = qual$1.getRanges$default$2();
            Seq keyRanges = qual$1.getRanges(x$1, x$22).toSeq();
            Seq bytes = this.keySpace().getRangeBytes(keyRanges.iterator(), this.tieredKeySpace().isDefined()).toSeq();
            IndexKeySpace tier = (IndexKeySpace)this.tieredKeySpace().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Filter secondary = (Filter)filter.secondary().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (tier == null) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)bytes, keyRanges, (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), ecql, hints, indexValues);
            }
            if (secondary == null || GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$8(x$6)))) {
                Seq byteRanges = this.keySpace().getRangeBytes(keyRanges.iterator(), true).map((Function1 & Serializable)x0$1 -> {
                    package.ByteRange byteRange = x0$1;
                    if (byteRange instanceof package.BoundedByteRange) {
                        package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                        byte[] lo = boundedByteRange.lower();
                        byte[] hi = boundedByteRange.upper();
                        return new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.SingleRowByteRange) {
                        package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                        byte[] row = singleRowByteRange.row();
                        return new package.BoundedByteRange(row, ByteArrays$.MODULE$.concat(row, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.UpperBoundedByteRange) {
                        package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                        byte[] lo = upperBoundedByteRange.lower();
                        byte[] hi = upperBoundedByteRange.upper();
                        return new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, package$ByteRange$.MODULE$.UnboundedUpperRange()));
                    }
                    if (byteRange instanceof package.LowerBoundedByteRange) {
                        package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                        byte[] lo = lowerBoundedByteRange.lower();
                        byte[] hi = lowerBoundedByteRange.upper();
                        return new package.BoundedByteRange(lo, hi);
                    }
                    if (byteRange instanceof package.UnboundedByteRange) {
                        package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                        byte[] lo = unboundedByteRange.lower();
                        byte[] hi = unboundedByteRange.upper();
                        return new package.BoundedByteRange(lo, hi);
                    }
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
                }).toSeq();
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), ecql, hints, indexValues);
            }
            if (GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).isEmpty()) {
                return new package.QueryStrategy(filter, (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), (Seq)package$.MODULE$.Seq().empty(), (Seq<package.ByteRange>)((Seq)package$.MODULE$.Seq().empty()), ecql, hints, indexValues);
            }
            LazyRef minTier$lzy = new LazyRef();
            LazyRef maxTier$lzy = new LazyRef();
            Seq byteRanges = (Seq)bytes.flatMap((Function1 & Serializable)x0$2 -> {
                package.ByteRange byteRange = x0$2;
                if (byteRange instanceof package.SingleRowByteRange) {
                    package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                    byte[] row = singleRowByteRange.row();
                    return GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain).map((Function1 & Serializable)x0$3 -> {
                        package.ByteRange byteRange = x0$3;
                        if (byteRange instanceof package.BoundedByteRange) {
                            package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                            byte[] lo = boundedByteRange.lower();
                            byte[] hi = boundedByteRange.upper();
                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(row, lo), ByteArrays$.MODULE$.concat(row, hi));
                        }
                        if (byteRange instanceof package.SingleRowByteRange) {
                            package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                            byte[] trow = singleRowByteRange.row();
                            return new package.SingleRowByteRange(ByteArrays$.MODULE$.concat(row, trow));
                        }
                        throw new MatchError((Object)byteRange);
                    });
                }
                if (byteRange instanceof package.BoundedByteRange) {
                    package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                    byte[] lo = boundedByteRange.lower();
                    byte[] hi = boundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                }
                if (byteRange instanceof package.LowerBoundedByteRange) {
                    package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)byteRange;
                    byte[] lo = lowerBoundedByteRange.lower();
                    byte[] hi = lowerBoundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(ByteArrays$.MODULE$.concat(lo, GeoMesaFeatureIndex.minTier$1(minTier$lzy, tiers$lzy, bytes, tier, secondary, explain)), hi));
                }
                if (byteRange instanceof package.UpperBoundedByteRange) {
                    package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)byteRange;
                    byte[] lo = upperBoundedByteRange.lower();
                    byte[] hi = upperBoundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, ByteArrays$.MODULE$.concat(hi, GeoMesaFeatureIndex.maxTier$1(maxTier$lzy, tiers$lzy, bytes, tier, secondary, explain))));
                }
                if (byteRange instanceof package.UnboundedByteRange) {
                    package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)byteRange;
                    byte[] lo = unboundedByteRange.lower();
                    byte[] hi = unboundedByteRange.upper();
                    return package$.MODULE$.Iterator().single((Object)new package.BoundedByteRange(lo, hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(byteRange).toString());
            });
            return new package.QueryStrategy(filter, (Seq<package.ByteRange>)byteRanges, keyRanges, (Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy, bytes, tier, secondary, explain), ecql, hints, indexValues);
        }
        throw new MatchError((Object)option);
    }

    public Explainer getQueryStrategy$default$3() {
        return ExplainNull$.MODULE$;
    }

    public String generateTableName(Option<String> partition, Option<Object> limit) {
        String string = this.ds().config().catalog();
        String prefix = ((IterableOnceOps)((SeqOps)new .colon.colon((Object)this.sft().getTypeName(), (List)new .colon.colon((Object)this.name(), (List)Nil$.MODULE$)).map((Function1 & Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input))).$plus$colon((Object)string)).mkString("_");
        String suffix = new StringBuilder(1).append("v").append(this.version()).append(partition.map((Function1 & Serializable)p -> new StringBuilder(1).append("_").append((String)p).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        String full = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable)input -> StringSerialization$.MODULE$.alphaNumericSafeString(input)), prefix, suffix);
        Option<Object> option = limit;
        if (option instanceof Some) {
            Some some = (Some)option;
            int lim = BoxesRunTime.unboxToInt((Object)some.value());
            if (StringOps$.MODULE$.lengthCompare$extension(Predef$.MODULE$.augmentString(full), lim) > 0) {
                BoxedUnit boxedUnit;
                String nums = GeoMesaFeatureIndex.build$1((Seq)this.attributes().map((Function1 & Serializable)a -> String.valueOf(BoxesRunTime.boxToInteger((int)this.sft().indexOf(a)))), prefix, suffix);
                if (StringOps$.MODULE$.lengthCompare$extension(Predef$.MODULE$.augmentString(nums), lim) <= 0) {
                    return nums;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Table name length exceeds configured limit ({}), falling back to UUID: {}", new Object[]{BoxesRunTime.boxToInteger((int)lim), full});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return IndexAdapter$.MODULE$.truncateTableName(full, lim);
            }
        }
        return full;
    }

    public Option<String> generateTableName$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> generateTableName$default$2() {
        return None$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(0).append(this.getClass().getSimpleName()).append(this.attributes().mkString("(", ",", ")")).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof GeoMesaFeatureIndex)) return false;
        GeoMesaFeatureIndex geoMesaFeatureIndex = (GeoMesaFeatureIndex)object;
        String string = this.identifier();
        String string2 = geoMesaFeatureIndex.identifier();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        IndexMode.IndexMode indexMode = this.mode();
        IndexMode.IndexMode indexMode2 = geoMesaFeatureIndex.mode();
        if (indexMode == null) {
            if (indexMode2 != null) {
                return false;
            }
        } else if (!indexMode.equals(indexMode2)) return false;
        GeoMesaDataStore<?> geoMesaDataStore = this.ds();
        GeoMesaDataStore<?> geoMesaDataStore2 = geoMesaFeatureIndex.ds();
        if (geoMesaDataStore == null) {
            if (geoMesaDataStore2 != null) {
                return false;
            }
        } else if (!geoMesaDataStore.equals(geoMesaDataStore2)) return false;
        SimpleFeatureType simpleFeatureType = this.sft();
        SimpleFeatureType simpleFeatureType2 = geoMesaFeatureIndex.sft();
        if (simpleFeatureType == null) {
            if (simpleFeatureType2 == null) return true;
            return false;
        } else {
            if (!simpleFeatureType.equals(simpleFeatureType2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)new .colon.colon((Object)this.identifier(), (List)new .colon.colon(this.ds(), (List)new .colon.colon((Object)this.sft(), (List)new .colon.colon((Object)this.mode(), (List)Nil$.MODULE$)))).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    return (B1)BoxesRunTime.boxToInteger((int)A1.hashCode());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object != null;
            }
        })).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ void $anonfun$deleteTableNames$1(GeoMesaFeatureIndex $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            $this.ds().metadata().remove($this.sft().getTypeName(), k);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Seq nonEmpty$1(Seq bytes) {
        if (bytes.nonEmpty()) {
            return bytes;
        }
        return new .colon.colon((Object)((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$2(Filter x$3) {
        return x$3 instanceof ExcludeFilter;
    }

    private static final /* synthetic */ String filterString$lzycompute$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        String string;
        LazyRef lazyRef = filterString$lzy$1;
        synchronized (lazyRef) {
            string = filterString$lzy$1.initialized() ? (String)filterString$lzy$1.value() : (String)filterString$lzy$1.initialize((Object)org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter$1.filter().getOrElse((Function0 & Serializable)() -> Filter.INCLUDE)));
        }
        return string;
    }

    private static final String filterString$1(LazyRef filterString$lzy$1, package.FilterStrategy filter$1) {
        if (filterString$lzy$1.initialized()) {
            return (String)filterString$lzy$1.value();
        }
        return GeoMesaFeatureIndex.filterString$lzycompute$1(filterString$lzy$1, filter$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$7(package.ByteRange x$5) {
        return x$5 instanceof package.SingleRowByteRange;
    }

    private static final /* synthetic */ Seq tiers$lzycompute$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        Seq seq;
        LazyRef lazyRef = tiers$lzy$1;
        synchronized (lazyRef) {
            Seq seq2;
            if (tiers$lzy$1.initialized()) {
                seq2 = (Seq)tiers$lzy$1.value();
            } else {
                int multiplier = scala.math.package$.MODULE$.max(1, bytes$1.count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaFeatureIndex.$anonfun$getQueryStrategy$7(x$5))));
                seq2 = (Seq)tiers$lzy$1.initialize((Object)tier$1.getRangeBytes(tier$1.getRanges(tier$1.getIndexValues(secondary$1, explain$1), multiplier), tier$1.getRangeBytes$default$2()).toSeq());
            }
            seq = seq2;
        }
        return seq;
    }

    private static final Seq tiers$1(LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (tiers$lzy$1.initialized()) {
            return (Seq)tiers$lzy$1.value();
        }
        return GeoMesaFeatureIndex.tiers$lzycompute$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    public static final /* synthetic */ boolean $anonfun$getQueryStrategy$8(package.ByteRange x$6) {
        return x$6 instanceof package.UnboundedByteRange;
    }

    private static final /* synthetic */ byte[] minTier$lzycompute$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = minTier$lzy$1;
        synchronized (lazyRef) {
            byArray = minTier$lzy$1.initialized() ? (byte[])minTier$lzy$1.value() : (byte[])minTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.min((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] minTier$1(LazyRef minTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (minTier$lzy$1.initialized()) {
            return (byte[])minTier$lzy$1.value();
        }
        return GeoMesaFeatureIndex.minTier$lzycompute$1(minTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final /* synthetic */ byte[] maxTier$lzycompute$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        byte[] byArray;
        LazyRef lazyRef = maxTier$lzy$1;
        synchronized (lazyRef) {
            byArray = maxTier$lzy$1.initialized() ? (byte[])maxTier$lzy$1.value() : (byte[])maxTier$lzy$1.initialize((Object)package$ByteRange$.MODULE$.max((Seq<package.ByteRange>)GeoMesaFeatureIndex.tiers$1(tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1)));
        }
        return byArray;
    }

    private static final byte[] maxTier$1(LazyRef maxTier$lzy$1, LazyRef tiers$lzy$1, Seq bytes$1, IndexKeySpace tier$1, Filter secondary$1, Explainer explain$1) {
        if (maxTier$lzy$1.initialized()) {
            return (byte[])maxTier$lzy$1.value();
        }
        return GeoMesaFeatureIndex.maxTier$lzycompute$1(maxTier$lzy$1, tiers$lzy$1, bytes$1, tier$1, secondary$1, explain$1);
    }

    private static final String build$1(Seq attrs, String prefix$1, String suffix$1) {
        String string = prefix$1;
        return ((IterableOnceOps)((SeqOps)attrs.$plus$colon((Object)string)).$colon$plus((Object)suffix$1)).mkString("_");
    }

    public GeoMesaFeatureIndex(GeoMesaDataStore<?> ds, SimpleFeatureType sft, String name, int version, Seq<String> attributes2, IndexMode.IndexMode mode) {
        this.ds = ds;
        this.sft = sft;
        this.name = name;
        this.version = version;
        this.attributes = attributes2;
        this.mode = mode;
        LazyLogging.$init$((LazyLogging)this);
        this.tableNameKey = GeoMesaFeatureIndex$.MODULE$.baseTableNameKey(name, attributes2, version);
        this.identifier = GeoMesaFeatureIndex$.MODULE$.identifier(name, version, attributes2);
        this.serializedWithId = false;
    }

    public static interface IdFromRow {
        public String apply(byte[] var1, int var2, int var3, SimpleFeature var4);

        public int start(byte[] var1, int var2, int var3);
    }
}

