/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.api;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndexFactory$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata$;
import org.locationtech.geomesa.utils.cache.CacheKeyGenerator$;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006c\u0001!\tA\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019y\u0004\u0001)A\u0005y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u00028\u0001A\u0003%!\tC\u0004\u0002`\u0001!\t!!\u0019\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005m\u0006BB\b\u0001\t\u0003\t\t\u000eC\u0005\u0002l\u0002\t\n\u0011\"\u0001\u0002n\na\u0011J\u001c3fq6\u000bg.Y4fe*\u0011QBD\u0001\u0004CBL'BA\b\u0011\u0003\u0015Ig\u000eZ3y\u0015\t\t\"#A\u0004hK>lWm]1\u000b\u0005M!\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0002egB\u0012\u0001\u0005\u000b\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\rr\u0011\u0001C4f_R|w\u000e\\:\n\u0005\u0015\u0012#\u0001E$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f!\t9\u0003\u0006\u0004\u0001\u0005\u0013%\n\u0011\u0011!A\u0001\u0006\u0003Q#aA0%cE\u00111F\f\t\u000331J!!\f\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011dL\u0005\u0003ai\u00111!\u00118z\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011\u0001\u0004\u0005\u0006=\t\u0001\rA\u000e\u0019\u0003oe\u00022!\t\u00139!\t9\u0013\bB\u0005*k\u0005\u0005\t\u0011!B\u0001U\u00051Q\r\u001f9jef,\u0012\u0001\u0010\t\u00033uJ!A\u0010\u000e\u0003\t1{gnZ\u0001\bKb\u0004\u0018N]=!\u0003\u0015\u0019\u0017m\u00195f+\u0005\u0011\u0005\u0003B\"N\u001fjk\u0011\u0001\u0012\u0006\u0003\u0001\u0016S!AR$\u0002\u0011\r\fgMZ3j]\u0016T!\u0001S%\u0002\u0011\t,g.\\1oKNT!AS&\u0002\r\u001dLG\u000f[;c\u0015\u0005a\u0015aA2p[&\u0011a\n\u0012\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\t\u0003!^s!!U+\u0011\u0005ISR\"A*\u000b\u0005Q3\u0012A\u0002\u001fs_>$h(\u0003\u0002W5\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1&\u0004E\u0003\u001a7v\u000bY&\u0003\u0002]5\t1A+\u001e9mKJ\u00022AX2f\u001b\u0005y&B\u00011b\u0003%IW.\\;uC\ndWM\u0003\u0002c5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011|&aA*fcB\"aM[A,!\u0015!t-[A+\u0013\tAGBA\nHK>lUm]1GK\u0006$XO]3J]\u0012,\u0007\u0010\u0005\u0002(U\u0012I1\u000e\\A\u0001\u0002\u0003\u0015\tA\u000b\u0002\u0004?\u0012\u0012d\u0001B7\u0007\u0005=\u0014Q\u0001J1o_:\faaY1dQ\u0016\u00043c\u00017qqB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(AB(cU\u0016\u001cG\u000f\u0005\u0003Ds>[\u0018B\u0001>E\u0005-\u0019\u0015m\u00195f\u0019>\fG-\u001a:\u0011\u000beYF0!\u0003\u0011\tu\f)!\u001a\b\u0004}\u0006\u0005aB\u0001*\u0000\u0013\u0005Y\u0012bAA\u00025\u00059\u0001/Y2lC\u001e,\u0017b\u00013\u0002\b)\u0019\u00111\u0001\u000e\u0011\rA\u000bYaTA\b\u0013\r\ti!\u0017\u0002\u0004\u001b\u0006\u0004\bGBA\t\u0003+\tY\u0002\u0005\u00045O\u0006M\u0011\u0011\u0004\t\u0004O\u0005UAACA\fY\u0006\u0005\t\u0011!B\u0001U\t\u0019q\f\n\u001b\u0011\u0007\u001d\nY\u0002\u0002\u0006\u0002\u001e1\f\t\u0011!A\u0003\u0002)\u00121a\u0018\u00136\u0011\u0019\tD\u000e\"\u0001\u0002\"Q\u0011\u00111\u0005\t\u0003O1Dq!a\nm\t\u0003\nI#\u0001\u0003m_\u0006$G\u0003BA\u0016\u0003#\u0002b!G.\u0002.\u0005}\u0002#B?\u0002\u0006\u0005=\u0002GBA\u0019\u0003k\tY\u0004\u0005\u00045O\u0006M\u0012\u0011\b\t\u0004O\u0005UBaCA\u001c\u0003K\t\t\u0011!A\u0003\u0002)\u00121a\u0018\u00137!\r9\u00131\b\u0003\f\u0003{\t)#!A\u0001\u0002\u000b\u0005!FA\u0002`I]\u0002b\u0001UA\u0006\u001f\u0006\u0005\u0003GBA\"\u0003\u000f\ni\u0005\u0005\u00045O\u0006\u0015\u00131\n\t\u0004O\u0005\u001dCaCA%\u0003K\t\t\u0011!A\u0003\u0002)\u00121a\u0018\u00139!\r9\u0013Q\n\u0003\f\u0003\u001f\n)#!A\u0001\u0002\u000b\u0005!FA\u0002`IeBq!a\u0015\u0002&\u0001\u0007q*A\u0002lKf\u00042aJA,\t)\tI\u0006\\A\u0001\u0002\u0003\u0015\tA\u000b\u0002\u0004?\u0012\u001a\u0004C\u00020\u0002^=\u000by!C\u0002\u0002\u000e}\u000bq!\u001b8eS\u000e,7\u000f\u0006\u0004\u0002d\u0005U\u0014Q\u0012\t\u0006{\u0006\u0015\u0011Q\r\u0019\u0007\u0003O\nY'!\u001d\u0011\rQ:\u0017\u0011NA8!\r9\u00131\u000e\u0003\u000b\u0003[:\u0011\u0011!A\u0001\u0006\u0003Q#\u0001B0%cA\u00022aJA9\t)\t\u0019hBA\u0001\u0002\u0003\u0015\tA\u000b\u0002\u0005?\u0012\n\u0014\u0007C\u0004\u0002x\u001d\u0001\r!!\u001f\u0002\u0007M4G\u000f\u0005\u0003\u0002|\u0005%UBAA?\u0015\u0011\ty(!!\u0002\rMLW\u000e\u001d7f\u0015\u0011\t\u0019)!\"\u0002\u000f\u0019,\u0017\r^;sK*\u0019\u0011q\u0011\u000b\u0002\u000f=\u0004XM\\4jg&!\u00111RA?\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\n\u0003\u001f;\u0001\u0013!a\u0001\u0003#\u000bA!\\8eKB!\u00111SAZ\u001d\u0011\t)*!,\u000f\t\u0005]\u0015\u0011\u0016\b\u0005\u00033\u000b)K\u0004\u0003\u0002\u001c\u0006\rf\u0002BAO\u0003Cs1AUAP\u0013\u0005)\u0012BA\n\u0015\u0013\t\t\"#C\u0002\u0002(B\tQ!\u001e;jYNL1aDAV\u0015\r\t9\u000bE\u0005\u0005\u0003_\u000b\t,A\u0005J]\u0012,\u00070T8eK*\u0019q\"a+\n\t\u0005U\u0016q\u0017\u0002\n\u0013:$W\r_'pI\u0016TA!a,\u00022\u0006\t\u0012N\u001c3jG\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u&\u0006BAI\u0003\u007f[#!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017T\u0012AC1o]>$\u0018\r^5p]&!\u0011qZAc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u000b\u0007\u0003'\fI.a8\u0015\u0011\u0005U\u00171]As\u0003S\u0004b\u0001N4\u0002X\u0006u\u0007cA\u0014\u0002Z\u00121\u00111\\\u0005C\u0002)\u0012\u0011\u0001\u0016\t\u0004O\u0005}GABAq\u0013\t\u0007!FA\u0001V\u0011\u001d\t9(\u0003a\u0001\u0003sBa!a:\n\u0001\u0004y\u0015AC5eK:$\u0018NZ5fe\"I\u0011qR\u0005\u0011\u0002\u0003\u0007\u0011\u0011S\u0001\u0010S:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%gU1\u00111XAx\u0003c$a!a7\u000b\u0005\u0004QCABAq\u0015\t\u0007!\u0006")
public class IndexManager {
    public final GeoMesaDataStore<?> org$locationtech$geomesa$index$api$IndexManager$$ds;
    private final long expiry;
    private final LoadingCache<String, Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>>> cache;

    private long expiry() {
        return this.expiry;
    }

    private LoadingCache<String, Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>>> cache() {
        return this.cache;
    }

    public Seq<GeoMesaFeatureIndex<?, ?>> indices(SimpleFeatureType sft, IndexMode.IndexMode mode) {
        Seq seq;
        try {
            seq = (Seq)((IterableOps)((Tuple2)this.cache().get((Object)CacheKeyGenerator$.MODULE$.cacheKey(sft)))._1()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IndexManager.$anonfun$indices$1(mode, x$1)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(43).append("Invalid indices for simple feature type '").append(sft.getTypeName()).append("':").toString(), e);
            }
            throw throwable;
        }
        return seq;
    }

    public IndexMode.IndexMode indices$default$2() {
        return IndexMode$.MODULE$.Any();
    }

    public <T, U> GeoMesaFeatureIndex<T, U> index(SimpleFeatureType sft, String identifier, IndexMode.IndexMode mode) {
        GeoMesaFeatureIndex idx = (GeoMesaFeatureIndex)((MapOps)((Tuple2)this.cache().get((Object)CacheKeyGenerator$.MODULE$.cacheKey(sft)))._2()).getOrElse((Object)identifier, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(34).append("No index exists with identifier '").append(identifier).append("'").toString());
        });
        if (idx.mode().supports(mode)) {
            return idx;
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Index '").append(identifier).append("' does not support mode ").append(mode).toString());
    }

    public <T, U> IndexMode.IndexMode index$default$3() {
        return IndexMode$.MODULE$.Any();
    }

    public static final /* synthetic */ boolean $anonfun$indices$1(IndexMode.IndexMode mode$1, GeoMesaFeatureIndex x$1) {
        return x$1.mode().supports(mode$1);
    }

    public IndexManager(GeoMesaDataStore<?> ds) {
        this.org$locationtech$geomesa$index$api$IndexManager$$ds = ds;
        this.expiry = ((Duration)TableBasedMetadata$.MODULE$.Expiry().toDuration().get()).toMillis();
        this.cache = Caffeine.newBuilder().expireAfterWrite(this.expiry(), TimeUnit.MILLISECONDS).build(new CacheLoader<String, Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>>>(this){
            private final /* synthetic */ IndexManager $outer;

            public java.util.Map<String, Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>>> loadAll(Iterable<? extends String> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<java.util.Map<String, Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>>>> asyncLoadAll(Iterable<? extends String> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<Seq<GeoMesaFeatureIndex<?, ?>>, Map<String, GeoMesaFeatureIndex<?, ?>>> load(String key) {
                SimpleFeatureType sft = CacheKeyGenerator$.MODULE$.restore(key);
                Seq<GeoMesaFeatureIndex<?, ?>> indices = GeoMesaFeatureIndexFactory$.MODULE$.create(this.$outer.org$locationtech$geomesa$index$api$IndexManager$$ds, sft, (Seq<IndexId>)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
                return new Tuple2(indices, (Object)((IterableOnceOps)indices.map((Function1 & Serializable)i -> new Tuple2((Object)i.identifier(), i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(org.locationtech.geomesa.index.api.GeoMesaFeatureIndex )}, serializedLambda);
            }
        });
    }
}

