/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.conf.partition;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartitionFactory;
import org.locationtech.geomesa.index.conf.partition.TimePartition$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u0017/\u0001mB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\f\u0001B\u0001B\u0003%A\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\"B8\u0001\t\u0003\u0001\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003z\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0005\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA\u000b\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#Aaa\f\u0001\u0005B\tu\u0001bBAd\u0001\u0011\u0005#q\u0005\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f:q!!\n/\u0011\u0003\t9C\u0002\u0004.]!\u0005\u0011\u0011\u0006\u0005\u0007_N!\t!a\u000b\t\u0013\u000552C1A\u0005\u0002\u0005=\u0002\u0002CA '\u0001\u0006I!!\r\t\u0013\u0005\u00053C1A\u0005\n\u0005=\u0002\u0002CA\"'\u0001\u0006I!!\r\t\u0013\u0005E1C1A\u0005\n\u0005\u0015\u0003\u0002CA4'\u0001\u0006I!a\u0012\u0007\r\u0005%4\u0003AA6\u0011\u0019y7\u0004\"\u0001\u0002t!9\u0011\u0011P\u000e\u0005B\u0005m\u0004bBA?7\u0011\u0005\u0013q\u0010\u0004\u0007\u0003_\u001bB!!-\t\u0011\u0019{\"\u0011!Q\u0001\n\u001dC\u0001bV\u0010\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0007_~!\t!a-\t\u0013\u0005mvD1A\u0005\n\u0005u\u0006\u0002CAc?\u0001\u0006I!a0\t\u0017\u0005\u001dw\u00041AA\u0002\u0013%\u0011\u0011\u001a\u0005\f\u0003[|\u0002\u0019!a\u0001\n\u0013\ty\u000fC\u0006\u0002|~\u0001\r\u0011!Q!\n\u0005-\u0007\"CA\u007f?\u0001\u0007I\u0011BA_\u0011%\typ\ba\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\u0006}\u0001\u000b\u0015BA`\u0011\u001d\u00119a\bC\u0001\u0005\u0013AqAa\u0003 \t\u0003\u0011iAA\u0007US6,\u0007+\u0019:uSRLwN\u001c\u0006\u0003_A\n\u0011\u0002]1si&$\u0018n\u001c8\u000b\u0005E\u0012\u0014\u0001B2p]\u001aT!a\r\u001b\u0002\u000b%tG-\u001a=\u000b\u0005U2\u0014aB4f_6,7/\u0019\u0006\u0003oa\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011!O\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\t6\ta&\u0003\u0002F]\tqA+\u00192mKB\u000b'\u000f^5uS>t\u0017\u0001C7fi\u0006$\u0017\r^1\u0011\u0007!SE*D\u0001J\u0015\t1%'\u0003\u0002L\u0013\nyq)Z8NKN\fW*\u001a;bI\u0006$\u0018\r\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fzj\u0011\u0001\u0015\u0006\u0003#j\na\u0001\u0010:p_Rt\u0014BA*?\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ms\u0014\u0001\u0003;za\u0016t\u0015-\\3\u0002\u0007\u0011$x-\u0001\u0005ei\u001eLe\u000eZ3y!\ti4,\u0003\u0002]}\t\u0019\u0011J\u001c;\u0002\rA,'/[8e!\tyFN\u0004\u0002aS:\u0011\u0011m\u001a\b\u0003E\u001at!aY3\u000f\u0005=#\u0017\"A\u001d\n\u0005]B\u0014BA\u001b7\u0013\tAG'A\u0003dkJ4X-\u0003\u0002kW\u0006QA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005!$\u0014BA7o\u0005)!\u0016.\\3QKJLw\u000e\u001a\u0006\u0003U.\fa\u0001P5oSRtDCB9sgR,h\u000f\u0005\u0002D\u0001!)aI\u0002a\u0001\u000f\")qK\u0002a\u0001\u0019\")\u0001L\u0002a\u0001\u0019\")\u0011L\u0002a\u00015\")QL\u0002a\u0001=\u0006)Ao\u001c\"j]V\t\u0011\u0010\u0005\u0002{}:\u00111\u0010`\u0007\u0002W&\u0011Qp[\u0001\u000b\u0005&tg.\u001a3US6,\u0017bA@\u0002\u0002\tIA)\u0019;f)>\u0014\u0015N\u001c\u0006\u0003{.\fa\u0001^8CS:\u0004\u0013A\u0002;p\t\u0006$X-\u0006\u0002\u0002\nA\u0019!0a\u0003\n\t\u00055\u0011\u0011\u0001\u0002\u0011\u0005&tg.\u001a3US6,Gk\u001c#bi\u0016\fq\u0001^8ECR,\u0007%A\u0003dC\u000eDW-\u0006\u0002\u0002\u0016A\u0019\u0011qC\u0010\u000f\u0007\u0005e!C\u0004\u0003\u0002\u001c\u0005\rb\u0002BA\u000f\u0003Cq1!YA\u0010\u0013\t\u0019D'\u0003\u00022e%\u0011q\u0006M\u0001\u000e)&lW\rU1si&$\u0018n\u001c8\u0011\u0005\r\u001b2CA\n=)\t\t9#\u0001\u0003OC6,WCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u00111H\u0001\u0005U\u00064\u0018-C\u0002V\u0003k\tQAT1nK\u0002\n!\u0003U1si&$\u0018n\u001c8LKf\u0004&/\u001a4jq\u0006\u0019\u0002+\u0019:uSRLwN\\&fsB\u0013XMZ5yAU\u0011\u0011q\t\t\b\u0003\u0013\ni&!\u0019C\u001b\t\tYE\u0003\u0003\u0002\u0012\u00055#\u0002BA(\u0003#\n\u0001bY1gM\u0016Lg.\u001a\u0006\u0005\u0003'\n)&\u0001\u0005cK:l\u0017M\\3t\u0015\u0011\t9&!\u0017\u0002\r\u001dLG\u000f[;c\u0015\t\tY&A\u0002d_6LA!a\u0018\u0002L\taAj\\1eS:<7)Y2iKBAQ(a\u0019H\u00192Sf,C\u0002\u0002fy\u0012a\u0001V;qY\u0016,\u0014AB2bG\",\u0007E\u0001\u000bUS6,\u0007+\u0019:uSRLwN\u001c$bGR|'/_\n\u00057q\ni\u0007E\u0002D\u0003_J1!!\u001d/\u0005U!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:4\u0015m\u0019;pef$\"!!\u001e\u0011\u0007\u0005]4$D\u0001\u0014\u0003\u0011q\u0017-\\3\u0016\u00031\u000baa\u0019:fCR,G#\u0002\"\u0002\u0002\u0006]\u0005bBAB=\u0001\u0007\u0011QQ\u0001\u0003IN\u0004R!a\"\u0002\u00122sA!!#\u0002\u000e:!\u0011QDAF\u0013\t1%'C\u0002\u0002\u0010&\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0006U%A\u0005%bg\u001e+w.T3tC6+G/\u00193bi\u0006T1!a$J\u0011\u001d\tIJ\ba\u0001\u00037\u000b1a\u001d4u!\u0011\ti*a+\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000baa]5na2,'\u0002BAS\u0003O\u000bqAZ3biV\u0014XMC\u0002\u0002*b\nqa\u001c9f]\u001eL7/\u0003\u0003\u0002.\u0006}%!E*j[BdWMR3biV\u0014X\rV=qK\n!2)^:u_6\u0004\u0016M\u001d;ji&|gnQ1dQ\u0016\u001c\"a\b\u001f\u0015\r\u0005U\u0016qWA]!\r\t9h\b\u0005\u0006\r\n\u0002\ra\u0012\u0005\u0006/\n\u0002\r\u0001T\u0001\u0007Kb\u0004\u0018N]=\u0016\u0005\u0005}\u0006cA\u001f\u0002B&\u0019\u00111\u0019 \u0003\t1{gnZ\u0001\bKb\u0004\u0018N]=!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003\u0017\u0004b!!4\u0002V\u0006mg\u0002BAh\u0003't1aTAi\u0013\u0005y\u0014bAAH}%!\u0011q[Am\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001fs\u0004\u0003C\u001f\u0002^2\u000b\t/!9\n\u0007\u0005}gH\u0001\u0004UkBdWm\r\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]A\u001d\u0003\u0011!\u0018.\\3\n\t\u0005-\u0018Q\u001d\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u001dA\f'\u000f^5uS>t7o\u0018\u0013fcR!\u0011\u0011_A|!\ri\u00141_\u0005\u0004\u0003kt$\u0001B+oSRD\u0011\"!?'\u0003\u0003\u0005\r!a3\u0002\u0007a$\u0013'A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013A\u0002:fY>\fG-\u0001\u0006sK2|\u0017\rZ0%KF$B!!=\u0003\u0004!I\u0011\u0011`\u0015\u0002\u0002\u0003\u0007\u0011qX\u0001\be\u0016dw.\u00193!\u0003A\u0019Wo\u001d;p[B\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002L\u0006Q\u0011N\u001c<bY&$\u0017\r^3\u0015\u0005\u0005E\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0011\u0005E(1\u0003B\u000b\u00053AQaL\u0007A\u00021CqAa\u0006\u000e\u0001\u0004\t\t/A\u0003ti\u0006\u0014H\u000fC\u0004\u0003\u001c5\u0001\r!!9\u0002\u0007\u0015tG\rF\u0002M\u0005?Aq!!*\u000f\u0001\u0004\u0011\t\u0003\u0005\u0003\u0002\u001e\n\r\u0012\u0002\u0002B\u0013\u0003?\u0013QbU5na2,g)Z1ukJ,G\u0003\u0002B\u0015\u0005c\u0001R!\u0010B\u0016\u0005_I1A!\f?\u0005\u0019y\u0005\u000f^5p]B)\u0011QZAk\u0019\"9!1G\bA\u0002\tU\u0012A\u00024jYR,'\u000f\u0005\u0003\u00038\tmRB\u0001B\u001d\u0015\u0011\u0011\u0019$a*\n\t\tu\"\u0011\b\u0002\u0007\r&dG/\u001a:\u0002\u000fI,7m\u001c<feR\u0019AHa\u0011\t\u000b=\u0002\u0002\u0019\u0001'\u0002\u0011=4XM\u001d7baN$\u0002B!\u0013\u0003P\t\r$Q\r\t\u0004{\t-\u0013b\u0001B'}\t9!i\\8mK\u0006t\u0007b\u0002B)#\u0001\u0007!1K\u0001\nS:$XM\u001d<bYN\u0004bA!\u0016\u0003Z\tuSB\u0001B,\u0015\r\u0011\u0019\u0004N\u0005\u0005\u00057\u00129F\u0001\u0007GS2$XM\u001d,bYV,7\u000f\u0005\u0004\u0003V\t}\u0013\u0011]\u0005\u0005\u0005C\u00129F\u0001\u0004C_VtGm\u001d\u0005\b\u0005/\t\u0002\u0019AAq\u0011\u001d\u0011Y\"\u0005a\u0001\u0003C\u0004")
public class TimePartition
implements TablePartition {
    private final GeoMesaMetadata<String> metadata;
    private final String typeName;
    private final String dtg;
    private final int dtgIndex;
    private final Function1<ZonedDateTime, Object> toBin;
    private final Function1<BinnedTime, ZonedDateTime> toDate;
    private final CustomPartitionCache cache;

    public static String Name() {
        return TimePartition$.MODULE$.Name();
    }

    private Function1<ZonedDateTime, Object> toBin() {
        return this.toBin;
    }

    private Function1<BinnedTime, ZonedDateTime> toDate() {
        return this.toDate;
    }

    private CustomPartitionCache cache() {
        return this.cache;
    }

    public void register(String partition, ZonedDateTime start, ZonedDateTime end) {
        String dates = new StringBuilder(1).append(DateParsing$.MODULE$.format(start, DateParsing$.MODULE$.format$default$2())).append("/").append(DateParsing$.MODULE$.format(end, DateParsing$.MODULE$.format$default$2())).toString();
        this.metadata.insert(this.typeName, new StringBuilder(0).append(TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix()).append(partition).toString(), dates);
        this.cache().invalidate();
    }

    @Override
    public String partition(SimpleFeature feature) {
        Date date = (Date)feature.getAttribute(this.dtgIndex);
        return StringOps$.MODULE$.format$extension("%05d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.toBin().apply((Object)ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(date), ZoneOffset.UTC))}));
    }

    @Override
    public Option<Seq<String>> partitions(Filter filter) {
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(filter, this.dtg, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
        if (intervals.disjoint()) {
            return new Some((Object)package$.MODULE$.Seq().empty());
        }
        if (intervals.isEmpty() || !intervals.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isBoundedBothSides()))) {
            return None$.MODULE$;
        }
        Seq bins = (Seq)intervals.values().flatMap((Function1 & Serializable)i -> package$.MODULE$.Range().inclusive((int)BoxesRunTime.unboxToShort((Object)this.toBin().apply(i.lower().value().get())), (int)BoxesRunTime.unboxToShort((Object)this.toBin().apply(i.upper().value().get()))));
        Seq names = (Seq)((IterableOps)((IterableOps)bins.distinct()).map((Function1 & Serializable)b -> StringOps$.MODULE$.format$extension("%05d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)b))})))).$plus$plus((IterableOnce)this.cache().customPartitions().collect((PartialFunction)new Serializable(this, intervals){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TimePartition $outer;
            private final FilterValues intervals$1;

            public final <A1 extends Tuple3<String, ZonedDateTime, ZonedDateTime>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    ZonedDateTime end;
                    String p = (String)A1._1();
                    ZonedDateTime start = (ZonedDateTime)A1._2();
                    if (this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start, end = (ZonedDateTime)A1._3())) {
                        return (B1)p;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple3<String, ZonedDateTime, ZonedDateTime> x1) {
                ZonedDateTime end;
                ZonedDateTime start;
                Tuple3<String, ZonedDateTime, ZonedDateTime> tuple3 = x1;
                return tuple3 != null && this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start = (ZonedDateTime)tuple3._2(), end = (ZonedDateTime)tuple3._3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.intervals$1 = intervals$1;
            }
        }));
        return new Some((Object)names);
    }

    @Override
    public Object recover(String partition) {
        return new Date(((ChronoZonedDateTime)this.toDate().apply((Object)new BinnedTime(StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(partition)), 0L))).toInstant().toEpochMilli());
    }

    public boolean org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps(FilterValues<Bounds<ZonedDateTime>> intervals, ZonedDateTime start, ZonedDateTime end) {
        return intervals.exists((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)TimePartition.$anonfun$overlaps$1(end, start, i)));
    }

    public static final /* synthetic */ boolean $anonfun$overlaps$1(ZonedDateTime end$1, ZonedDateTime start$1, Bounds i) {
        return i.lower().value().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isBefore(end$1))) && i.upper().value().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isAfter(start$1)));
    }

    public TimePartition(GeoMesaMetadata<String> metadata, String typeName, String dtg, int dtgIndex, Enumeration.Value period) {
        this.metadata = metadata;
        this.typeName = typeName;
        this.dtg = dtg;
        this.dtgIndex = dtgIndex;
        this.toBin = BinnedTime$.MODULE$.dateToBin(period);
        this.toDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.cache = new CustomPartitionCache(metadata, typeName);
    }

    private static class CustomPartitionCache {
        private final GeoMesaMetadata<String> metadata;
        private final String typeName;
        private final long expiry;
        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions;
        private long reload;

        private long expiry() {
            return this.expiry;
        }

        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions() {
            return this.partitions;
        }

        private void partitions_$eq(Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> x$1) {
            this.partitions = x$1;
        }

        private long reload() {
            return this.reload;
        }

        private void reload_$eq(long x$1) {
            this.reload = x$1;
        }

        public Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> customPartitions() {
            if (System.currentTimeMillis() < this.reload()) {
                return this.partitions();
            }
            this.reload_$eq(System.currentTimeMillis() + this.expiry());
            this.partitions_$eq((Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>>)((Seq)this.metadata.scan(this.typeName, TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix(), this.metadata.scan$default$3()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object object;
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ZonedDateTime[] zonedDateTimeArray = (ZonedDateTime[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])v.split("/")), (Function1 & Serializable)x$5 -> DateParsing$.MODULE$.parse(x$5, DateParsing$.MODULE$.parse$default$2()), ClassTag$.MODULE$.apply(ZonedDateTime.class));
                    if (zonedDateTimeArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)zonedDateTimeArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                        throw new MatchError((Object)zonedDateTimeArray);
                    }
                    ZonedDateTime start = (ZonedDateTime)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    ZonedDateTime end = (ZonedDateTime)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
                    ZonedDateTime start2 = (ZonedDateTime)tuple22._1();
                    ZonedDateTime end2 = (ZonedDateTime)tuple22._2();
                    return new Tuple3((Object)k.substring(TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix().length()), (Object)start2, (Object)end2);
                }
                throw new MatchError((Object)tuple2);
            })));
            return this.partitions();
        }

        public void invalidate() {
            this.reload_$eq(0L);
        }

        public CustomPartitionCache(GeoMesaMetadata<String> metadata, String typeName) {
            this.metadata = metadata;
            this.typeName = typeName;
            this.expiry = ((Duration)TableBasedMetadata$.MODULE$.Expiry().toDuration().get()).toMillis();
            this.reload = 0L;
        }
    }

    public static class TimePartitionFactory
    implements TablePartitionFactory {
        @Override
        public String name() {
            return TimePartition$.MODULE$.Name();
        }

        @Override
        public TablePartition create(package.HasGeoMesaMetadata<String> ds, SimpleFeatureType sft) {
            String dtg = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Can't use time partitioning without a date field");
            });
            return (TablePartition)TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$cache().get((Object)new Tuple5(ds.metadata(), (Object)sft.getTypeName(), (Object)dtg, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).get(), (Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
        }
    }
}

