/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.util.Date;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.filters.AgeOffFilter$;
import org.locationtech.geomesa.index.filters.DtgAgeOffFilter$Configuration$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DtgAgeOffFilter$ {
    public static final DtgAgeOffFilter$ MODULE$ = new DtgAgeOffFilter$();

    public Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Duration expiry, Option<String> dtgField) {
        int n;
        Predef$.MODULE$.require(!RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) || new GeoMesaSystemProperties.SystemProperty("geomesa.age-off.override", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$4)))), (Function0 & Serializable)() -> "DtgAgeOff filter should only be applied to features that don't use table sharing. You may override this checkby setting the system property 'geomesa.age-off.override=true', however please note that age-offwill affect all shared feature types in the same catalog, and may not work correctly with multiple featuretypes");
        Option<String> option = dtgField;
        if (None$.MODULE$.equals(option)) {
            n = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Simple feature type does not have a valid date field");
            }));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String dtg = (String)some.value();
            int i = sft.indexOf(dtg);
            if (i == -1 || !Date.class.isAssignableFrom(sft.getDescriptor(i).getType().getBinding())) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Simple feature type does not have a valid date field '").append(dtg).append("'").toString());
            }
            n = i;
        } else {
            throw new MatchError(option);
        }
        int dtgIndex = n;
        Option indexSftOpt = new Some((Object)index.sft()).collect((PartialFunction)new Serializable(sft){
            private static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final <A1 extends SimpleFeatureType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = A1 = x1;
                SimpleFeatureType simpleFeatureType = this.sft$1;
                if (A12 == null ? simpleFeatureType != null : !A12.equals(simpleFeatureType)) {
                    return (B1)SimpleFeatureTypes$.MODULE$.encodeType(A1, true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SimpleFeatureType x1) {
                SimpleFeatureType simpleFeatureType;
                SimpleFeatureType simpleFeatureType2 = simpleFeatureType = x1;
                SimpleFeatureType simpleFeatureType3 = this.sft$1;
                return simpleFeatureType2 == null ? simpleFeatureType3 != null : !simpleFeatureType2.equals(simpleFeatureType3);
            }
            {
                this.sft$1 = sft$1;
            }
        });
        return (Map)((MapOps)AgeOffFilter$.MODULE$.configure(sft, expiry).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DtgAgeOffFilter$Configuration$.MODULE$.SftOpt()), (Object)SimpleFeatureTypes$.MODULE$.encodeType(sft)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DtgAgeOffFilter$Configuration$.MODULE$.IndexOpt()), (Object)index.identifier()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DtgAgeOffFilter$Configuration$.MODULE$.DtgOpt()), (Object)Integer.toString(dtgIndex))})))).$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DtgAgeOffFilter$Configuration$.MODULE$.IndexSftOpt()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)indexSftOpt))})));
    }

    private DtgAgeOffFilter$() {
    }
}

