/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S2Filter;
import org.locationtech.geomesa.index.index.s2.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class S2Filter$
implements RowFilter.RowFilterFactory<S2Filter> {
    public static final S2Filter$ MODULE$ = new S2Filter$();
    private static final String RangeSeparator = ":";
    private static final String TermSeparator = ";";
    private static final String XYKey = "sxy";

    private String RangeSeparator() {
        return RangeSeparator;
    }

    private String TermSeparator() {
        return TermSeparator;
    }

    public String XYKey() {
        return XYKey;
    }

    public S2Filter apply(package.S2IndexValues values) {
        Seq xy = (Seq)values.spatialBounds().map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new double[]{xmin, ymin, xmax, ymax};
            }
            throw new MatchError((Object)tuple4);
        });
        return new S2Filter((double[][])xy.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    @Override
    public byte[] serializeToBytes(S2Filter filter) {
        int xyLength = 4 + filter.xy().length * 32;
        ByteBuffer buffer = ByteBuffer.allocate(xyLength);
        buffer.putInt(filter.xy().length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(bounds), (Function1 & Serializable)x$1 -> buffer$1.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
            return BoxedUnit.UNIT;
        });
        return buffer.array();
    }

    @Override
    public S2Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        double[][] xy = (double[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable)() -> (double[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcD.sp & Serializable)() -> buffer.getDouble(), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return new S2Filter(xy);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(S2Filter filter) {
        String xy = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> Predef$.MODULE$.wrapDoubleArray(bounds).mkString(MODULE$.RangeSeparator()), ClassTag$.MODULE$.apply(String.class))).mkString(this.TermSeparator());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy)}));
    }

    @Override
    public S2Filter deserializeFromStrings(Map<String, String> serialized) {
        double[][] xy = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.TermSeparator())), (Function1 & Serializable)x$1 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$1.split(MODULE$.RangeSeparator())), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$2))), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return new S2Filter(xy);
    }

    private S2Filter$() {
    }
}

