/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S2Filter$;
import org.locationtech.geomesa.index.index.s2.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\n\u0015\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005Y!)A\u0007\u0001C\u0001k!)\u0001\b\u0001C!s\u001d)\u0001\n\u0006E\u0001\u0013\u001a)1\u0003\u0006E\u0001\u0015\")AG\u0002C\u0001?\"9\u0001M\u0002b\u0001\n\u0013\t\u0007B\u00026\u0007A\u0003%!\rC\u0004l\r\t\u0007I\u0011B1\t\r14\u0001\u0015!\u0003c\u0011\u001digA1A\u0005\u0002\u0005DaA\u001c\u0004!\u0002\u0013\u0011\u0007\"B8\u0007\t\u0003\u0001\bbBA\u0002\r\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u00171A\u0011IA\u0007\u0011\u001d\t\u0019B\u0002C!\u0003+Aq!!\f\u0007\t\u0003\nyC\u0001\u0005Te\u0019KG\u000e^3s\u0015\t)b#A\u0004gS2$XM]:\u000b\u0005]A\u0012!B5oI\u0016D(BA\r\u001b\u0003\u001d9Wm\\7fg\u0006T!a\u0007\u000f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005K\u0007\u0002)%\u0011\u0011\u0006\u0006\u0002\n%><h)\u001b7uKJ\f!\u0001_=\u0016\u00031\u00022!I\u00170\u0013\tq#EA\u0003BeJ\f\u0017\u0010E\u0002\"[A\u0002\"!I\u0019\n\u0005I\u0012#A\u0002#pk\ndW-A\u0002ys\u0002\na\u0001P5oSRtDC\u0001\u001c8!\t9\u0003\u0001C\u0003+\u0007\u0001\u0007A&\u0001\u0005j]\n{WO\u001c3t)\rQTh\u0011\t\u0003CmJ!\u0001\u0010\u0012\u0003\u000f\t{w\u000e\\3b]\")a\b\u0002a\u0001\u007f\u0005\u0019!-\u001e4\u0011\u0007\u0005j\u0003\t\u0005\u0002\"\u0003&\u0011!I\t\u0002\u0005\u0005f$X\rC\u0003E\t\u0001\u0007Q)\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003C\u0019K!a\u0012\u0012\u0003\u0007%sG/\u0001\u0005Te\u0019KG\u000e^3s!\t9caE\u0002\u0007A-\u00032\u0001\u0014/7\u001d\ti%L\u0004\u0002O3:\u0011q\n\u0017\b\u0003!^s!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Qs\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003+YI!a\u0017\u000b\u0002\u0013I{wOR5mi\u0016\u0014\u0018BA/_\u0005A\u0011vn\u001e$jYR,'OR1di>\u0014\u0018P\u0003\u0002\\)Q\t\u0011*\u0001\bSC:<WmU3qCJ\fGo\u001c:\u0016\u0003\t\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\t1\fgn\u001a\u0006\u0002O\u0006!!.\u0019<b\u0013\tIGM\u0001\u0004TiJLgnZ\u0001\u0010%\u0006tw-Z*fa\u0006\u0014\u0018\r^8sA\u0005iA+\u001a:n'\u0016\u0004\u0018M]1u_J\fa\u0002V3s[N+\u0007/\u0019:bi>\u0014\b%A\u0003Y3.+\u00170\u0001\u0004Y3.+\u0017\u0010I\u0001\u0006CB\u0004H.\u001f\u000b\u0003mEDQA\u001d\bA\u0002M\faA^1mk\u0016\u001c\bC\u0001;\u007f\u001d\t)8P\u0004\u0002wq:\u0011aj^\u0005\u0003/YI!!\u001f>\u0002\u0005M\u0014$BA\f\u0017\u0013\taX0A\u0004qC\u000e\\\u0017mZ3\u000b\u0005eT\u0018bA@\u0002\u0002\ti1KM%oI\u0016Dh+\u00197vKNT!\u0001`?\u0002!M,'/[1mSj,Gk\u001c\"zi\u0016\u001cHcA \u0002\b!1\u0011\u0011B\bA\u0002Y\naAZ5mi\u0016\u0014\u0018\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u00164%o\\7CsR,7\u000fF\u00027\u0003\u001fAa!!\u0005\u0011\u0001\u0004y\u0014AC:fe&\fG.\u001b>fI\u0006\u00112/\u001a:jC2L'0\u001a+p'R\u0014\u0018N\\4t)\u0011\t9\"a\u000b\u0011\u0011\u0005e\u0011\u0011EA\u0014\u0003OqA!a\u0007\u0002\u001eA\u0011!KI\u0005\u0004\u0003?\u0011\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0015\"aA'ba*\u0019\u0011q\u0004\u0012\u0011\t\u0005e\u0011\u0011F\u0005\u0004S\u0006\u0015\u0002BBA\u0005#\u0001\u0007a'\u0001\feKN,'/[1mSj,gI]8n'R\u0014\u0018N\\4t)\r1\u0014\u0011\u0007\u0005\b\u0003#\u0011\u0002\u0019AA\u001a!!\t)$a\u000f\u0002(\u0005\u001dRBAA\u001c\u0015\r\tIDI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u0003o\u0001")
public class S2Filter
implements RowFilter {
    private final double[][] xy;

    public static S2Filter deserializeFromStrings(Map<String, String> serialized) {
        return S2Filter$.MODULE$.deserializeFromStrings((Map)serialized);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(S2Filter filter) {
        return S2Filter$.MODULE$.serializeToStrings(filter);
    }

    public static S2Filter deserializeFromBytes(byte[] serialized) {
        return S2Filter$.MODULE$.deserializeFromBytes(serialized);
    }

    public static byte[] serializeToBytes(S2Filter filter) {
        return S2Filter$.MODULE$.serializeToBytes(filter);
    }

    public static S2Filter apply(package.S2IndexValues values) {
        return S2Filter$.MODULE$.apply(values);
    }

    public static String XYKey() {
        return S2Filter$.MODULE$.XYKey();
    }

    public double[][] xy() {
        return this.xy;
    }

    @Override
    public boolean inBounds(byte[] buf, int offset) {
        S2LatLng latLon = new S2CellId(ByteArrays$.MODULE$.readLong(buf, offset)).toLatLng();
        double x = latLon.lngDegrees();
        double y = latLon.latDegrees();
        for (int i = 0; i < this.xy().length; ++i) {
            double[] xyi = this.xy()[i];
            if (!(x >= xyi[0]) || !(x <= xyi[2]) || !(y >= xyi[1]) || !(y <= xyi[3])) continue;
            return true;
        }
        return false;
    }

    public S2Filter(double[][] xy) {
        this.xy = xy;
    }
}

