/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S3Filter;
import org.locationtech.geomesa.index.index.s3.package;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.ShortRef;
import scala.runtime.java8.JFunction0;

public final class S3Filter$
implements RowFilter.RowFilterFactory<S3Filter> {
    public static final S3Filter$ MODULE$ = new S3Filter$();
    private static final String RangeSeparator = ":";
    private static final String TermSeparator = ";";
    private static final String EpochSeparator = ",";
    private static final String XYKey = "sxy";
    private static final String TKey = "st";
    private static final String EpochKey = "epoch";

    private String RangeSeparator() {
        return RangeSeparator;
    }

    private String TermSeparator() {
        return TermSeparator;
    }

    private String EpochSeparator() {
        return EpochSeparator;
    }

    public String XYKey() {
        return XYKey;
    }

    public String TKey() {
        return TKey;
    }

    public String EpochKey() {
        return EpochKey;
    }

    public S3Filter apply(package.S3IndexValues values) {
        package.S3IndexValues s3IndexValues = values;
        if (s3IndexValues == null) {
            throw new MatchError((Object)s3IndexValues);
        }
        int maxTime = s3IndexValues.maxTime();
        Seq<Tuple4<Object, Object, Object, Object>> spatialBounds = s3IndexValues.spatialBounds();
        scala.collection.immutable.Map<Object, Seq<Tuple2<Object, Object>>> temporalBounds = s3IndexValues.temporalBounds();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxTime), spatialBounds, temporalBounds);
        int maxTime2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Seq spatialBounds2 = (Seq)tuple3._2();
        scala.collection.immutable.Map temporalBounds2 = (scala.collection.immutable.Map)tuple3._3();
        double[][] xy = (double[][])((IterableOnceOps)spatialBounds2.map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new double[]{xmin, ymin, xmax, ymax};
            }
            throw new MatchError((Object)tuple4);
        })).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        .colon.colon wholePeriod = new .colon.colon((Object)new Tuple2.mcJI.sp(0L, maxTime2), (List)Nil$.MODULE$);
        ShortRef minEpoch = ShortRef.create((short)Short.MAX_VALUE);
        ShortRef maxEpoch = ShortRef.create((short)Short.MIN_VALUE);
        Seq epochsAndTimes = (Seq)((IterableOps)((SeqOps)temporalBounds2.toSeq().filter(arg_0 -> S3Filter$.$anonfun$apply$2$adapted((Seq)wholePeriod, arg_0))).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToShort((short)S3Filter$.$anonfun$apply$3(x$4)), (Ordering)Ordering.Short$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short epoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq times = (Seq)tuple2._2();
                if (epoch < minEpoch$1.elem) {
                    minEpoch$1.elem = epoch;
                }
                if (epoch > maxEpoch$1.elem) {
                    maxEpoch$1.elem = epoch;
                }
                return new Tuple2((Object)BoxesRunTime.boxToShort((short)epoch), ((IterableOnceOps)times.map((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        int t1 = tuple2._1$mcI$sp();
                        int t2 = tuple2._2$mcI$sp();
                        return new int[]{t1, t2};
                    }
                    throw new MatchError((Object)tuple2);
                })).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            }
            throw new MatchError((Object)tuple2);
        });
        int[][][] t = minEpoch.elem == Short.MAX_VALUE && maxEpoch.elem == Short.MIN_VALUE ? (int[][][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))) : (int[][][])Array$.MODULE$.ofDim(maxEpoch.elem - minEpoch.elem + 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        epochsAndTimes.foreach((Function1 & Serializable)x0$4 -> {
            S3Filter$.$anonfun$apply$6(t, minEpoch, x0$4);
            return BoxedUnit.UNIT;
        });
        return new S3Filter(xy, t, minEpoch.elem, maxEpoch.elem);
    }

    @Override
    public byte[] serializeToBytes(S3Filter filter) {
        int xyLength = 4 + filter.xy().length * 32;
        int tLength = 4 + BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filter.t()), (Function1 & Serializable)bounds -> BoxesRunTime.boxToInteger((int)S3Filter$.$anonfun$serializeToBytes$1(bounds)), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer buffer = ByteBuffer.allocate(xyLength + tLength + 4);
        buffer.putInt(filter.xy().length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(bounds), (Function1 & Serializable)x$1 -> buffer$1.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
            return BoxedUnit.UNIT;
        });
        buffer.putInt(filter.t().length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filter.t()), (Function1 & Serializable)bounds -> {
            if (bounds == null) {
                return buffer.putInt(-1);
            }
            buffer.putInt(((int[][])bounds).length);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])bounds), (Function1 & Serializable)inner -> {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(inner), (Function1 & Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        buffer.putShort(filter.minEpoch());
        buffer.putShort(filter.maxEpoch());
        return buffer.array();
    }

    @Override
    public S3Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        double[][] xy = (double[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable)() -> (double[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcD.sp & Serializable)() -> buffer.getDouble(), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[][][] t = (int[][][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable)() -> {
            int length = buffer.getInt();
            if (length == -1) {
                return null;
            }
            return (int[][])Array$.MODULE$.fill(length, (Function0 & Serializable)() -> (int[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcI.sp & Serializable)() -> buffer.getInt(), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        short minEpoch = buffer.getShort();
        short maxEpoch = buffer.getShort();
        return new S3Filter(xy, t, minEpoch, maxEpoch);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(S3Filter filter) {
        String xy = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> Predef$.MODULE$.wrapDoubleArray(bounds).mkString(MODULE$.RangeSeparator()), ClassTag$.MODULE$.apply(String.class))).mkString(this.TermSeparator());
        String t = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filter.t()), (Function1 & Serializable)bounds -> {
            if (bounds == null) {
                return "";
            }
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])bounds), (Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapIntArray(x$5).mkString(MODULE$.RangeSeparator()), ClassTag$.MODULE$.apply(String.class))).mkString(MODULE$.TermSeparator());
        }, ClassTag$.MODULE$.apply(String.class))).mkString(this.EpochSeparator());
        String epoch = new StringBuilder(0).append(filter.minEpoch()).append(this.RangeSeparator()).append(filter.maxEpoch()).toString();
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.XYKey()), (Object)xy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TKey()), (Object)t), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EpochKey()), (Object)epoch)}));
    }

    @Override
    public S3Filter deserializeFromStrings(Map<String, String> serialized) {
        Object object;
        double[][] xy = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.XYKey())).split(this.TermSeparator())), (Function1 & Serializable)x$6 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$6.split(MODULE$.RangeSeparator())), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$7))), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[][][] t = (int[][][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.TKey())).split(this.EpochSeparator())), (Function1 & Serializable)bounds -> {
            if (bounds.isEmpty()) {
                return null;
            }
            return (int[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])bounds.split(MODULE$.TermSeparator())), (Function1 & Serializable)x$8 -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$8.split(MODULE$.RangeSeparator())), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$9))), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        short[] sArray = (short[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)this.EpochKey())).split(this.RangeSeparator())), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$10))), (ClassTag)ClassTag$.MODULE$.Short());
        if (sArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)sArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)sArray);
        }
        short minEpoch = BoxesRunTime.unboxToShort((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
        short maxEpoch = BoxesRunTime.unboxToShort((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)minEpoch), (Object)BoxesRunTime.boxToShort((short)maxEpoch));
        short minEpoch2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        short maxEpoch2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
        return new S3Filter(xy, t, minEpoch2, maxEpoch2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Seq wholePeriod$1, Tuple2 x$3) {
        Object object = x$3._2();
        Seq seq = wholePeriod$1;
        return object == null ? seq != null : !object.equals(seq);
    }

    public static final /* synthetic */ short $anonfun$apply$3(Tuple2 x$4) {
        return BoxesRunTime.unboxToShort((Object)x$4._1());
    }

    public static final /* synthetic */ void $anonfun$apply$6(int[][][] t$1, ShortRef minEpoch$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            int[][] times = (int[][])tuple2._2();
            t$1[w - minEpoch$1.elem] = times;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$serializeToBytes$1(int[][] bounds) {
        if (bounds == null) {
            return 4;
        }
        return 4 + bounds.length * 8;
    }

    private S3Filter$() {
    }

    public static final /* synthetic */ Object $anonfun$apply$2$adapted(Seq wholePeriod$1, Tuple2 x$3) {
        return BoxesRunTime.boxToBoolean((boolean)S3Filter$.$anonfun$apply$2(wholePeriod$1, x$3));
    }
}

