/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import com.google.common.geometry.S2CellId;
import java.io.Serializable;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.S3Filter$;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\u0012$\u00019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005w!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!Q1A\u0005\u00025C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006)\u0002!\t!\u0016\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006Q\u0002!I!\u001b\u0005\u0006_\u0002!I\u0001\u001d\u0005\u0006i\u0002!\t%^\u0004\b\u0003\u0007\u0019\u0003\u0012AA\u0003\r\u0019\u00113\u0005#\u0001\u0002\b!1Ak\u0004C\u0001\u0003WA\u0011\"!\f\u0010\u0005\u0004%I!a\f\t\u0011\u0005}r\u0002)A\u0005\u0003cA\u0011\"!\u0011\u0010\u0005\u0004%I!a\f\t\u0011\u0005\rs\u0002)A\u0005\u0003cA\u0011\"!\u0012\u0010\u0005\u0004%I!a\f\t\u0011\u0005\u001ds\u0002)A\u0005\u0003cA\u0011\"!\u0013\u0010\u0005\u0004%\t!a\f\t\u0011\u0005-s\u0002)A\u0005\u0003cA\u0011\"!\u0014\u0010\u0005\u0004%\t!a\f\t\u0011\u0005=s\u0002)A\u0005\u0003cA\u0011\"!\u0015\u0010\u0005\u0004%\t!a\f\t\u0011\u0005Ms\u0002)A\u0005\u0003cAq!!\u0016\u0010\t\u0003\t9\u0006C\u0004\u0002z=!\t%a\u001f\t\u000f\u0005\u0005u\u0002\"\u0011\u0002\u0004\"9\u0011\u0011R\b\u0005B\u0005-\u0005bBAK\u001f\u0011\u0005\u0013q\u0013\u0002\t'N2\u0015\u000e\u001c;fe*\u0011A%J\u0001\bM&dG/\u001a:t\u0015\t1s%A\u0003j]\u0012,\u0007P\u0003\u0002)S\u00059q-Z8nKN\f'B\u0001\u0016,\u00031awnY1uS>tG/Z2i\u0015\u0005a\u0013aA8sO\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003\rJ!\u0001O\u0012\u0003\u0013I{wOR5mi\u0016\u0014\u0018A\u0001=z+\u0005Y\u0004c\u0001\u0019=}%\u0011Q(\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004aqz\u0004C\u0001\u0019A\u0013\t\t\u0015G\u0001\u0004E_V\u0014G.Z\u0001\u0004qf\u0004\u0013!\u0001;\u0016\u0003\u0015\u00032\u0001\r\u001fG!\r\u0001Dh\u0012\t\u0004aqB\u0005C\u0001\u0019J\u0013\tQ\u0015GA\u0002J]R\f!\u0001\u001e\u0011\u0002\u00115Lg.\u00129pG\",\u0012A\u0014\t\u0003a=K!\u0001U\u0019\u0003\u000bMCwN\u001d;\u0002\u00135Lg.\u00129pG\"\u0004\u0013\u0001C7bq\u0016\u0003xn\u00195\u0002\u00135\f\u00070\u00129pG\"\u0004\u0013A\u0002\u001fj]&$h\bF\u0003W/bK&\f\u0005\u00027\u0001!)\u0011(\u0003a\u0001w!)1)\u0003a\u0001\u000b\")A*\u0003a\u0001\u001d\")!+\u0003a\u0001\u001d\u0006A\u0011N\u001c\"pk:$7\u000fF\u0002^A\u001a\u0004\"\u0001\r0\n\u0005}\u000b$a\u0002\"p_2,\u0017M\u001c\u0005\u0006C*\u0001\rAY\u0001\u0004EV4\u0007c\u0001\u0019=GB\u0011\u0001\u0007Z\u0005\u0003KF\u0012AAQ=uK\")qM\u0003a\u0001\u0011\u00061qN\u001a4tKR\fQ\u0002]8j]RLeNQ8v]\u0012\u001cHCA/k\u0011\u0015Y7\u00021\u0001m\u0003!\u00198GV1mk\u0016\u001c\bC\u0001\u0019n\u0013\tq\u0017G\u0001\u0003M_:<\u0017\u0001\u0004;j[\u0016LeNQ8v]\u0012\u001cHcA/rg\")!\u000f\u0004a\u0001\u001d\u0006)Q\r]8dQ\")q\r\u0004a\u0001\u0011\u0006AAo\\*ue&tw\rF\u0001w!\t9hP\u0004\u0002yyB\u0011\u00110M\u0007\u0002u*\u001110L\u0001\u0007yI|w\u000e\u001e \n\u0005u\f\u0014A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0003\u0011aa\u0015;sS:<'BA?2\u0003!\u00196GR5mi\u0016\u0014\bC\u0001\u001c\u0010'\u0011yq&!\u0003\u0011\u000b\u0005-\u0011Q\u0005,\u000f\t\u00055\u0011\u0011\u0005\b\u0005\u0003\u001f\tyB\u0004\u0003\u0002\u0012\u0005ua\u0002BA\n\u00037qA!!\u0006\u0002\u001a9\u0019\u00110a\u0006\n\u00031J!AK\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\t!S%C\u0002\u0002$\r\n\u0011BU8x\r&dG/\u001a:\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0011%><h)\u001b7uKJ4\u0015m\u0019;pefT1!a\t$)\t\t)!\u0001\bSC:<WmU3qCJ\fGo\u001c:\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0005Y\u0006twM\u0003\u0002\u0002<\u0005!!.\u0019<b\u0013\ry\u0018QG\u0001\u0010%\u0006tw-Z*fa\u0006\u0014\u0018\r^8sA\u0005iA+\u001a:n'\u0016\u0004\u0018M]1u_J\fa\u0002V3s[N+\u0007/\u0019:bi>\u0014\b%\u0001\bFa>\u001c\u0007nU3qCJ\fGo\u001c:\u0002\u001f\u0015\u0003xn\u00195TKB\f'/\u0019;pe\u0002\nQ\u0001W-LKf\fa\u0001W-LKf\u0004\u0013\u0001\u0002+LKf\fQ\u0001V&fs\u0002\n\u0001\"\u00129pG\"\\U-_\u0001\n\u000bB|7\r[&fs\u0002\nQ!\u00199qYf$2AVA-\u0011\u001d\tY&\ba\u0001\u0003;\naA^1mk\u0016\u001c\b\u0003BA0\u0003grA!!\u0019\u0002n9!\u00111MA4\u001d\u0011\ty!!\u001a\n\u0005\u0019*\u0013\u0002BA5\u0003W\n!a]\u001a\u000b\u0005\u0019*\u0013\u0002BA8\u0003c\nq\u0001]1dW\u0006<WM\u0003\u0003\u0002j\u0005-\u0014\u0002BA;\u0003o\u0012QbU\u001aJ]\u0012,\u0007PV1mk\u0016\u001c(\u0002BA8\u0003c\n\u0001c]3sS\u0006d\u0017N_3U_\nKH/Z:\u0015\u0007\t\fi\b\u0003\u0004\u0002\u0000y\u0001\rAV\u0001\u0007M&dG/\u001a:\u0002)\u0011,7/\u001a:jC2L'0\u001a$s_6\u0014\u0015\u0010^3t)\r1\u0016Q\u0011\u0005\u0007\u0003\u000f{\u0002\u0019\u00012\u0002\u0015M,'/[1mSj,G-\u0001\ntKJL\u0017\r\\5{KR{7\u000b\u001e:j]\u001e\u001cH\u0003BAG\u0003'\u0003Ra^AHmZLA!!%\u0002\u0002\t\u0019Q*\u00199\t\r\u0005}\u0004\u00051\u0001W\u0003Y!Wm]3sS\u0006d\u0017N_3Ge>l7\u000b\u001e:j]\u001e\u001cHc\u0001,\u0002\u001a\"9\u0011qQ\u0011A\u0002\u0005m\u0005CBAO\u0003G3h/\u0004\u0002\u0002 *\u0019\u0011\u0011U\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0006}\u0005")
public class S3Filter
implements RowFilter {
    private final double[][] xy;
    private final int[][][] t;
    private final short minEpoch;
    private final short maxEpoch;

    public static S3Filter deserializeFromStrings(Map<String, String> serialized) {
        return S3Filter$.MODULE$.deserializeFromStrings((Map)serialized);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(S3Filter filter) {
        return S3Filter$.MODULE$.serializeToStrings(filter);
    }

    public static S3Filter deserializeFromBytes(byte[] serialized) {
        return S3Filter$.MODULE$.deserializeFromBytes(serialized);
    }

    public static byte[] serializeToBytes(S3Filter filter) {
        return S3Filter$.MODULE$.serializeToBytes(filter);
    }

    public static S3Filter apply(package.S3IndexValues values) {
        return S3Filter$.MODULE$.apply(values);
    }

    public static String EpochKey() {
        return S3Filter$.MODULE$.EpochKey();
    }

    public static String TKey() {
        return S3Filter$.MODULE$.TKey();
    }

    public static String XYKey() {
        return S3Filter$.MODULE$.XYKey();
    }

    public double[][] xy() {
        return this.xy;
    }

    public int[][][] t() {
        return this.t;
    }

    public short minEpoch() {
        return this.minEpoch;
    }

    public short maxEpoch() {
        return this.maxEpoch;
    }

    @Override
    public boolean inBounds(byte[] buf, int offset) {
        long keyS = ByteArrays$.MODULE$.readLong(buf, offset + 2);
        int timeOffset = ByteArrays$.MODULE$.readInt(buf, offset + 10);
        return this.pointInBounds(keyS) && this.timeInBounds(ByteArrays$.MODULE$.readShort(buf, offset), timeOffset);
    }

    private boolean pointInBounds(long s3Values) {
        S2CellId s2CellId = new S2CellId(s3Values);
        double x = s2CellId.toLatLng().lngDegrees();
        double y = s2CellId.toLatLng().latDegrees();
        for (int i = 0; i < this.xy().length; ++i) {
            double[] xyi = this.xy()[i];
            if (!(x >= xyi[0]) || !(x <= xyi[2]) || !(y >= xyi[1]) || !(y <= xyi[3])) continue;
            return true;
        }
        return false;
    }

    private boolean timeInBounds(short epoch, int offset) {
        if (epoch > this.maxEpoch() || epoch < this.minEpoch()) {
            return false;
        }
        int[][] tEpoch = this.t()[epoch - this.minEpoch()];
        if (tEpoch == null) {
            return true;
        }
        int time = offset;
        for (int i = 0; i < tEpoch.length; ++i) {
            int[] ti = tEpoch[i];
            if (time < ti[0] || time > ti[1]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ((IterableOnceOps)S3Filter$.MODULE$.serializeToStrings(this).toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public S3Filter(double[][] xy, int[][][] t, short minEpoch, short maxEpoch) {
        this.xy = xy;
        this.t = t;
        this.minEpoch = minEpoch;
        this.maxEpoch = maxEpoch;
    }
}

