/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.Z2Filter;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.z2.package;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Z2Filter$
implements RowFilter.RowFilterFactory<Z2Filter> {
    public static final Z2Filter$ MODULE$ = new Z2Filter$();
    private static final String RangeSeparator = ":";
    private static final String TermSeparator = ";";

    private String RangeSeparator() {
        return RangeSeparator;
    }

    private String TermSeparator() {
        return TermSeparator;
    }

    public Z2Filter apply(package.Z2IndexValues values) {
        Z2SFC sfc = values.sfc();
        int[][] xy = (int[][])((IterableOnceOps)values.spatialBounds().map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new int[]{sfc.lon().normalize(xmin), sfc.lat().normalize(ymin), sfc.lon().normalize(xmax), sfc.lat().normalize(ymax)};
            }
            throw new MatchError((Object)tuple4);
        })).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    @Override
    public byte[] serializeToBytes(Z2Filter filter) {
        int xyLength = 4 + filter.xy().length * 16;
        ByteBuffer buffer = ByteBuffer.allocate(xyLength);
        buffer.putInt(filter.xy().length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(bounds), (Function1 & Serializable)x$1 -> buffer$1.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
            return BoxedUnit.UNIT;
        });
        return buffer.array();
    }

    @Override
    public Z2Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        int[][] xy = (int[][])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable)() -> (int[])Array$.MODULE$.fill(4, (Function0)(JFunction0.mcI.sp & Serializable)() -> buffer.getInt(), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    @Override
    public scala.collection.immutable.Map<String, String> serializeToStrings(Z2Filter filter) {
        String xy = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filter.xy()), (Function1 & Serializable)bounds -> Predef$.MODULE$.wrapIntArray(bounds).mkString(MODULE$.RangeSeparator()), ClassTag$.MODULE$.apply(String.class))).mkString(this.TermSeparator());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Z3Filter$.MODULE$.XYKey()), (Object)xy)}));
    }

    @Override
    public Z2Filter deserializeFromStrings(Map<String, String> serialized) {
        int[][] xy = (int[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)Z3Filter$.MODULE$.XYKey())).split(this.TermSeparator())), (Function1 & Serializable)x$2 -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.split(MODULE$.RangeSeparator())), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3))), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    private Z2Filter$() {
    }
}

