/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import java.io.Serializable;
import org.locationtech.geomesa.index.filters.RowFilter;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.zorder.sfcurve.Z3$;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\u0012$\u00019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005w!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003F\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00115\u0003!Q1A\u0005\u0002!C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006-\u0002!\te\u0016\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006U\u0002!Ia\u001b\u0005\u0006_\u0002!\t\u0005]\u0004\u0006y\u000eB\t! \u0004\u0006E\rB\tA \u0005\u0007\u001f>!\t!!\t\t\u0013\u0005\rrB1A\u0005\n\u0005\u0015\u0002\u0002CA\u001b\u001f\u0001\u0006I!a\n\t\u0013\u0005]rB1A\u0005\n\u0005\u0015\u0002\u0002CA\u001d\u001f\u0001\u0006I!a\n\t\u0013\u0005mrB1A\u0005\n\u0005\u0015\u0002\u0002CA\u001f\u001f\u0001\u0006I!a\n\t\u0013\u0005}rB1A\u0005\u0002\u0005\u0015\u0002\u0002CA!\u001f\u0001\u0006I!a\n\t\u0013\u0005\rsB1A\u0005\u0002\u0005\u0015\u0002\u0002CA#\u001f\u0001\u0006I!a\n\t\u0013\u0005\u001dsB1A\u0005\u0002\u0005\u0015\u0002\u0002CA%\u001f\u0001\u0006I!a\n\t\u000f\u0005-s\u0002\"\u0001\u0002N!9\u0011qN\b\u0005B\u0005E\u0004bBA<\u001f\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u007fzA\u0011IAA\u0011\u001d\tYi\u0004C!\u0003\u001b\u0013\u0001BW\u001aGS2$XM\u001d\u0006\u0003I\u0015\nqAZ5mi\u0016\u00148O\u0003\u0002'O\u0005)\u0011N\u001c3fq*\u0011\u0001&K\u0001\bO\u0016|W.Z:b\u0015\tQ3&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001-\u0003\ry'oZ\u0002\u0001'\r\u0001q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y:T\"A\u0012\n\u0005a\u001a#!\u0003*po\u001aKG\u000e^3s\u0003\tA\u00180F\u0001<!\r\u0001DHP\u0005\u0003{E\u0012Q!\u0011:sCf\u00042\u0001\r\u001f@!\t\u0001\u0004)\u0003\u0002Bc\t\u0019\u0011J\u001c;\u0002\u0007aL\b%A\u0001u+\u0005)\u0005c\u0001\u0019=w\u0005\u0011A\u000fI\u0001\t[&tW\t]8dQV\t\u0011\n\u0005\u00021\u0015&\u00111*\r\u0002\u0006'\"|'\u000f^\u0001\n[&tW\t]8dQ\u0002\n\u0001\"\\1y\u000bB|7\r[\u0001\n[\u0006DX\t]8dQ\u0002\na\u0001P5oSRtD#B)S'R+\u0006C\u0001\u001c\u0001\u0011\u0015I\u0014\u00021\u0001<\u0011\u0015\u0019\u0015\u00021\u0001F\u0011\u00159\u0015\u00021\u0001J\u0011\u0015i\u0015\u00021\u0001J\u0003!IgNQ8v]\u0012\u001cHc\u0001-\\CB\u0011\u0001'W\u0005\u00035F\u0012qAQ8pY\u0016\fg\u000eC\u0003]\u0015\u0001\u0007Q,A\u0002ck\u001a\u00042\u0001\r\u001f_!\t\u0001t,\u0003\u0002ac\t!!)\u001f;f\u0011\u0015\u0011'\u00021\u0001@\u0003\u0019ygMZ:fi\u0006i\u0001o\\5oi&s'i\\;oIN$\"\u0001W3\t\u000b\u0019\\\u0001\u0019A4\u0002\u0003i\u0004\"\u0001\r5\n\u0005%\f$\u0001\u0002'p]\u001e\fA\u0002^5nK&s'i\\;oIN$2\u0001\u00177o\u0011\u0015iG\u00021\u0001J\u0003\u0015)\u0007o\\2i\u0011\u00151G\u00021\u0001h\u0003!!xn\u0015;sS:<G#A9\u0011\u0005ILhBA:x!\t!\u0018'D\u0001v\u0015\t1X&\u0001\u0004=e>|GOP\u0005\u0003qF\na\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u00010M\u0001\t5N2\u0015\u000e\u001c;feB\u0011agD\n\u0004\u001f=z\b#BA\u0001\u00037\tf\u0002BA\u0002\u0003/qA!!\u0002\u0002\u00169!\u0011qAA\n\u001d\u0011\tI!!\u0005\u000f\t\u0005-\u0011q\u0002\b\u0004i\u00065\u0011\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002%K%\u0019\u0011\u0011D\u0012\u0002\u0013I{wOR5mi\u0016\u0014\u0018\u0002BA\u000f\u0003?\u0011\u0001CU8x\r&dG/\u001a:GC\u000e$xN]=\u000b\u0007\u0005e1\u0005F\u0001~\u00039\u0011\u0016M\\4f'\u0016\u0004\u0018M]1u_J,\"!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005!A.\u00198h\u0015\t\t\t$\u0001\u0003kCZ\f\u0017b\u0001>\u0002,\u0005y!+\u00198hKN+\u0007/\u0019:bi>\u0014\b%A\u0007UKJl7+\u001a9be\u0006$xN]\u0001\u000f)\u0016\u0014XnU3qCJ\fGo\u001c:!\u00039)\u0005o\\2i'\u0016\u0004\u0018M]1u_J\fq\"\u00129pG\"\u001cV\r]1sCR|'\u000fI\u0001\u00061f[U-_\u0001\u00071f[U-\u001f\u0011\u0002\tQ[U-_\u0001\u0006).+\u0017\u0010I\u0001\t\u000bB|7\r[&fs\u0006IQ\t]8dQ.+\u0017\u0010I\u0001\u0006CB\u0004H.\u001f\u000b\u0004#\u0006=\u0003bBA);\u0001\u0007\u00111K\u0001\u0007m\u0006dW/Z:\u0011\t\u0005U\u0013\u0011\u000e\b\u0005\u0003/\n\u0019G\u0004\u0003\u0002Z\u0005uc\u0002BA\u0003\u00037J!AJ\u0013\n\t\u0005}\u0013\u0011M\u0001\u0003uNR!AJ\u0013\n\t\u0005\u0015\u0014qM\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\ty&!\u0019\n\t\u0005-\u0014Q\u000e\u0002\u000e5NJe\u000eZ3y-\u0006dW/Z:\u000b\t\u0005\u0015\u0014qM\u0001\u0011g\u0016\u0014\u0018.\u00197ju\u0016$vNQ=uKN$2!XA:\u0011\u0019\t)H\ba\u0001#\u00061a-\u001b7uKJ\fA\u0003Z3tKJL\u0017\r\\5{K\u001a\u0013x.\u001c\"zi\u0016\u001cHcA)\u0002|!1\u0011QP\u0010A\u0002u\u000b!b]3sS\u0006d\u0017N_3e\u0003I\u0019XM]5bY&TX\rV8TiJLgnZ:\u0015\t\u0005\r\u0015\u0011\u0012\t\u0006e\u0006\u0015\u0015/]\u0005\u0004\u0003\u000f[(aA'ba\"1\u0011Q\u000f\u0011A\u0002E\u000ba\u0003Z3tKJL\u0017\r\\5{K\u001a\u0013x.\\*ue&twm\u001d\u000b\u0004#\u0006=\u0005bBA?C\u0001\u0007\u0011\u0011\u0013\t\u0007\u0003'\u000bI*]9\u000e\u0005\u0005U%bAALc\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0013")
public class Z3Filter
implements RowFilter {
    private final int[][] xy;
    private final int[][][] t;
    private final short minEpoch;
    private final short maxEpoch;

    public static Z3Filter deserializeFromStrings(Map<String, String> serialized) {
        return Z3Filter$.MODULE$.deserializeFromStrings((Map)serialized);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(Z3Filter filter) {
        return Z3Filter$.MODULE$.serializeToStrings(filter);
    }

    public static Z3Filter deserializeFromBytes(byte[] serialized) {
        return Z3Filter$.MODULE$.deserializeFromBytes(serialized);
    }

    public static byte[] serializeToBytes(Z3Filter filter) {
        return Z3Filter$.MODULE$.serializeToBytes(filter);
    }

    public static Z3Filter apply(package.Z3IndexValues values) {
        return Z3Filter$.MODULE$.apply(values);
    }

    public static String EpochKey() {
        return Z3Filter$.MODULE$.EpochKey();
    }

    public static String TKey() {
        return Z3Filter$.MODULE$.TKey();
    }

    public static String XYKey() {
        return Z3Filter$.MODULE$.XYKey();
    }

    public int[][] xy() {
        return this.xy;
    }

    public int[][][] t() {
        return this.t;
    }

    public short minEpoch() {
        return this.minEpoch;
    }

    public short maxEpoch() {
        return this.maxEpoch;
    }

    @Override
    public boolean inBounds(byte[] buf, int offset) {
        long keyZ = ByteArrays$.MODULE$.readLong(buf, offset + 2);
        return this.pointInBounds(keyZ) && this.timeInBounds(ByteArrays$.MODULE$.readShort(buf, offset), keyZ);
    }

    private boolean pointInBounds(long z) {
        int x = Z3$.MODULE$.d0$extension(Z3$.MODULE$.apply(z));
        int y = Z3$.MODULE$.d1$extension(Z3$.MODULE$.apply(z));
        for (int i = 0; i < this.xy().length; ++i) {
            int[] xyi = this.xy()[i];
            if (x < xyi[0] || x > xyi[2] || y < xyi[1] || y > xyi[3]) continue;
            return true;
        }
        return false;
    }

    private boolean timeInBounds(short epoch, long z) {
        if (epoch > this.maxEpoch() || epoch < this.minEpoch()) {
            return true;
        }
        int[][] tEpoch = this.t()[epoch - this.minEpoch()];
        if (tEpoch == null) {
            return true;
        }
        int time = Z3$.MODULE$.d2$extension(Z3$.MODULE$.apply(z));
        for (int i = 0; i < tEpoch.length; ++i) {
            int[] ti = tEpoch[i];
            if (time < ti[0] || time > ti[1]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ((IterableOnceOps)Z3Filter$.MODULE$.serializeToStrings(this).toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public Z3Filter(int[][] xy, int[][][] t, short minEpoch, short maxEpoch) {
        this.xy = xy;
        this.t = t;
        this.minEpoch = minEpoch;
        this.maxEpoch = maxEpoch;
    }
}

