/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource$GeoMesaQueryCapabilities$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Function0;
import scala.NotImplementedError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\u0016-\u0001]B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005+\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003a\u0011\u0015Q\u0007\u0001\"\u0001l\u0011!y\u0007\u0001#b\u0001\n\u0013\u0001\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\f\u0001\t\u0003\n\u0019\u0005C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011\u0011\u000b\u0001\u0005B\u0005m\u0003bBA)\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"9\u0011Q\u0016\u0001\u0005B\u0005=vaBAZY!\u0005\u0011Q\u0017\u0004\u0007W1B\t!a.\t\r)4B\u0011AA`\u000f\u001d\t\tM\u0006E\u0001\u0003\u00074q!a2\u0017\u0011\u0003\tI\r\u0003\u0004k3\u0011\u0005\u00111\u001a\u0005\b\u0003\u001bLB\u0011IAh\u0011\u001d\t9.\u0007C!\u0003\u001fDq!!7\u001a\t\u0003\ny\rC\u0004\u0002\\f!\t%!8\u0007\r\u0005Uh\u0003AA|\u0011%\tIp\bB\u0001B\u0003%\u0001\t\u0003\u0004k?\u0011\u0005\u00111 \u0005\n\u0005\u0003y\"\u0019!C\u0005\u0005\u0007A\u0001Ba\u0006 A\u0003%!Q\u0001\u0005\b\u0003czB\u0011\tB\r\u0011\u001d\u0011Yb\bC!\u00053AqA!\b \t\u0003\u0012I\u0002C\u0004\u0003 }!\tE!\t\t\u000f\u0005=q\u0004\"\u0011\u0003$!9!\u0011G\u0010\u0005B\tM\u0002bBA\u0018?\u0011\u0005\u0013\u0011\u0007\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\u000b\u00055r\u0013\u0001C4f_R|w\u000e\\:\u000b\u0005=\u0002\u0014!B5oI\u0016D(BA\u00193\u0003\u001d9Wm\\7fg\u0006T!a\r\u001b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u001dA\u0013B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB(cU\u0016\u001cG\u000f\u0005\u0002B\u000f6\t!I\u0003\u0002D\t\u000611/[7qY\u0016T!!\u0012$\u0002\t\u0011\fG/\u0019\u0006\u0003[QJ!\u0001\u0013\"\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015\u0001D:dC2\fGn\\4hS:<'B\u0001(P\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001)\u0002\u0007\r|W.\u0003\u0002S\u0017\nYA*\u0019>z\u0019><w-\u001b8h\u0003\t!7/F\u0001V!\t1&L\u0004\u0002X16\tA&\u0003\u0002ZY\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005A9Um\\'fCN\u0014\u0015m]3Ti>\u0014XM\u0003\u0002ZY\u0005\u0019Am\u001d\u0011\u0002\u0007M4G/F\u0001a!\t\tw-D\u0001c\u0015\t\u00195M\u0003\u0002eK\u00069a-Z1ukJ,'B\u000145\u0003\u001dy\u0007/\u001a8hSNL!\u0001\u001b2\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002m[:\u0004\"a\u0016\u0001\t\u000bM+\u0001\u0019A+\t\u000by+\u0001\u0019\u00011\u0002\u000b!Lg\u000e^:\u0016\u0003E\u00042A];x\u001b\u0005\u0019(B\u0001;=\u0003\u0011)H/\u001b7\n\u0005Y\u001c(aA*fiB\u0019\u00010!\u0003\u000f\u0007e\f\u0019A\u0004\u0002{\u007f:\u00111P`\u0007\u0002y*\u0011QPN\u0001\u0007yI|w\u000e\u001e \n\u0003uJ1!!\u0001=\u0003\r\tw\u000f^\u0005\u0005\u0003\u000b\t9!\u0001\bSK:$WM]5oO\"Kg\u000e^:\u000b\u0007\u0005\u0005A(\u0003\u0003\u0002\f\u00055!aA&fs*!\u0011QAA\u0004\u0003%9W\r^*dQ\u0016l\u0017\rF\u0001a\u0003!9W\r^\"pk:$H\u0003BA\f\u0003G\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0003\u0003;\tQa]2bY\u0006LA!!\t\u0002\u001c\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015\u0002\u00021\u0001\u0002(\u0005)\u0011/^3ssB!\u0011\u0011FA\u0016\u001b\u0005!\u0015bAA\u0017\t\n)\u0011+^3ss\u0006Iq-\u001a;C_VtGm\u001d\u000b\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0002kiNT1!!\u0010G\u0003!9Wm\\7fiJL\u0018\u0002BA!\u0003o\u0011!CU3gKJ,gnY3e\u000b:4X\r\\8qKR!\u00111GA#\u0011\u001d\t)C\u0003a\u0001\u0003O\tAcZ3u#V,'/_\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCAA&!\u0011\tI#!\u0014\n\u0007\u0005=CIA\tRk\u0016\u0014\u0018pQ1qC\nLG.\u001b;jKN\f1bZ3u\r\u0016\fG/\u001e:fgR\u0011\u0011Q\u000b\t\u0004\u0003\u0006]\u0013bAA-\u0005\n92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0005\u0003+\ni\u0006C\u0004\u0002`5\u0001\r!!\u0019\u0002\r\u0019LG\u000e^3s!\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$bAA0K&!\u0011\u0011NA3\u0005\u00191\u0015\u000e\u001c;feR!\u0011QKA7\u0011\u001d\tyG\u0004a\u0001\u0003O\t\u0001b\u001c:jO&t\u0017\r\\\u0001\bO\u0016$h*Y7f)\t\t)\b\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tYhY\u0001\u0005if\u0004X-\u0003\u0003\u0002\u0000\u0005e$\u0001\u0002(b[\u0016\fAbZ3u\t\u0006$\u0018m\u0015;pe\u0016$\"!!\"\u0011\t\u0005%\u0012qQ\u0005\u0004\u0003\u0013#%!\u0003#bi\u0006\u001cFo\u001c:f\u0003E9W\r^*vaB|'\u000f^3e\u0011&tGo\u001d\u000b\u0002c\u00069q-\u001a;J]\u001a|GCAAJ!\u0011\tI#!&\n\u0007\u0005]EI\u0001\u0007SKN|WO]2f\u0013:4w.\u0001\nbI\u00124U-\u0019;ve\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BAO\u0003G\u0003B!!\u0007\u0002 &!\u0011\u0011UA\u000e\u0005\u0011)f.\u001b;\t\u000f\u0005\u00156\u00031\u0001\u0002(\u0006AA.[:uK:,'\u000f\u0005\u0003\u0002*\u0005%\u0016bAAV\t\nya)Z1ukJ,G*[:uK:,'/A\u000bsK6|g/\u001a$fCR,(/\u001a'jgR,g.\u001a:\u0015\t\u0005u\u0015\u0011\u0017\u0005\b\u0003K#\u0002\u0019AAT\u0003Q9Um\\'fg\u00064U-\u0019;ve\u0016\u001cv.\u001e:dKB\u0011qKF\n\u0004-\u0005e\u0006\u0003BA\r\u0003wKA!!0\u0002\u001c\t1\u0011I\\=SK\u001a$\"!!.\u00021\u001d+w.T3tCF+XM]=DCB\f'-\u001b7ji&,7\u000fE\u0002\u0002Ffi\u0011A\u0006\u0002\u0019\u000f\u0016|W*Z:b#V,'/_\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c8cA\r\u0002LQ\u0011\u00111Y\u0001\u0012SN|eMZ:fiN+\b\u000f]8si\u0016$GCAAi!\u0011\tI\"a5\n\t\u0005U\u00171\u0004\u0002\b\u0005>|G.Z1o\u0003YI7OU3mS\u0006\u0014G.\u001a$J\tN+\b\u000f]8si\u0016$\u0017!G5t+N,\u0007K]8wS\u0012,GMR%E'V\u0004\bo\u001c:uK\u0012\fqb];qa>\u0014Ho]*peRLgn\u001a\u000b\u0005\u0003#\fy\u000eC\u0004\u0002bz\u0001\r!a9\u0002\u001dM|'\u000f^!uiJL'-\u001e;fgB1\u0011\u0011DAs\u0003SLA!a:\u0002\u001c\tQAH]3qK\u0006$X\r\u001a \u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[TA!a<\u0002f\u0005!1o\u001c:u\u0013\u0011\t\u00190!<\u0003\rM{'\u000f\u001e\"z\u0005Y!U\r\\3hCRLgn\u001a*fg>,(oY3J]\u001a|7\u0003B\u00109\u0003'\u000baa]8ve\u000e,G\u0003BA\u007f\u0003\u007f\u00042!!2 \u0011\u0019\tI0\ta\u0001\u0001\u0006A1.Z=x_J$7/\u0006\u0002\u0003\u0006A!!/\u001eB\u0004!\u0011\u0011IA!\u0005\u000f\t\t-!Q\u0002\t\u0004w\u0006m\u0011\u0002\u0002B\b\u00037\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B\n\u0005+\u0011aa\u0015;sS:<'\u0002\u0002B\b\u00037\t\u0011b[3zo>\u0014Hm\u001d\u0011\u0015\u0005\t\u001d\u0011\u0001C4fiRKG\u000f\\3\u0002\u001d\u001d,G\u000fR3tGJL\u0007\u000f^5p]\u0006Yq-\u001a;LKf<xN\u001d3t)\t\u0011)\u0001\u0006\u0002\u0003&A!!q\u0005B\u0017\u001b\t\u0011ICC\u0002\u0003,q\n1A\\3u\u0013\u0011\u0011yC!\u000b\u0003\u0007U\u0013\u0016*\u0001\u0004hKR\u001c%k\u0015\u000b\u0003\u0005k\u0001BAa\u000e\u0003B5\u0011!\u0011\b\u0006\u0005\u0005w\u0011i$A\u0002deNT1Aa\u0010f\u0003-\u0011XMZ3sK:\u001c\u0017N\\4\n\t\t\r#\u0011\b\u0002\u001a\u0007>|'\u000fZ5oCR,'+\u001a4fe\u0016t7-Z*zgR,W\u000e")
public class GeoMesaFeatureSource
implements SimpleFeatureSource,
LazyLogging {
    private java.util.Set<RenderingHints.Key> hints;
    private final DataStore ds;
    private final SimpleFeatureType sft;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaFeatureSource geoMesaFeatureSource = this;
        synchronized (geoMesaFeatureSource) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DataStore ds() {
        return this.ds;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    private java.util.Set<RenderingHints.Key> hints$lzycompute() {
        GeoMesaFeatureSource geoMesaFeatureSource = this;
        synchronized (geoMesaFeatureSource) {
            if (!this.bitmap$0) {
                this.hints = Collections.unmodifiableSet(Collections.emptySet());
                this.bitmap$0 = true;
            }
        }
        return this.hints;
    }

    private java.util.Set<RenderingHints.Key> hints() {
        if (!this.bitmap$0) {
            return this.hints$lzycompute();
        }
        return this.hints;
    }

    public SimpleFeatureType getSchema() {
        return this.sft();
    }

    public int getCount(Query query) {
        long count;
        long l;
        Hints hints = ((GeoMesaFeatureReader.HasGeoMesaFeatureReader)this.ds()).getFeatureReader(this.sft(), Transaction.AUTO_COMMIT, query).hints();
        boolean useExactCount = BoxesRunTime.unboxToBoolean((Object)QueryHints$.MODULE$.RichHints(hints).isExactCount().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(QueryProperties$.MODULE$.QueryExactCount().get()))));
        if (useExactCount && !query.isMaxFeaturesUnlimited() && query.getMaxFeatures() < StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(QueryProperties$.MODULE$.QueryExactCountMaxFeatures().get()))) {
            l = SelfClosingIterator$.MODULE$.apply(this.getFeatures(query)).size();
        } else {
            long statsCount = BoxesRunTime.unboxToLong((Object)((package.HasGeoMesaStats)this.ds()).stats().getCount(this.getSchema(), query.getFilter(), useExactCount, hints).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            l = count = query.isMaxFeaturesUnlimited() ? statsCount : package$.MODULE$.min(statsCount, (long)query.getMaxFeatures());
        }
        if (count > Integer.MAX_VALUE) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Truncating count {} to Int.MaxValue ({})", new Object[]{BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    public ReferencedEnvelope getBounds() {
        return this.getBounds(new Query(this.sft().getTypeName(), (Filter)Filter.INCLUDE));
    }

    public ReferencedEnvelope getBounds(Query query) {
        GeoMesaStats qual$1 = ((package.HasGeoMesaStats)this.ds()).stats();
        SimpleFeatureType x$1 = this.getSchema();
        Filter x$2 = query.getFilter();
        boolean x$3 = qual$1.getBounds$default$3();
        return qual$1.getBounds(x$1, x$2, x$3);
    }

    public QueryCapabilities getQueryCapabilities() {
        return GeoMesaFeatureSource$GeoMesaQueryCapabilities$.MODULE$;
    }

    public SimpleFeatureCollection getFeatures() {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) {
        return this.getFeatures(new Query(this.sft().getTypeName(), filter));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureCollection getFeatures(Query original) {
        Query query;
        if (original.getTypeName() != null) {
            query = original;
        } else {
            void var3_2;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received Query with null typeName, setting to: {}", (Object)this.sft().getTypeName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Query nq = new Query(original);
            nq.setTypeName(this.sft().getTypeName());
            query = var3_2;
        }
        Query query2 = query;
        return new GeoMesaFeatureCollection(this, query2);
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public DataStore getDataStore() {
        return this.ds();
    }

    public java.util.Set<RenderingHints.Key> getSupportedHints() {
        return this.hints();
    }

    public ResourceInfo getInfo() {
        return new DelegatingResourceInfo(this);
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public GeoMesaFeatureSource(DataStore ds, SimpleFeatureType sft) {
        this.ds = ds;
        this.sft = sft;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class DelegatingResourceInfo
    implements ResourceInfo {
        private final SimpleFeatureSource source;
        private final java.util.Set<String> keywords;

        private java.util.Set<String> keywords() {
            return this.keywords;
        }

        public String getName() {
            return this.source.getSchema().getName().getURI();
        }

        public String getTitle() {
            return this.source.getSchema().getName().getLocalPart();
        }

        public String getDescription() {
            return null;
        }

        public java.util.Set<String> getKeywords() {
            return this.keywords();
        }

        public URI getSchema() {
            return (URI)Try$.MODULE$.apply((Function0 & Serializable)() -> new URI($this.source.getSchema().getName().getNamespaceURI())).getOrElse((Function0 & Serializable)() -> null);
        }

        public CoordinateReferenceSystem getCRS() {
            return this.source.getSchema().getCoordinateReferenceSystem();
        }

        public ReferencedEnvelope getBounds() {
            return this.source.getBounds();
        }

        public DelegatingResourceInfo(SimpleFeatureSource source) {
            this.source = source;
            this.keywords = Collections.unmodifiableSet((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"features", this.getName()}))).$plus$plus((IterableOnce)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)source.getSchema())))).asJava());
        }
    }
}

