/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.identity.FeatureId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\n\u0015\u0001}A\u0011\"\f\u0001\u0003\u0002\u0003\u0006IAL\u001b\t\u0013Y\u0002!\u0011!Q\u0001\n]\u0002\u0005\"B!\u0001\t\u0003\u0011\u0005b\u0002$\u0001\u0001\u0004%Ia\u0012\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0011\u00191\u0006\u0001)Q\u0005\u0011\")q\u000b\u0001C!1\")1\u000f\u0001C!i\")!\u0010\u0001C!w\"1!\u0010\u0001C!\u0003_AaA\u001f\u0001\u0005B\u0005m\u0002B\u0002>\u0001\t\u0003\ny\u0005C\u0004\u0002Z\u0001!\t%a\u0017\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004B\u0002>\u0001\t\u0003\tI\u0007\u0003\u0004{\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0003\u0003A\u0011BAB\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016\u001cFo\u001c:f\u0015\t)b#\u0001\u0005hK>$xn\u001c7t\u0015\t9\u0002$A\u0003j]\u0012,\u0007P\u0003\u0002\u001a5\u00059q-Z8nKN\f'BA\u000e\u001d\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!IA\u0011\u0011EI\u0007\u0002)%\u00111\u0005\u0006\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\u0011\u0005\u0015ZS\"\u0001\u0014\u000b\u0005\u001dB\u0013AB:j[BdWM\u0003\u0002*U\u0005!A-\u0019;b\u0015\t)B$\u0003\u0002-M\t\u00112+[7qY\u00164U-\u0019;ve\u0016\u001cFo\u001c:f\u0003\t!7\u000f\u0005\u00020e9\u0011\u0011\u0005M\u0005\u0003cQ\tq\u0001]1dW\u0006<W-\u0003\u00024i\t\u0001r)Z8NK\u0006\u001c()Y:f'R|'/\u001a\u0006\u0003cQI!!\f\u0012\u0002\u0007M4G\u000f\u0005\u00029}5\t\u0011H\u0003\u0002(u)\u00111\bP\u0001\bM\u0016\fG/\u001e:f\u0015\tiD$A\u0004pa\u0016tw-[:\n\u0005}J$!E*j[BdWMR3biV\u0014X\rV=qK&\u0011aGI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r#U\t\u0005\u0002\"\u0001!)Qf\u0001a\u0001]!)ag\u0001a\u0001o\u0005YAO]1og\u0006\u001cG/[8o+\u0005A\u0005CA%K\u001b\u0005A\u0013BA&)\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\0%KF$\"A\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\tUs\u0017\u000e\u001e\u0005\b+\u0016\t\t\u00111\u0001I\u0003\rAH%M\u0001\riJ\fgn]1di&|g\u000eI\u0001\fC\u0012$g)Z1ukJ,7\u000f\u0006\u0002ZSB\u0019!lX1\u000e\u0003mS!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003MSN$\bC\u00012h\u001b\u0005\u0019'B\u00013f\u0003!IG-\u001a8uSRL(B\u00014=\u0003\u00191\u0017\u000e\u001c;fe&\u0011\u0001n\u0019\u0002\n\r\u0016\fG/\u001e:f\u0013\u0012DQA[\u0004A\u0002-\f!bY8mY\u0016\u001cG/[8o!\u0011agn\u000e9\u000e\u00035T!a\u000f\u0016\n\u0005=l'!\u0005$fCR,(/Z\"pY2,7\r^5p]B\u0011\u0001(]\u0005\u0003ef\u0012QbU5na2,g)Z1ukJ,\u0017aC:fi\u001a+\u0017\r^;sKN$\"AT;\t\u000bYD\u0001\u0019A<\u0002\rI,\u0017\rZ3s!\u0011I\u0005p\u000e9\n\u0005eD#!\u0004$fCR,(/\u001a*fC\u0012,'/\u0001\bn_\u0012Lg-\u001f$fCR,(/Z:\u0015\r9c\u0018\u0011DA\u0013\u0011\u0015i\u0018\u00021\u0001\u007f\u0003)\tG\u000f\u001e:jEV$Xm\u001d\t\u0005\u001f~\f\u0019!C\u0002\u0002\u0002A\u0013Q!\u0011:sCf\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tI\u0001U\u0007\u0003\u0003\u0017Q1!!\u0004\u001f\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0003)\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\t\u0002\u0015\u0005\b\u00037I\u0001\u0019AA\u000f\u0003\u00191\u0018\r\\;fgB!qj`A\u0010!\ry\u0015\u0011E\u0005\u0004\u0003G\u0001&AB!osJ+g\r\u0003\u0004g\u0013\u0001\u0007\u0011q\u0005\t\u0005\u0003S\tY#D\u0001f\u0013\r\ti#\u001a\u0002\u0007\r&dG/\u001a:\u0015\u000f9\u000b\t$!\u000e\u0002:!9\u00111\u0007\u0006A\u0002\u0005\r\u0011!C1uiJL'-\u001e;f\u0011\u001d\t9D\u0003a\u0001\u0003?\tQA^1mk\u0016DaA\u001a\u0006A\u0002\u0005\u001dBc\u0002(\u0002>\u0005-\u0013Q\n\u0005\b\u0003gY\u0001\u0019AA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#u\u0005!A/\u001f9f\u0013\u0011\tI%a\u0011\u0003\t9\u000bW.\u001a\u0005\b\u0003oY\u0001\u0019AA\u0010\u0011\u001917\u00021\u0001\u0002(Q9a*!\u0015\u0002V\u0005]\u0003BB?\r\u0001\u0004\t\u0019\u0006\u0005\u0003P\u007f\u0006}\u0002bBA\u000e\u0019\u0001\u0007\u0011Q\u0004\u0005\u0007M2\u0001\r!a\n\u0002\u001dI,Wn\u001c<f\r\u0016\fG/\u001e:fgR\u0019a*!\u0018\t\r\u0019l\u0001\u0019AA\u0014\u00039\u0019X\r\u001e+sC:\u001c\u0018m\u0019;j_:$2ATA2\u0011\u00151e\u00021\u0001I\u000399W\r\u001e+sC:\u001c\u0018m\u0019;j_:$\u0012\u0001\u0013\u000b\b\u001d\u0006-\u00141OA;\u0011\u001d\t\u0019\u0004\u0005a\u0001\u0003[\u0002B!!\u0011\u0002p%!\u0011\u0011OA\"\u0005M\tE\u000f\u001e:jEV$X\rR3tGJL\u0007\u000f^8s\u0011\u001d\t9\u0004\u0005a\u0001\u0003?AaA\u001a\tA\u0002\u0005\u001dBc\u0002(\u0002z\u0005u\u0014q\u0010\u0005\u0007{F\u0001\r!a\u001f\u0011\t={\u0018Q\u000e\u0005\b\u00037\t\u0002\u0019AA\u000f\u0011\u00191\u0017\u00031\u0001\u0002(\u00051qO]5uKJ$B!!\"\u0002\fB)\u0011*a\"8a&\u0019\u0011\u0011\u0012\u0015\u0003\u001b\u0019+\u0017\r^;sK^\u0013\u0018\u000e^3s\u0011\u00191'\u00031\u0001\u0002\u000eB)q*a$\u0002(%\u0019\u0011\u0011\u0013)\u0003\r=\u0003H/[8o\u0001")
public class GeoMesaFeatureStore
extends GeoMesaFeatureSource
implements SimpleFeatureStore {
    private Transaction transaction = Transaction.AUTO_COMMIT;

    private Transaction transaction() {
        return this.transaction;
    }

    private void transaction_$eq(Transaction x$1) {
        this.transaction = x$1;
    }

    public java.util.List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeatureId> fids = new ArrayList<FeatureId>(collection.size());
        ArrayBuffer errors = ArrayBuffer$.MODULE$.empty();
        package.WithClose$.MODULE$.apply((Object)collection.features(), (Function0 & Serializable)() -> this.writer((Option<Filter>)None$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            GeoMesaFeatureStore.$anonfun$addFeatures$2(fids, errors, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
        if (errors.isEmpty()) {
            return fids;
        }
        IllegalArgumentException e = new IllegalArgumentException("Some features were not written:");
        errors.foreach((Function1 & Serializable)x$1 -> {
            e.addSuppressed(x$1);
            return BoxedUnit.UNIT;
        });
        throw e;
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.removeFeatures((Filter)Filter.INCLUDE);
        try {
            package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)None$.MODULE$), (Function1 & Serializable)writer -> {
                GeoMesaFeatureStore.$anonfun$setFeatures$1(reader, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        finally {
            reader.close();
        }
    }

    public void modifyFeatures(String[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attributes2), (Function1 & Serializable)x$1 -> new NameImpl(x$1), ClassTag$.MODULE$.apply(Name.class)), values, filter);
    }

    public void modifyFeatures(String attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{new NameImpl(attribute)}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name attribute, Object value, Filter filter) {
        this.modifyFeatures((Name[])((Object[])new Name[]{attribute}), new Object[]{value}, filter);
    }

    public void modifyFeatures(Name[] attributes2, Object[] values, Filter filter) {
        SimpleFeatureType sft = this.getSchema();
        Predef$.MODULE$.require(filter != null, (Function0 & Serializable)() -> "Filter must not be null");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])attributes2), (Function1 & Serializable)a -> {
            Predef$.MODULE$.require(sft.getDescriptor(a) != null, (Function0 & Serializable)() -> new StringBuilder(24).append(a).append(" is not an attribute of ").append(sft$1.getName()).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.require(attributes2.length == values.length, (Function0 & Serializable)() -> "Modified names and values don't match");
        package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$modifyFeatures$6(attributes2, values, writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void removeFeatures(Filter filter) {
        DataStore dataStore = super.ds();
        if (dataStore instanceof GeoMesaDataStore) {
            GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
                List indices = geoMesaDataStore.manager().indices(super.sft(), geoMesaDataStore.manager().indices$default$2()).toList();
                if (TablePartition$.MODULE$.partitioned(super.sft())) {
                    indices.map((Function1 & Serializable)i -> CachedThreadPool$.MODULE$.submit(() -> GeoMesaFeatureStore.deleteOne$1(i, geoMesaDataStore))).foreach((Function1 & Serializable)x$2 -> x$2.get());
                } else {
                    indices.map((Function1 & Serializable)i -> CachedThreadPool$.MODULE$.submit(() -> GeoMesaFeatureStore.deleteOne$2(i, geoMesaDataStore))).foreach((Function1 & Serializable)x$4 -> x$4.get());
                }
                geoMesaDataStore.stats().writer().clear(super.sft());
                return;
            }
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)package.WithClose$.MODULE$.apply(this.writer((Option<Filter>)new Some((Object)filter)), (Function1 & Serializable)writer -> {
            GeoMesaFeatureStore.$anonfun$removeFeatures$8(writer);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void setTransaction(Transaction transaction) {
        Predef$.MODULE$.require(transaction != null, (Function0 & Serializable)() -> "Transaction can't be null - did you mean Transaction.AUTO_COMMIT?");
        this.transaction_$eq(transaction);
    }

    public Transaction getTransaction() {
        return this.transaction();
    }

    public void modifyFeatures(AttributeDescriptor attribute, Object value, Filter filter) {
        this.modifyFeatures(attribute.getName(), value, filter);
    }

    public void modifyFeatures(AttributeDescriptor[] attributes2, Object[] values, Filter filter) {
        this.modifyFeatures((Name[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attributes2), (Function1 & Serializable)x$5 -> x$5.getName(), ClassTag$.MODULE$.apply(Name.class)), values, filter);
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> writer(Option<Filter> filter) {
        DataStore dataStore = super.ds();
        if (dataStore instanceof MetadataBackedDataStore) {
            MetadataBackedDataStore metadataBackedDataStore = (MetadataBackedDataStore)dataStore;
            return metadataBackedDataStore.getFeatureWriter(super.sft(), this.transaction(), filter);
        }
        if (filter.isEmpty()) {
            return super.ds().getFeatureWriterAppend(super.sft().getTypeName(), this.transaction());
        }
        return super.ds().getFeatureWriter(super.sft().getTypeName(), (Filter)filter.get(), this.transaction());
    }

    public static final /* synthetic */ void $anonfun$addFeatures$2(ArrayList fids$1, ArrayBuffer errors$1, FeatureIterator x0$1, FeatureWriter x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            FeatureIterator features = (FeatureIterator)tuple2._1();
            FeatureWriter writer = (FeatureWriter)tuple2._2();
            while (features.hasNext()) {
                Object object;
                try {
                    object = BoxesRunTime.boxToBoolean((boolean)fids$1.add(FeatureUtils$.MODULE$.write(writer, (SimpleFeature)features.next(), FeatureUtils$.MODULE$.write$default$3()).getIdentifier()));
                }
                catch (IllegalArgumentException e) {
                    object = errors$1.append((Object)e);
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setFeatures$1(FeatureReader reader$1, FeatureWriter writer) {
        while (reader$1.hasNext()) {
            FeatureUtils$.MODULE$.write(writer, (SimpleFeature)reader$1.next(), FeatureUtils$.MODULE$.write$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$modifyFeatures$6(Name[] attributes$1, Object[] values$1, FeatureWriter writer) {
        while (writer.hasNext()) {
            SimpleFeature sf = (SimpleFeature)writer.next();
            for (int i = 0; i < attributes$1.length; ++i) {
                try {
                    sf.setAttribute(attributes$1[i], values$1[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new DataSourceException(new StringBuilder(32).append("Error updating feature ").append("'").append(sf.getID()).append("' with ").append(attributes$1[i]).append("=").append(values$1[i]).toString(), (Throwable)e);
                }
            }
            writer.write();
        }
    }

    private static final void deleteOne$1(GeoMesaFeatureIndex index, GeoMesaDataStore x2$1) {
        x2$1.adapter().deleteTables(index.deleteTableNames((Option<String>)None$.MODULE$));
    }

    private static final void deleteOne$2(GeoMesaFeatureIndex index, GeoMesaDataStore x2$1) {
        Option prefix = new Some((Object)index.keySpace().sharing()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(x$3))));
        x2$1.adapter().clearTables(index.getTableNames((Option<String>)None$.MODULE$), (Option<byte[]>)prefix);
    }

    public static final /* synthetic */ void $anonfun$removeFeatures$8(FeatureWriter writer) {
        while (writer.hasNext()) {
            writer.next();
            writer.remove();
        }
    }

    public GeoMesaFeatureStore(DataStore ds, SimpleFeatureType sft) {
        super(ds, sft);
    }
}

